/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.BaseIndex;
import org.h2.index.IndexCondition;
import org.h2.index.IndexType;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class H2IndexCostedBase
extends BaseIndex {
    protected GridH2Table tbl;
    private final double NULL_FRACTION = 0.25;
    private final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
    private final int RANGE_CLOSE_SELECTIVITY = 25;
    private final int RANGE_OPEN_SELECTIVITY = 33;

    protected H2IndexCostedBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        this.initBaseIndex((Table)tbl, 0, name, cols, type);
        this.tbl = tbl;
    }

    private double nulls(ColumnStatistics colStat) {
        if (colStat == null) {
            return 0.25;
        }
        if (colStat.total() > 0L) {
            return (double)colStat.nulls() / (double)colStat.total();
        }
        return 0.0;
    }

    private long rowCost(Session ses, TableFilter filter, int[] masks, long rowCount, ObjectStatisticsImpl locTblStats) {
        double totalCardinality = 0.0;
        long rowsCost = rowCount;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            while (i < len) {
                Column column = this.columns[i++];
                ColumnStatistics colStats = this.getColumnStatistics(locTblStats, column);
                int index = column.getColumnId();
                int mask = masks[index];
                if (this.isByteFlag(mask, 1)) {
                    long distinctRows;
                    double cardinality;
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    Value equalValue = this.getEqualValue(ses, column, filter);
                    Boolean equalNull = equalValue == null ? null : Boolean.valueOf(equalValue.getType() == 0);
                    rowCount = this.getColumnSize(colStats, rowCount, equalNull);
                    if (colStats != null && equalNull == Boolean.TRUE) {
                        rowsCost = Math.min(5L + Math.max(Math.round((double)rowsCost * this.nulls(colStats)), 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                        continue;
                    }
                    if (colStats != null && equalNull == Boolean.FALSE) {
                        rowsCost = Math.max(Math.round((double)rowsCost * (1.0 - this.nulls(colStats))), 1L);
                    }
                    if (colStats == null) {
                        cardinality = (double)column.getSelectivity() / 100.0;
                        totalCardinality = 1.0 - (1.0 - totalCardinality) * (1.0 - cardinality);
                        distinctRows = Math.round((double)rowCount * totalCardinality);
                    } else {
                        long nonNulls = colStats.total() - colStats.nulls();
                        cardinality = nonNulls == 0L ? 1.0 : (double)colStats.distinct() / (double)nonNulls;
                        totalCardinality = 1.0 - (1.0 - totalCardinality) * (1.0 - cardinality);
                        distinctRows = Math.round((double)rowCount * totalCardinality);
                    }
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = Math.min(5L + Math.max(rowsCost / distinctRows, 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                    continue;
                }
                if (this.isByteFlag(mask, 6) || this.isByteFlag(mask, 2) || this.isByteFlag(mask, 4)) {
                    Value min = this.getStartValue(ses, column, filter);
                    Value max = this.getEndValue(ses, column, filter);
                    int percent = this.estimatePercent(colStats, min, max);
                    rowsCost = Math.min(5L + rowsCost * (long)percent / 100L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if (this.isNullFilter(ses, column, filter)) {
                    if (colStats == null) break;
                    rowsCost = Math.min(5L + colStats.nulls(), rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if (!this.isNotNullFilter(ses, column, filter) || colStats == null) break;
                rowsCost = Math.min(5L + colStats.total() - colStats.nulls(), rowsCost - (long)(i > 0 ? 1 : 0));
                break;
            }
        }
        return rowsCost;
    }

    private long getColumnSize(@Nullable ColumnStatistics colStats, long rowCount, Boolean nulls) {
        if (colStats == null) {
            return rowCount;
        }
        if (nulls == null) {
            return colStats.total();
        }
        if (nulls.booleanValue()) {
            return colStats.nulls();
        }
        return colStats.total() - colStats.nulls();
    }

    private Value getEqualValue(Session ses, Column column, TableFilter filter) {
        Value maxValue = null;
        for (IndexCondition cond : filter.getIndexConditions()) {
            Expression expr;
            if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 0) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
            Value curVal = cond.getCurrentValue(ses);
            if (null != maxValue && curVal == null && filter.getTable().compareTypeSafe(curVal, maxValue) >= 0) continue;
            maxValue = curVal;
        }
        return maxValue;
    }

    private Value getStartValue(Session ses, Column column, TableFilter filter) {
        if (filter == null) {
            return null;
        }
        Value maxValue = null;
        for (IndexCondition cond : filter.getIndexConditions()) {
            Expression expr;
            if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 2) && !this.isByteFlag(cond.getCompareType(), 1) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
            Value curVal = cond.getCurrentValue(ses);
            if (null != maxValue && curVal == null && filter.getTable().compareTypeSafe(curVal, maxValue) >= 0) continue;
            maxValue = curVal;
        }
        return maxValue;
    }

    private Value getEndValue(Session ses, Column column, TableFilter filter) {
        if (filter == null) {
            return null;
        }
        Value minValue = null;
        for (IndexCondition cond : filter.getIndexConditions()) {
            Expression expr;
            if (!column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 4) && !this.isByteFlag(cond.getCompareType(), 3) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant()) continue;
            Value curVal = cond.getCurrentValue(ses);
            if (null != minValue && curVal == null && filter.getTable().compareTypeSafe(minValue, curVal) >= 0) continue;
            minValue = curVal;
        }
        return minValue;
    }

    private boolean isNotNullFilter(Session ses, Column column, TableFilter filter) {
        return false;
    }

    private boolean isNullFilter(Session ses, Column column, TableFilter filter) {
        if (filter == null) {
            return false;
        }
        for (IndexCondition cond : filter.getIndexConditions()) {
            Value curVal;
            Expression expr;
            if (column.equals((Object)cond.getColumn()) || !this.isByteFlag(cond.getCompareType(), 11) || !cond.isEvaluatable() || (expr = cond.getExpression()) == null || !expr.isConstant() || (curVal = cond.getCurrentValue(ses)) == null || curVal.getType() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isByteFlag(int value, int mask) {
        return (value & mask) == mask;
    }

    private int estimatePercent(ColumnStatistics colStat, Value min, Value max) {
        BigDecimal start;
        BigDecimal maxValue;
        if (colStat == null || colStat.min() == null || colStat.max() == null) {
            return this.estimatePercentFallback(min, max);
        }
        BigDecimal minValue = min == null ? null : this.getComparableValue(min);
        BigDecimal bigDecimal = maxValue = max == null ? null : this.getComparableValue(max);
        if (minValue == null && maxValue == null) {
            return this.estimatePercentFallback(min, max);
        }
        BigDecimal minStat = this.getComparableValue(colStat.min());
        BigDecimal maxStat = this.getComparableValue(colStat.max());
        if (minStat == null || maxStat == null) {
            return this.estimatePercentFallback(min, max);
        }
        BigDecimal end = maxValue == null || maxValue.compareTo(maxStat) > 0 ? maxStat : maxValue;
        BigDecimal actual = end.subtract(start = minValue == null || minValue.compareTo(minStat) < 0 ? minStat : minValue);
        if (actual.signum() < 0) {
            return 0;
        }
        BigDecimal total = maxStat.subtract(minStat);
        if (total.signum() < 0) {
            return this.estimatePercentFallback(min, max);
        }
        if (total.signum() == 0) {
            return minStat.equals(start) ? 100 - (int)Math.round(this.nulls(colStat) * 100.0) : 0;
        }
        int result = actual.multiply(BigDecimal.valueOf(100L - colStat.nulls())).divide(total, this.MATH_CONTEXT).intValue();
        return result > 100 ? 100 : result;
    }

    private int estimatePercentFallback(Value min, Value max) {
        return min == null || max == null ? 33 : 25;
    }

    private BigDecimal getComparableValue(Value value) {
        switch (value.getType()) {
            case 0: {
                throw new IllegalArgumentException("Can't compare null values");
            }
            case 1: {
                return new BigDecimal(value.getBoolean() ? 1 : 0);
            }
            case 2: {
                return new BigDecimal(value.getByte());
            }
            case 3: {
                return new BigDecimal(value.getShort());
            }
            case 4: {
                return new BigDecimal(value.getInt());
            }
            case 5: {
                return new BigDecimal(value.getLong());
            }
            case 6: {
                return value.getBigDecimal();
            }
            case 7: {
                return new BigDecimal(value.getDouble());
            }
            case 8: {
                return new BigDecimal(value.getFloat());
            }
            case 10: {
                return new BigDecimal(value.getDate().getTime());
            }
            case 9: {
                return new BigDecimal(value.getTime().getTime());
            }
            case 11: {
                return new BigDecimal(value.getTimestamp().getTime());
            }
            case 12: {
                BigInteger bigInteger = new BigInteger(1, value.getBytes());
                return new BigDecimal(bigInteger);
            }
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                return null;
            }
            case 20: {
                BigInteger bigInt = new BigInteger(1, value.getBytes());
                return new BigDecimal(bigInt);
            }
        }
        throw new IllegalStateException("Unsupported H2 type: " + value.getType());
    }

    private ColumnStatistics getColumnStatistics(@Nullable ObjectStatisticsImpl locTblStats, Column column) {
        return locTblStats == null ? null : locTblStats.columnStatistics(column.getName());
    }

    private long sortingCost(long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex) {
        if (sortOrder == null) {
            return 0L;
        }
        long sortingCost = 100L + rowCount / 10L;
        if (!isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        return sortingCost;
    }

    public long getCostRangeIndex(Session ses, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        ObjectStatisticsImpl locTblStats = (ObjectStatisticsImpl)this.tbl.tableStatistics();
        if (locTblStats != null) {
            rowCount = locTblStats.rowCount();
        }
        TableFilter tableFilter = filters == null ? null : filters[filter];
        long rowsCost = this.rowCost(ses, tableFilter, masks, rowCount += 1000L, locTblStats);
        long sortingCost = this.sortingCost(rowCount, filters, filter, sortOrder, isScanIndex);
        boolean skipColumnsIntersection = false;
        if (filters != null && tableFilter != null && this.columns != null) {
            skipColumnsIntersection = true;
            ArrayList idxConds = tableFilter.getIndexConditions();
            if (F.isEmpty((Collection)idxConds)) {
                skipColumnsIntersection = false;
            }
            for (IndexCondition cond : idxConds) {
                if (cond.getColumn() != this.columns[0]) continue;
                skipColumnsIntersection = false;
                break;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!(isScanIndex || allColumnsSet == null || skipColumnsIntersection || allColumnsSet.isEmpty())) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                boolean found = false;
                for (Column c2 : this.columns) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }
}

