/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.table.IndexColumn;

public class QueryIndexRowHandler
implements InlineIndexRowHandler {
    private final GridH2RowDescriptor cacheDesc;
    private final List<IndexColumn> h2IdxColumns;
    private final List<InlineIndexKeyType> keyTypes;
    private final List<IndexKeyDefinition> keyDefs;
    private final IndexKeyTypeSettings keyTypeSettings;
    private final GridH2Table h2Table;

    public QueryIndexRowHandler(GridH2Table h2table, List<IndexColumn> h2IdxColumns, LinkedHashMap<String, IndexKeyDefinition> keyDefs, List<InlineIndexKeyType> keyTypes, IndexKeyTypeSettings keyTypeSettings) {
        this.h2IdxColumns = h2IdxColumns;
        this.keyTypes = keyTypes;
        this.keyDefs = Collections.unmodifiableList(new ArrayList<IndexKeyDefinition>(keyDefs.values()));
        this.h2Table = h2table;
        this.cacheDesc = h2table.rowDescriptor();
        this.keyTypeSettings = keyTypeSettings;
    }

    public IndexKey indexKey(int idx, CacheDataRow row) {
        Object o = this.getKey(idx, row);
        return IndexKeyFactory.wrap((Object)o, (int)this.keyDefs.get(idx).idxType(), (CacheObjectValueContext)this.cacheDesc.context().cacheObjectContext(), (IndexKeyTypeSettings)this.keyTypeSettings);
    }

    public List<IndexColumn> getH2IdxColumns() {
        return this.h2IdxColumns;
    }

    public List<InlineIndexKeyType> inlineIndexKeyTypes() {
        return this.keyTypes;
    }

    public List<IndexKeyDefinition> indexKeyDefinitions() {
        return this.keyDefs;
    }

    public IndexKeyTypeSettings indexKeyTypeSettings() {
        return this.keyTypeSettings;
    }

    private Object getKey(int idx, CacheDataRow row) {
        int cacheIdx = this.h2IdxColumns.get((int)idx).column.getColumnId();
        if (this.cacheDesc.isKeyColumn(cacheIdx)) {
            return this.key(row);
        }
        if (this.cacheDesc.isValueColumn(cacheIdx)) {
            return this.value(row);
        }
        return this.cacheDesc.columnValue(row.key(), row.value(), cacheIdx - 2);
    }

    public int partition(CacheDataRow row) {
        Object key = this.key(row);
        return this.cacheDesc.context().affinity().partition(key);
    }

    public Object cacheKey(CacheDataRow row) {
        return this.key(row);
    }

    public Object cacheValue(CacheDataRow row) {
        return this.value(row);
    }

    public GridH2Table getTable() {
        return this.h2Table;
    }

    public Object key(CacheDataRow row) {
        KeyCacheObject key = row.key();
        Object o = this.getBinaryObject((CacheObject)key);
        if (o != null) {
            return o;
        }
        CacheObjectContext coctx = this.cacheDesc.context().cacheObjectContext();
        return key.value((CacheObjectValueContext)coctx, false);
    }

    private Object value(CacheDataRow row) {
        CacheObject val = row.value();
        Object o = this.getBinaryObject(val);
        if (o != null) {
            return o;
        }
        CacheObjectContext coctx = this.cacheDesc.context().cacheObjectContext();
        return row.value().value((CacheObjectValueContext)coctx, false);
    }

    private Object getBinaryObject(CacheObject o) {
        if (o instanceof BinaryObjectImpl) {
            ((BinaryObjectImpl)o).detachAllowed(true);
            o = ((BinaryObjectImpl)o).detach();
            return o;
        }
        return null;
    }
}

