/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.BulkLoadContextCursor;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.internal.processors.bulkload.BulkLoadFormat;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.apache.ignite.internal.processors.bulkload.BulkLoadStreamerWriter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQuerySchemaManager;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.h2.CommandResult;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.dml.DmlBulkLoadDataConverter;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableDropColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.sql.SqlCommandProcessor;
import org.apache.ignite.internal.sql.command.SqlAnalyzeCommand;
import org.apache.ignite.internal.sql.command.SqlBeginTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCommitTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlDropStatisticsCommand;
import org.apache.ignite.internal.sql.command.SqlKillQueryCommand;
import org.apache.ignite.internal.sql.command.SqlRefreshStatitsicsCommand;
import org.apache.ignite.internal.sql.command.SqlRollbackTransactionCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.command.dml.NoOperation;
import org.h2.table.Column;
import org.h2.value.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandProcessor
extends SqlCommandProcessor {
    private final SchemaManager schemaMgr;
    private final IgniteH2Indexing idx;
    private static final boolean handleUuidAsByte = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_UUID_DDL_BYTE_FORMAT", (boolean)false);

    public CommandProcessor(GridKernalContext ctx, SchemaManager schemaMgr, IgniteH2Indexing idx) {
        super(ctx, (GridQuerySchemaManager)schemaMgr);
        this.schemaMgr = schemaMgr;
        this.idx = idx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommandResult runCommand(String sql, SqlCommand cmdNative, GridSqlStatement cmdH2, QueryParameters params, @Nullable SqlClientContext cliCtx, long qryId) throws IgniteCheckedException {
        assert (cmdNative != null || cmdH2 != null);
        QueryCursorImpl<List<?>> res = H2Utils.zeroCursor();
        boolean unregister = true;
        if (cmdNative != null) {
            assert (cmdH2 == null);
            if (!this.isCommandSupported(cmdNative)) throw new UnsupportedOperationException("Unsupported command: " + cmdNative);
            FieldsQueryCursor<List<?>> resNative = this.runNativeCommand(sql, cmdNative, params, cliCtx, qryId);
            if (resNative == null) return new CommandResult((FieldsQueryCursor<List<?>>)res, unregister);
            res = resNative;
            unregister = !(cmdNative instanceof SqlBulkLoadCommand);
            return new CommandResult((FieldsQueryCursor<List<?>>)res, unregister);
        } else {
            assert (cmdH2 != null);
            this.runCommandH2(sql, cmdH2);
        }
        return new CommandResult((FieldsQueryCursor<List<?>>)res, unregister);
    }

    public FieldsQueryCursor<List<?>> runNativeCommand(String sql, SqlCommand cmdNative, QueryParameters params, @Nullable SqlClientContext cliCtx, Long qryId) throws IgniteCheckedException {
        if (super.isCommandSupported(cmdNative)) {
            return this.runCommand(cmdNative);
        }
        if (cmdNative instanceof SqlBulkLoadCommand) {
            return this.processBulkLoadCommand((SqlBulkLoadCommand)cmdNative, qryId);
        }
        if (cmdNative instanceof SqlSetStreamingCommand) {
            this.processSetStreamingCommand((SqlSetStreamingCommand)cmdNative, cliCtx);
        } else if (cmdNative instanceof SqlAnalyzeCommand) {
            this.processAnalyzeCommand((SqlAnalyzeCommand)cmdNative);
        } else if (cmdNative instanceof SqlRefreshStatitsicsCommand) {
            this.processRefreshStatisticsCommand((SqlRefreshStatitsicsCommand)cmdNative);
        } else if (cmdNative instanceof SqlDropStatisticsCommand) {
            this.processDropStatisticsCommand((SqlDropStatisticsCommand)cmdNative);
        } else {
            this.processTxCommand(cmdNative, params);
        }
        return null;
    }

    public boolean isCommandSupported(SqlCommand cmd) {
        return super.isCommandSupported(cmd) || cmd instanceof SqlBeginTransactionCommand || cmd instanceof SqlCommitTransactionCommand || cmd instanceof SqlRollbackTransactionCommand || cmd instanceof SqlBulkLoadCommand || cmd instanceof SqlSetStreamingCommand;
    }

    private void processKillQueryCommand(SqlKillQueryCommand cmd) {
        this.idx.runningQueryManager().cancelQuery(cmd.nodeQueryId(), cmd.nodeId(), cmd.async());
    }

    private void processAnalyzeCommand(SqlAnalyzeCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsObjectConfiguration[] objCfgs = (StatisticsObjectConfiguration[])cmd.configurations().stream().map(t -> {
            if (t.key().schema() == null) {
                StatisticsKey key = new StatisticsKey(cmd.schemaName(), t.key().obj());
                return new StatisticsObjectConfiguration(key, t.columns().values(), t.maxPartitionObsolescencePercent());
            }
            return t;
        }).toArray(StatisticsObjectConfiguration[]::new);
        indexing.statsManager().collectStatistics(objCfgs);
    }

    private void processRefreshStatisticsCommand(SqlRefreshStatitsicsCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.REFRESH_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        indexing.statsManager().refreshStatistics(targets);
    }

    private void processDropStatisticsCommand(SqlDropStatisticsCommand cmd) throws IgniteCheckedException {
        this.ctx.security().authorize(SecurityPermission.CHANGE_STATISTICS);
        IgniteH2Indexing indexing = (IgniteH2Indexing)this.ctx.query().getIndexing();
        StatisticsTarget[] targets = (StatisticsTarget[])cmd.targets().stream().map(t -> t.schema() == null ? new StatisticsTarget(cmd.schemaName(), t.obj(), t.columns()) : t).toArray(StatisticsTarget[]::new);
        indexing.statsManager().dropStatistics(targets);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runCommandH2(String sql, GridSqlStatement cmdH2) {
        GridFinishedFuture fut = null;
        try {
            this.finishActiveTxIfNecessary();
            if (cmdH2 instanceof GridSqlCreateIndex) {
                GridSqlCreateIndex cmd = (GridSqlCreateIndex)cmdH2;
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, cmd.tableName());
                }
                assert (tbl.rowDescriptor() != null);
                CommandProcessor.ensureDdlSupported((GridCacheContextInfo)tbl.cacheInfo());
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(cmd.index().getName());
                newIdx.setIndexType(cmd.index().getIndexType());
                LinkedHashMap flds = new LinkedHashMap();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (Map.Entry e : cmd.index().getFields().entrySet()) {
                    GridQueryProperty prop = typeDesc.property((String)e.getKey());
                    if (prop == null) {
                        throw new SchemaOperationException(4, (String)e.getKey());
                    }
                    flds.put(prop.name(), e.getValue());
                }
                newIdx.setFields(flds);
                fut = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), cmd.schemaName(), typeDesc.tableName(), newIdx, cmd.ifNotExists(), 0);
            } else if (cmdH2 instanceof GridSqlDropIndex) {
                GridSqlDropIndex cmd = (GridSqlDropIndex)cmdH2;
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTableForIndex(cmd.schemaName(), cmd.indexName());
                if (tbl != null) {
                    CommandProcessor.ensureDdlSupported((GridCacheContextInfo)tbl.cacheInfo());
                    fut = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), cmd.schemaName(), cmd.indexName(), cmd.ifExists());
                } else {
                    if (!cmd.ifExists()) throw new SchemaOperationException(6, cmd.indexName());
                    fut = new GridFinishedFuture();
                }
            } else if (cmdH2 instanceof GridSqlCreateTable) {
                GridSqlCreateTable cmd = (GridSqlCreateTable)cmdH2;
                this.ctx.security().authorize(cmd.cacheName(), SecurityPermission.CACHE_CREATE);
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl != null) {
                    if (!cmd.ifNotExists()) {
                        throw new SchemaOperationException(3, cmd.tableName());
                    }
                } else {
                    QueryEntity e = CommandProcessor.toQueryEntity(cmd);
                    CacheConfiguration ccfg = new CacheConfiguration(cmd.tableName());
                    ccfg.setQueryEntities(Collections.singleton(e));
                    ccfg.setSqlSchema(cmd.schemaName());
                    SchemaOperationException err = QueryUtils.checkQueryEntityConflicts((CacheConfiguration)ccfg, this.ctx.cache().cacheDescriptors().values());
                    if (err != null) {
                        throw err;
                    }
                    if (!F.isEmpty((String)cmd.cacheName()) && this.ctx.cache().cacheDescriptor(cmd.cacheName()) != null) {
                        this.ctx.query().dynamicAddQueryEntity(cmd.cacheName(), cmd.schemaName(), e, cmd.parallelism(), true).get();
                    } else {
                        this.ctx.query().dynamicTableCreate(cmd.schemaName(), e, cmd.templateName(), cmd.cacheName(), cmd.cacheGroup(), cmd.dataRegionName(), cmd.affinityKey(), cmd.atomicityMode(), cmd.writeSynchronizationMode(), cmd.backups(), cmd.ifNotExists(), cmd.encrypted(), cmd.parallelism());
                    }
                }
            } else if (cmdH2 instanceof GridSqlDropTable) {
                GridSqlDropTable cmd = (GridSqlDropTable)cmdH2;
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    this.ctx.security().authorize(tbl.cacheName(), SecurityPermission.CACHE_DESTROY);
                    this.ctx.query().dynamicTableDrop(tbl.cacheName(), cmd.tableName(), cmd.ifExists());
                }
            } else if (cmdH2 instanceof GridSqlAlterTableAddColumn) {
                GridSqlAlterTableAddColumn cmd = (GridSqlAlterTableAddColumn)cmdH2;
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifTableExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    if (QueryUtils.isSqlType((Class)tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot add column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<QueryField> cols = new ArrayList<QueryField>(cmd.columns().length);
                    boolean allFieldsNullable = true;
                    for (GridSqlColumn col : cmd.columns()) {
                        if (tbl.doesColumnExist(col.columnName())) {
                            if (!cmd.ifNotExists() || cmd.columns().length != 1) {
                                throw new SchemaOperationException(5, col.columnName());
                            }
                            cols = null;
                            break;
                        }
                        QueryField field = new QueryField(col.columnName(), CommandProcessor.getTypeClassName(col), col.column().isNullable(), col.defaultValue(), col.precision(), col.scale());
                        cols.add(field);
                        allFieldsNullable &= field.isNullable();
                    }
                    if (cols != null) {
                        assert (tbl.rowDescriptor() != null);
                        if (!allFieldsNullable) {
                            QueryUtils.checkNotNullAllowed((CacheConfiguration)tbl.cacheInfo().config());
                        }
                        fut = this.ctx.query().dynamicColumnAdd(tbl.cacheName(), cmd.schemaName(), tbl.rowDescriptor().type().tableName(), cols, cmd.ifTableExists(), cmd.ifNotExists());
                    }
                }
            } else {
                if (!(cmdH2 instanceof GridSqlAlterTableDropColumn)) throw new IgniteSQLException("Unsupported DDL operation: " + sql, 1002);
                GridSqlAlterTableDropColumn cmd = (GridSqlAlterTableDropColumn)cmdH2;
                QueryUtils.isDdlOnSchemaSupported((String)cmd.schemaName());
                GridH2Table tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName());
                if (tbl == null) {
                    if (!cmd.ifTableExists()) {
                        throw new SchemaOperationException(2, cmd.tableName());
                    }
                } else {
                    assert (tbl.rowDescriptor() != null);
                    GridCacheContext cctx = tbl.cacheContext();
                    assert (cctx != null);
                    if (cctx.mvccEnabled()) {
                        throw new IgniteSQLException("Cannot drop column(s) with enabled MVCC. Operation is unsupported at the moment.", 1002);
                    }
                    if (QueryUtils.isSqlType((Class)tbl.rowDescriptor().type().valueClass())) {
                        throw new SchemaOperationException("Cannot drop column(s) because table was created with WRAP_VALUE=false option.");
                    }
                    ArrayList<String> cols = new ArrayList<String>(cmd.columns().length);
                    GridQueryTypeDescriptor type = tbl.rowDescriptor().type();
                    for (String colName : cmd.columns()) {
                        if (!tbl.doesColumnExist(colName)) {
                            if (!cmd.ifExists() || cmd.columns().length != 1) {
                                throw new SchemaOperationException(4, colName);
                            }
                            cols = null;
                            break;
                        }
                        SchemaOperationException err = QueryUtils.validateDropColumn((GridQueryTypeDescriptor)type, (String)colName);
                        if (err != null) {
                            throw err;
                        }
                        cols.add(colName);
                    }
                    if (cols != null) {
                        fut = this.ctx.query().dynamicColumnRemove(tbl.cacheName(), cmd.schemaName(), type.tableName(), cols, cmd.ifTableExists(), cmd.ifExists());
                    }
                }
            }
            if (fut == null) return;
            fut.get();
            return;
        }
        catch (SchemaOperationException e) {
            U.error(null, (Object)"DDL operation failure", (Throwable)e);
            throw QueryUtils.convert((SchemaOperationException)e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException(e.getMessage(), (Throwable)e);
        }
    }

    private static QueryEntity toQueryEntity(GridSqlCreateTable createTbl) {
        QueryEntityEx res = new QueryEntityEx();
        res.setTableName(createTbl.tableName());
        HashSet<String> notNullFields = null;
        HashMap<String, Object> dfltValues = new HashMap<String, Object>();
        HashMap<String, Integer> precision = new HashMap<String, Integer>();
        HashMap<String, Integer> scale = new HashMap<String, Integer>();
        for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
            Object dfltVal;
            GridSqlColumn gridCol = e.getValue();
            Column col = gridCol.column();
            res.addQueryField(e.getKey(), CommandProcessor.getTypeClassName(gridCol), null);
            if (!col.isNullable()) {
                if (notNullFields == null) {
                    notNullFields = new HashSet<String>();
                }
                notNullFields.add(e.getKey());
            }
            if ((dfltVal = gridCol.defaultValue()) != null) {
                dfltValues.put(e.getKey(), dfltVal);
            }
            if (col.getType() == 6) {
                if (col.getPrecision() < 65535L) {
                    precision.put(e.getKey(), (int)col.getPrecision());
                }
                if (col.getScale() < Short.MAX_VALUE) {
                    scale.put(e.getKey(), col.getScale());
                }
            }
            if (col.getType() != 13 && col.getType() != 21 && col.getType() != 14 && col.getType() != 12 || col.getPrecision() >= Integer.MAX_VALUE) continue;
            precision.put(e.getKey(), (int)col.getPrecision());
        }
        if (!F.isEmpty(dfltValues)) {
            res.setDefaultFieldValues(dfltValues);
        }
        if (!F.isEmpty(precision)) {
            res.setFieldsPrecision(precision);
        }
        if (!F.isEmpty(scale)) {
            res.setFieldsScale(scale);
        }
        String valTypeName = QueryUtils.createTableValueTypeName((String)createTbl.schemaName(), (String)createTbl.tableName());
        String keyTypeName = QueryUtils.createTableKeyTypeName((String)valTypeName);
        if (!F.isEmpty((String)createTbl.keyTypeName())) {
            keyTypeName = createTbl.keyTypeName();
        }
        if (!F.isEmpty((String)createTbl.valueTypeName())) {
            valTypeName = createTbl.valueTypeName();
        }
        assert (createTbl.wrapKey() != null);
        assert (createTbl.wrapValue() != null);
        if (!createTbl.wrapKey().booleanValue()) {
            GridSqlColumn pkCol = createTbl.columns().get(createTbl.primaryKeyColumns().iterator().next());
            keyTypeName = CommandProcessor.getTypeClassName(pkCol);
            res.setKeyFieldName(pkCol.columnName());
        } else {
            res.setKeyFields(createTbl.primaryKeyColumns());
            res.setPreserveKeysOrder(true);
        }
        if (!createTbl.wrapValue().booleanValue()) {
            GridSqlColumn valCol = null;
            for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
                if (createTbl.primaryKeyColumns().contains(e.getKey())) continue;
                valCol = e.getValue();
                break;
            }
            assert (valCol != null);
            valTypeName = CommandProcessor.getTypeClassName(valCol);
            res.setValueFieldName(valCol.columnName());
        }
        res.setValueType(valTypeName);
        res.setKeyType(keyTypeName);
        if (!F.isEmpty(notNullFields)) {
            res.setNotNullFields(notNullFields);
        }
        res.fillAbsentPKsWithDefaults(true);
        if (Objects.nonNull(createTbl.primaryKeyInlineSize())) {
            res.setPrimaryKeyInlineSize(createTbl.primaryKeyInlineSize());
        }
        if (Objects.nonNull(createTbl.affinityKeyInlineSize())) {
            res.setAffinityKeyInlineSize(createTbl.affinityKeyInlineSize());
        }
        return res;
    }

    public static boolean isCommand(Prepared cmd) {
        return cmd instanceof CreateIndex || cmd instanceof DropIndex || cmd instanceof CreateTable || cmd instanceof DropTable || cmd instanceof AlterTableAlterColumn;
    }

    public static boolean isCommandNoOp(Prepared cmd) {
        return cmd instanceof NoOperation;
    }

    private static String getTypeClassName(GridSqlColumn col) {
        int type = col.column().getType();
        switch (type) {
            case 20: {
                if (handleUuidAsByte) break;
                return UUID.class.getName();
            }
        }
        return DataType.getTypeClassName((int)type);
    }

    private void processTxCommand(SqlCommand cmd, QueryParameters params) throws IgniteCheckedException {
        block14: {
            GridNearTxLocal tx;
            block12: {
                block13: {
                    NestedTxMode nestedTxMode = params.nestedTxMode();
                    tx = MvccUtils.tx((GridKernalContext)this.ctx);
                    if (!(cmd instanceof SqlBeginTransactionCommand)) break block12;
                    if (!MvccUtils.mvccEnabled((GridKernalContext)this.ctx)) {
                        throw new IgniteSQLException("MVCC must be enabled in order to start transaction.", 5002);
                    }
                    if (tx == null) break block13;
                    if (nestedTxMode == null) {
                        nestedTxMode = NestedTxMode.DEFAULT;
                    }
                    switch (nestedTxMode) {
                        case COMMIT: {
                            this.doCommit(tx);
                            MvccUtils.txStart((GridKernalContext)this.ctx, (long)params.timeout());
                            break block14;
                        }
                        case IGNORE: {
                            this.log.warning("Transaction has already been started, ignoring BEGIN command.");
                            break block14;
                        }
                        case ERROR: {
                            throw new IgniteSQLException("Transaction has already been started.", 5001);
                        }
                        default: {
                            throw new IgniteSQLException("Unexpected nested transaction handling mode: " + nestedTxMode.name());
                        }
                    }
                }
                MvccUtils.txStart((GridKernalContext)this.ctx, (long)params.timeout());
                break block14;
            }
            if (cmd instanceof SqlCommitTransactionCommand) {
                if (tx != null) {
                    this.doCommit(tx);
                }
            } else {
                assert (cmd instanceof SqlRollbackTransactionCommand);
                if (tx != null) {
                    this.doRollback(tx);
                }
            }
        }
    }

    private void doCommit(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.commit();
        }
        finally {
            this.closeTx(tx);
        }
    }

    public void doRollback(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.rollback();
        }
        finally {
            this.closeTx(tx);
        }
    }

    private void closeTx(@NotNull GridNearTxLocal tx) throws IgniteCheckedException {
        try {
            tx.close();
        }
        finally {
            this.ctx.cache().context().tm().resetContext();
        }
    }

    private void processSetStreamingCommand(SqlSetStreamingCommand cmd, @Nullable SqlClientContext cliCtx) {
        if (cliCtx == null) {
            throw new IgniteSQLException("SET STREAMING command can only be executed from JDBC or ODBC driver.");
        }
        if (cmd.isTurnOn()) {
            cliCtx.enableStreaming(cmd.allowOverwrite(), cmd.flushFrequency(), cmd.perNodeBufferSize(), cmd.perNodeParallelOperations(), cmd.isOrdered());
        } else {
            cliCtx.disableStreaming();
        }
    }

    private FieldsQueryCursor<List<?>> processBulkLoadCommand(SqlBulkLoadCommand cmd, long qryId) throws IgniteCheckedException {
        GridH2Table tbl;
        if (cmd.packetSize() == null) {
            cmd.packetSize(0x400000);
        }
        if ((tbl = this.schemaMgr.dataTable(cmd.schemaName(), cmd.tableName())) == null) {
            throw new IgniteSQLException("Table does not exist: " + cmd.tableName(), 3001);
        }
        H2Utils.checkAndStartNotStartedCache(this.ctx, tbl);
        UpdatePlan plan = UpdatePlanBuilder.planForBulkLoad(cmd, tbl);
        DmlBulkLoadDataConverter dataConverter = new DmlBulkLoadDataConverter(plan);
        IgniteDataStreamer streamer = this.ctx.grid().dataStreamer(tbl.cacheName());
        BulkLoadStreamerWriter outputWriter = new BulkLoadStreamerWriter(streamer);
        BulkLoadParser inputParser = BulkLoadParser.createParser((BulkLoadFormat)cmd.inputFormat());
        BulkLoadProcessor processor = new BulkLoadProcessor(inputParser, (IgniteClosureX)dataConverter, (BulkLoadCacheWriter)outputWriter, this.idx.runningQueryManager(), qryId, this.ctx.tracing());
        BulkLoadAckClientParameters params = new BulkLoadAckClientParameters(cmd.localFileName(), cmd.packetSize().intValue());
        return new BulkLoadContextCursor(processor, params);
    }
}

