/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class CommandLogger {
    public static final String INDENT = "  ";
    public static final String DOUBLE_INDENT = "    ";

    public static String join(String delimeter, Object ... params) {
        return CommandLogger.join(new SB(), "", delimeter, params).toString();
    }

    public static SB join(SB sb, String sbDelimeter, String delimeter, Object ... params) {
        if (!F.isEmpty((Object[])params)) {
            sb.a(sbDelimeter);
            for (Object par : params) {
                sb.a(par).a(delimeter);
            }
            sb.setLength(sb.length() - delimeter.length());
        }
        return sb;
    }

    public static String optional(Object ... params) {
        return CommandLogger.join(new SB(), "[", " ", params).a("]").toString();
    }

    public static String or(Object ... params) {
        return CommandLogger.join("|", params);
    }

    public static String grouped(Object ... params) {
        return CommandLogger.join(new SB(), "(", " ", params).a(")").toString();
    }

    public static String errorMessage(Throwable e) {
        String msg = e.getMessage();
        if (F.isEmpty((String)msg)) {
            msg = e.getClass().getName();
        } else if (msg.startsWith("Failed to handle request")) {
            int p = msg.indexOf("err=");
            msg = msg.substring(p + 4, msg.length() - 1);
        }
        return msg;
    }

    public static boolean printErrors(Map<UUID, Exception> exceptions, String infoMsg, Logger logger) {
        if (!F.isEmpty(exceptions)) {
            logger.info(infoMsg);
            for (Map.Entry<UUID, Exception> e : exceptions.entrySet()) {
                logger.info("  Node ID: " + e.getKey());
                logger.info("  Exception message:");
                logger.info(DOUBLE_INDENT + e.getValue().getMessage());
                logger.info("");
            }
            return true;
        }
        return false;
    }
}

