/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCheckTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTask;
import org.jetbrains.annotations.Nullable;

public enum SnapshotSubcommand {
    CREATE("create", VisorSnapshotCreateTask.class.getName()),
    CANCEL("cancel", VisorSnapshotCancelTask.class.getName()),
    CHECK("check", VisorSnapshotCheckTask.class.getName()),
    RESTORE("restore", VisorSnapshotRestoreTask.class.getName());

    private final String name;
    private final String taskName;

    private SnapshotSubcommand(String name, String taskName) {
        this.name = name;
        this.taskName = taskName;
    }

    @Nullable
    public static SnapshotSubcommand of(String text) {
        for (SnapshotSubcommand cmd : SnapshotSubcommand.values()) {
            if (!cmd.name.equalsIgnoreCase(text)) continue;
            return cmd;
        }
        throw new IllegalArgumentException("Expected correct action: " + text);
    }

    public String taskName() {
        return this.taskName;
    }

    public String toString() {
        return this.name;
    }
}

