/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property.subcommands;

import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.property.PropertyArgs;
import org.apache.ignite.internal.commandline.property.PropertySubCommandsList;
import org.apache.ignite.internal.commandline.property.subcommands.PropertyAbstractSubCommand;
import org.apache.ignite.internal.commandline.property.tasks.PropertyOperationResult;
import org.apache.ignite.internal.commandline.property.tasks.PropertyTask;

public class PropertyGetCommand
extends PropertyAbstractSubCommand<PropertyArgs, PropertyOperationResult> {
    @Override
    protected String taskName() {
        return PropertyTask.class.getName();
    }

    @Override
    public PropertyArgs parseArguments0(CommandArgIterator argIter) {
        String name = null;
        while (argIter.hasNextSubArg() && name == null) {
            String optName = argIter.nextArg("Expecting --name");
            if (!"--name".equals(optName)) continue;
            name = argIter.nextArg("property name");
        }
        if (name == null) {
            throw new IllegalArgumentException("Property name is not specified. Please use the option: --name <property_name>");
        }
        return new PropertyArgs(name, null, PropertyArgs.Action.GET);
    }

    @Override
    protected void printResult(PropertyOperationResult res, Logger log) {
        log.info(((PropertyArgs)this.arg()).name() + " = " + res.value());
    }

    @Override
    public String name() {
        return PropertySubCommandsList.GET.text();
    }
}

