/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.indexreader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.AbstractInlineLeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.LeafIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccInnerIO;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.MvccLeafIO;
import org.apache.ignite.internal.commandline.ProgressPrinter;
import org.apache.ignite.internal.commandline.StringBuilderOutputStream;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgument;
import org.apache.ignite.internal.commandline.argument.parser.CLIArgumentParser;
import org.apache.ignite.internal.commandline.indexreader.CacheAwareLink;
import org.apache.ignite.internal.commandline.indexreader.CountOnlyStorage;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactory;
import org.apache.ignite.internal.commandline.indexreader.IgniteIndexReaderFilePageStoreFactoryImpl;
import org.apache.ignite.internal.commandline.indexreader.ItemCallback;
import org.apache.ignite.internal.commandline.indexreader.ItemStorage;
import org.apache.ignite.internal.commandline.indexreader.ItemsListStorage;
import org.apache.ignite.internal.commandline.indexreader.LinkStorage;
import org.apache.ignite.internal.commandline.indexreader.PageCallback;
import org.apache.ignite.internal.commandline.indexreader.PageContent;
import org.apache.ignite.internal.commandline.indexreader.PageListsInfo;
import org.apache.ignite.internal.commandline.indexreader.TreeNode;
import org.apache.ignite.internal.commandline.indexreader.TreeTraversalInfo;
import org.apache.ignite.internal.commandline.indexreader.TreeTraverseContext;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingRowIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataLeafIO;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.lang.GridClosure3;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class IgniteIndexReader
implements AutoCloseable {
    private static final String META_TREE_NAME = "MetaTree";
    public static final String RECURSIVE_TRAVERSE_NAME = "<RECURSIVE> ";
    public static final String HORIZONTAL_SCAN_NAME = "<HORIZONTAL> ";
    private static final String PAGE_LISTS_PREFIX = "<PAGE_LIST> ";
    public static final String ERROR_PREFIX = "<ERROR> ";
    private static final Pattern CACHE_TYPE_ID_SEACH_PATTERN = Pattern.compile("(?<id>[-0-9]{1,15})_(?<typeId>[-0-9]{1,15})_.*");
    private static final Pattern CACHE_ID_SEACH_PATTERN = Pattern.compile("(?<id>[-0-9]{1,15})_.*");
    private static final int CHECK_PARTS_MAX_ERRORS_PER_PARTITION = 10;
    private static final Map<String, IgnitePair<Integer>> CACHE_TYPE_IDS = new HashMap<String, IgnitePair<Integer>>();
    private final int pageSize;
    private final int partCnt;
    @Nullable
    private final Predicate<String> idxFilter;
    private final PrintStream outStream;
    @Nullable
    private final FilePageStore idxStore;
    @Nullable
    private final FilePageStore[] partStores;
    private final boolean checkParts;
    private final Set<Integer> missingPartitions = new HashSet<Integer>();
    private final PageIOProcessor innerPageIOProcessor = new InnerPageIOProcessor();
    private final PageIOProcessor leafPageIOProcessor = new LeafPageIOProcessor();
    private final PageIOProcessor metaPageIOProcessor = new MetaPageIOProcessor();

    public IgniteIndexReader(@Nullable Predicate<String> idxFilter, boolean checkParts, @Nullable PrintStream outStream, IgniteIndexReaderFilePageStoreFactory filePageStoreFactory) throws IgniteCheckedException {
        this.pageSize = filePageStoreFactory.pageSize();
        this.partCnt = filePageStoreFactory.partitionCount();
        this.checkParts = checkParts;
        this.idxFilter = idxFilter;
        this.outStream = Objects.isNull(outStream) ? System.out : outStream;
        HashMap<Integer, List<Throwable>> partStoresErrors = new HashMap<Integer, List<Throwable>>();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.idxStore = filePageStoreFactory.createFilePageStoreWithEnsure(65535, (byte)2, errors);
        if (!errors.isEmpty()) {
            partStoresErrors.put(65535, new ArrayList<Throwable>(errors));
        }
        if (Objects.isNull(this.idxStore)) {
            throw new IgniteCheckedException("index.bin file not found");
        }
        this.print("Analyzing file: index.bin");
        this.partStores = new FilePageStore[this.partCnt];
        for (int i = 0; i < this.partCnt; ++i) {
            if (!errors.isEmpty()) {
                errors.clear();
            }
            this.partStores[i] = filePageStoreFactory.createFilePageStoreWithEnsure(i, (byte)1, errors);
            if (errors.isEmpty()) continue;
            partStoresErrors.put(i, new ArrayList<Throwable>(errors));
        }
        this.printFileReadingErrors(partStoresErrors);
    }

    private void print(String s) {
        this.outStream.println(s);
    }

    private void printErr(String s) {
        this.outStream.println(ERROR_PREFIX + s);
    }

    private void printErrors(String prefix, String caption, @Nullable String alternativeCaption, String elementFormatPtrn, boolean printTrace, Map<?, ? extends List<? extends Throwable>> errors) {
        if (errors.isEmpty() && alternativeCaption != null) {
            this.print(prefix + alternativeCaption);
            return;
        }
        if (caption != null) {
            this.outStream.println(prefix + ERROR_PREFIX + caption);
        }
        errors.forEach((k, v) -> {
            this.outStream.println(prefix + ERROR_PREFIX + String.format(elementFormatPtrn, k.toString()));
            v.forEach(e -> {
                if (printTrace) {
                    this.printStackTrace((Throwable)e);
                } else {
                    this.printErr(e.getMessage());
                }
            });
        });
    }

    private void printPageStat(String prefix, String caption, Map<Class, Long> stat) {
        if (caption != null) {
            this.print(prefix + caption + (stat.isEmpty() ? " empty" : ""));
        }
        stat.forEach((cls, cnt) -> this.print(prefix + cls.getSimpleName() + ": " + cnt));
    }

    private void printStackTrace(Throwable e) {
        StringBuilderOutputStream os = new StringBuilderOutputStream();
        e.printStackTrace(new PrintStream(os));
        this.outStream.println(((Object)os).toString());
    }

    static long normalizePageId(long pageId) {
        return PageIdUtils.pageId((int)PageIdUtils.partId((long)pageId), (byte)PageIdUtils.flag((long)pageId), (int)PageIdUtils.pageIndex((long)pageId));
    }

    private void readPage(FilePageStore store, long pageId, ByteBuffer buf) throws IgniteCheckedException {
        try {
            store.read(pageId, buf, false);
        }
        catch (IllegalArgumentException | IgniteDataIntegrityViolationException e) {
            throw new IgniteException("Failed to read page, id=" + pageId + ", idx=" + PageIdUtils.pageIndex((long)pageId) + ", file=" + store.getFileAbsolutePath());
        }
    }

    IgniteBiTuple<Long, Long> partitionRoots(long pageMetaPageId) throws IgniteCheckedException {
        AtomicLong pageListMetaPageId = new AtomicLong();
        AtomicLong metaTreeRootId = new AtomicLong();
        this.doWithBuffer((buf, addr) -> {
            this.readPage(this.filePageStore(PageIdUtils.partId((long)pageMetaPageId)), pageMetaPageId, buf);
            PageMetaIO pageMetaIO = (PageMetaIO)PageIO.getPageIO((long)addr);
            pageListMetaPageId.set(IgniteIndexReader.normalizePageId(pageMetaIO.getReuseListRoot(addr.longValue())));
            metaTreeRootId.set(IgniteIndexReader.normalizePageId(pageMetaIO.getTreeRoot(addr.longValue())));
            return null;
        });
        return new IgniteBiTuple((Object)metaTreeRootId.get(), (Object)pageListMetaPageId.get());
    }

    public void readIdx() {
        List<Throwable> errors;
        long partPageStoresNum = Arrays.stream(this.partStores).filter(Objects::nonNull).count();
        this.print("Partitions files num: " + partPageStoresNum);
        HashMap<Class, Long> pageClasses = new HashMap<Class, Long>();
        long pagesNum = Objects.isNull(this.idxStore) ? 0L : (this.idxStore.size() - (long)this.idxStore.headerSize()) / (long)this.pageSize;
        this.print("Going to check " + pagesNum + " pages.");
        HashSet pageIds = new HashSet();
        AtomicReference<Map<String, TreeTraversalInfo>> treeInfo = new AtomicReference<Map<String, TreeTraversalInfo>>();
        AtomicReference<Map<String, TreeTraversalInfo>> horizontalScans = new AtomicReference<Map<String, TreeTraversalInfo>>();
        AtomicReference<PageListsInfo> pageListsInfo = new AtomicReference<PageListsInfo>();
        try {
            IgniteBiTuple<Long, Long> indexPartitionRoots = this.partitionRoots(IgniteIndexReader.partMetaPageId(65535, (byte)2));
            long metaTreeRootId = (Long)indexPartitionRoots.get1();
            long pageListMetaPageId = (Long)indexPartitionRoots.get2();
            treeInfo.set(this.traverseAllTrees("Index trees traversal", metaTreeRootId, CountOnlyStorage::new, this::traverseTree));
            ((Map)treeInfo.get()).forEach((name, info) -> {
                pageIds.addAll(info.innerPageIds);
                pageIds.add(info.rootPageId);
            });
            Supplier<ItemStorage> itemStorageFactory = this.checkParts ? LinkStorage::new : CountOnlyStorage::new;
            horizontalScans.set(this.traverseAllTrees("Scan index trees horizontally", metaTreeRootId, itemStorageFactory, this::horizontalTreeScan));
            if (pageListMetaPageId != 0L) {
                pageListsInfo.set(this.getPageListsInfo(pageListMetaPageId));
            }
            ProgressPrinter progressPrinter = new ProgressPrinter(System.out, "Reading pages sequentially", pagesNum);
            errors = this.scanFileStore(65535, (byte)2, this.idxStore, (GridClosure3<Long, Long, PageIO, Boolean>)((GridClosure3)(pageId, addr, io) -> {
                progressPrinter.printProgress();
                pageClasses.compute(io.getClass(), (k, v) -> v == null ? 1L : v + 1L);
                if (!(io instanceof PageMetaIO || io instanceof PagesListMetaIO || this.idxFilter != null || !(io instanceof BPlusMetaIO) && !(io instanceof BPlusInnerIO) || pageIds.contains(pageId) || pageListsInfo.get() == null || ((PageListsInfo)pageListsInfo.get()).allPages.contains(pageId))) {
                    throw new IgniteException("Possibly orphan " + io.getClass().getSimpleName() + " page, pageId=" + pageId);
                }
                return true;
            }));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("index.bin scan problem", (Throwable)e);
        }
        if (treeInfo.get() == null) {
            this.printErr("No tree meta info found.");
        } else {
            this.printTraversalResults(RECURSIVE_TRAVERSE_NAME, (Map)treeInfo.get());
            this.printTraversalResults(HORIZONTAL_SCAN_NAME, (Map)horizontalScans.get());
        }
        this.compareTraversals((Map)treeInfo.get(), (Map)horizontalScans.get());
        if (pageListsInfo.get() == null) {
            this.printErr("No page lists meta info found.");
        } else {
            this.printPagesListsInfo((PageListsInfo)pageListsInfo.get());
        }
        this.printPageStat("", "\n---These pages types were encountered during sequential scan:", pageClasses);
        if (!errors.isEmpty()) {
            this.printErr("---");
            this.printErr("Errors:");
            errors.forEach(this::printStackTrace);
        }
        this.print("---");
        this.print("Total pages encountered during sequential scan: " + pageClasses.values().stream().mapToLong(a -> a).sum());
        this.print("Total errors occurred during sequential scan: " + errors.size());
        if (this.idxFilter != null) {
            this.print("Orphan pages were not reported due to --indexes filter.");
        }
        this.print("Note that some pages can be occupied by meta info, tracking info, etc., so total page count can differ from count of pages found in index trees and page lists.");
        if (this.checkParts) {
            Map<Integer, List<Throwable>> checkPartsErrors = this.checkParts((Map)horizontalScans.get());
            this.print("");
            this.printErrors("", "Partitions check:", "Partitions check detected no errors.", "Errors detected in partition, partId=%s", false, checkPartsErrors);
            this.print("\nPartition check finished, total errors: " + checkPartsErrors.values().stream().mapToInt(List::size).sum() + ", total problem partitions: " + checkPartsErrors.size());
        }
    }

    private void printFileReadingErrors(Map<Integer, List<Throwable>> partStoresErrors) {
        List<Throwable> idxPartErrors = partStoresErrors.get(65535);
        if (!F.isEmpty(idxPartErrors)) {
            this.printErr("Errors detected while reading index.bin");
            idxPartErrors.forEach(err -> this.printErr(err.getMessage()));
            partStoresErrors.remove(65535);
        }
        if (!partStoresErrors.isEmpty()) {
            this.printErrors("", "Errors detected while reading partition files:", null, "Partition id: %s, exceptions: ", false, partStoresErrors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithBuffer(BufferClosure<T> c) throws IgniteCheckedException {
        ByteBuffer buf = GridUnsafe.allocateBuffer((int)this.pageSize);
        try {
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            T t = c.apply(buf, addr);
            return t;
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
    }

    private List<Throwable> scanFileStore(int partId, byte flag, FilePageStore store, GridClosure3<Long, Long, PageIO, Boolean> c) throws IgniteCheckedException {
        return this.doWithBuffer((buf, addr) -> {
            ArrayList<IgniteException> errors = new ArrayList<IgniteException>();
            long pagesNum = Objects.isNull(store) ? 0L : (store.size() - (long)store.headerSize()) / (long)this.pageSize;
            int i = 0;
            while ((long)i < pagesNum) {
                buf.rewind();
                try {
                    long pageId = PageIdUtils.pageId((int)partId, (byte)flag, (int)i);
                    this.readPage(store, pageId, buf);
                    PageIO io = PageIO.getPageIO((long)addr);
                    if (!((Boolean)c.apply((Object)pageId, (Object)addr, (Object)io)).booleanValue()) {
                        break;
                    }
                }
                catch (Throwable e) {
                    String err = "Exception occurred on step " + i + ": " + e.getMessage();
                    errors.add(new IgniteException(err, e));
                }
                ++i;
            }
            return errors;
        });
    }

    private Map<Integer, List<Throwable>> checkParts(Map<String, TreeTraversalInfo> aTreesInfo) {
        System.out.println();
        HashMap<Integer, List<Throwable>> res = new HashMap<Integer, List<Throwable>>();
        HashMap<String, TreeTraversalInfo> treesInfo = new HashMap<String, TreeTraversalInfo>(aTreesInfo);
        treesInfo.remove(META_TREE_NAME);
        ProgressPrinter progressPrinter = new ProgressPrinter(System.out, "Checking partitions", this.partCnt);
        for (int i = 0; i < this.partCnt; ++i) {
            progressPrinter.printProgress();
            FilePageStore partStore = this.partStores[i];
            if (partStore == null) continue;
            LinkedList<IgniteException> errors = new LinkedList<IgniteException>();
            int partId = i;
            try {
                long partMetaId = IgniteIndexReader.partMetaPageId(i, (byte)1);
                this.doWithBuffer((buf, addr) -> {
                    this.readPage(partStore, partMetaId, buf);
                    PagePartitionMetaIO partMetaIO = (PagePartitionMetaIO)PageIO.getPageIO((long)addr);
                    long cacheDataTreeRoot = partMetaIO.getTreeRoot(addr.longValue());
                    TreeTraversalInfo cacheDataTreeInfo = this.horizontalTreeScan(cacheDataTreeRoot, "dataTree-" + partId, new ItemsListStorage());
                    for (Object dataTreeItem : cacheDataTreeInfo.itemStorage) {
                        CacheAwareLink cacheAwareLink = (CacheAwareLink)dataTreeItem;
                        for (Map.Entry e : treesInfo.entrySet()) {
                            String name = (String)e.getKey();
                            TreeTraversalInfo tree = (TreeTraversalInfo)e.getValue();
                            int cacheId = IgniteIndexReader.getCacheId(name);
                            if (cacheId != cacheAwareLink.cacheId || tree.itemStorage.contains(cacheAwareLink) || cacheAwareLink.tombstone) continue;
                            errors.add(new IgniteException(this.cacheDataTreeEntryMissingError(name, cacheAwareLink)));
                        }
                        if (errors.size() < 10) continue;
                        errors.add(new IgniteException("Too many errors (10) found for partId=" + partId + ", stopping analysis for this partition."));
                        break;
                    }
                    return null;
                });
            }
            catch (IgniteCheckedException e) {
                errors.add(new IgniteException("Partition check failed, partId=" + i, (Throwable)e));
            }
            if (errors.isEmpty()) continue;
            res.put(partId, errors);
        }
        return res;
    }

    private String cacheDataTreeEntryMissingError(String treeName, CacheAwareLink cacheAwareLink) {
        long link = cacheAwareLink.link;
        long pageId = PageIdUtils.pageId((long)link);
        int itemId = PageIdUtils.itemId((long)link);
        int partId = PageIdUtils.partId((long)pageId);
        int pageIdx = PageIdUtils.pageIndex((long)pageId);
        return "Entry is missing in index: " + treeName + ", cacheId=" + cacheAwareLink.cacheId + ", partId=" + partId + ", pageIndex=" + pageIdx + ", itemId=" + itemId + ", link=" + link;
    }

    public static long partMetaPageId(int partId, byte flag) {
        return PageIdUtils.pageId((int)partId, (byte)flag, (int)0);
    }

    private void compareTraversals(Map<String, TreeTraversalInfo> treeInfos, Map<String, TreeTraversalInfo> treeScans) {
        LinkedList errors = new LinkedList();
        HashSet treeIdxNames = new HashSet();
        treeInfos.forEach((name, tree) -> {
            treeIdxNames.add(name);
            TreeTraversalInfo scan = (TreeTraversalInfo)treeScans.get(name);
            if (scan == null) {
                errors.add("Tree was detected in <RECURSIVE>  but absent in  <HORIZONTAL> : " + name);
                return;
            }
            if (tree.itemStorage.size() != scan.itemStorage.size()) {
                errors.add(this.compareError("items", (String)name, tree.itemStorage.size(), scan.itemStorage.size(), null));
            }
            HashSet classesInStat = new HashSet();
            tree.ioStat.forEach((cls, cnt) -> {
                classesInStat.add(cls);
                long scanCnt = scan.ioStat.getOrDefault(cls, 0L);
                if (scanCnt != cnt) {
                    errors.add(this.compareError("pages", (String)name, (long)cnt, scanCnt, (Class)cls));
                }
            });
            scan.ioStat.forEach((cls, cnt) -> {
                if (classesInStat.contains(cls)) {
                    return;
                }
                errors.add(this.compareError("pages", (String)name, 0L, (long)cnt, (Class)cls));
            });
        });
        treeScans.forEach((name, tree) -> {
            if (!treeIdxNames.contains(name)) {
                errors.add("Tree was detected in <HORIZONTAL>  but absent in  <RECURSIVE> : " + name);
            }
        });
        errors.forEach(this::printErr);
        this.print("Comparing traversals detected " + errors.size() + " errors.");
        this.print("------------------");
    }

    private String compareError(String itemName, String idxName, long fromRoot, long scan, Class pageType) {
        return String.format("Different count of %s; index: %s, %s:%s, %s:%s" + (pageType == null ? "" : ", pageType: " + pageType.getName()), itemName, idxName, RECURSIVE_TRAVERSE_NAME, fromRoot, HORIZONTAL_SCAN_NAME, scan);
    }

    private PageListsInfo getPageListsInfo(long metaPageListId) {
        HashMap<IgniteBiTuple<Long, Integer>, List<Long>> bucketsData = new HashMap<IgniteBiTuple<Long, Integer>, List<Long>>();
        HashSet<Long> allPages = new HashSet<Long>();
        HashMap<Class, Long> pageListStat = new HashMap<Class, Long>();
        HashMap<Long, List<Throwable>> errors = new HashMap<Long, List<Throwable>>();
        try {
            this.doWithBuffer((buf, addr) -> {
                long nextMetaId = metaPageListId;
                while (nextMetaId != 0L) {
                    try {
                        buf.rewind();
                        this.readPage(this.idxStore, nextMetaId, buf);
                        PagesListMetaIO io = (PagesListMetaIO)PageIO.getPageIO((long)addr);
                        HashMap<Integer, GridLongList> data = new HashMap<Integer, GridLongList>();
                        io.getBucketsData(addr.longValue(), data);
                        long fNextMetaId = nextMetaId;
                        data.forEach((k, v) -> {
                            List listIds = LongStream.of(v.array()).map(IgniteIndexReader::normalizePageId).boxed().collect(Collectors.toList());
                            for (Long listId : listIds) {
                                try {
                                    allPages.addAll(this.getPageList(listId, pageListStat));
                                }
                                catch (Exception e) {
                                    errors.put(listId, Collections.singletonList(e));
                                }
                            }
                            bucketsData.put(new IgniteBiTuple((Object)fNextMetaId, k), listIds);
                        });
                        nextMetaId = io.getNextMetaPageId(addr.longValue());
                    }
                    catch (Exception e) {
                        errors.put(nextMetaId, Collections.singletonList(e));
                        nextMetaId = 0L;
                    }
                }
                return null;
            });
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        return new PageListsInfo(bucketsData, allPages, pageListStat, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Long> getPageList(long pageListStartId, Map<Class, Long> pageStat) {
        LinkedList<Long> res = new LinkedList<Long>();
        long nextNodeId = pageListStartId;
        ByteBuffer nodeBuf = GridUnsafe.allocateBuffer((int)this.pageSize);
        ByteBuffer pageBuf = GridUnsafe.allocateBuffer((int)this.pageSize);
        long nodeAddr = GridUnsafe.bufferAddress((ByteBuffer)nodeBuf);
        long pageAddr = GridUnsafe.bufferAddress((ByteBuffer)pageBuf);
        try {
            while (nextNodeId != 0L) {
                try {
                    nodeBuf.rewind();
                    this.readPage(this.idxStore, nextNodeId, nodeBuf);
                    PagesListNodeIO io = (PagesListNodeIO)PageIO.getPageIO((long)nodeAddr);
                    for (int i = 0; i < io.getCount(nodeAddr); ++i) {
                        pageBuf.rewind();
                        long pageId = IgniteIndexReader.normalizePageId(io.getAt(nodeAddr, i));
                        res.add(pageId);
                        this.readPage(this.idxStore, pageId, pageBuf);
                        PageIO pageIO = PageIO.getPageIO((long)pageAddr);
                        pageStat.compute(pageIO.getClass(), (k, v) -> v == null ? 1L : v + 1L);
                    }
                    nextNodeId = io.getNextId(nodeAddr);
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e.getMessage(), (Throwable)e);
                    return res;
                }
            }
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)nodeBuf);
            GridUnsafe.freeBuffer((ByteBuffer)pageBuf);
        }
    }

    private Map<String, TreeTraversalInfo> traverseAllTrees(String traverseProcCaption, long metaTreeRoot, Supplier<ItemStorage> itemStorageFactory, TraverseProc traverseProc) {
        LinkedHashMap<String, TreeTraversalInfo> treeInfos = new LinkedHashMap<String, TreeTraversalInfo>();
        TreeTraversalInfo metaTreeTraversalInfo = traverseProc.traverse(metaTreeRoot, META_TREE_NAME, new ItemsListStorage());
        treeInfos.put(META_TREE_NAME, metaTreeTraversalInfo);
        ProgressPrinter progressPrinter = new ProgressPrinter(System.out, traverseProcCaption, metaTreeTraversalInfo.itemStorage.size());
        metaTreeTraversalInfo.itemStorage.forEach(item -> {
            progressPrinter.printProgress();
            IndexStorageImpl.IndexItem idxItem = (IndexStorageImpl.IndexItem)item;
            if (Objects.nonNull(this.idxFilter) && !this.idxFilter.test(idxItem.nameString())) {
                return;
            }
            TreeTraversalInfo treeTraversalInfo = traverseProc.traverse(IgniteIndexReader.normalizePageId(idxItem.pageId()), idxItem.nameString(), (ItemStorage)itemStorageFactory.get());
            treeInfos.put(idxItem.toString(), treeTraversalInfo);
        });
        return treeInfos;
    }

    private void printTraversalResults(String prefix, Map<String, TreeTraversalInfo> treeInfos) {
        this.print("\n" + prefix + "Tree traversal results");
        HashMap<Class, Long> totalStat = new HashMap<Class, Long>();
        AtomicInteger totalErr = new AtomicInteger(0);
        HashMap<IgnitePair, Map> cacheIdxSizes = new HashMap<IgnitePair, Map>();
        treeInfos.forEach((idxName, validationInfo) -> {
            this.print(prefix + "-----");
            this.print(prefix + "Index tree: " + idxName);
            this.print(prefix + "-- Page stat:");
            validationInfo.ioStat.forEach((cls, cnt) -> {
                this.print(prefix + cls.getSimpleName() + ": " + cnt);
                totalStat.compute((Class)cls, (k, v) -> v == null ? 1L : v + 1L);
            });
            this.print(prefix + "-- Count of items found in leaf pages: " + validationInfo.itemStorage.size());
            this.printErrors(prefix, "Errors:", "No errors occurred while traversing.", "Page id=%s, exceptions:", true, validationInfo.errors);
            totalErr.addAndGet(validationInfo.errors.size());
            cacheIdxSizes.computeIfAbsent(IgniteIndexReader.getCacheAndTypeId(idxName), k -> new HashMap()).put(idxName, validationInfo.itemStorage.size());
        });
        this.print(prefix + "---");
        this.printPageStat(prefix, "Total page stat collected during trees traversal:", totalStat);
        this.print("");
        AtomicBoolean sizeConsistencyErrorsFound = new AtomicBoolean(false);
        cacheIdxSizes.forEach((cacheTypeId, idxSizes) -> {
            if (idxSizes.values().stream().distinct().count() > 1L) {
                sizeConsistencyErrorsFound.set(true);
                totalErr.incrementAndGet();
                this.printErr("Index size inconsistency: cacheId=" + cacheTypeId.get1() + ", typeId=" + cacheTypeId.get2());
                idxSizes.forEach((name, size) -> this.printErr("     Index name: " + name + ", size=" + size));
            }
        });
        if (!sizeConsistencyErrorsFound.get()) {
            this.print(prefix + "No index size consistency errors found.");
        }
        this.print("");
        this.print(prefix + "Total trees: " + treeInfos.keySet().size());
        this.print(prefix + "Total pages found in trees: " + totalStat.values().stream().mapToLong(a -> a).sum());
        this.print(prefix + "Total errors during trees traversal: " + totalErr.get());
        this.print("");
        this.print("------------------");
    }

    public static int getCacheId(String name) {
        return (Integer)IgniteIndexReader.getCacheAndTypeId(name).get1();
    }

    public static IgnitePair<Integer> getCacheAndTypeId(String name) {
        return CACHE_TYPE_IDS.computeIfAbsent(name, k -> {
            Matcher mId = CACHE_TYPE_ID_SEACH_PATTERN.matcher((CharSequence)k);
            if (mId.find()) {
                String id = mId.group("id");
                String typeId = mId.group("typeId");
                return new IgnitePair((Object)Integer.parseInt(id), (Object)Integer.parseInt(typeId));
            }
            Matcher cId = CACHE_ID_SEACH_PATTERN.matcher((CharSequence)k);
            if (cId.find()) {
                String id = cId.group("id");
                return new IgnitePair((Object)Integer.parseInt(id), (Object)0);
            }
            return new IgnitePair((Object)0, (Object)0);
        });
    }

    private void printPagesListsInfo(PageListsInfo pageListsInfo) {
        String prefix = PAGE_LISTS_PREFIX;
        this.print("\n" + prefix + "Page lists info.");
        if (!pageListsInfo.bucketsData.isEmpty()) {
            this.print(prefix + "---Printing buckets data:");
        }
        pageListsInfo.bucketsData.forEach((bucket, bucketData) -> {
            GridStringBuilder sb = new GridStringBuilder(prefix).a("List meta id=").a(bucket.get1()).a(", bucket number=").a(bucket.get2()).a(", lists=[").a(bucketData.stream().map(String::valueOf).collect(Collectors.joining(", "))).a("]");
            this.print(sb.toString());
        });
        this.printPageStat(prefix, "-- Page stat:", pageListsInfo.pageListStat);
        this.printErrors(prefix, "---Errors:", "---No errors.", "Page id: %s, exception: ", true, pageListsInfo.errors);
        this.print("");
        this.print(prefix + "Total index pages found in lists: " + pageListsInfo.allPages.size());
        this.print(prefix + "Total errors during lists scan: " + pageListsInfo.errors.size());
        this.print("------------------");
    }

    TreeTraversalInfo traverseTree(long rootPageId, String treeName, @Nullable PageCallback innerCb, @Nullable PageCallback leafCb, @Nullable ItemCallback itemCb, ItemStorage itemStorage) {
        FilePageStore store = this.filePageStore(PageIdUtils.partId((long)rootPageId));
        HashMap<Class, Long> ioStat = new HashMap<Class, Long>();
        HashMap<Long, List<Throwable>> errors = new HashMap<Long, List<Throwable>>();
        HashSet<Long> innerPageIds = new HashSet<Long>();
        PageCallback innerCb0 = (content, pageId) -> {
            if (innerCb != null) {
                innerCb.cb(content, pageId);
            }
            innerPageIds.add(IgniteIndexReader.normalizePageId(pageId));
        };
        ItemCallback itemCb0 = (currPageId, item, link) -> {
            if (itemCb != null) {
                itemCb.cb(currPageId, item, link);
            }
            itemStorage.add(item);
        };
        this.getTreeNode(rootPageId, new TreeTraverseContext(treeName, store, ioStat, errors, innerCb0, leafCb, itemCb0));
        return new TreeTraversalInfo(ioStat, errors, innerPageIds, rootPageId, itemStorage);
    }

    TreeTraversalInfo traverseTree(long rootPageId, String treeName, ItemStorage itemStorage) {
        return this.traverseTree(rootPageId, treeName, null, null, null, itemStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeTraversalInfo horizontalTreeScan(long rootPageId, String treeName, ItemStorage itemStorage) {
        FilePageStore store = this.filePageStore(PageIdUtils.partId((long)rootPageId));
        HashMap<Long, List<Throwable>> errors = new HashMap<Long, List<Throwable>>();
        HashMap<Class, Long> ioStat = new HashMap<Class, Long>();
        TreeTraverseContext treeCtx = new TreeTraverseContext(treeName, store, ioStat, errors, null, null, null);
        ByteBuffer buf = GridUnsafe.allocateBuffer((int)this.pageSize);
        try {
            long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
            this.readPage(store, rootPageId, buf);
            PageIO pageIO = PageIO.getPageIO((long)addr);
            if (!(pageIO instanceof BPlusMetaIO)) {
                throw new IgniteException("Root page is not meta, pageId=" + rootPageId);
            }
            BPlusMetaIO metaIO = (BPlusMetaIO)pageIO;
            ioStat.compute(metaIO.getClass(), (k, v) -> v == null ? 1L : v + 1L);
            int lvlsCnt = metaIO.getLevelsCount(addr);
            long[] firstPageIds = IntStream.range(0, lvlsCnt).mapToLong(i -> metaIO.getFirstPageId(addr, i)).toArray();
            for (int i2 = 0; i2 < lvlsCnt; ++i2) {
                long pageId = firstPageIds[i2];
                while (pageId > 0L) {
                    try {
                        buf.rewind();
                        this.readPage(store, pageId, buf);
                        pageIO = PageIO.getPageIO((long)addr);
                        if (i2 == 0 && !(pageIO instanceof BPlusLeafIO)) {
                            throw new IgniteException("Not-leaf page found on leaf level, pageId=" + pageId + ", level=" + i2);
                        }
                        if (!(pageIO instanceof BPlusIO)) {
                            throw new IgniteException("Not-BPlus page found, pageId=" + pageId + ", level=" + i2);
                        }
                        ioStat.compute(pageIO.getClass(), (k, v) -> v == null ? 1L : v + 1L);
                        if (pageIO instanceof BPlusLeafIO) {
                            PageIOProcessor ioProcessor = this.getIOProcessor(pageIO);
                            PageContent pageContent = ioProcessor.getContent(pageIO, addr, pageId, treeCtx);
                            pageContent.items.forEach(itemStorage::add);
                        }
                        pageId = ((BPlusIO)pageIO).getForward(addr);
                    }
                    catch (Throwable e) {
                        errors.computeIfAbsent(pageId, k -> new LinkedList()).add(e);
                        pageId = 0L;
                    }
                }
            }
        }
        catch (Throwable e) {
            errors.computeIfAbsent(rootPageId, k -> new LinkedList()).add(e);
        }
        finally {
            GridUnsafe.freeBuffer((ByteBuffer)buf);
        }
        return new TreeTraversalInfo(ioStat, errors, null, rootPageId, itemStorage);
    }

    private FilePageStore filePageStore(int partId) {
        return partId == 65535 ? this.idxStore : this.partStores[partId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeNode getTreeNode(long pageId, TreeTraverseContext nodeCtx) {
        try {
            PageContent pageContent;
            PageIOProcessor ioProcessor;
            ByteBuffer buf = GridUnsafe.allocateBuffer((int)this.pageSize);
            try {
                this.readPage(nodeCtx.store, pageId, buf);
                long addr = GridUnsafe.bufferAddress((ByteBuffer)buf);
                PageIO io = PageIO.getPageIO((long)addr);
                nodeCtx.ioStat.compute(io.getClass(), (k, v) -> v == null ? 1L : v + 1L);
                ioProcessor = this.getIOProcessor(io);
                pageContent = ioProcessor.getContent(io, addr, pageId, nodeCtx);
            }
            finally {
                GridUnsafe.freeBuffer((ByteBuffer)buf);
            }
            return ioProcessor.getNode(pageContent, pageId, nodeCtx);
        }
        catch (Throwable e) {
            nodeCtx.errors.computeIfAbsent(pageId, k -> new LinkedList()).add(e);
            return new TreeNode(pageId, null, "exception: " + e.getMessage(), Collections.emptyList());
        }
    }

    private PageIOProcessor getIOProcessor(PageIO io) {
        if (io instanceof BPlusLeafIO) {
            return this.leafPageIOProcessor;
        }
        if (io instanceof BPlusInnerIO) {
            return this.innerPageIOProcessor;
        }
        if (io instanceof BPlusMetaIO) {
            return this.metaPageIOProcessor;
        }
        return null;
    }

    @Override
    public void close() throws StorageException {
        if (Objects.nonNull(this.idxStore)) {
            this.idxStore.stop(false);
        }
        if (Objects.nonNull(this.partStores)) {
            for (FilePageStore store : this.partStores) {
                if (!Objects.nonNull(store)) continue;
                store.stop(false);
            }
        }
    }

    private boolean readNextPage(ByteBuffer buf, FileChannel ch, int pageSize) throws IOException {
        assert (buf.remaining() == pageSize);
        while (ch.read(buf) != -1 && buf.hasRemaining()) {
        }
        if (!buf.hasRemaining() && PageIO.getPageId((ByteBuffer)buf) != 0L) {
            return true;
        }
        if (buf.remaining() == pageSize) {
            return false;
        }
        throw new IgniteException("Corrupted page in partitionId , readByte=" + buf.position() + ", pageSize=" + pageSize);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("THIS UTILITY MUST BE LAUNCHED ON PERSISTENT STORE WHICH IS NOT UNDER RUNNING GRID!");
        AtomicReference<CLIArgumentParser> parserRef = new AtomicReference<CLIArgumentParser>();
        List<CLIArgument> argsConfiguration = Arrays.asList(CLIArgument.mandatoryArg(Args.DIR.arg(), "partition directory, where index.bin and (optionally) partition files are located.", String.class), CLIArgument.optionalArg(Args.PART_CNT.arg(), "full partitions count in cache group.", Integer.class, () -> 0), CLIArgument.optionalArg(Args.PAGE_SIZE.arg(), "page size.", Integer.class, () -> 4096), CLIArgument.optionalArg(Args.PAGE_STORE_VER.arg(), "page store version.", Integer.class, () -> 2), CLIArgument.optionalArg(Args.INDEXES.arg(), "you can specify index tree names that will be processed, separated by comma without spaces, other index trees will be skipped.", String[].class, () -> null), CLIArgument.optionalArg(Args.DEST_FILE.arg(), "file to print the report to (by default report is printed to console).", String.class, () -> null), CLIArgument.optionalArg(Args.CHECK_PARTS.arg(), "check cache data tree in partition files and it's consistency with indexes.", Boolean.class, () -> false));
        CLIArgumentParser p = new CLIArgumentParser(argsConfiguration);
        parserRef.set(p);
        if (args.length == 0) {
            System.out.println(p.usage());
            return;
        }
        p.parse(Arrays.asList(args).iterator());
        String destFile = (String)p.get(Args.DEST_FILE.arg());
        FileOutputStream destStream = Objects.isNull(destFile) ? null : new FileOutputStream(destFile);
        String dir = (String)p.get(Args.DIR.arg());
        int pageSize = (Integer)p.get(Args.PAGE_SIZE.arg());
        IgniteIndexReaderFilePageStoreFactoryImpl filePageStoreFactory = new IgniteIndexReaderFilePageStoreFactoryImpl(new File(dir), pageSize, (Integer)p.get(Args.PART_CNT.arg()), (Integer)p.get(Args.PAGE_STORE_VER.arg()));
        String[] idxArr = (String[])p.get(Args.INDEXES.arg());
        HashSet<String> idxSet = Objects.isNull(idxArr) ? null : new HashSet<String>(Arrays.asList(idxArr));
        try (IgniteIndexReader reader = new IgniteIndexReader(Objects.isNull(idxSet) ? null : idxSet::contains, (Boolean)p.get(Args.CHECK_PARTS.arg()), Objects.isNull(destStream) ? null : new PrintStream(destFile), filePageStoreFactory);){
            reader.readIdx();
        }
    }

    static {
        PageIO.registerH2((IOVersions)InnerIO.VERSIONS, (IOVersions)LeafIO.VERSIONS, (IOVersions)MvccInnerIO.VERSIONS, (IOVersions)MvccLeafIO.VERSIONS);
        AbstractInlineInnerIO.register();
        AbstractInlineLeafIO.register();
    }

    private class LeafPageIOProcessor
    implements PageIOProcessor {
        private LeafPageIOProcessor() {
        }

        @Override
        public PageContent getContent(PageIO io, long addr, long pageId, TreeTraverseContext nodeCtx) {
            GridStringBuilder sb = new GridStringBuilder();
            LinkedList<Object> items = new LinkedList<Object>();
            BPlusLeafIO leafIO = (BPlusLeafIO)io;
            for (int j = 0; j < leafIO.getCount(addr); ++j) {
                Object idxItem = null;
                try {
                    if (io instanceof IndexStorageImpl.MetaStoreLeafIO) {
                        idxItem = ((IndexStorageImpl.MetaStoreLeafIO)io).getLookupRow(null, addr, j);
                        sb.a(idxItem.toString() + " ");
                    } else {
                        idxItem = this.getLeafItem(leafIO, pageId, addr, j, nodeCtx);
                    }
                }
                catch (Exception e) {
                    nodeCtx.errors.computeIfAbsent(pageId, k -> new LinkedList()).add(e);
                }
                if (idxItem == null) continue;
                items.add(idxItem);
            }
            return new PageContent(io, null, items, sb.toString());
        }

        private Object getLeafItem(BPlusLeafIO io, long pageId, long addr, int idx, TreeTraverseContext nodeCtx) {
            if (this.isLinkIo((PageIO)io)) {
                long link = this.getLink(io, addr, idx);
                int cacheId = io instanceof AbstractDataLeafIO && ((AbstractDataLeafIO)io).storeCacheId() ? ((AbstractDataLeafIO)io).getCacheId(addr, idx) : nodeCtx.cacheId;
                boolean tombstone = false;
                if (IgniteIndexReader.this.partCnt > 0) {
                    try {
                        long linkedPageId = PageIdUtils.pageId((long)link);
                        int linkedPagePartId = PageIdUtils.partId((long)linkedPageId);
                        if (IgniteIndexReader.this.missingPartitions.contains(linkedPagePartId)) {
                            return new CacheAwareLink(cacheId, link, false);
                        }
                        int linkedItemId = PageIdUtils.itemId((long)link);
                        if (linkedPagePartId > IgniteIndexReader.this.partStores.length - 1) {
                            IgniteIndexReader.this.missingPartitions.add(linkedPagePartId);
                            throw new IgniteException("Calculated data page partition id exceeds given partitions count: " + linkedPagePartId + ", partCnt=" + IgniteIndexReader.this.partCnt);
                        }
                        FilePageStore store = IgniteIndexReader.this.partStores[linkedPagePartId];
                        if (store == null) {
                            IgniteIndexReader.this.missingPartitions.add(linkedPagePartId);
                            throw new IgniteException("Corresponding store wasn't found for partId=" + linkedPagePartId + ". Does partition file exist?");
                        }
                        tombstone = (Boolean)IgniteIndexReader.this.doWithBuffer((dataBuf, dataBufAddr) -> {
                            IgniteIndexReader.this.readPage(store, linkedPageId, dataBuf);
                            PageIO dataIo = PageIO.getPageIO((int)PageIO.getType((ByteBuffer)dataBuf), (int)PageIO.getVersion((ByteBuffer)dataBuf));
                            if (dataIo instanceof AbstractDataPageIO) {
                                AbstractDataPageIO dataPageIO = (AbstractDataPageIO)dataIo;
                                DataPagePayload payload = dataPageIO.readPayload(dataBufAddr.longValue(), linkedItemId, IgniteIndexReader.this.pageSize);
                                if (payload.offset() <= 0 || payload.payloadSize() <= 0) {
                                    GridStringBuilder payloadInfo = new GridStringBuilder("Invalid data page payload: ").a("off=").a(payload.offset()).a(", size=").a(payload.payloadSize()).a(", nextLink=").a(payload.nextLink());
                                    throw new IgniteException(payloadInfo.toString());
                                }
                                if (payload.nextLink() == 0L) {
                                    if (io instanceof MvccDataLeafIO) {
                                        return false;
                                    }
                                    int off = payload.offset();
                                    int len = PageUtils.getInt((long)dataBufAddr, (int)off);
                                    byte type = PageUtils.getByte((long)dataBufAddr, (int)(off + len + 9));
                                    return type == -1;
                                }
                            }
                            return false;
                        });
                    }
                    catch (Exception e) {
                        nodeCtx.errors.computeIfAbsent(pageId, k -> new LinkedList()).add(e);
                    }
                }
                return new CacheAwareLink(cacheId, link, tombstone);
            }
            throw new IgniteException("Unexpected page io: " + io.getClass().getSimpleName());
        }

        private boolean isLinkIo(PageIO io) {
            return io instanceof InlineIO || io instanceof PendingRowIO || io instanceof RowLinkIO;
        }

        private long getLink(BPlusLeafIO io, long addr, int idx) {
            if (io instanceof RowLinkIO) {
                return ((RowLinkIO)io).getLink(addr, idx);
            }
            if (io instanceof InlineIO) {
                return ((InlineIO)io).link(addr, idx);
            }
            if (io instanceof PendingRowIO) {
                return ((PendingRowIO)io).getLink(addr, idx);
            }
            throw new IgniteException("No link to data page on idx=" + idx);
        }

        @Override
        public TreeNode getNode(PageContent content, long pageId, TreeTraverseContext nodeCtx) {
            if (nodeCtx.leafCb != null) {
                nodeCtx.leafCb.cb(content, pageId);
            }
            if (nodeCtx.itemCb != null) {
                for (Object item : content.items) {
                    nodeCtx.itemCb.cb(pageId, item, 0L);
                }
            }
            return new TreeNode(pageId, content.io, content.info, Collections.emptyList());
        }
    }

    private class InnerPageIOProcessor
    implements PageIOProcessor {
        private InnerPageIOProcessor() {
        }

        @Override
        public PageContent getContent(PageIO io, long addr, long pageId, TreeTraverseContext nodeCtx) {
            List<Object> childrenIds;
            BPlusInnerIO innerIo = (BPlusInnerIO)io;
            int cnt = innerIo.getCount(addr);
            if (cnt > 0) {
                childrenIds = new ArrayList(cnt + 1);
                for (int i = 0; i < cnt; ++i) {
                    childrenIds.add(innerIo.getLeft(addr, i));
                }
                childrenIds.add(innerIo.getRight(addr, cnt - 1));
            } else {
                long left = innerIo.getLeft(addr, 0);
                childrenIds = left == 0L ? Collections.emptyList() : Collections.singletonList(left);
            }
            return new PageContent(io, childrenIds, null, null);
        }

        @Override
        public TreeNode getNode(PageContent content, long pageId, TreeTraverseContext nodeCtx) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(content.linkedPageIds.size());
            for (Long id : content.linkedPageIds) {
                children.add(IgniteIndexReader.this.getTreeNode(id, nodeCtx));
            }
            if (nodeCtx.innerCb != null) {
                nodeCtx.innerCb.cb(content, pageId);
            }
            return new TreeNode(pageId, content.io, null, children);
        }
    }

    private class MetaPageIOProcessor
    implements PageIOProcessor {
        private MetaPageIOProcessor() {
        }

        @Override
        public PageContent getContent(PageIO io, long addr, long pageId, TreeTraverseContext nodeCtx) {
            BPlusMetaIO bPlusMetaIO = (BPlusMetaIO)io;
            int rootLvl = bPlusMetaIO.getRootLevel(addr);
            long rootId = bPlusMetaIO.getFirstPageId(addr, rootLvl);
            return new PageContent(io, Collections.singletonList(rootId), null, null);
        }

        @Override
        public TreeNode getNode(PageContent content, long pageId, TreeTraverseContext nodeCtx) {
            return new TreeNode(pageId, content.io, null, Collections.singletonList(IgniteIndexReader.this.getTreeNode(content.linkedPageIds.get(0), nodeCtx)));
        }
    }

    private static interface PageIOProcessor {
        public PageContent getContent(PageIO var1, long var2, long var4, TreeTraverseContext var6);

        public TreeNode getNode(PageContent var1, long var2, TreeTraverseContext var4);
    }

    private static interface TraverseProc {
        public TreeTraversalInfo traverse(long var1, String var3, ItemStorage var4);
    }

    private static interface BufferClosure<T> {
        public T apply(ByteBuffer var1, Long var2) throws IgniteCheckedException;
    }

    public static enum Args {
        DIR("--dir"),
        PART_CNT("--part-cnt"),
        PAGE_SIZE("--page-size"),
        PAGE_STORE_VER("--page-store-ver"),
        INDEXES("--indexes"),
        DEST_FILE("--dest-file"),
        CHECK_PARTS("--check-parts");

        private String arg;

        private Args(String arg) {
            this.arg = arg;
        }

        public String arg() {
            return this.arg;
        }
    }
}

