/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.consistency;

import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.consistency.ConsistencySubCommand;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyRepairTaskArg;
import org.apache.ignite.internal.visor.consistency.VisorConsistencyRepairTaskResult;

public class ConsistencyCommand
extends AbstractCommand<VisorConsistencyRepairTaskArg> {
    private VisorConsistencyRepairTaskArg cmdArg;
    private ConsistencySubCommand cmd;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        boolean failed = false;
        StringBuilder sb = new StringBuilder();
        try (GridClient client = Command.startClient(clientCfg);){
            VisorConsistencyRepairTaskResult res = (VisorConsistencyRepairTaskResult)TaskExecutor.executeTaskByNameOnNode(client, this.cmd.taskName(), this.arg(), TaskExecutor.BROADCAST_UUID, clientCfg);
            if (res.cancelled()) {
                sb.append("Operation execution cancelled.\n\n");
                failed = true;
            }
            if (res.failed()) {
                sb.append("Operation execution failed.\n\n");
                failed = true;
            }
            if (failed) {
                sb.append("[EXECUTION FAILED OR CANCELLED, RESULTS MAY BE INCOMPLETE OR INCONSISTENT]\n\n");
            }
            sb.append(res.message());
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
        String output = sb.toString();
        if (failed) {
            throw new IgniteCheckedException(output);
        }
        log.info(output);
        return output;
    }

    @Override
    public VisorConsistencyRepairTaskArg arg() {
        return this.cmdArg;
    }

    @Override
    public void printUsage(Logger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("cache-name", "Cache to be checked/repaired.");
        params.put("partition", "Cache's partition to be checked/repaired.");
        this.usage(log, "Checks/Repairs cache consistency using Read Repair approach:", CommandList.CONSISTENCY, params, ConsistencySubCommand.REPAIR.toString(), "cache-name", "partition");
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.cmd = ConsistencySubCommand.of(argIter.nextArg("Expected consistency action."));
        if (this.cmd != ConsistencySubCommand.REPAIR) {
            throw new IllegalArgumentException("Unsupported operation.");
        }
        String cacheName = argIter.nextArg("Expected cache name.");
        int part = argIter.nextNonNegativeIntArg("Expected partition.");
        this.cmdArg = new VisorConsistencyRepairTaskArg(cacheName, part);
    }

    @Override
    public String name() {
        return CommandList.CONSISTENCY.toCommandName();
    }

    @Override
    public boolean experimental() {
        return true;
    }
}

