/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsColumnData;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsObjectData;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.value.Value;

public class StatisticsUtils {
    public static StatisticsColumnData toMessage(ColumnStatistics stat) throws IgniteCheckedException {
        GridH2ValueMessage msgMin = stat.min() == null ? null : GridH2ValueMessageFactory.toMessage(stat.min());
        GridH2ValueMessage msgMax = stat.max() == null ? null : GridH2ValueMessageFactory.toMessage(stat.max());
        return new StatisticsColumnData(msgMin, msgMax, stat.nulls(), stat.distinct(), stat.total(), stat.size(), stat.raw(), stat.version(), stat.createdAt());
    }

    public static ColumnStatistics toColumnStatistics(GridKernalContext ctx, StatisticsColumnData data) throws IgniteCheckedException {
        Value min = data.min() == null ? null : data.min().value(ctx);
        Value max = data.max() == null ? null : data.max().value(ctx);
        return new ColumnStatistics(min, max, data.nulls(), data.distinct(), data.total(), data.size(), data.rawData(), data.version(), data.createdAt());
    }

    public static StatisticsObjectData toObjectData(StatisticsKeyMessage keyMsg, StatisticsType type, ObjectStatisticsImpl stat) throws IgniteCheckedException {
        StatisticsObjectData data;
        HashMap<String, StatisticsColumnData> colData = new HashMap<String, StatisticsColumnData>(stat.columnsStatistics().size());
        for (Map.Entry<String, ColumnStatistics> ts : stat.columnsStatistics().entrySet()) {
            colData.put(ts.getKey(), StatisticsUtils.toMessage(ts.getValue()));
        }
        if (stat instanceof ObjectPartitionStatisticsImpl) {
            ObjectPartitionStatisticsImpl partStats = (ObjectPartitionStatisticsImpl)stat;
            data = new StatisticsObjectData(keyMsg, stat.rowCount(), type, partStats.partId(), partStats.updCnt(), colData);
        } else {
            data = new StatisticsObjectData(keyMsg, stat.rowCount(), type, 0, 0L, colData);
        }
        return data;
    }

    public static StatisticsKeyMessage toMessage(String schema, String obj, String ... colNames) {
        return new StatisticsKeyMessage(schema, obj, F.asList((Object[])colNames));
    }

    public static ObjectPartitionStatisticsImpl toObjectPartitionStatistics(GridKernalContext ctx, StatisticsObjectData objData) throws IgniteCheckedException {
        if (objData == null) {
            return null;
        }
        assert (objData.type() == StatisticsType.PARTITION);
        HashMap<String, ColumnStatistics> colNameToStat = new HashMap<String, ColumnStatistics>(objData.data().size());
        for (Map.Entry<String, StatisticsColumnData> cs : objData.data().entrySet()) {
            colNameToStat.put(cs.getKey(), StatisticsUtils.toColumnStatistics(ctx, cs.getValue()));
        }
        return new ObjectPartitionStatisticsImpl(objData.partId(), objData.rowsCnt(), objData.updCnt(), colNameToStat);
    }

    public static ObjectStatisticsImpl toObjectStatistics(GridKernalContext ctx, StatisticsObjectData data) throws IgniteCheckedException {
        HashMap<String, ColumnStatistics> colNameToStat = new HashMap<String, ColumnStatistics>(data.data().size());
        for (Map.Entry<String, StatisticsColumnData> cs : data.data().entrySet()) {
            colNameToStat.put(cs.getKey(), StatisticsUtils.toColumnStatistics(ctx, cs.getValue()));
        }
        return new ObjectStatisticsImpl(data.rowsCnt(), colNameToStat);
    }

    public static StatisticsTarget statisticsTarget(StatisticsKeyMessage msg) {
        String[] cols = msg.colNames() == null ? null : msg.colNames().toArray(new String[0]);
        return new StatisticsTarget(msg.schema(), msg.obj(), cols);
    }
}

