/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.systemview.GridSystemViewManager;
import org.apache.ignite.internal.managers.systemview.walker.StatisticsColumnConfigurationViewWalker;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cluster.GridClusterStateProcessor;
import org.apache.ignite.internal.processors.metastorage.DistributedMetaStorage;
import org.apache.ignite.internal.processors.metastorage.DistributedMetastorageLifecycleListener;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.BusyExecutor;
import org.apache.ignite.internal.processors.query.stat.LocalStatisticsGatheringContext;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsProcessor;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.query.stat.view.ColumnConfigurationViewSupplier;
import org.apache.ignite.internal.processors.subscription.GridInternalSubscriptionProcessor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class IgniteStatisticsConfigurationManager {
    private static final String STAT_OBJ_PREFIX = "sql.statobj.";
    private static final String STAT_CFG_VIEW_NAME = "statistics.configuration";
    private static final String STAT_CFG_VIEW_DESCRIPTION = "Statistics configuration";
    public static final String[] EMPTY_STRINGS = new String[0];
    private final SchemaManager schemaMgr;
    private volatile DistributedMetaStorage distrMetaStorage;
    private final StatisticsProcessor statProc;
    private final BusyExecutor mgmtBusyExecutor;
    private final boolean persistence;
    private final IgniteLogger log;
    private volatile AffinityTopologyVersion topVer;
    private final GridClusterStateProcessor cluster;
    private final boolean isServerNode;
    private final DistributedMetastorageLifecycleListener distrMetaStoreLsnr = new DistributedMetastorageLifecycleListener(){

        public void onReadyForWrite(DistributedMetaStorage metastorage) {
            IgniteStatisticsConfigurationManager.this.distrMetaStorage = metastorage;
            IgniteStatisticsConfigurationManager.this.distrMetaStorage.listen(metaKey -> metaKey.startsWith(IgniteStatisticsConfigurationManager.STAT_OBJ_PREFIX), (k, oldV, newV) -> {
                if (IgniteStatisticsConfigurationManager.this.topVer == null) {
                    return;
                }
                IgniteStatisticsConfigurationManager.this.mgmtBusyExecutor.execute(() -> {
                    StatisticsObjectConfiguration newStatCfg = (StatisticsObjectConfiguration)newV;
                    IgniteStatisticsConfigurationManager.this.updateLocalStatistics(newStatCfg);
                });
            });
        }
    };
    private final BiConsumer<GridH2Table, List<String>> dropColsLsnr = new BiConsumer<GridH2Table, List<String>>(){

        @Override
        public void accept(GridH2Table tbl, List<String> cols) {
            assert (!F.isEmpty(cols));
            IgniteStatisticsConfigurationManager.this.dropStatistics(Collections.singletonList(new StatisticsTarget(tbl.identifier().schema(), tbl.getName(), cols.toArray(EMPTY_STRINGS))), false);
        }
    };
    private final BiConsumer<String, String> dropTblLsnr = new BiConsumer<String, String>(){

        @Override
        public void accept(String schema, String name) {
            block4: {
                assert (!F.isEmpty((String)schema) && !F.isEmpty((String)name)) : schema + ":" + name;
                StatisticsKey key = new StatisticsKey(schema, name);
                try {
                    StatisticsObjectConfiguration cfg = IgniteStatisticsConfigurationManager.this.config(key);
                    if (cfg != null && !F.isEmpty((Map)cfg.columns())) {
                        IgniteStatisticsConfigurationManager.this.dropStatistics(Collections.singletonList(new StatisticsTarget(schema, name, new String[0])), false);
                    }
                }
                catch (Throwable e) {
                    if (X.hasCause((Throwable)e, (Class[])new Class[]{NodeStoppingException.class})) break block4;
                    throw new IgniteSQLException("Error on drop statistics for dropped table [key=" + key + ']', e);
                }
            }
        }
    };

    public IgniteStatisticsConfigurationManager(SchemaManager schemaMgr, GridInternalSubscriptionProcessor subscriptionProcessor, GridSystemViewManager sysViewMgr, GridClusterStateProcessor cluster, StatisticsProcessor statProc, boolean persistence, IgniteThreadPoolExecutor mgmtPool, Function<Class<?>, IgniteLogger> logSupplier, boolean isServerNode) {
        this.schemaMgr = schemaMgr;
        this.log = logSupplier.apply(IgniteStatisticsConfigurationManager.class);
        this.persistence = persistence;
        this.mgmtBusyExecutor = new BusyExecutor("configuration", mgmtPool, logSupplier);
        this.statProc = statProc;
        this.cluster = cluster;
        this.isServerNode = isServerNode;
        subscriptionProcessor.registerDistributedMetastorageListener(this.distrMetaStoreLsnr);
        ColumnConfigurationViewSupplier colCfgViewSupplier = new ColumnConfigurationViewSupplier(this, logSupplier);
        sysViewMgr.registerFiltrableView(STAT_CFG_VIEW_NAME, STAT_CFG_VIEW_DESCRIPTION, (SystemViewRowAttributeWalker)new StatisticsColumnConfigurationViewWalker(), colCfgViewSupplier::columnConfigurationViewSupplier, Function.identity());
    }

    public void afterTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        DiscoveryCustomMessage msg;
        this.topVer = fut.topologyVersion();
        if (fut.exchangeType() != GridDhtPartitionsExchangeFuture.ExchangeType.ALL || this.persistence && this.cluster.clusterState().lastState() != ClusterState.ACTIVE) {
            return;
        }
        DiscoveryEvent evt = fut.firstEvent();
        if (evt.type() == 18 && (msg = ((DiscoveryCustomEvent)evt).customMessage()) instanceof DynamicCacheChangeBatch) {
            return;
        }
        this.mgmtBusyExecutor.execute(this::updateAllLocalStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalStatistics(StatisticsObjectConfiguration cfg) {
        GridH2Table tbl = this.schemaMgr.dataTable(cfg.key().schema(), cfg.key().obj());
        if (tbl == null || cfg.columns().isEmpty()) {
            if (this.log.isDebugEnabled()) {
                if (tbl == null) {
                    this.log.debug("Can't find table by key " + cfg.key() + ". Check statistics empty.");
                } else if (cfg == null) {
                    this.log.debug("Tombstone configuration by key " + cfg.key() + ". Check statistics empty.");
                }
            }
            LocalStatisticsGatheringContext ctx = new LocalStatisticsGatheringContext(false, tbl, cfg, Collections.emptySet(), this.topVer);
            this.statProc.updateLocalStatistics(ctx);
            if (tbl == null && !cfg.columns().isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Removing config for non existing object " + cfg.key());
                }
                this.dropStatistics(Collections.singletonList(new StatisticsTarget(cfg.key(), new String[0])), false);
            }
            return;
        }
        GridCacheContext cctx = tbl.cacheContext();
        if (cctx == null || !cctx.gate().enterIfNotStopped()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to lock table by key " + cfg.key() + ". Skipping statistics collection.");
            }
            return;
        }
        try {
            AffinityTopologyVersion topVer0 = (AffinityTopologyVersion)cctx.affinity().affinityReadyFuture(this.topVer).get();
            Set primParts = cctx.affinity().primaryPartitions(cctx.localNodeId(), topVer0);
            LocalStatisticsGatheringContext ctx = new LocalStatisticsGatheringContext(false, tbl, cfg, primParts, topVer0);
            this.statProc.updateLocalStatistics(ctx);
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unexpected error during statistics collection: " + e.getMessage(), (Throwable)e);
        }
        finally {
            cctx.gate().leave();
        }
    }

    public Collection<StatisticsObjectConfiguration> getAllConfig() throws IgniteCheckedException {
        ArrayList<StatisticsObjectConfiguration> res = new ArrayList<StatisticsObjectConfiguration>();
        this.distrMetaStorage.iterate(STAT_OBJ_PREFIX, (k, v) -> res.add((StatisticsObjectConfiguration)v));
        return res;
    }

    public void start() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Statistics configuration manager starting...");
        }
        this.mgmtBusyExecutor.activate();
        if (this.isServerNode) {
            this.schemaMgr.registerDropColumnsListener(this.dropColsLsnr);
            this.schemaMgr.registerDropTableListener(this.dropTblLsnr);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics configuration manager started.");
        }
        if (this.distrMetaStorage != null && this.isServerNode) {
            this.mgmtBusyExecutor.execute(this::updateAllLocalStatistics);
        }
    }

    public void updateAllLocalStatistics() {
        try {
            this.distrMetaStorage.iterate(STAT_OBJ_PREFIX, (k, v) -> {
                StatisticsObjectConfiguration cfg = (StatisticsObjectConfiguration)v;
                this.updateLocalStatistics(cfg);
            });
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Unexpected statistics configuration processing error", (Throwable)e);
        }
    }

    public void stop() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Statistics configuration manager stopping...");
        }
        if (this.isServerNode) {
            this.schemaMgr.unregisterDropColumnsListener(this.dropColsLsnr);
            this.schemaMgr.unregisterDropTableListener(this.dropTblLsnr);
        }
        this.mgmtBusyExecutor.deactivate(() -> {});
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statistics configuration manager stopped.");
        }
    }

    public void updateStatistics(StatisticsObjectConfiguration ... targets) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Update statistics [targets=" + targets + ']');
        }
        for (StatisticsObjectConfiguration target : targets) {
            GridH2Table tbl = this.schemaMgr.dataTable(target.key().schema(), target.key().obj());
            this.validate(target, tbl);
            List<Object> colCfgs = F.isEmpty((Map)target.columns()) ? Arrays.stream(tbl.getColumns()).filter(c -> c.getColumnId() >= 2).map(c -> new StatisticsColumnConfiguration(c.getName(), null)).collect(Collectors.toList()) : new ArrayList(target.columns().values());
            StatisticsObjectConfiguration newCfg = new StatisticsObjectConfiguration(target.key(), colCfgs, target.maxPartitionObsolescencePercent());
            try {
                StatisticsObjectConfiguration resultCfg;
                StatisticsObjectConfiguration oldCfg;
                String key;
                while (!this.distrMetaStorage.compareAndSet(key, (Serializable)oldCfg, (Serializable)(resultCfg = (oldCfg = (StatisticsObjectConfiguration)this.distrMetaStorage.read(key = IgniteStatisticsConfigurationManager.key2String(newCfg.key()))) == null ? newCfg : StatisticsObjectConfiguration.merge((StatisticsObjectConfiguration)oldCfg, (StatisticsObjectConfiguration)newCfg)))) {
                }
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteSQLException("Error on get or update statistic schema", 1, (Throwable)ex);
            }
        }
    }

    public void dropStatistics(List<StatisticsTarget> targets, boolean validate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Drop statistics [targets=" + targets + ']');
        }
        for (StatisticsTarget target : targets) {
            String key = IgniteStatisticsConfigurationManager.key2String(target.key());
            try {
                Set dropColNames;
                StatisticsObjectConfiguration newCfg;
                StatisticsObjectConfiguration oldCfg;
                do {
                    oldCfg = (StatisticsObjectConfiguration)this.distrMetaStorage.read(key);
                    if (validate) {
                        this.validateDropRefresh(target, oldCfg);
                    }
                    if (oldCfg != null) continue;
                    return;
                } while (!oldCfg.equals((Object)(newCfg = oldCfg.dropColumns(dropColNames = target.columns() == null ? Collections.emptySet() : Arrays.stream(target.columns()).collect(Collectors.toSet())))) && !this.distrMetaStorage.compareAndSet(key, (Serializable)oldCfg, (Serializable)newCfg));
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteSQLException("Error on get or update statistic schema", 1, (Throwable)ex);
            }
        }
    }

    public void dropAll() {
        try {
            ArrayList<StatisticsTarget> targetsToRemove = new ArrayList<StatisticsTarget>();
            this.distrMetaStorage.iterate(STAT_OBJ_PREFIX, (k, v) -> {
                StatisticsKey statKey = ((StatisticsObjectConfiguration)v).key();
                StatisticsObjectConfiguration cfg = (StatisticsObjectConfiguration)v;
                if (!F.isEmpty((Map)cfg.columns())) {
                    targetsToRemove.add(new StatisticsTarget(statKey, null));
                }
            });
            this.dropStatistics(targetsToRemove, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSQLException("Unexpected exception drop all statistics", 1, (Throwable)e);
        }
    }

    public void refreshStatistics(List<StatisticsTarget> targets) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Drop statistics [targets=" + targets + ']');
        }
        for (StatisticsTarget target : targets) {
            String key = IgniteStatisticsConfigurationManager.key2String(target.key());
            try {
                Set cols;
                StatisticsObjectConfiguration newCfg;
                StatisticsObjectConfiguration oldCfg;
                do {
                    oldCfg = (StatisticsObjectConfiguration)this.distrMetaStorage.read(key);
                    this.validateDropRefresh(target, oldCfg);
                } while (!this.distrMetaStorage.compareAndSet(key, (Serializable)oldCfg, (Serializable)(newCfg = oldCfg.refresh(cols = F.isEmpty((Object[])target.columns()) ? oldCfg.columns().values().stream().map(StatisticsColumnConfiguration::name).collect(Collectors.toSet()) : Arrays.stream(target.columns()).collect(Collectors.toSet())))));
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteSQLException("Error on get or update statistic schema", 1, (Throwable)ex);
            }
        }
    }

    private void validateDropRefresh(@NotNull StatisticsTarget target, @NotNull StatisticsObjectConfiguration cfg) {
        if (cfg == null || F.isEmpty((Map)cfg.columns())) {
            throw new IgniteSQLException("Statistic doesn't exist for [schema=" + target.schema() + ", obj=" + target.obj() + ']', 3001);
        }
        if (!F.isEmpty((Object[])target.columns())) {
            for (String col : target.columns()) {
                if (cfg.columns().containsKey(col)) continue;
                throw new IgniteSQLException("Statistic doesn't exist for [schema=" + cfg.key().schema() + ", obj=" + cfg.key().obj() + ", col=" + col + ']', 3008);
            }
        }
    }

    public StatisticsObjectConfiguration config(StatisticsKey key) throws IgniteCheckedException {
        return (StatisticsObjectConfiguration)this.distrMetaStorage.read(IgniteStatisticsConfigurationManager.key2String(key));
    }

    private void validate(StatisticsObjectConfiguration cfg, GridH2Table tbl) {
        if (tbl == null) {
            throw new IgniteSQLException("Table doesn't exist [schema=" + cfg.key().schema() + ", table=" + cfg.key().obj() + ']', 3001);
        }
        if (!F.isEmpty((Map)cfg.columns())) {
            for (String col : cfg.columns().keySet()) {
                if (tbl.doesColumnExist(col)) continue;
                throw new IgniteSQLException("Column doesn't exist [schema=" + cfg.key().schema() + ", table=" + cfg.key().obj() + ", column=" + col + ']', 3008);
            }
        }
    }

    private static String key2String(StatisticsKey key) {
        StringBuilder sb = new StringBuilder(STAT_OBJ_PREFIX);
        sb.append(key.schema()).append('.').append(key.obj());
        return sb.toString();
    }
}

