/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableAddColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlterTableDropColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlKeyword;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.processors.query.h2.sql.SplitterUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Update;
import org.h2.engine.FunctionAlias;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionExists;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInConstantSet;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Subquery;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.index.ViewIndex;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.value.DataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSqlQueryParser {
    private static final GridSqlOperationType[] COMPARISON_TYPES = new GridSqlOperationType[]{GridSqlOperationType.EQUAL, GridSqlOperationType.BIGGER_EQUAL, GridSqlOperationType.BIGGER, GridSqlOperationType.SMALLER_EQUAL, GridSqlOperationType.SMALLER, GridSqlOperationType.NOT_EQUAL, GridSqlOperationType.IS_NULL, GridSqlOperationType.IS_NOT_NULL, null, null, null, GridSqlOperationType.SPATIAL_INTERSECTS, null, null, null, null, GridSqlOperationType.EQUAL_NULL_SAFE, null, null, null, null, GridSqlOperationType.NOT_EQUAL_NULL_SAFE};
    private static final Getter<Select, Expression> CONDITION = GridSqlQueryParser.getter(Select.class, "condition");
    private static final Getter<Select, int[]> GROUP_INDEXES = GridSqlQueryParser.getter(Select.class, "groupIndex");
    private static final Getter<Select, Boolean> SELECT_IS_FOR_UPDATE = GridSqlQueryParser.getter(Select.class, "isForUpdate");
    private static final Getter<Select, Boolean> SELECT_IS_GROUP_QUERY = GridSqlQueryParser.getter(Select.class, "isGroupQuery");
    private static final Getter<SelectUnion, Boolean> UNION_IS_FOR_UPDATE = GridSqlQueryParser.getter(SelectUnion.class, "isForUpdate");
    private static final Getter<Operation, Operation.OpType> OPERATION_TYPE = GridSqlQueryParser.getter(Operation.class, "opType");
    private static final Getter<Operation, Expression> OPERATION_LEFT = GridSqlQueryParser.getter(Operation.class, "left");
    private static final Getter<Operation, Expression> OPERATION_RIGHT = GridSqlQueryParser.getter(Operation.class, "right");
    private static final Getter<Comparison, Integer> COMPARISON_TYPE = GridSqlQueryParser.getter(Comparison.class, "compareType");
    private static final Getter<Comparison, Expression> COMPARISON_LEFT = GridSqlQueryParser.getter(Comparison.class, "left");
    private static final Getter<Comparison, Expression> COMPARISON_RIGHT = GridSqlQueryParser.getter(Comparison.class, "right");
    private static final Getter<ConditionAndOr, Integer> ANDOR_TYPE = GridSqlQueryParser.getter(ConditionAndOr.class, "andOrType");
    private static final Getter<ConditionAndOr, Expression> ANDOR_LEFT = GridSqlQueryParser.getter(ConditionAndOr.class, "left");
    private static final Getter<ConditionAndOr, Expression> ANDOR_RIGHT = GridSqlQueryParser.getter(ConditionAndOr.class, "right");
    public static final Getter<TableView, Query> VIEW_QUERY = GridSqlQueryParser.getter(TableView.class, "viewQuery");
    private static final Getter<TableFilter, String> ALIAS = GridSqlQueryParser.getter(TableFilter.class, "alias");
    private static final Getter<Select, Integer> HAVING_INDEX = GridSqlQueryParser.getter(Select.class, "havingIndex");
    private static final Getter<ConditionIn, Expression> LEFT_CI = GridSqlQueryParser.getter(ConditionIn.class, "left");
    private static final Getter<ConditionIn, List<Expression>> VALUE_LIST_CI = GridSqlQueryParser.getter(ConditionIn.class, "valueList");
    private static final Getter<ConditionInConstantSet, Expression> LEFT_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "left");
    private static final Getter<ConditionInConstantSet, List<Expression>> VALUE_LIST_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "valueList");
    private static final Getter<ExpressionList, Expression[]> EXPR_LIST = GridSqlQueryParser.getter(ExpressionList.class, "list");
    private static final Getter<ConditionInSelect, Expression> LEFT_CIS = GridSqlQueryParser.getter(ConditionInSelect.class, "left");
    private static final Getter<ConditionInSelect, Boolean> ALL = GridSqlQueryParser.getter(ConditionInSelect.class, "all");
    private static final Getter<ConditionInSelect, Integer> COMPARE_TYPE = GridSqlQueryParser.getter(ConditionInSelect.class, "compareType");
    private static final Getter<ConditionInSelect, Query> QUERY_IN = GridSqlQueryParser.getter(ConditionInSelect.class, "query");
    private static final Getter<ConditionExists, Query> QUERY_EXISTS = GridSqlQueryParser.getter(ConditionExists.class, "query");
    private static final Getter<CompareLike, Expression> LEFT = GridSqlQueryParser.getter(CompareLike.class, "left");
    private static final Getter<CompareLike, Expression> RIGHT = GridSqlQueryParser.getter(CompareLike.class, "right");
    private static final Getter<CompareLike, Expression> ESCAPE = GridSqlQueryParser.getter(CompareLike.class, "escape");
    private static final Getter<CompareLike, Boolean> REGEXP_CL = GridSqlQueryParser.getter(CompareLike.class, "regexp");
    private static final Getter<Aggregate, Boolean> DISTINCT = GridSqlQueryParser.getter(Aggregate.class, "distinct");
    private static final Getter<Aggregate, Aggregate.AggregateType> TYPE = GridSqlQueryParser.getter(Aggregate.class, "type");
    private static final Getter<Aggregate, Expression> ON = GridSqlQueryParser.getter(Aggregate.class, "on");
    private static final Getter<Aggregate, Expression> GROUP_CONCAT_SEPARATOR = GridSqlQueryParser.getter(Aggregate.class, "groupConcatSeparator");
    private static final Getter<Aggregate, ArrayList<SelectOrderBy>> GROUP_CONCAT_ORDER_LIST = GridSqlQueryParser.getter(Aggregate.class, "groupConcatOrderList");
    private static final Getter<RangeTable, Expression> RANGE_MIN = GridSqlQueryParser.getter(RangeTable.class, "min");
    private static final Getter<RangeTable, Expression> RANGE_MAX = GridSqlQueryParser.getter(RangeTable.class, "max");
    private static final Getter<FunctionTable, Expression> FUNC_EXPR = GridSqlQueryParser.getter(FunctionTable.class, "functionExpr");
    private static final Getter<TableFunction, Column[]> FUNC_TBL_COLS = GridSqlQueryParser.getter(TableFunction.class, "columnList");
    private static final Getter<JavaFunction, FunctionAlias> FUNC_ALIAS = GridSqlQueryParser.getter(JavaFunction.class, "functionAlias");
    private static final Getter<ExpressionColumn, String> SCHEMA_NAME = GridSqlQueryParser.getter(ExpressionColumn.class, "schemaName");
    private static final Getter<JdbcPreparedStatement, Command> COMMAND = GridSqlQueryParser.getter(JdbcPreparedStatement.class, "command");
    private static final Getter<SelectUnion, SortOrder> UNION_SORT = GridSqlQueryParser.getter(SelectUnion.class, "sort");
    private static final Getter<Explain, Prepared> EXPLAIN_COMMAND = GridSqlQueryParser.getter(Explain.class, "command");
    private static final Getter<Merge, Table> MERGE_TABLE = GridSqlQueryParser.getter(Merge.class, "targetTable");
    private static final Getter<Merge, Column[]> MERGE_COLUMNS = GridSqlQueryParser.getter(Merge.class, "columns");
    private static final Getter<Merge, Column[]> MERGE_KEYS = GridSqlQueryParser.getter(Merge.class, "keys");
    private static final Getter<Merge, List<Expression[]>> MERGE_ROWS = GridSqlQueryParser.getter(Merge.class, "valuesExpressionList");
    private static final Getter<Merge, Query> MERGE_QUERY = GridSqlQueryParser.getter(Merge.class, "query");
    private static final Getter<Insert, Table> INSERT_TABLE = GridSqlQueryParser.getter(Insert.class, "table");
    private static final Getter<Insert, Column[]> INSERT_COLUMNS = GridSqlQueryParser.getter(Insert.class, "columns");
    private static final Getter<Insert, List<Expression[]>> INSERT_ROWS = GridSqlQueryParser.getter(Insert.class, "list");
    private static final Getter<Insert, Query> INSERT_QUERY = GridSqlQueryParser.getter(Insert.class, "query");
    private static final Getter<Insert, Boolean> INSERT_DIRECT = GridSqlQueryParser.getter(Insert.class, "insertFromSelect");
    private static final Getter<Insert, Boolean> INSERT_SORTED = GridSqlQueryParser.getter(Insert.class, "sortedInsertMode");
    private static final Getter<Delete, TableFilter> DELETE_FROM = GridSqlQueryParser.getter(Delete.class, "targetTableFilter");
    private static final Getter<Delete, Expression> DELETE_WHERE = GridSqlQueryParser.getter(Delete.class, "condition");
    private static final Getter<Delete, Expression> DELETE_LIMIT = GridSqlQueryParser.getter(Delete.class, "limitExpr");
    private static final Getter<Update, TableFilter> UPDATE_TARGET = GridSqlQueryParser.getter(Update.class, "targetTableFilter");
    private static final Getter<Update, ArrayList<Column>> UPDATE_COLUMNS = GridSqlQueryParser.getter(Update.class, "columns");
    private static final Getter<Update, HashMap<Column, Expression>> UPDATE_SET = GridSqlQueryParser.getter(Update.class, "expressionMap");
    private static final Getter<Update, Expression> UPDATE_WHERE = GridSqlQueryParser.getter(Update.class, "condition");
    private static final Getter<Update, Expression> UPDATE_LIMIT = GridSqlQueryParser.getter(Update.class, "limitExpr");
    private static final Getter<Command, Prepared> PREPARED = GridSqlQueryParser.getter(CommandContainer.class, "prepared");
    private static final Getter<CreateIndex, String> CREATE_INDEX_NAME = GridSqlQueryParser.getter(CreateIndex.class, "indexName");
    private static final Getter<CreateIndex, String> CREATE_INDEX_TABLE_NAME = GridSqlQueryParser.getter(CreateIndex.class, "tableName");
    private static final Getter<CreateIndex, IndexColumn[]> CREATE_INDEX_COLUMNS = GridSqlQueryParser.getter(CreateIndex.class, "indexColumns");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_SPATIAL = GridSqlQueryParser.getter(CreateIndex.class, "spatial");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_PRIMARY_KEY = GridSqlQueryParser.getter(CreateIndex.class, "primaryKey");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_UNIQUE = GridSqlQueryParser.getter(CreateIndex.class, "unique");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_HASH = GridSqlQueryParser.getter(CreateIndex.class, "hash");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_IF_NOT_EXISTS = GridSqlQueryParser.getter(CreateIndex.class, "ifNotExists");
    private static final Getter<IndexColumn, String> INDEX_COLUMN_NAME = GridSqlQueryParser.getter(IndexColumn.class, "columnName");
    private static final Getter<IndexColumn, Integer> INDEX_COLUMN_SORT_TYPE = GridSqlQueryParser.getter(IndexColumn.class, "sortType");
    private static final Getter<DropIndex, String> DROP_INDEX_NAME = GridSqlQueryParser.getter(DropIndex.class, "indexName");
    private static final Getter<DropIndex, Boolean> DROP_INDEX_IF_EXISTS = GridSqlQueryParser.getter(DropIndex.class, "ifExists");
    private static final Getter<SchemaCommand, Schema> SCHEMA_COMMAND_SCHEMA = GridSqlQueryParser.getter(SchemaCommand.class, "schema");
    private static final Getter<CreateTable, CreateTableData> CREATE_TABLE_DATA = GridSqlQueryParser.getter(CreateTable.class, "data");
    private static final Getter<CommandWithColumns, ArrayList<DefineCommand>> CREATE_TABLE_CONSTRAINTS = GridSqlQueryParser.getter(CommandWithColumns.class, "constraintCommands");
    private static final Getter<CommandWithColumns, IndexColumn[]> CREATE_TABLE_PK = GridSqlQueryParser.getter(CommandWithColumns.class, "pkColumns");
    private static final Getter<CreateTable, Boolean> CREATE_TABLE_IF_NOT_EXISTS = GridSqlQueryParser.getter(CreateTable.class, "ifNotExists");
    private static final Getter<CreateTable, Query> CREATE_TABLE_QUERY = GridSqlQueryParser.getter(CreateTable.class, "asQuery");
    private static final Getter<DropTable, Boolean> DROP_TABLE_IF_EXISTS = GridSqlQueryParser.getter(DropTable.class, "ifExists");
    private static final Getter<DropTable, String> DROP_TABLE_NAME = GridSqlQueryParser.getter(DropTable.class, "tableName");
    private static final Getter<Column, Boolean> COLUMN_IS_COMPUTED = GridSqlQueryParser.getter(Column.class, "isComputed");
    private static final Getter<Column, Expression> COLUMN_CHECK_CONSTRAINT = GridSqlQueryParser.getter(Column.class, "checkConstraint");
    private static final Class<? extends Command> CLS_COMMAND_LIST;
    private static final Getter<Command, Command> LIST_COMMAND;
    private static final Getter<Command, String> REMAINING;
    public static final String ORG_H2_COMMAND_COMMAND_LIST = "org.h2.command.CommandList";
    private static final Getter<AlterTableAlterColumn, String> ALTER_COLUMN_TBL_NAME;
    private static final Getter<AlterTableAlterColumn, ArrayList<Column>> ALTER_COLUMN_NEW_COLS;
    private static final Getter<AlterTableAlterColumn, ArrayList<Column>> ALTER_COLUMN_REMOVE_COLS;
    private static final Getter<AlterTableAlterColumn, Boolean> ALTER_COLUMN_IF_NOT_EXISTS;
    private static final Getter<AlterTableAlterColumn, Boolean> ALTER_COLUMN_IF_TBL_EXISTS;
    private static final Getter<AlterTableAlterColumn, String> ALTER_COLUMN_BEFORE_COL;
    private static final Getter<AlterTableAlterColumn, Boolean> ALTER_COLUMN_FIRST;
    private static final Getter<AlterTableAlterColumn, String> ALTER_COLUMN_AFTER_COL;
    private static final String PARAM_NAME_VALUE_SEPARATOR = "=";
    private static final String PARAM_TEMPLATE = "TEMPLATE";
    private static final String PARAM_BACKUPS = "BACKUPS";
    private static final String PARAM_ATOMICITY = "ATOMICITY";
    private static final String PARAM_CACHE_GROUP_OLD = "CACHEGROUP";
    private static final String PARAM_AFFINITY_KEY_OLD = "AFFINITYKEY";
    private static final String PARAM_CACHE_GROUP = "CACHE_GROUP";
    private static final String PARAM_AFFINITY_KEY = "AFFINITY_KEY";
    private static final String PARAM_WRITE_SYNC = "WRITE_SYNCHRONIZATION_MODE";
    private static final String PARAM_CACHE_NAME = "CACHE_NAME";
    private static final String PARAM_KEY_TYPE = "KEY_TYPE";
    private static final String PARAM_VAL_TYPE = "VALUE_TYPE";
    private static final String PARAM_WRAP_KEY = "WRAP_KEY";
    public static final String PARAM_WRAP_VALUE = "WRAP_VALUE";
    public static final String PARAM_DATA_REGION = "DATA_REGION";
    private static final String PARAM_ENCRYPTED = "ENCRYPTED";
    private static final String PARAM_PARALLELISM = "PARALLELISM";
    private final IdentityHashMap<Object, Object> h2ObjToGridObj = new IdentityHashMap();
    private final Map<String, Integer> optimizedTableFilterOrder;
    private final IgniteLogger log;
    private int parsingSubQryExpression;
    private boolean selectForUpdate;

    public GridSqlQueryParser(boolean useOptimizedSubqry, IgniteLogger log) {
        assert (Objects.nonNull(log));
        this.optimizedTableFilterOrder = useOptimizedSubqry ? new HashMap() : null;
        this.log = log;
    }

    public static boolean checkMultipleStatements(PreparedStatement stmt) {
        Command cmd = GridSqlQueryParser.extractCommand(stmt);
        return ORG_H2_COMMAND_COMMAND_LIST.equals(cmd.getClass().getName());
    }

    public static Prepared prepared(PreparedStatement stmt) {
        Command cmd = GridSqlQueryParser.extractCommand(stmt);
        assert (cmd instanceof CommandContainer);
        return PREPARED.get(cmd);
    }

    public static PreparedWithRemaining preparedWithRemaining(PreparedStatement stmt) {
        Command cmd = GridSqlQueryParser.extractCommand(stmt);
        if (cmd instanceof CommandContainer) {
            return new PreparedWithRemaining(PREPARED.get(cmd), null);
        }
        Class<?> cmdCls = cmd.getClass();
        if (cmdCls.getName().equals(ORG_H2_COMMAND_COMMAND_LIST)) {
            return new PreparedWithRemaining(PREPARED.get(LIST_COMMAND.get(cmd)), REMAINING.get(cmd));
        }
        throw new IgniteSQLException("Unexpected statement command");
    }

    private static Command extractCommand(PreparedStatement stmt) {
        return COMMAND.get((JdbcPreparedStatement)stmt);
    }

    public static boolean isForUpdateQuery(Prepared p) {
        boolean forUpdate;
        boolean union;
        if (p.getClass() == Select.class) {
            union = false;
        } else if (p.getClass() == SelectUnion.class) {
            union = true;
        } else {
            return false;
        }
        boolean bl = forUpdate = !union && SELECT_IS_FOR_UPDATE.get((Select)p) != false || union && UNION_IS_FOR_UPDATE.get((SelectUnion)p) != false;
        if (union && forUpdate) {
            throw new IgniteSQLException("SELECT UNION FOR UPDATE is not supported.", 1002);
        }
        return forUpdate;
    }

    private GridSqlSubquery parseQueryExpression(Query qry) {
        ++this.parsingSubQryExpression;
        GridSqlQuery subQry = this.parseQuery(qry);
        --this.parsingSubQryExpression;
        return new GridSqlSubquery(subQry);
    }

    private GridSqlElement parseTableFilter(TableFilter filter) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(filter);
        if (res == null) {
            String alias;
            res = this.parseTable(filter.getTable());
            if (res instanceof GridSqlTable && filter.getIndexHints() != null) {
                ((GridSqlTable)res).useIndexes(new ArrayList<String>(filter.getIndexHints().getAllowedIndexes()));
            }
            if ((alias = ALIAS.get(filter)) != null) {
                res = new GridSqlAlias(alias, res, false);
            }
            this.h2ObjToGridObj.put(filter, res);
        }
        return res;
    }

    private GridSqlElement parseTable(Table tbl) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(tbl);
        if (res == null) {
            if (tbl instanceof TableBase || tbl instanceof MetaTable) {
                return new GridSqlTable(tbl);
            }
            if (tbl instanceof TableView) {
                if (((TableView)tbl).isRecursive()) {
                    throw new IgniteSQLException("Recursive CTE ('WITH RECURSIVE (...)') is not supported.", 1002);
                }
                Query qry = VIEW_QUERY.get((TableView)tbl);
                res = new GridSqlSubquery(this.parseQuery(qry));
            } else if (tbl instanceof FunctionTable) {
                res = this.parseExpression(FUNC_EXPR.get((FunctionTable)tbl), false);
            } else if (tbl instanceof RangeTable) {
                res = new GridSqlFunction(GridSqlFunctionType.SYSTEM_RANGE);
                res.addChild(this.parseExpression(RANGE_MIN.get((RangeTable)tbl), false));
                res.addChild(this.parseExpression(RANGE_MAX.get((RangeTable)tbl), false));
            } else if (tbl instanceof MetaTable) {
                res = new GridSqlTable(tbl);
            } else {
                GridSqlQueryParser.assert0(false, "Unexpected Table implementation [cls=" + tbl.getClass().getSimpleName() + ']');
            }
            this.h2ObjToGridObj.put(tbl, res);
        }
        return res;
    }

    private GridSqlSelect parseSelect(Select select) {
        int havingIdx;
        GridSqlSelect res = (GridSqlSelect)this.h2ObjToGridObj.get(select);
        if (res != null) {
            return res;
        }
        res = new GridSqlSelect();
        this.h2ObjToGridObj.put(select, res);
        res.distinct(select.isDistinct());
        Expression where = CONDITION.get(select);
        res.where(this.parseExpression(where, true));
        ArrayList<TableFilter> tableFilters = new ArrayList<TableFilter>();
        TableFilter filter = select.getTopTableFilter();
        boolean isForUpdate = SELECT_IS_FOR_UPDATE.get(select);
        do {
            GridSqlQueryParser.assert0(filter != null, select);
            GridSqlQueryParser.assert0(filter.getNestedJoin() == null, select);
            if (this.parsingSubQryExpression == 0 && this.optimizedTableFilterOrder != null) {
                String tblAlias = filter.getTableAlias();
                int idx = this.optimizedTableFilterOrder.get(tblAlias);
                GridSqlQueryParser.setElementAt(tableFilters, idx, filter);
                continue;
            }
            tableFilters.add(filter);
        } while ((filter = filter.getJoin()) != null);
        GridSqlElement from = null;
        for (int i = 0; i < tableFilters.size(); ++i) {
            TableFilter f = (TableFilter)tableFilters.get(i);
            GridSqlElement gridFilter = this.parseTableFilter(f);
            from = from == null ? gridFilter : new GridSqlJoin(from, gridFilter, f.isJoinOuter(), this.parseExpression(f.getJoinCondition(), true));
        }
        res.from(from);
        if (isForUpdate) {
            if (!(from instanceof GridSqlTable || from instanceof GridSqlAlias && from.size() == 1 && from.child() instanceof GridSqlTable)) {
                throw new IgniteSQLException("SELECT FOR UPDATE with joins is not supported.", 1002);
            }
            GridSqlTable gridTbl = from instanceof GridSqlTable ? (GridSqlTable)from : (GridSqlTable)((GridSqlAlias)from).child();
            GridH2Table tbl = gridTbl.dataTable();
            if (tbl == null) {
                throw new IgniteSQLException("SELECT FOR UPDATE query must involve Ignite table.", 1002);
            }
            if (select.getLimit() != null || select.getOffset() != null) {
                throw new IgniteSQLException("LIMIT/OFFSET clauses are not supported for SELECT FOR UPDATE.", 1002);
            }
            if (SELECT_IS_GROUP_QUERY.get(select).booleanValue()) {
                throw new IgniteSQLException("SELECT FOR UPDATE with aggregates and/or GROUP BY is not supported.", 1002);
            }
            if (select.isDistinct()) {
                throw new IgniteSQLException("DISTINCT clause is not supported for SELECT FOR UPDATE.", 1002);
            }
            if (SplitterUtils.hasSubQueries(res)) {
                throw new IgniteSQLException("Sub queries are not supported for SELECT FOR UPDATE.", 1002);
            }
        }
        ArrayList expressions = select.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            res.addColumn(this.parseExpression((Expression)expressions.get(i), true), i < select.getColumnCount());
        }
        int[] grpIdx = GROUP_INDEXES.get(select);
        if (grpIdx != null) {
            res.groupColumns(grpIdx);
        }
        if ((havingIdx = HAVING_INDEX.get(select).intValue()) >= 0) {
            res.havingColumn(havingIdx);
        }
        res.forUpdate(isForUpdate);
        this.processSortOrder(select.getSortOrder(), res);
        res.limit(this.parseExpression(select.getLimit(), false));
        res.offset(this.parseExpression(select.getOffset(), false));
        return res;
    }

    private static <Z> void setElementAt(List<Z> list, int idx, Z x) {
        while (list.size() <= idx) {
            list.add(null);
        }
        GridSqlQueryParser.assert0(list.get(idx) == null, "Element already set: " + idx);
        list.set(idx, x);
    }

    private GridSqlMerge parseMerge(Merge merge) {
        List<Expression[]> srcRows;
        GridSqlMerge res = (GridSqlMerge)this.h2ObjToGridObj.get(merge);
        if (res != null) {
            return res;
        }
        res = new GridSqlMerge();
        this.h2ObjToGridObj.put(merge, res);
        Table srcTbl = MERGE_TABLE.get(merge);
        GridSqlElement tbl = this.parseTable(srcTbl);
        res.into(tbl);
        Column[] srcCols = MERGE_COLUMNS.get(merge);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, null, null, srcCols[i].getName());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        if (!F.isEmpty((Object[])MERGE_KEYS.get(merge))) {
            this.log.warning("The search row by explicit KEY isn't supported. The primary key is always used to search row [sql=" + merge.getSQL() + ']');
        }
        if (!(srcRows = MERGE_ROWS.get(merge)).isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                    if (row[i] != null) continue;
                    throw new IgniteSQLException("Explicit DEFAULT values are unsupported for MERGE.", 1002);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parseQuery(MERGE_QUERY.get(merge)));
        }
        return res;
    }

    private GridSqlInsert parseInsert(Insert insert) {
        GridSqlInsert res = (GridSqlInsert)this.h2ObjToGridObj.get(insert);
        if (res != null) {
            return res;
        }
        res = new GridSqlInsert();
        this.h2ObjToGridObj.put(insert, res);
        Table srcTbl = INSERT_TABLE.get(insert);
        GridSqlElement tbl = this.parseTable(srcTbl);
        res.into(tbl).direct(INSERT_DIRECT.get(insert)).sorted(INSERT_SORTED.get(insert));
        Column[] srcCols = INSERT_COLUMNS.get(insert);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, null, null, srcCols[i].getName());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        List<Expression[]> srcRows = INSERT_ROWS.get(insert);
        if (!srcRows.isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                    if (row[i] != null) continue;
                    throw new IgniteSQLException("Explicit DEFAULT values are unsupported for INSERT.", 1002);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parseQuery(INSERT_QUERY.get(insert)));
        }
        return res;
    }

    private GridSqlDelete parseDelete(Delete del) {
        GridSqlDelete res = (GridSqlDelete)this.h2ObjToGridObj.get(del);
        if (res != null) {
            return res;
        }
        res = new GridSqlDelete();
        this.h2ObjToGridObj.put(del, res);
        GridSqlElement tbl = this.parseTableFilter(DELETE_FROM.get(del));
        GridSqlElement where = this.parseExpression(DELETE_WHERE.get(del), true);
        GridSqlElement limit = this.parseExpression(DELETE_LIMIT.get(del), true);
        res.from(tbl).where(where).limit(limit);
        return res;
    }

    private GridSqlUpdate parseUpdate(Update update) {
        GridSqlUpdate res = (GridSqlUpdate)this.h2ObjToGridObj.get(update);
        if (res != null) {
            return res;
        }
        res = new GridSqlUpdate();
        this.h2ObjToGridObj.put(update, res);
        GridSqlElement tbl = this.parseTableFilter(UPDATE_TARGET.get(update));
        List srcCols = UPDATE_COLUMNS.get(update);
        Map srcSet = UPDATE_SET.get(update);
        ArrayList<GridSqlColumn> cols = new ArrayList<GridSqlColumn>(srcCols.size());
        LinkedHashMap<String, GridSqlElement> set = new LinkedHashMap<String, GridSqlElement>(srcSet.size());
        for (Column c : srcCols) {
            GridSqlColumn col = new GridSqlColumn(c, tbl, null, null, c.getName());
            col.resultType(GridSqlType.fromColumn(c));
            cols.add(col);
            GridSqlElement setVal = this.parseExpression((Expression)srcSet.get(c), true);
            if (this.containsDefaultKeyword(setVal)) {
                throw new IgniteSQLException("DEFAULT values are unsupported for UPDATE.", 1002);
            }
            set.put(col.columnName(), setVal);
        }
        GridSqlElement where = this.parseExpression(UPDATE_WHERE.get(update), true);
        GridSqlElement limit = this.parseExpression(UPDATE_LIMIT.get(update), true);
        res.target(tbl).cols(cols).set(set).where(where).limit(limit);
        return res;
    }

    private boolean containsDefaultKeyword(GridSqlAst val) {
        if (val == GridSqlKeyword.DEFAULT) {
            return true;
        }
        for (int i = 0; i < val.size(); ++i) {
            if (!this.containsDefaultKeyword((GridSqlAst)val.child(i))) continue;
            return true;
        }
        return false;
    }

    private GridSqlDropIndex parseDropIndex(DropIndex dropIdx) {
        GridSqlDropIndex res = new GridSqlDropIndex();
        res.indexName(DROP_INDEX_NAME.get(dropIdx));
        res.schemaName(SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)dropIdx).getName());
        res.ifExists(DROP_INDEX_IF_EXISTS.get(dropIdx));
        return res;
    }

    private GridSqlCreateIndex parseCreateIndex(CreateIndex createIdx) {
        if (CREATE_INDEX_HASH.get(createIdx).booleanValue() || CREATE_INDEX_PRIMARY_KEY.get(createIdx).booleanValue() || CREATE_INDEX_UNIQUE.get(createIdx).booleanValue()) {
            throw new IgniteSQLException("Only SPATIAL modifier is supported for CREATE INDEX", 1002);
        }
        GridSqlCreateIndex res = new GridSqlCreateIndex();
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)createIdx);
        String tblName = CREATE_INDEX_TABLE_NAME.get(createIdx);
        res.schemaName(schema.getName());
        res.tableName(tblName);
        res.ifNotExists(CREATE_INDEX_IF_NOT_EXISTS.get(createIdx));
        QueryIndex idx = new QueryIndex();
        idx.setName(CREATE_INDEX_NAME.get(createIdx));
        idx.setIndexType(CREATE_INDEX_SPATIAL.get(createIdx) != false ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED);
        IndexColumn[] cols = CREATE_INDEX_COLUMNS.get(createIdx);
        LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>(cols.length);
        for (IndexColumn col : CREATE_INDEX_COLUMNS.get(createIdx)) {
            int sortType = INDEX_COLUMN_SORT_TYPE.get(col);
            if ((sortType & 2) != 0 || (sortType & 4) != 0) {
                throw new IgniteSQLException("NULLS FIRST and NULLS LAST modifiers are not supported for index columns", 1002);
            }
            Boolean prev = flds.put(INDEX_COLUMN_NAME.get(col), (sortType & 1) == 0);
            if (prev == null) continue;
            String prevCol = INDEX_COLUMN_NAME.get(col) + " " + (prev != false ? "ASC" : "DESC");
            throw new IgniteSQLException("Already defined column in index: " + prevCol, 3009);
        }
        idx.setFields(flds);
        res.index(idx);
        return res;
    }

    private GridSqlCreateTable parseCreateTable(CreateTable createTbl) {
        LinkedHashSet<String> pkCols0;
        Boolean bl;
        ArrayList<String> extraParams;
        GridSqlCreateTable res = new GridSqlCreateTable();
        res.templateName("PARTITIONED");
        Query qry = CREATE_TABLE_QUERY.get(createTbl);
        if (qry != null) {
            throw new IgniteSQLException("CREATE TABLE ... AS ... syntax is not supported", 1002);
        }
        List constraints = CREATE_TABLE_CONSTRAINTS.get((CommandWithColumns)createTbl);
        if (F.isEmpty((Collection)constraints)) {
            throw new IgniteSQLException("No PRIMARY KEY defined for CREATE TABLE", 1001);
        }
        if (constraints.size() > 1) {
            throw new IgniteSQLException("Too many constraints - only PRIMARY KEY is supported for CREATE TABLE", 1002);
        }
        DefineCommand constraint = (DefineCommand)constraints.get(0);
        if (!(constraint instanceof AlterTableAddConstraint)) {
            throw new IgniteSQLException("Unsupported type of constraint for CREATE TABLE - only PRIMARY KEY is supported", 1002);
        }
        AlterTableAddConstraint alterTbl = (AlterTableAddConstraint)constraint;
        if (alterTbl.getType() != 6) {
            throw new IgniteSQLException("Unsupported type of constraint for CREATE TABLE - only PRIMARY KEY is supported", 1002);
        }
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)createTbl);
        res.schemaName(schema.getName());
        CreateTableData data = CREATE_TABLE_DATA.get(createTbl);
        if (data.globalTemporary) {
            throw new IgniteSQLException("GLOBAL TEMPORARY keyword is not supported", 1002);
        }
        if (data.temporary) {
            throw new IgniteSQLException("TEMPORARY keyword is not supported", 1002);
        }
        if (data.isHidden) {
            throw new IgniteSQLException("HIDDEN keyword is not supported", 1002);
        }
        if (!data.persistIndexes) {
            throw new IgniteSQLException("MEMORY and NOT PERSISTENT keywords are not supported", 1002);
        }
        LinkedHashMap<String, GridSqlColumn> cols = new LinkedHashMap<String, GridSqlColumn>(data.columns.size());
        for (Column col : data.columns) {
            if (cols.put(col.getName(), GridSqlQueryParser.parseColumn(col)) == null) continue;
            throw new IgniteSQLException("Duplicate column name: " + col.getName(), 1001);
        }
        if (cols.containsKey("_KEY".toUpperCase()) || cols.containsKey("_VAL".toUpperCase())) {
            throw new IgniteSQLException("Direct specification of _KEY and _VAL columns is forbidden", 1001);
        }
        Object[] pkIdxCols = CREATE_TABLE_PK.get((CommandWithColumns)createTbl);
        if (F.isEmpty((Object[])pkIdxCols)) {
            throw new AssertionError((Object)"No PRIMARY KEY columns specified");
        }
        LinkedHashSet<String> pkCols = new LinkedHashSet<String>();
        for (Object object : pkIdxCols) {
            GridSqlColumn gridCol = (GridSqlColumn)cols.get(((IndexColumn)object).columnName);
            if (gridCol == null) {
                throw new IgniteSQLException("PRIMARY KEY column is not defined: " + ((IndexColumn)object).columnName, 1001);
            }
            pkCols.add(gridCol.columnName());
        }
        int keyColsNum = pkCols.size();
        int valColsNum = cols.size() - keyColsNum;
        if (valColsNum == 0) {
            throw new IgniteSQLException("Table must have at least one non PRIMARY KEY column.", 1002);
        }
        res.columns(cols);
        res.primaryKeyColumns(pkCols);
        res.tableName(data.tableName);
        res.ifNotExists(CREATE_TABLE_IF_NOT_EXISTS.get(createTbl));
        ArrayList<String> arrayList = extraParams = data.tableEngineParams != null ? new ArrayList<String>() : null;
        if (data.tableEngineParams != null) {
            for (Iterator s : data.tableEngineParams) {
                extraParams.addAll(F.asList((Object[])((String)((Object)s)).split(",")));
            }
        }
        res.params(extraParams);
        if (!F.isEmpty(extraParams)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String p : extraParams) {
                String val;
                String[] parts = p.split(PARAM_NAME_VALUE_SEPARATOR);
                if (parts.length > 2) {
                    throw new IgniteSQLException("Invalid parameter (key[=value] expected): " + p, 1001);
                }
                String name = parts[0].trim().toUpperCase();
                String string = val = parts.length > 1 ? parts[1].trim() : null;
                if (F.isEmpty((String)name)) {
                    throw new IgniteSQLException("Invalid parameter (key[=value] expected): " + p, 1001);
                }
                if (hashMap.put(name, val) == null) continue;
                throw new IgniteSQLException("Duplicate parameter: " + p, 1001);
            }
            for (Map.Entry e : hashMap.entrySet()) {
                GridSqlQueryParser.processExtraParam((String)e.getKey(), (String)e.getValue(), res);
            }
        }
        if ((bl = res.wrapKey()) != null && !bl.booleanValue()) {
            if (keyColsNum > 1) {
                throw new IgniteSQLException("WRAP_KEY cannot be false when composite primary key exists.", 1001);
            }
            if (!F.isEmpty((String)res.keyTypeName())) {
                throw new IgniteSQLException("WRAP_KEY cannot be false when KEY_TYPE is set.", 1001);
            }
        }
        boolean wrapKey0 = res.wrapKey() != null && res.wrapKey() != false || !F.isEmpty((String)res.keyTypeName()) || keyColsNum > 1;
        res.wrapKey(wrapKey0);
        Boolean wrapVal = res.wrapValue();
        if (wrapVal != null && !wrapVal.booleanValue()) {
            if (valColsNum > 1) {
                throw new IgniteSQLException("WRAP_VALUE cannot be false when multiple non-primary key columns exist.", 1001);
            }
            if (!F.isEmpty((String)res.valueTypeName())) {
                throw new IgniteSQLException("WRAP_VALUE cannot be false when VALUE_TYPE is set.", 1001);
            }
            res.wrapValue(false);
        } else {
            res.wrapValue(true);
        }
        if (!F.isEmpty((String)res.valueTypeName()) && F.eq((Object)res.keyTypeName(), (Object)res.valueTypeName())) {
            throw new IgniteSQLException("Key and value type names should be different for CREATE TABLE: " + res.valueTypeName(), 1001);
        }
        if (res.affinityKey() == null && !F.isEmpty(pkCols0 = res.primaryKeyColumns()) && pkCols0.size() == 1 && wrapKey0) {
            res.affinityKey((String)pkCols0.iterator().next());
        }
        return res;
    }

    private GridSqlDropTable parseDropTable(DropTable dropTbl) {
        GridSqlDropTable res = new GridSqlDropTable();
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)dropTbl);
        res.schemaName(schema.getName());
        res.ifExists(DROP_TABLE_IF_EXISTS.get(dropTbl));
        res.tableName(DROP_TABLE_NAME.get(dropTbl));
        return res;
    }

    private GridSqlStatement parseAlterColumn(AlterTableAlterColumn stmt) {
        switch (stmt.getType()) {
            case 7: {
                return this.parseAddColumn(stmt);
            }
            case 12: {
                return this.parseDropColumn(stmt);
            }
        }
        String stmtName = null;
        switch (stmt.getType()) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 87: {
                stmtName = "ALTER COLUMN";
            }
        }
        if (stmtName == null) {
            throw new IgniteSQLException("Unsupported operation: " + stmt.getSQL(), 1002);
        }
        throw new IgniteSQLException(stmtName + " is not supported", 1002);
    }

    private static GridSqlColumn parseColumn(Column col) {
        if (col.isAutoIncrement()) {
            throw new IgniteSQLException("AUTO_INCREMENT columns are not supported [colName=" + col.getName() + ']', 1002);
        }
        if (COLUMN_IS_COMPUTED.get(col).booleanValue()) {
            throw new IgniteSQLException("Computed columns are not supported [colName=" + col.getName() + ']', 1002);
        }
        GridSqlQueryParser.checkTypeSupported(col.getType(), "[colName=" + col.getName() + ']');
        if (col.getDefaultExpression() != null) {
            if (!col.getDefaultExpression().isConstant()) {
                throw new IgniteSQLException("Non-constant DEFAULT expressions are not supported [colName=" + col.getName() + ']', 1002);
            }
            DataType colType = DataType.getDataType((int)col.getType());
            DataType dfltType = DataType.getDataType((int)col.getDefaultExpression().getType());
            if (DataType.isStringType((int)colType.type) && !DataType.isStringType((int)dfltType.type) || DataType.supportsAdd((int)colType.type) && !DataType.supportsAdd((int)dfltType.type)) {
                throw new IgniteSQLException("Invalid default value for column. [colName=" + col.getName() + ", colType=" + colType.name + ", dfltValueType=" + dfltType.name + ']', 2002);
            }
        }
        if (col.getSequence() != null) {
            throw new IgniteSQLException("SEQUENCE columns are not supported [colName=" + col.getName() + ']', 1002);
        }
        if (col.getSelectivity() != 50) {
            throw new IgniteSQLException("SELECTIVITY column attribute is not supported [colName=" + col.getName() + ']', 1002);
        }
        if (COLUMN_CHECK_CONSTRAINT.get(col) != null) {
            throw new IgniteSQLException("Column CHECK constraints are not supported [colName=" + col.getName() + ']', 1002);
        }
        GridSqlColumn gridCol = new GridSqlColumn(col, null, col.getName());
        gridCol.resultType(GridSqlType.fromColumn(col));
        return gridCol;
    }

    private GridSqlStatement parseAddColumn(AlterTableAlterColumn addCol) {
        assert (addCol.getType() == 7);
        if (ALTER_COLUMN_BEFORE_COL.get(addCol) != null) {
            throw new IgniteSQLException("BEFORE keyword is not supported", 1002);
        }
        if (ALTER_COLUMN_AFTER_COL.get(addCol) != null) {
            throw new IgniteSQLException("AFTER keyword is not supported", 1002);
        }
        if (ALTER_COLUMN_FIRST.get(addCol).booleanValue()) {
            throw new IgniteSQLException("FIRST keyword is not supported", 1002);
        }
        GridSqlAlterTableAddColumn res = new GridSqlAlterTableAddColumn();
        ArrayList<Column> h2NewCols = ALTER_COLUMN_NEW_COLS.get(addCol);
        GridSqlColumn[] gridNewCols = new GridSqlColumn[h2NewCols.size()];
        for (int i = 0; i < h2NewCols.size(); ++i) {
            Column col = h2NewCols.get(i);
            if (col.getDefaultExpression() != null) {
                throw new IgniteSQLException("ALTER TABLE ADD COLUMN with DEFAULT value is not supported [col=" + col.getName() + ']', 1002);
            }
            gridNewCols[i] = GridSqlQueryParser.parseColumn(h2NewCols.get(i));
        }
        res.columns(gridNewCols);
        if (gridNewCols.length == 1) {
            res.ifNotExists(ALTER_COLUMN_IF_NOT_EXISTS.get(addCol));
        }
        res.ifTableExists(ALTER_COLUMN_IF_TBL_EXISTS.get(addCol));
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)addCol);
        res.schemaName(schema.getName());
        res.tableName(ALTER_COLUMN_TBL_NAME.get(addCol));
        return res;
    }

    private GridSqlStatement parseDropColumn(AlterTableAlterColumn dropCol) {
        assert (dropCol.getType() == 12);
        GridSqlAlterTableDropColumn res = new GridSqlAlterTableDropColumn();
        ArrayList<Column> h2DropCols = ALTER_COLUMN_REMOVE_COLS.get(dropCol);
        String[] gridDropCols = new String[h2DropCols.size()];
        for (int i = 0; i < h2DropCols.size(); ++i) {
            gridDropCols[i] = h2DropCols.get(i).getName();
        }
        res.columns(gridDropCols);
        if (gridDropCols.length == 1) {
            res.ifExists(ALTER_COLUMN_IF_NOT_EXISTS.get(dropCol) == false);
        }
        res.ifTableExists(ALTER_COLUMN_IF_TBL_EXISTS.get(dropCol));
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)dropCol);
        res.schemaName(schema.getName());
        res.tableName(ALTER_COLUMN_TBL_NAME.get(dropCol));
        return res;
    }

    private static void processExtraParam(String name, String val, GridSqlCreateTable res) {
        assert (!F.isEmpty((String)name));
        switch (name) {
            case "TEMPLATE": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.templateName(val);
                break;
            }
            case "BACKUPS": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                int backups = GridSqlQueryParser.parseIntParam(PARAM_BACKUPS, val);
                if (backups < 0) {
                    throw new IgniteSQLException("\"BACKUPS\" cannot be negative: " + backups, 1001);
                }
                res.backups(backups);
                break;
            }
            case "PARALLELISM": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                int qryPar = GridSqlQueryParser.parseIntParam(PARAM_PARALLELISM, val);
                if (qryPar <= 0) {
                    throw new IgniteSQLException("\"PARALLELISM\" must be positive: " + qryPar, 1001);
                }
                res.parallelism(qryPar);
                break;
            }
            case "ATOMICITY": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                try {
                    res.atomicityMode(CacheAtomicityMode.valueOf((String)val.toUpperCase()));
                    break;
                }
                catch (IllegalArgumentException e) {
                    String validVals = Arrays.stream(CacheAtomicityMode.values()).map(Enum::name).collect(Collectors.joining(", "));
                    throw new IgniteSQLException("Invalid value of \"ATOMICITY\" parameter (should be either " + validVals + "): " + val, 1001, (Throwable)e);
                }
            }
            case "CACHE_NAME": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.cacheName(val);
                break;
            }
            case "KEY_TYPE": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.keyTypeName(val);
                break;
            }
            case "VALUE_TYPE": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.valueTypeName(val);
                break;
            }
            case "CACHEGROUP": 
            case "CACHE_GROUP": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.cacheGroup(val);
                break;
            }
            case "AFFINITYKEY": 
            case "AFFINITY_KEY": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                String affColName = null;
                if (val.startsWith("'")) {
                    if (val.length() == 1 || !val.endsWith("'")) {
                        throw new IgniteSQLException("Affinity key column name does not have trailing quote: " + val, 1001);
                    }
                    val = val.substring(1, val.length() - 1);
                    GridSqlQueryParser.ensureNotEmpty(name, val);
                    affColName = val;
                } else {
                    for (String colName : res.columns().keySet()) {
                        if (!val.equalsIgnoreCase(colName)) continue;
                        if (affColName != null) {
                            throw new IgniteSQLException("Ambiguous affinity column name, use single quotes for case sensitivity: " + val, 1001);
                        }
                        affColName = colName;
                    }
                }
                if (affColName == null || !res.columns().containsKey(affColName)) {
                    throw new IgniteSQLException("Affinity key column with given name not found: " + val, 1001);
                }
                if (!res.primaryKeyColumns().contains(affColName)) {
                    throw new IgniteSQLException("Affinity key column must be one of key columns: " + affColName, 1001);
                }
                res.affinityKey(affColName);
                break;
            }
            case "WRITE_SYNCHRONIZATION_MODE": {
                CacheWriteSynchronizationMode writeSyncMode;
                GridSqlQueryParser.ensureNotEmpty(name, val);
                if (CacheWriteSynchronizationMode.FULL_ASYNC.name().equalsIgnoreCase(val)) {
                    writeSyncMode = CacheWriteSynchronizationMode.FULL_ASYNC;
                } else if (CacheWriteSynchronizationMode.FULL_SYNC.name().equalsIgnoreCase(val)) {
                    writeSyncMode = CacheWriteSynchronizationMode.FULL_SYNC;
                } else if (CacheWriteSynchronizationMode.PRIMARY_SYNC.name().equalsIgnoreCase(val)) {
                    writeSyncMode = CacheWriteSynchronizationMode.PRIMARY_SYNC;
                } else {
                    throw new IgniteSQLException("Invalid value of \"WRITE_SYNCHRONIZATION_MODE\" parameter (should be FULL_SYNC, FULL_ASYNC, or PRIMARY_SYNC): " + val, 1001);
                }
                res.writeSynchronizationMode(writeSyncMode);
                break;
            }
            case "WRAP_KEY": {
                res.wrapKey(F.isEmpty((String)val) || Boolean.parseBoolean(val));
                break;
            }
            case "WRAP_VALUE": {
                res.wrapValue(F.isEmpty((String)val) || Boolean.parseBoolean(val));
                break;
            }
            case "DATA_REGION": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.dataRegionName(val);
                break;
            }
            case "ENCRYPTED": {
                res.encrypted(F.isEmpty((String)val) || Boolean.parseBoolean(val));
                break;
            }
            default: {
                throw new IgniteSQLException("Unsupported parameter: " + name, 1001);
            }
        }
    }

    private static void ensureNotEmpty(String name, String val) {
        if (F.isEmpty((String)val)) {
            throw new IgniteSQLException("Parameter value cannot be empty: " + name, 1001);
        }
    }

    private static int parseIntParam(String name, String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ignored) {
            throw new IgniteSQLException("Parameter value must be an integer [name=" + name + ", value=" + val + ']', 1001);
        }
    }

    private void processSortOrder(SortOrder sortOrder, GridSqlQuery qry) {
        if (sortOrder == null) {
            return;
        }
        int[] indexes = sortOrder.getQueryColumnIndexes();
        int[] sortTypes = sortOrder.getSortTypes();
        for (int i = 0; i < indexes.length; ++i) {
            int colIdx = indexes[i];
            int type = sortTypes[i];
            qry.addSort(new GridSqlSortColumn(colIdx, (type & 1) == 0, (type & 2) != 0, (type & 4) != 0));
        }
    }

    public static Query query(Prepared qry) {
        if (qry instanceof Query) {
            return (Query)qry;
        }
        if (qry instanceof Explain) {
            return GridSqlQueryParser.query(EXPLAIN_COMMAND.get((Explain)qry));
        }
        throw new CacheException("Unsupported query: " + qry);
    }

    public static boolean isDml(Prepared stmt) {
        return stmt instanceof Merge || stmt instanceof Insert || stmt instanceof Update || stmt instanceof Delete;
    }

    @NotNull
    public static GridH2Table dmlTable(@NotNull Prepared stmt) {
        Table table;
        if (stmt.getClass() == Insert.class) {
            table = INSERT_TABLE.get((Insert)stmt);
        } else if (stmt.getClass() == Merge.class) {
            table = MERGE_TABLE.get((Merge)stmt);
        } else if (stmt.getClass() == Delete.class) {
            table = DELETE_FROM.get((Delete)stmt).getTable();
        } else if (stmt.getClass() == Update.class) {
            table = UPDATE_TARGET.get((Update)stmt).getTable();
        } else {
            throw new IgniteException("Unsupported statement: " + stmt);
        }
        assert (table instanceof GridH2Table) : table;
        return (GridH2Table)table;
    }

    public boolean isLocalQuery() {
        if (this.selectForUpdate) {
            return false;
        }
        for (Object o : this.h2ObjToGridObj.values()) {
            GridH2Table tbl;
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || (tbl = ((GridSqlTable)o).dataTable()) == null) continue;
            GridCacheContext cctx = tbl.cacheContext();
            if (cctx == null) {
                return false;
            }
            if (cctx.mvccEnabled()) {
                return false;
            }
            if (cctx.isPartitioned()) {
                return false;
            }
            if (!GridSqlQueryParser.isReplicatedLocalExecutionImpossible(cctx)) continue;
            return false;
        }
        return true;
    }

    private static boolean isReplicatedLocalExecutionImpossible(GridCacheContext<?, ?> cctx) {
        return cctx.isReplicated() && (!cctx.affinityNode() || cctx.topology().hasMovingPartitions());
    }

    public GridCacheContext getFirstPartitionedCache() {
        for (Object o : this.h2ObjToGridObj.values()) {
            GridH2Table tbl;
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || (tbl = ((GridSqlTable)o).dataTable()) == null || !tbl.cacheContext().isPartitioned()) continue;
            return tbl.cacheContext();
        }
        return null;
    }

    public List<Integer> cacheIds() {
        ArrayList<Integer> res = new ArrayList<Integer>(1);
        for (Object o : this.h2ObjToGridObj.values()) {
            GridH2Table tbl;
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable) || (tbl = ((GridSqlTable)o).dataTable()) == null) continue;
            res.add(tbl.cacheId());
        }
        return res;
    }

    public List<GridH2Table> tablesForDml() throws IgniteSQLException {
        Collection<Object> parserObjects = this.h2ObjToGridObj.values();
        ArrayList<GridH2Table> tbls = new ArrayList<GridH2Table>(parserObjects.size());
        for (Object o : parserObjects) {
            if (o instanceof GridSqlMerge) {
                o = ((GridSqlMerge)o).into();
            } else if (o instanceof GridSqlInsert) {
                o = ((GridSqlInsert)o).into();
            } else if (o instanceof GridSqlUpdate) {
                o = ((GridSqlUpdate)o).target();
            } else if (o instanceof GridSqlDelete) {
                o = ((GridSqlDelete)o).from();
            }
            if (o instanceof GridSqlAlias) {
                o = GridSqlAlias.unwrap((GridSqlAst)o);
            }
            if (!(o instanceof GridSqlTable)) continue;
            GridH2Table h2tbl = ((GridSqlTable)o).dataTable();
            if (h2tbl == null) {
                throw new IgniteSQLException("Operation not supported for table '" + ((GridSqlTable)o).tableName() + "'", 1002);
            }
            tbls.add(h2tbl);
        }
        return tbls;
    }

    public static GridSqlQuery parseQuery(Prepared prepared, boolean useOptimizedSubqry, IgniteLogger log) {
        return (GridSqlQuery)new GridSqlQueryParser(useOptimizedSubqry, log).parse(prepared);
    }

    public final GridSqlStatement parse(Prepared stmt) {
        if (stmt instanceof Query) {
            if (this.optimizedTableFilterOrder != null) {
                this.collectOptimizedTableFiltersOrder((Query)stmt);
            }
            this.selectForUpdate = GridSqlQueryParser.isForUpdateQuery(stmt);
            return this.parseQuery((Query)stmt);
        }
        if (stmt instanceof Merge) {
            return this.parseMerge((Merge)stmt);
        }
        if (stmt instanceof Insert) {
            return this.parseInsert((Insert)stmt);
        }
        if (stmt instanceof Delete) {
            return this.parseDelete((Delete)stmt);
        }
        if (stmt instanceof Update) {
            return this.parseUpdate((Update)stmt);
        }
        if (stmt instanceof Explain) {
            return this.parse(EXPLAIN_COMMAND.get((Explain)stmt)).explain(true);
        }
        if (stmt instanceof CreateIndex) {
            return this.parseCreateIndex((CreateIndex)stmt);
        }
        if (stmt instanceof DropIndex) {
            return this.parseDropIndex((DropIndex)stmt);
        }
        if (stmt instanceof CreateTable) {
            return this.parseCreateTable((CreateTable)stmt);
        }
        if (stmt instanceof DropTable) {
            return this.parseDropTable((DropTable)stmt);
        }
        if (stmt instanceof AlterTableAlterColumn) {
            return this.parseAlterColumn((AlterTableAlterColumn)stmt);
        }
        throw new IgniteSQLException("Unsupported statement: " + stmt, 1002);
    }

    public Map<Object, Object> objectsMap() {
        return this.h2ObjToGridObj;
    }

    private GridSqlQuery parseQuery(Query qry) {
        if (qry instanceof Select) {
            return this.parseSelect((Select)qry);
        }
        if (qry instanceof SelectUnion) {
            return this.parseUnion((SelectUnion)qry);
        }
        throw new UnsupportedOperationException("Unknown query type: " + qry);
    }

    private GridSqlUnion parseUnion(SelectUnion union) {
        if (UNION_IS_FOR_UPDATE.get(union).booleanValue()) {
            throw new IgniteSQLException("SELECT UNION FOR UPDATE is not supported.", 1002);
        }
        GridSqlUnion res = (GridSqlUnion)this.h2ObjToGridObj.get(union);
        if (res != null) {
            return res;
        }
        res = new GridSqlUnion();
        res.right(this.parseQuery(union.getRight()));
        res.left(this.parseQuery(union.getLeft()));
        res.unionType(union.getUnionType());
        res.limit(this.parseExpression(union.getLimit(), false));
        res.offset(this.parseExpression(union.getOffset(), false));
        this.processSortOrder(UNION_SORT.get(union), res);
        this.h2ObjToGridObj.put(union, res);
        return res;
    }

    private GridSqlElement parseExpression(@Nullable Expression expression, boolean calcTypes) {
        if (expression == null) {
            return null;
        }
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(expression);
        if (res == null) {
            res = this.parseExpression0(expression, calcTypes);
            if (calcTypes) {
                res.resultType(GridSqlType.fromExpression(expression));
            }
            this.h2ObjToGridObj.put(expression, res);
        }
        return res;
    }

    private void collectOptimizedTableFiltersOrder(Query qry) {
        if (qry instanceof SelectUnion) {
            this.collectOptimizedTableFiltersOrder(((SelectUnion)qry).getLeft());
            this.collectOptimizedTableFiltersOrder(((SelectUnion)qry).getRight());
        } else {
            Select select = (Select)qry;
            TableFilter filter = select.getTopTableFilter();
            int i = 0;
            do {
                GridSqlQueryParser.assert0(filter != null, select);
                GridSqlQueryParser.assert0(filter.getNestedJoin() == null, select);
                this.optimizedTableFilterOrder.put(filter.getTableAlias(), i++);
                Table tbl = filter.getTable();
                if (!(tbl instanceof TableView)) continue;
                ViewIndex viewIdx = (ViewIndex)filter.getIndex();
                this.collectOptimizedTableFiltersOrder(viewIdx.getQuery());
            } while ((filter = filter.getJoin()) != null);
        }
    }

    private static GridSqlOperationType mapOperationType(Operation.OpType opType) {
        switch (opType) {
            case CONCAT: {
                return GridSqlOperationType.CONCAT;
            }
            case PLUS: {
                return GridSqlOperationType.PLUS;
            }
            case MINUS: {
                return GridSqlOperationType.MINUS;
            }
            case MULTIPLY: {
                return GridSqlOperationType.MULTIPLY;
            }
            case DIVIDE: {
                return GridSqlOperationType.DIVIDE;
            }
            case NEGATE: {
                return null;
            }
            case MODULUS: {
                return GridSqlOperationType.MODULUS;
            }
        }
        throw new IllegalStateException("Unsupported operation type: " + opType);
    }

    private GridSqlElement parseExpression0(Expression expression, boolean calcTypes) {
        Aggregate.AggregateType type;
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expCol = (ExpressionColumn)expression;
            return new GridSqlColumn(expCol.getColumn(), this.parseTableFilter(expCol.getTableFilter()), SCHEMA_NAME.get(expCol), expCol.getOriginalTableAliasName(), expCol.getColumnName());
        }
        if (expression instanceof Alias) {
            return new GridSqlAlias(expression.getAlias(), this.parseExpression(expression.getNonAliasExpression(), calcTypes), true);
        }
        if (expression instanceof ValueExpression) {
            return expression == ValueExpression.getDefault() ? GridSqlKeyword.DEFAULT : new GridSqlConst(expression.getValue(null));
        }
        if (expression instanceof Operation) {
            Operation operation = (Operation)expression;
            Operation.OpType type2 = OPERATION_TYPE.get(operation);
            if (type2 == Operation.OpType.NEGATE) {
                assert (OPERATION_RIGHT.get(operation) == null);
                return new GridSqlOperation(GridSqlOperationType.NEGATE, this.parseExpression(OPERATION_LEFT.get(operation), calcTypes));
            }
            return new GridSqlOperation(GridSqlQueryParser.mapOperationType(type2), this.parseExpression(OPERATION_LEFT.get(operation), calcTypes), this.parseExpression(OPERATION_RIGHT.get(operation), calcTypes));
        }
        if (expression instanceof Comparison) {
            Comparison cmp = (Comparison)expression;
            GridSqlOperationType opType = COMPARISON_TYPES[COMPARISON_TYPE.get(cmp)];
            assert (opType != null) : COMPARISON_TYPE.get(cmp);
            Expression leftExp = COMPARISON_LEFT.get(cmp);
            GridSqlElement left = this.parseExpression(leftExp, calcTypes);
            if (opType.childrenCount() == 1) {
                return new GridSqlOperation(opType, left);
            }
            Expression rightExp = COMPARISON_RIGHT.get(cmp);
            GridSqlElement right = this.parseExpression(rightExp, calcTypes);
            return new GridSqlOperation(opType, left, right);
        }
        if (expression instanceof ConditionNot) {
            return new GridSqlOperation(GridSqlOperationType.NOT, this.parseExpression(expression.getNotIfPossible(null), calcTypes));
        }
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr andOr = (ConditionAndOr)expression;
            int type3 = ANDOR_TYPE.get(andOr);
            assert (type3 == 0 || type3 == 1);
            return new GridSqlOperation(type3 == 0 ? GridSqlOperationType.AND : GridSqlOperationType.OR, this.parseExpression(ANDOR_LEFT.get(andOr), calcTypes), this.parseExpression(ANDOR_RIGHT.get(andOr), calcTypes));
        }
        if (expression instanceof Subquery) {
            Query qry = ((Subquery)expression).getQuery();
            return this.parseQueryExpression(qry);
        }
        if (expression instanceof ConditionIn) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CI.get((ConditionIn)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CI.get((ConditionIn)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInConstantSet) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CICS.get((ConditionInConstantSet)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CICS.get((ConditionInConstantSet)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInSelect) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            boolean all = ALL.get((ConditionInSelect)expression);
            int compareType = COMPARE_TYPE.get((ConditionInSelect)expression);
            GridSqlQueryParser.assert0(!all, expression);
            GridSqlQueryParser.assert0(compareType == 0, expression);
            res.addChild(this.parseExpression(LEFT_CIS.get((ConditionInSelect)expression), calcTypes));
            Query qry = QUERY_IN.get((ConditionInSelect)expression);
            res.addChild(this.parseQueryExpression(qry));
            return res;
        }
        if (expression instanceof CompareLike) {
            GridSqlQueryParser.assert0(ESCAPE.get((CompareLike)expression) == null, expression);
            boolean regexp = REGEXP_CL.get((CompareLike)expression);
            return new GridSqlOperation(regexp ? GridSqlOperationType.REGEXP : GridSqlOperationType.LIKE, this.parseExpression(LEFT.get((CompareLike)expression), calcTypes), this.parseExpression(RIGHT.get((CompareLike)expression), calcTypes));
        }
        if (expression instanceof Function) {
            Function f = (Function)expression;
            GridSqlFunction res = new GridSqlFunction(null, f.getName());
            if (f.getArgs() != null) {
                if (f.getFunctionType() == 223 || f.getFunctionType() == 224) {
                    Column[] cols = FUNC_TBL_COLS.get((TableFunction)f);
                    Expression[] args = f.getArgs();
                    assert (cols.length == args.length);
                    for (int i = 0; i < cols.length; ++i) {
                        GridSqlElement arg = this.parseExpression(args[i], calcTypes);
                        GridSqlAlias alias = new GridSqlAlias(cols[i].getName(), arg, false);
                        alias.resultType(GridSqlType.fromColumn(cols[i]));
                        res.addChild(alias);
                    }
                } else {
                    for (Expression arg : f.getArgs()) {
                        if (arg == null) {
                            if (f.getFunctionType() != 206) {
                                throw new IllegalStateException("Function type with null arg: " + f.getFunctionType());
                            }
                            res.addChild(GridSqlPlaceholder.EMPTY);
                            continue;
                        }
                        res.addChild(this.parseExpression(arg, calcTypes));
                    }
                }
            }
            if (f.getFunctionType() == 203 || f.getFunctionType() == 202) {
                GridSqlQueryParser.checkTypeSupported(f.getType(), "[expSql=" + f.getSQL() + ']');
                res.resultType(GridSqlType.fromExpression((Expression)f));
            }
            return res;
        }
        if (expression instanceof JavaFunction) {
            JavaFunction f = (JavaFunction)expression;
            FunctionAlias alias = FUNC_ALIAS.get(f);
            GridSqlFunction res = new GridSqlFunction(alias.getSchema().getName(), f.getName());
            if (f.getArgs() != null) {
                for (Expression arg : f.getArgs()) {
                    res.addChild(this.parseExpression(arg, calcTypes));
                }
            }
            return res;
        }
        if (expression instanceof Parameter) {
            return new GridSqlParameter(((Parameter)expression).getIndex());
        }
        if (expression instanceof Aggregate && GridSqlAggregateFunction.isValidType(type = TYPE.get((Aggregate)expression))) {
            Expression separator;
            ArrayList<SelectOrderBy> orders;
            GridSqlAggregateFunction res = new GridSqlAggregateFunction((boolean)DISTINCT.get((Aggregate)expression), type);
            Expression on = ON.get((Aggregate)expression);
            if (on != null) {
                res.addChild(this.parseExpression(on, calcTypes));
            }
            if (!F.isEmpty(orders = GROUP_CONCAT_ORDER_LIST.get((Aggregate)expression))) {
                this.parseGroupConcatOrder(res, orders, calcTypes);
            }
            if ((separator = GROUP_CONCAT_SEPARATOR.get((Aggregate)expression)) != null) {
                res.setGroupConcatSeparator(this.parseExpression(separator, calcTypes));
            }
            return res;
        }
        if (expression instanceof ExpressionList) {
            Expression[] exprs = EXPR_LIST.get((ExpressionList)expression);
            GridSqlArray res = new GridSqlArray(exprs.length);
            for (Expression expr : exprs) {
                res.addChild(this.parseExpression(expr, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionExists) {
            Query qry = QUERY_EXISTS.get((ConditionExists)expression);
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.EXISTS);
            res.addChild(this.parseQueryExpression(qry));
            return res;
        }
        throw new IgniteException("Unsupported expression: " + expression + " [type=" + expression.getClass().getSimpleName() + ']');
    }

    public static boolean isStreamableInsertStatement(Prepared prep) {
        return prep instanceof Insert && INSERT_QUERY.get((Insert)prep) == null;
    }

    private void parseGroupConcatOrder(GridSqlAggregateFunction f, ArrayList<SelectOrderBy> orders, boolean calcTypes) {
        GridSqlElement[] grpConcatOrderExpression = new GridSqlElement[orders.size()];
        boolean[] grpConcatOrderDesc = new boolean[orders.size()];
        for (int i = 0; i < orders.size(); ++i) {
            SelectOrderBy o = orders.get(i);
            grpConcatOrderExpression[i] = this.parseExpression(o.expression, calcTypes);
            grpConcatOrderDesc[i] = o.descending;
        }
        f.setGroupConcatOrder(grpConcatOrderExpression, grpConcatOrderDesc);
    }

    private static void assert0(boolean cond, Object o) {
        if (!cond) {
            throw new IgniteException("Unsupported query: " + o);
        }
    }

    public static boolean isExplainUpdate(Prepared statement) {
        if (!(statement instanceof Explain)) {
            return false;
        }
        return !EXPLAIN_COMMAND.get((Explain)statement).isQuery();
    }

    public static void checkTypeSupported(int type, String errMsg) {
        if (type == 24) {
            throw new IgniteSQLException("TIMESTAMP WITH TIMEZONE type is not supported " + errMsg, 1002);
        }
        if (type == 25) {
            throw new IgniteSQLException("ENUM type is not supported " + errMsg, 1002);
        }
    }

    private static <T, R> Getter<T, R> getter(Class<? extends T> cls, String fldName) {
        Field field;
        try {
            field = cls.getDeclaredField(fldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return new Getter(field);
    }

    static {
        try {
            CLS_COMMAND_LIST = CommandContainer.class.getClassLoader().loadClass(ORG_H2_COMMAND_COMMAND_LIST);
            LIST_COMMAND = GridSqlQueryParser.getter(CLS_COMMAND_LIST, "command");
            REMAINING = GridSqlQueryParser.getter(CLS_COMMAND_LIST, "remaining");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ALTER_COLUMN_TBL_NAME = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "tableName");
        ALTER_COLUMN_NEW_COLS = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "columnsToAdd");
        ALTER_COLUMN_REMOVE_COLS = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "columnsToRemove");
        ALTER_COLUMN_IF_NOT_EXISTS = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "ifNotExists");
        ALTER_COLUMN_IF_TBL_EXISTS = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "ifTableExists");
        ALTER_COLUMN_BEFORE_COL = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "addBefore");
        ALTER_COLUMN_FIRST = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "addFirst");
        ALTER_COLUMN_AFTER_COL = GridSqlQueryParser.getter(AlterTableAlterColumn.class, "addAfter");
    }

    public static class PreparedWithRemaining {
        private Prepared prepared;
        private String remainingSql;

        public PreparedWithRemaining(Prepared prepared, String sql) {
            this.prepared = prepared;
            if (sql != null) {
                sql = sql.trim();
            }
            this.remainingSql = !F.isEmpty((String)sql) ? sql : null;
        }

        public Prepared prepared() {
            return this.prepared;
        }

        public String remainingSql() {
            return this.remainingSql;
        }
    }

    public static class Getter<T, R> {
        private final Field fld;

        private Getter(Field fld) {
            this.fld = fld;
        }

        public R get(T obj) {
            try {
                return (R)this.fld.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }
}

