/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioMessageReaderFactory;
import org.apache.ignite.internal.util.nio.GridNioMessageWriterFactory;
import org.apache.ignite.internal.util.nio.GridNioRecoveryDescriptor;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiMultipleInstancesSupport;
import org.apache.ignite.spi.IgniteSpiThread;
import org.apache.ignite.spi.communication.CommunicationListener;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationMetricsListener;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpiMBean;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationDiscoveryEventListener;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationListenerEx;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationTcpUtils;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationWorker;
import org.apache.ignite.spi.communication.tcp.internal.ConnectGateway;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionClientPool;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionKey;
import org.apache.ignite.spi.communication.tcp.internal.FirstConnectionPolicy;
import org.apache.ignite.spi.communication.tcp.internal.GridNioServerWrapper;
import org.apache.ignite.spi.communication.tcp.internal.InboundConnectionHandler;
import org.apache.ignite.spi.communication.tcp.internal.NodeUnreachableException;
import org.apache.ignite.spi.communication.tcp.internal.RoundRobinConnectionPolicy;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfigInitializer;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConnectionCheckFuture;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationSpiMBeanImpl;
import org.apache.ignite.spi.communication.tcp.internal.TcpConnectionIndexAwareMessage;
import org.apache.ignite.spi.communication.tcp.internal.TcpHandshakeExecutor;
import org.apache.ignite.spi.communication.tcp.internal.shmem.ShmemAcceptWorker;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;

@IgniteSpiMultipleInstancesSupport(value=true)
@IgniteSpiConsistencyChecked(optional=false)
public class TcpCommunicationSpi
extends TcpCommunicationConfigInitializer {
    public static final String OUT_OF_RESOURCES_TCP_MSG = "Failed to allocate shared memory segment (switching to TCP, may be slower).";
    public static final String ATTR_ADDRS = "comm.tcp.addrs";
    public static final String ATTR_HOST_NAMES = "comm.tcp.host.names";
    public static final String ATTR_PORT = "comm.tcp.port";
    public static final String ATTR_SHMEM_PORT = "comm.shmem.tcp.port";
    public static final String ATTR_EXT_ADDRS = "comm.tcp.ext-addrs";
    public static final String ATTR_PAIRED_CONN = "comm.tcp.pairedConnection";
    public static final int DFLT_PORT = 47100;
    public static final int DFLT_SHMEM_PORT = -1;
    public static final long DFLT_IDLE_CONN_TIMEOUT = 600000L;
    public static final int DFLT_SOCK_BUF_SIZE = 32768;
    public static final long DFLT_CONN_TIMEOUT = 5000L;
    public static final long DFLT_MAX_CONN_TIMEOUT = 600000L;
    public static final int DFLT_RECONNECT_CNT = 10;
    public static final int DFLT_MSG_QUEUE_LIMIT = 0;
    public static final int DFLT_SELECTORS_CNT = Math.max(4, Runtime.getRuntime().availableProcessors() / 2);
    public static final int CONN_IDX_META = GridNioSessionMetaKey.nextUniqueKey();
    public static final int CONSISTENT_ID_META = GridNioSessionMetaKey.nextUniqueKey();
    public static final int DFLT_PORT_RANGE = 100;
    public static final boolean DFLT_TCP_NODELAY = true;
    public static final boolean DFLT_FILTER_REACHABLE_ADDRESSES = false;
    public static final int DFLT_ACK_SND_THRESHOLD = 32;
    public static final long DFLT_SOCK_WRITE_TIMEOUT = 2000L;
    public static final int DFLT_CONN_PER_NODE = 1;
    public static final short NODE_ID_MSG_TYPE = -1;
    public static final short RECOVERY_LAST_ID_MSG_TYPE = -2;
    public static final short HANDSHAKE_MSG_TYPE = -3;
    public static final short HANDSHAKE_WAIT_MSG_TYPE = -28;
    public static final String COMMUNICATION_METRICS_GROUP_NAME = MetricUtils.metricName("communication", "tcp");
    public static final String SENT_MESSAGES_METRIC_NAME = "sentMessagesCount";
    public static final String SENT_MESSAGES_METRIC_DESC = "Total number of messages sent by current node";
    public static final String RECEIVED_MESSAGES_METRIC_NAME = "receivedMessagesCount";
    public static final String RECEIVED_MESSAGES_METRIC_DESC = "Total number of messages received by current node";
    public static final String SENT_MESSAGES_BY_TYPE_METRIC_NAME = "sentMessagesByType";
    public static final String SENT_MESSAGES_BY_TYPE_METRIC_DESC = "Total number of messages with given type sent by current node";
    public static final String RECEIVED_MESSAGES_BY_TYPE_METRIC_NAME = "receivedMessagesByType";
    public static final String RECEIVED_MESSAGES_BY_TYPE_METRIC_DESC = "Total number of messages with given type received by current node";
    public static final String SENT_MESSAGES_BY_NODE_CONSISTENT_ID_METRIC_NAME = "sentMessagesToNode";
    public static final String SENT_MESSAGES_BY_NODE_CONSISTENT_ID_METRIC_DESC = "Total number of messages sent by current node to the given node";
    public static final String RECEIVED_MESSAGES_BY_NODE_CONSISTENT_ID_METRIC_NAME = "receivedMessagesFromNode";
    public static final String RECEIVED_MESSAGES_BY_NODE_CONSISTENT_ID_METRIC_DESC = "Total number of messages received by current node from the given node";
    public static final Integer DISABLED_CLIENT_PORT = 0;
    private final ConnectGateway connectGate = new ConnectGateway();
    private final CountDownLatch ctxInitLatch = new CountDownLatch(1);
    private volatile ShmemAcceptWorker shmemAcceptWorker;
    private volatile boolean stopping;
    private volatile CommunicationListener<Message> lsnr;
    private volatile ConnectionClientPool clientPool;
    private volatile CommunicationWorker commWorker;
    private volatile InboundConnectionHandler srvLsnr;
    private volatile GridLocalEventListener discoLsnr;
    private volatile GridNioServerWrapper nioSrvWrapper;
    private volatile ClusterStateProvider stateProvider;
    public static final String ATTR_FORCE_CLIENT_SERVER_CONNECTIONS = "comm.force.client.srv.connections";
    @LoggerResource
    private IgniteLogger log;
    @LoggerResource(categoryName="org.apache.ignite.internal.diagnostic")
    private IgniteLogger diagnosticLog;

    @Override
    @Deprecated
    public void setListener(CommunicationListener<Message> lsnr) {
        this.lsnr = lsnr;
    }

    public CommunicationListener getListener() {
        return this.lsnr;
    }

    @Override
    public int getSentMessagesCount() {
        if (this.metricsLsnr == null) {
            return 0;
        }
        return this.metricsLsnr.sentMessagesCount();
    }

    @Override
    public long getSentBytesCount() {
        if (this.metricsLsnr == null) {
            return 0L;
        }
        return this.metricsLsnr.sentBytesCount();
    }

    @Override
    public int getReceivedMessagesCount() {
        if (this.metricsLsnr == null) {
            return 0;
        }
        return this.metricsLsnr.receivedMessagesCount();
    }

    @Override
    public long getReceivedBytesCount() {
        if (this.metricsLsnr == null) {
            return 0L;
        }
        return this.metricsLsnr.receivedBytesCount();
    }

    public Map<String, Long> getReceivedMessagesByType() {
        return this.metricsLsnr.receivedMessagesByType();
    }

    public Map<UUID, Long> getReceivedMessagesByNode() {
        return this.metricsLsnr.receivedMessagesByNode();
    }

    public Map<String, Long> getSentMessagesByType() {
        return this.metricsLsnr.sentMessagesByType();
    }

    public Map<UUID, Long> getSentMessagesByNode() {
        return this.metricsLsnr.sentMessagesByNode();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        GridNioServer<Message> srv = this.nioSrvWrapper.nio();
        return srv != null ? srv.outboundMessagesQueueSize() : 0;
    }

    @Override
    public void resetMetrics() {
        this.metricsLsnr.resetMetrics();
    }

    void onNodeLeft(Object consistentId, UUID nodeId) {
        assert (nodeId != null);
        this.metricsLsnr.onNodeLeft(consistentId);
        this.clientPool.onNodeLeft(nodeId);
    }

    public IgniteInternalFuture<String> dumpNodeStatistics(UUID nodeId) {
        StringBuilder sb = new StringBuilder("Communication SPI statistics [rmtNode=").append(nodeId).append(']').append(U.nl());
        this.dumpInfo(sb, nodeId);
        GridNioServer<Message> nioSrvr = this.nioSrvWrapper.nio();
        if (nioSrvr != null) {
            sb.append("NIO sessions statistics:");
            IgnitePredicate<GridNioSession> p = ses -> {
                ConnectionKey connId = (ConnectionKey)ses.meta(CONN_IDX_META);
                return connId != null && nodeId.equals(connId.nodeId());
            };
            return nioSrvr.dumpStats(sb.toString(), p);
        }
        sb.append(U.nl()).append("GridNioServer is null.");
        return new GridFinishedFuture<String>(sb.toString());
    }

    public void dumpStats() {
        IgniteLogger log = this.diagnosticLog;
        if (log != null) {
            StringBuilder sb = new StringBuilder();
            this.dumpInfo(sb, null);
            U.warn(log, sb.toString());
            GridNioServer<Message> nioSrvr = this.nioSrvWrapper.nio();
            if (nioSrvr != null) {
                nioSrvr.dumpStats().listen(fut -> {
                    try {
                        U.warn(log, fut.get());
                    }
                    catch (Exception e) {
                        U.error(log, "Failed to dump NIO server statistics: " + e, e);
                    }
                });
            }
        }
    }

    private void dumpInfo(StringBuilder sb, UUID dstNodeId) {
        GridNioRecoveryDescriptor desc;
        sb.append("Communication SPI recovery descriptors: ").append(U.nl());
        for (Map.Entry entry : this.nioSrvWrapper.recoveryDescs().entrySet()) {
            desc = (GridNioRecoveryDescriptor)entry.getValue();
            if (dstNodeId != null && !dstNodeId.equals(((ConnectionKey)entry.getKey()).nodeId())) continue;
            sb.append("    [key=").append(entry.getKey()).append(", msgsSent=").append(desc.sent()).append(", msgsAckedByRmt=").append(desc.acked()).append(", msgsRcvd=").append(desc.received()).append(", lastAcked=").append(desc.lastAcknowledged()).append(", reserveCnt=").append(desc.reserveCount()).append(", descIdHash=").append(System.identityHashCode(desc)).append(']').append(U.nl());
        }
        for (Map.Entry entry : this.nioSrvWrapper.outRecDescs().entrySet()) {
            desc = (GridNioRecoveryDescriptor)entry.getValue();
            if (dstNodeId != null && !dstNodeId.equals(((ConnectionKey)entry.getKey()).nodeId())) continue;
            sb.append("    [key=").append(entry.getKey()).append(", msgsSent=").append(desc.sent()).append(", msgsAckedByRmt=").append(desc.acked()).append(", reserveCnt=").append(desc.reserveCount()).append(", connected=").append(desc.connected()).append(", reserved=").append(desc.reserved()).append(", descIdHash=").append(System.identityHashCode(desc)).append(']').append(U.nl());
        }
        for (Map.Entry entry : this.nioSrvWrapper.inRecDescs().entrySet()) {
            desc = (GridNioRecoveryDescriptor)entry.getValue();
            if (dstNodeId != null && !dstNodeId.equals(((ConnectionKey)entry.getKey()).nodeId())) continue;
            sb.append("    [key=").append(entry.getKey()).append(", msgsRcvd=").append(desc.received()).append(", lastAcked=").append(desc.lastAcknowledged()).append(", reserveCnt=").append(desc.reserveCount()).append(", connected=").append(desc.connected()).append(", reserved=").append(desc.reserved()).append(", handshakeIdx=").append(desc.handshakeIndex()).append(", descIdHash=").append(System.identityHashCode(desc)).append(']').append(U.nl());
        }
        sb.append("Communication SPI clients: ").append(U.nl());
        for (Map.Entry entry : this.clientPool.entrySet()) {
            GridCommunicationClient[] clients0;
            UUID clientNodeId = (UUID)entry.getKey();
            if (dstNodeId != null && !dstNodeId.equals(clientNodeId)) continue;
            for (GridCommunicationClient client : clients0 = (GridCommunicationClient[])entry.getValue()) {
                if (client == null) continue;
                sb.append("    [node=").append(clientNodeId).append(", client=").append(client).append(']').append(U.nl());
            }
        }
    }

    @Override
    public void spiStart(String igniteInstanceName) throws IgniteSpiException {
        boolean forceClientToSrvConnections;
        Function<UUID, ClusterNode> nodeGetter = nodeId -> this.getSpiContext().node((UUID)nodeId);
        Supplier<ClusterNode> locNodeSupplier = () -> this.getSpiContext().localNode();
        Supplier<Ignite> igniteExSupplier = this::ignite;
        Function<UUID, Boolean> pingNode = nodeId -> this.getSpiContext().pingNode((UUID)nodeId);
        Supplier<FailureProcessor> failureProcessorSupplier = () -> this.ignite instanceof IgniteEx ? ((IgniteEx)this.ignite).context().failure() : null;
        Supplier<Boolean> isStopped = () -> this.getSpiContext().isStopping();
        this.igniteInstanceName = igniteInstanceName;
        this.cfg.failureDetectionTimeout(this.ignite.configuration().getFailureDetectionTimeout());
        this.attributeNames = new AttributeNames(this.createSpiAttributeName(ATTR_PAIRED_CONN), this.createSpiAttributeName(ATTR_SHMEM_PORT), this.createSpiAttributeName(ATTR_ADDRS), this.createSpiAttributeName(ATTR_HOST_NAMES), this.createSpiAttributeName(ATTR_EXT_ADDRS), this.createSpiAttributeName(ATTR_PORT), this.createSpiAttributeName(ATTR_FORCE_CLIENT_SERVER_CONNECTIONS));
        boolean client = Boolean.TRUE.equals(this.ignite().configuration().isClientMode());
        this.stateProvider = new ClusterStateProvider(this.ignite, locNodeSupplier, this, isStopped, () -> super.getSpiContext(), this.log, igniteExSupplier);
        try {
            this.cfg.localHost(U.resolveLocalHost(this.cfg.localAddress()));
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to initialize local address: " + this.cfg.localAddress(), e);
        }
        this.connPlc = this.cfg.connectionsPerNode() > 1 ? new RoundRobinConnectionPolicy(this.cfg) : new FirstConnectionPolicy();
        this.srvLsnr = this.resolve(this.ignite, new InboundConnectionHandler(this.log, this.cfg, nodeGetter, locNodeSupplier, this.stateProvider, this.clientPool, this.commWorker, this.connectGate, failureProcessorSupplier, this.attributeNames, this.metricsLsnr, this.nioSrvWrapper, this.ctxInitLatch, client, igniteExSupplier, new CommunicationListener<Message>(){

            @Override
            public void onMessage(UUID nodeId, Message msg, IgniteRunnable msgC) {
                TcpCommunicationSpi.this.notifyListener(nodeId, msg, msgC);
            }

            @Override
            public void onDisconnected(UUID nodeId) {
                if (TcpCommunicationSpi.this.lsnr != null) {
                    TcpCommunicationSpi.this.lsnr.onDisconnected(nodeId);
                }
            }
        }));
        TcpHandshakeExecutor tcpHandshakeExecutor = this.resolve(this.ignite, new TcpHandshakeExecutor(this.log, this.stateProvider, this.cfg.directBuffer()));
        this.nioSrvWrapper = this.resolve(this.ignite, new GridNioServerWrapper(this.log, this.cfg, this.attributeNames, this.tracing, nodeGetter, locNodeSupplier, this.connectGate, this.stateProvider, this::getExceptionRegistry, this.commWorker, this.ignite.configuration(), this.srvLsnr, this.getName(), TcpCommunicationSpi.getWorkersRegistry(this.ignite), this.ignite instanceof IgniteEx ? ((IgniteEx)this.ignite).context().metric() : null, this::createTcpClient, (CommunicationListener<Message>)new CommunicationListenerEx<Message>(){

            @Override
            public void onMessage(UUID nodeId, Message msg, IgniteRunnable msgC) {
                TcpCommunicationSpi.this.notifyListener(nodeId, msg, msgC);
            }

            @Override
            public void onDisconnected(UUID nodeId) {
                if (TcpCommunicationSpi.this.lsnr != null) {
                    TcpCommunicationSpi.this.lsnr.onDisconnected(nodeId);
                }
            }

            @Override
            public void onChannelOpened(UUID rmtNodeId, Message initMsg, Channel channel) {
                if (TcpCommunicationSpi.this.lsnr instanceof CommunicationListenerEx) {
                    ((CommunicationListenerEx)TcpCommunicationSpi.this.lsnr).onChannelOpened(rmtNodeId, initMsg, channel);
                }
            }
        }, tcpHandshakeExecutor));
        this.srvLsnr.setNioSrvWrapper(this.nioSrvWrapper);
        this.clientPool = this.resolve(this.ignite, new ConnectionClientPool(this.cfg, this.attributeNames, this.log, this.metricsLsnr, locNodeSupplier, nodeGetter, null, TcpCommunicationSpi.getWorkersRegistry(this.ignite), this, this.stateProvider, this.nioSrvWrapper, this.getName()));
        this.srvLsnr.setClientPool(this.clientPool);
        this.nioSrvWrapper.clientPool(this.clientPool);
        this.discoLsnr = new CommunicationDiscoveryEventListener(this.clientPool, this.metricsLsnr);
        try {
            this.shmemSrv = this.resetShmemServer();
        }
        catch (IgniteCheckedException e) {
            U.warn(this.log, "Failed to start shared memory communication server.", e);
        }
        try {
            this.nioSrvWrapper.nio(this.nioSrvWrapper.resetNioServer());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to initialize TCP server: " + this.cfg.localHost(), e);
        }
        boolean bl = forceClientToSrvConnections = this.forceClientToServerConnections() || this.cfg.localPort() == -1;
        if (this.cfg.usePairedConnections() && forceClientToSrvConnections) {
            throw new IgniteSpiException("Node using paired connections is not allowed to start in forced client to server connections mode.");
        }
        assert (this.cfg.localHost() != null);
        this.startStopwatch();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.configInfo("locAddr", this.cfg.localAddress()));
            this.log.debug(this.configInfo("locPort", this.cfg.localPort()));
            this.log.debug(this.configInfo("locPortRange", this.cfg.localPortRange()));
            this.log.debug(this.configInfo("idleConnTimeout", this.cfg.idleConnectionTimeout()));
            this.log.debug(this.configInfo("directBuf", this.cfg.directBuffer()));
            this.log.debug(this.configInfo("directSendBuf", this.cfg.directSendBuffer()));
            this.log.debug(this.configInfo("selectorsCnt", this.cfg.selectorsCount()));
            this.log.debug(this.configInfo("tcpNoDelay", this.cfg.tcpNoDelay()));
            this.log.debug(this.configInfo("sockSndBuf", this.cfg.socketSendBuffer()));
            this.log.debug(this.configInfo("sockRcvBuf", this.cfg.socketReceiveBuffer()));
            this.log.debug(this.configInfo("shmemPort", this.cfg.shmemPort()));
            this.log.debug(this.configInfo("msgQueueLimit", this.cfg.messageQueueLimit()));
            this.log.debug(this.configInfo("connectionsPerNode", this.cfg.connectionsPerNode()));
            if (this.failureDetectionTimeoutEnabled()) {
                this.log.debug(this.configInfo("connTimeout", this.cfg.connectionTimeout()));
                this.log.debug(this.configInfo("maxConnTimeout", this.cfg.maxConnectionTimeout()));
                this.log.debug(this.configInfo("reconCnt", this.cfg.reconCount()));
            } else {
                this.log.debug(this.configInfo("failureDetectionTimeout", this.failureDetectionTimeout()));
            }
            this.log.debug(this.configInfo("sockWriteTimeout", this.cfg.socketWriteTimeout()));
            this.log.debug(this.configInfo("ackSndThreshold", this.cfg.ackSendThreshold()));
            this.log.debug(this.configInfo("unackedMsgsBufSize", this.cfg.unackedMsgsBufferSize()));
        }
        if (!this.cfg.tcpNoDelay()) {
            U.quietAndWarn(this.log, "'TCP_NO_DELAY' for communication is off, which should be used with caution since may produce significant delays with some scenarios.");
        }
        if (this.cfg.slowClientQueueLimit() > 0 && this.cfg.messageQueueLimit() > 0 && this.cfg.slowClientQueueLimit() >= this.cfg.messageQueueLimit()) {
            U.quietAndWarn(this.log, "Slow client queue limit is set to a value greater than or equal to message queue limit (slow client queue limit will have no effect) [msgQueueLimit=" + this.cfg.messageQueueLimit() + ", slowClientQueueLimit=" + this.cfg.slowClientQueueLimit() + ']');
        }
        if (this.cfg.messageQueueLimit() == 0) {
            U.quietAndWarn(this.log, "Message queue limit is set to 0 which may lead to potential OOMEs when running cache operations in FULL_ASYNC or PRIMARY_SYNC modes due to message queues growth on sender and receiver sides.");
        }
        if (this.shmemSrv != null) {
            MessageFactory msgFactory = new MessageFactory(){
                private MessageFactory impl;

                @Override
                @Nullable
                public Message create(short type) {
                    if (this.impl == null) {
                        this.impl = TcpCommunicationSpi.this.getSpiContext().messageFactory();
                    }
                    assert (this.impl != null);
                    return this.impl.create(type);
                }
            };
            GridNioMessageWriterFactory writerFactory = new GridNioMessageWriterFactory(){
                private MessageFormatter formatter;

                @Override
                public MessageWriter writer(GridNioSession ses) throws IgniteCheckedException {
                    if (this.formatter == null) {
                        this.formatter = TcpCommunicationSpi.this.getSpiContext().messageFormatter();
                    }
                    assert (this.formatter != null);
                    ConnectionKey connKey = (ConnectionKey)ses.meta(CONN_IDX_META);
                    return connKey != null ? this.formatter.writer(connKey.nodeId()) : null;
                }
            };
            GridNioMessageReaderFactory readerFactory = new GridNioMessageReaderFactory(){
                private MessageFormatter formatter;

                @Override
                public MessageReader reader(GridNioSession ses, MessageFactory msgFactory) throws IgniteCheckedException {
                    if (this.formatter == null) {
                        this.formatter = TcpCommunicationSpi.this.getSpiContext().messageFormatter();
                    }
                    assert (this.formatter != null);
                    ConnectionKey connKey = (ConnectionKey)ses.meta(CONN_IDX_META);
                    return connKey != null ? this.formatter.reader(connKey.nodeId(), msgFactory) : null;
                }
            };
            this.shmemAcceptWorker = new ShmemAcceptWorker(igniteInstanceName, this.srvLsnr, this.shmemSrv, this.metricsLsnr, this.log, msgFactory, writerFactory, readerFactory, this.tracing);
            new IgniteThread(this.shmemAcceptWorker).start();
        }
        this.nioSrvWrapper.start();
        this.commWorker = new CommunicationWorker(igniteInstanceName, this.log, this.cfg, this.attributeNames, this.clientPool, failureProcessorSupplier, nodeGetter, pingNode, this::getExceptionRegistry, this.nioSrvWrapper, TcpCommunicationSpi.getWorkersRegistry(this.ignite), this.getName());
        this.srvLsnr.communicationWorker(this.commWorker);
        this.nioSrvWrapper.communicationWorker(this.commWorker);
        new IgniteSpiThread(igniteInstanceName, this.commWorker.name(), this.log){

            @Override
            protected void body() {
                TcpCommunicationSpi.this.commWorker.run();
            }
        }.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    public void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        if (this.cfg.boundTcpPort() > 0) {
            spiCtx.registerPort(this.cfg.boundTcpPort(), IgnitePortProtocol.TCP);
        }
        if (this.cfg.boundTcpShmemPort() > 0) {
            spiCtx.registerPort(this.cfg.boundTcpShmemPort(), IgnitePortProtocol.TCP);
        }
        spiCtx.addLocalEventListener(this.discoLsnr, 11, 12);
        this.metricsLsnr = new TcpCommunicationMetricsListener(this.ignite, spiCtx);
        this.registerMBean(this.igniteInstanceName, new TcpCommunicationSpiMBeanImpl(this, this.metricsLsnr, this.cfg, this.stateProvider), TcpCommunicationSpiMBean.class);
        this.srvLsnr.metricsListener(this.metricsLsnr);
        this.clientPool.metricsListener(this.metricsLsnr);
        ((CommunicationDiscoveryEventListener)this.discoLsnr).metricsListener(this.metricsLsnr);
        if (this.shmemAcceptWorker != null) {
            this.shmemAcceptWorker.metricsListener(this.metricsLsnr);
        }
        this.ctxInitLatch.countDown();
    }

    @Override
    public IgniteSpiContext getSpiContext() {
        if (this.ctxInitLatch.getCount() > 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Waiting for context initialization.");
            }
            try {
                U.await(this.ctxInitLatch);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Context has been initialized.");
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                U.warn(this.log, "Thread has been interrupted while waiting for SPI context initialization.", e);
            }
        }
        return super.getSpiContext();
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        assert (this.stopping);
        this.unregisterMBean();
        if (this.nioSrvWrapper != null) {
            this.nioSrvWrapper.stop();
        }
        if (this.commWorker != null) {
            this.commWorker.stop();
            U.cancel(this.commWorker);
            U.join(this.commWorker, this.log);
        }
        U.cancel(this.shmemAcceptWorker);
        U.join(this.shmemAcceptWorker, this.log);
        if (this.srvLsnr != null) {
            this.srvLsnr.stop();
        }
        if (this.clientPool != null) {
            this.clientPool.stop();
            this.clientPool.forceClose();
        }
        if (this.nioSrvWrapper != null) {
            this.nioSrvWrapper.clear();
        }
        this.cfg.boundTcpPort(-1);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    @Override
    protected void onContextDestroyed0() {
        this.stopping = true;
        if (this.ctxInitLatch.getCount() > 0L) {
            this.ctxInitLatch.countDown();
        }
        this.connectGate.stopped();
        this.getSpiContext().deregisterPorts();
        this.getSpiContext().removeLocalEventListener(this.discoLsnr);
    }

    @Override
    public void onClientDisconnected(IgniteFuture<?> reconnectFut) {
        this.connectGate.disconnected(reconnectFut);
        this.clientPool.forceClose();
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Failed to connect client node disconnected.");
        this.clientPool.completeFutures(err);
        this.nioSrvWrapper.recoveryDescs().clear();
        this.nioSrvWrapper.inRecDescs().clear();
        this.nioSrvWrapper.outRecDescs().clear();
    }

    @Override
    public void onClientReconnected(boolean clusterRestarted) {
        this.connectGate.reconnected();
    }

    @Override
    protected void checkConfigurationConsistency0(IgniteSpiContext spiCtx, ClusterNode node, boolean starting) throws IgniteSpiException {
        this.checkAttributePresence(node, this.createSpiAttributeName(ATTR_ADDRS));
        this.checkAttributePresence(node, this.createSpiAttributeName(ATTR_HOST_NAMES));
        this.checkAttributePresence(node, this.createSpiAttributeName(ATTR_PORT));
    }

    public IgniteInternalFuture<Channel> openChannel(ClusterNode remote, Message initMsg) throws IgniteSpiException {
        return this.nioSrvWrapper.openChannel(remote, initMsg);
    }

    private <T> T resolve(Ignite ignite, T instance) {
        return ignite instanceof IgniteKernal ? ((IgniteKernal)ignite).context().resource().resolve(instance) : instance;
    }

    private void checkAttributePresence(ClusterNode node, String attrName) {
        if (node.attribute(attrName) == null) {
            U.warn(this.log, "Remote node has inconsistent configuration (required attribute was not found) [attrName=" + attrName + ", nodeId=" + node.id() + "spiCls=" + U.getSimpleName(TcpCommunicationSpi.class) + ']');
        }
    }

    @Override
    public void sendMessage(ClusterNode node, Message msg) throws IgniteSpiException {
        this.sendMessage0(node, msg, null);
    }

    public IgniteFuture<BitSet> checkConnection(List<ClusterNode> nodes) {
        long timeout;
        TcpCommunicationConnectionCheckFuture fut = new TcpCommunicationConnectionCheckFuture(this, this.log.getLogger(TcpCommunicationConnectionCheckFuture.class), this.nioSrvWrapper.nio(), nodes);
        long l = timeout = this.failureDetectionTimeoutEnabled() ? this.failureDetectionTimeout() : this.cfg.connectionTimeout();
        if (this.log.isInfoEnabled()) {
            this.log.info("Start check connection process [nodeCnt=" + nodes.size() + ", timeout=" + timeout + ']');
        }
        fut.init(timeout);
        return new IgniteFutureImpl<BitSet>(fut);
    }

    public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
        this.sendMessage0(node, msg, ackC);
    }

    private void sendMessage0(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
        assert (node != null);
        assert (msg != null);
        IgniteLogger log = this.log;
        if (log != null && log.isTraceEnabled()) {
            log.trace("Sending message with ack to node [node=" + node + ", msg=" + msg + ']');
        }
        if (this.stateProvider.isLocalNodeDisconnected()) {
            throw new IgniteSpiException("Failed to send a message to remote node because local node has been disconnected [rmtNodeId=" + node.id() + ']');
        }
        ClusterNode locNode = this.getLocalNode();
        if (locNode == null) {
            throw new IgniteSpiException("Local node has not been started or fully initialized [isStopping=" + this.getSpiContext().isStopping() + ']');
        }
        if (node.id().equals(locNode.id())) {
            this.notifyListener(node.id(), msg, CommunicationTcpUtils.NOOP);
        } else {
            int msgConnIdx;
            Message connIdxMsg;
            GridCommunicationClient client = null;
            Message message = connIdxMsg = msg instanceof GridIoMessage ? ((GridIoMessage)msg).message() : msg;
            int connIdx = connIdxMsg instanceof TcpConnectionIndexAwareMessage ? ((msgConnIdx = ((TcpConnectionIndexAwareMessage)connIdxMsg).connectionIndex()) == -1 ? this.connPlc.connectionIndex() : msgConnIdx) : this.connPlc.connectionIndex();
            try {
                boolean retry;
                do {
                    client = this.clientPool.reserveClient(node, connIdx);
                    UUID nodeId = null;
                    if (!client.async()) {
                        nodeId = node.id();
                    }
                    retry = client.sendMessage(nodeId, msg, ackC);
                    client.release();
                    if (retry) {
                        this.clientPool.removeNodeClient(node.id(), client);
                        ClusterNode node0 = this.getSpiContext().node(node.id());
                        if (node0 == null) {
                            throw new IgniteCheckedException("Failed to send message to remote node (node has left the grid): " + node.id());
                        }
                    }
                    client = null;
                } while (retry);
            }
            catch (Throwable t) {
                if (this.stopping) {
                    throw new IgniteSpiException("Node is stopping.", t);
                }
                if (!(t instanceof NodeUnreachableException)) {
                    log.error("Failed to send message to remote node [node=" + node + ", msg=" + msg + ']', t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IgniteSpiException("Failed to send message to remote node: " + node, t);
            }
            finally {
                if (client != null && this.clientPool.removeNodeClient(node.id(), client)) {
                    client.forceClose();
                }
            }
        }
    }

    public Collection<InetSocketAddress> nodeAddresses(ClusterNode node, boolean filterReachableAddrs) throws IgniteCheckedException {
        return CommunicationTcpUtils.nodeAddresses(node, filterReachableAddrs, this.attributeNames, () -> this.getSpiContext().localNode());
    }

    protected GridCommunicationClient createTcpClient(ClusterNode node, int connIdx) throws IgniteCheckedException {
        return this.nioSrvWrapper.createTcpClient(node, connIdx, false);
    }

    protected void processSessionCreationError(ClusterNode node, Collection<InetSocketAddress> addrs, IgniteCheckedException errs) throws IgniteCheckedException {
        this.nioSrvWrapper.processSessionCreationError(node, addrs, errs);
    }

    private boolean forceClientToServerConnections(ClusterNode node) {
        Boolean forceClientToSrvConnections = (Boolean)node.attribute(this.createSpiAttributeName(ATTR_FORCE_CLIENT_SERVER_CONNECTIONS));
        return Boolean.TRUE.equals(forceClientToSrvConnections);
    }

    protected void notifyListener(UUID sndId, Message msg, IgniteRunnable msgC) {
        MTC.span().addLog(() -> "Communication listeners notified");
        if (this.lsnr != null) {
            this.lsnr.onMessage(sndId, msg, msgC);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Received communication message without any registered listeners (will ignore, is node stopping?) [senderNodeId=" + sndId + ", msg=" + msg + ']');
        }
    }

    @Deprecated
    public void simulateNodeFailure() {
        if (this.nioSrvWrapper.nio() != null) {
            this.nioSrvWrapper.nio().stop();
        }
        if (this.commWorker != null) {
            U.interrupt(this.commWorker.runner());
        }
        U.join(this.commWorker, this.log);
        this.clientPool.forceClose();
    }

    private void onException(String msg, Exception e) {
        this.getExceptionRegistry().onException(msg, e);
    }

    public String toString() {
        return S.toString(TcpCommunicationSpi.class, this);
    }

    public static void writeMessageType(ByteBuffer buf, short type) {
        buf.put((byte)(type & 0xFF));
        buf.put((byte)(type >> 8 & 0xFF));
    }

    public static short makeMessageType(byte b0, byte b1) {
        return (short)((b1 & 0xFF) << 8 | b0 & 0xFF);
    }

    private static WorkersRegistry getWorkersRegistry(Ignite ignite) {
        return ignite instanceof IgniteEx ? ((IgniteEx)ignite).context().workersRegistry() : null;
    }
}

