/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.jdbc2.JdbcBatchUpdateTask;
import org.apache.ignite.internal.jdbc2.JdbcConnection;
import org.apache.ignite.internal.jdbc2.JdbcQueryMultipleStatementsNotAllowTask;
import org.apache.ignite.internal.jdbc2.JdbcQueryMultipleStatementsTask;
import org.apache.ignite.internal.jdbc2.JdbcQueryMultipleStatementsTaskV3;
import org.apache.ignite.internal.jdbc2.JdbcQueryTask;
import org.apache.ignite.internal.jdbc2.JdbcQueryTaskResult;
import org.apache.ignite.internal.jdbc2.JdbcQueryTaskV3;
import org.apache.ignite.internal.jdbc2.JdbcResultSet;
import org.apache.ignite.internal.jdbc2.JdbcStatementResultInfo;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcStatement
implements Statement {
    private static final int DFLT_FETCH_SIZE = 1024;
    protected final JdbcConnection conn;
    private boolean closed;
    private int maxRows;
    protected ArrayList<Object> args;
    private int fetchSize = 1024;
    private List<String> batch;
    protected List<JdbcResultSet> results;
    protected int curRes = 0;

    JdbcStatement(JdbcConnection conn) {
        assert (conn != null);
        this.conn = conn;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute0(sql, true);
        return this.getResultSet();
    }

    private void executeMultipleStatement(String sql, Boolean isQuery) throws SQLException {
        boolean loc;
        this.ensureNotClosed();
        this.closeResults();
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        IgniteKernal ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        boolean bl = loc = nodeId == null;
        JdbcQueryMultipleStatementsTask qryTask = this.conn.isMultipleStatementsTaskV3Supported() ? new JdbcQueryMultipleStatementsTaskV3(loc ? ignite : null, this.conn.schemaName(), sql, isQuery, loc, this.getArgs(), this.fetchSize, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins(), this.conn.isEnforceJoinOrder(), this.conn.isLazy(), this.conn.isMultipleStatementsAllowed(), this.conn.clientDescriptor()) : (!this.conn.isMultipleStatementsAllowed() && this.conn.isMultipleStatementsTaskV2Supported() ? new JdbcQueryMultipleStatementsNotAllowTask(loc ? ignite : null, this.conn.schemaName(), sql, isQuery, loc, this.getArgs(), this.fetchSize, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins(), this.conn.isEnforceJoinOrder(), this.conn.isLazy()) : new JdbcQueryMultipleStatementsTask(loc ? ignite : null, this.conn.schemaName(), sql, isQuery, loc, this.getArgs(), this.fetchSize, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins(), this.conn.isEnforceJoinOrder(), this.conn.isLazy()));
        try {
            List<JdbcStatementResultInfo> rsInfos = loc ? qryTask.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(qryTask);
            this.results = new ArrayList<JdbcResultSet>(rsInfos.size());
            for (JdbcStatementResultInfo rsInfo : rsInfos) {
                if (rsInfo.isQuery()) {
                    this.results.add(new JdbcResultSet(true, rsInfo.queryId(), this, null, null, null, null, false));
                    continue;
                }
                this.results.add(new JdbcResultSet(this, rsInfo.updateCount()));
            }
        }
        catch (Exception e) {
            throw JdbcUtils.convertToSqlException(e, "Failed to query Ignite.");
        }
    }

    private void executeSingle(String sql, Boolean isQuery) throws SQLException {
        boolean loc;
        this.ensureNotClosed();
        IgniteKernal ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        UUID uuid = UUID.randomUUID();
        boolean bl = loc = nodeId == null;
        if (!this.conn.isDmlSupported()) {
            if (isQuery != null && !isQuery.booleanValue()) {
                throw new SQLException("Failed to query Ignite: DML operations are supported in versions 1.8.0 and newer");
            }
            isQuery = true;
        }
        JdbcQueryTask qryTask = JdbcQueryTaskV3.createTask(loc ? ignite : null, this.conn.cacheName(), this.conn.schemaName(), sql, isQuery, loc, this.getArgs(), this.fetchSize, uuid, this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins(), this.conn.isEnforceJoinOrder(), this.conn.isLazy(), false, this.conn.skipReducerOnUpdate());
        try {
            JdbcQueryTaskResult qryRes = loc ? qryTask.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(qryTask);
            JdbcResultSet rs = new JdbcResultSet(qryRes.isQuery(), uuid, this, qryRes.getTbls(), qryRes.getCols(), qryRes.getTypes(), qryRes.getRows(), qryRes.isFinished());
            rs.setFetchSize(this.fetchSize);
            this.results = Collections.singletonList(rs);
            this.curRes = 0;
        }
        catch (Exception e) {
            throw JdbcUtils.convertToSqlException(e, "Failed to query Ignite.");
        }
    }

    protected void setupQuery(SqlFieldsQuery qry) {
        qry.setPageSize(this.fetchSize);
        qry.setLocal(this.conn.nodeId() == null);
        qry.setCollocated(this.conn.isCollocatedQuery());
        qry.setDistributedJoins(this.conn.isDistributedJoins());
        qry.setEnforceJoinOrder(this.conn.isEnforceJoinOrder());
        qry.setLazy(this.conn.isLazy());
        qry.setSchema(this.conn.schemaName());
    }

    protected void execute0(String sql, Boolean isQuery) throws SQLException {
        if (this.conn.isMultipleStatementsSupported()) {
            this.executeMultipleStatement(sql, isQuery);
        } else {
            this.executeSingle(sql, isQuery);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute0(sql, false);
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.conn.statements.remove(this);
        this.closeInternal();
    }

    void closeInternal() throws SQLException {
        this.closeResults();
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.ensureNotClosed();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Field size limitation is not supported.");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.ensureNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.ensureNotClosed();
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Query timeout is not supported.");
    }

    @Override
    public void setQueryTimeout(int timeout) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Query timeout is not supported.");
    }

    @Override
    public void cancel() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Cancellation is not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.execute0(sql, null);
        return this.results.get(0).isQuery();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        JdbcResultSet rs = this.nextResultSet();
        if (rs == null) {
            return null;
        }
        if (!rs.isQuery()) {
            --this.curRes;
            return null;
        }
        return rs;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        JdbcResultSet rs = this.nextResultSet();
        if (rs == null) {
            return -1;
        }
        if (rs.isQuery()) {
            --this.curRes;
            return -1;
        }
        return (int)rs.updateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.ensureNotClosed();
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize < 0) {
            throw new SQLException("Fetch size must be greater or equal zero.");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.ensureNotClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureNotClosed();
        if (F.isEmpty(sql)) {
            throw new SQLException("SQL query is empty");
        }
        if (this.batch == null) {
            this.batch = new ArrayList<String>();
        }
        this.batch.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureNotClosed();
        this.batch = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureNotClosed();
        List<String> batch = this.batch;
        this.batch = null;
        return this.doBatchUpdate(null, batch, null);
    }

    protected int[] doBatchUpdate(String command, List<String> batch, List<List<Object>> batchArgs) throws SQLException {
        boolean loc;
        this.closeResults();
        if ((F.isEmpty(command) || F.isEmpty(batchArgs)) && F.isEmpty(batch)) {
            throw new SQLException("Batch is empty.");
        }
        IgniteKernal ignite = this.conn.ignite();
        UUID nodeId = this.conn.nodeId();
        boolean bl = loc = nodeId == null;
        if (!this.conn.isDmlSupported()) {
            throw new SQLException("Failed to query Ignite: DML operations are supported in versions 1.8.0 and newer");
        }
        JdbcBatchUpdateTask task = new JdbcBatchUpdateTask(loc ? ignite : null, this.conn.cacheName(), this.conn.schemaName(), command, batch, batchArgs, loc, this.getFetchSize(), this.conn.isLocalQuery(), this.conn.isCollocatedQuery(), this.conn.isDistributedJoins());
        try {
            int[] res = loc ? task.call() : ignite.compute(ignite.cluster().forNodeId(nodeId, new UUID[0])).call(task);
            long updateCnt = F.isEmpty(res) ? -1L : (long)res[res.length - 1];
            this.results = Collections.singletonList(new JdbcResultSet(this, updateCnt));
            this.curRes = 0;
            return res;
        }
        catch (Exception e) {
            throw JdbcUtils.convertToSqlException(e, "Failed to query Ignite.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.ensureNotClosed();
        return this.conn;
    }

    @Override
    public boolean getMoreResults(int curr) throws SQLException {
        this.ensureNotClosed();
        if (this.results != null) {
            assert (this.curRes <= this.results.size()) : "Invalid results state: [resultsCount=" + this.results.size() + ", curRes=" + this.curRes + ']';
            switch (curr) {
                case 1: {
                    if (this.curRes <= 0) break;
                    this.results.get(this.curRes - 1).close();
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.curRes; ++i) {
                        this.results.get(i).close();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new SQLException("Invalid 'current' parameter.");
                }
            }
        }
        return this.results != null && this.curRes < this.results.size();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colIndexes)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colNames)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colIndexes)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        if (!F.isEmpty(colNames)) {
            throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
        }
        return this.execute(sql);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.ensureNotClosed();
        if (poolable) {
            throw new SQLFeatureNotSupportedException("Pooling is not supported.");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Statement is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Statement.class;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("closeOnCompletion is not supported.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    protected final Object[] getArgs() {
        return this.args != null ? this.args.toArray() : null;
    }

    void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    private JdbcResultSet nextResultSet() throws SQLException {
        this.ensureNotClosed();
        if (this.results == null || this.curRes >= this.results.size()) {
            return null;
        }
        return this.results.get(this.curRes++);
    }

    private void closeResults() throws SQLException {
        if (this.results != null) {
            for (JdbcResultSet rs : this.results) {
                rs.close();
            }
            this.results = null;
            this.curRes = 0;
        }
    }
}

