/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.ssl.BlockingSslHandler;
import org.apache.ignite.internal.util.nio.ssl.GridSslMeta;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.HandshakeException;
import org.apache.ignite.spi.communication.tcp.messages.HandshakeMessage;

public class TcpHandshakeExecutor {
    private final IgniteLogger log;
    private final ClusterStateProvider stateProvider;
    private final boolean directBuffer;

    public TcpHandshakeExecutor(IgniteLogger log, ClusterStateProvider stateProvider, boolean directBuffer) {
        this.log = log;
        this.stateProvider = stateProvider;
        this.directBuffer = directBuffer;
    }

    public long tcpHandshake(SocketChannel ch, UUID rmtNodeId, GridSslMeta sslMeta, HandshakeMessage msg) throws IgniteCheckedException, IOException {
        long rcvCnt;
        short msgType;
        int read;
        ByteBuffer buf;
        BlockingSslHandler sslHnd = null;
        if (this.stateProvider.isSslEnabled()) {
            short msgType2;
            assert (sslMeta != null);
            sslHnd = new BlockingSslHandler(sslMeta.sslEngine(), ch, this.directBuffer, ByteOrder.LITTLE_ENDIAN, this.log);
            if (!sslHnd.handshake()) {
                throw new HandshakeException("SSL handshake is not completed.");
            }
            ByteBuffer handBuff = sslHnd.applicationBuffer();
            if (handBuff.remaining() >= 2 && (msgType2 = TcpCommunicationSpi.makeMessageType(handBuff.get(0), handBuff.get(1))) == -28) {
                return -3L;
            }
            if (handBuff.remaining() < 18) {
                buf = ByteBuffer.allocate(1000);
                read = ch.read(buf);
                if (read == -1) {
                    throw new HandshakeException("Failed to read remote node ID (connection closed).");
                }
                buf.flip();
                buf = sslHnd.decode(buf);
                if (handBuff.remaining() >= 2 && (msgType = TcpCommunicationSpi.makeMessageType(handBuff.get(0), handBuff.get(1))) == -28) {
                    return -3L;
                }
            } else {
                buf = handBuff;
            }
        } else {
            buf = ByteBuffer.allocate(18);
            for (int i = 0; i < 18; i += read) {
                read = ch.read(buf);
                if (read == -1) {
                    throw new HandshakeException("Failed to read remote node ID (connection closed).");
                }
                if (read < 2 || (msgType = TcpCommunicationSpi.makeMessageType(buf.get(0), buf.get(1))) != -28) continue;
                return -3L;
            }
        }
        UUID rmtNodeId0 = U.bytesToUuid(buf.array(), 2);
        if (!rmtNodeId.equals(rmtNodeId0)) {
            throw new HandshakeException("Remote node ID is not as expected [expected=" + rmtNodeId + ", rcvd=" + rmtNodeId0 + ']');
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received remote node ID: " + rmtNodeId0);
        }
        if (this.stateProvider.isSslEnabled()) {
            assert (sslHnd != null);
            U.writeFully(ch, sslHnd.encrypt(ByteBuffer.wrap(U.IGNITE_HEADER)));
        } else {
            U.writeFully(ch, ByteBuffer.wrap(U.IGNITE_HEADER));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing handshake message [rmtNode=" + rmtNodeId + ", msg=" + msg + ']');
        }
        buf = ByteBuffer.allocate(msg.getMessageSize());
        buf.order(ByteOrder.LITTLE_ENDIAN);
        boolean written = msg.writeTo(buf, null);
        assert (written);
        buf.flip();
        if (this.stateProvider.isSslEnabled()) {
            assert (sslHnd != null);
            U.writeFully(ch, sslHnd.encrypt(buf));
        } else {
            U.writeFully(ch, buf);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Waiting for handshake [rmtNode=" + rmtNodeId + ']');
        }
        if (this.stateProvider.isSslEnabled()) {
            ByteBuffer inBuf;
            ByteBuffer decode0;
            assert (sslHnd != null);
            buf = ByteBuffer.allocate(1000);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer decode = ByteBuffer.allocate(2 * buf.capacity());
            decode.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < 10; i += decode0.remaining()) {
                int read2 = ch.read(buf);
                if (read2 == -1) {
                    throw new HandshakeException("Failed to read remote node recovery handshake (connection closed).");
                }
                buf.flip();
                decode0 = sslHnd.decode(buf);
                decode = this.appendAndResizeIfNeeded(decode, decode0);
                buf.clear();
            }
            decode.flip();
            rcvCnt = decode.getLong(2);
            if (decode.limit() > 10) {
                decode.position(10);
                sslMeta.decodedBuffer(decode);
            }
            if ((inBuf = sslHnd.inputBuffer()).position() > 0) {
                sslMeta.encodedBuffer(inBuf);
            }
        } else {
            int read3;
            buf = ByteBuffer.allocate(10);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < 10; i += read3) {
                read3 = ch.read(buf);
                if (read3 != -1) continue;
                throw new HandshakeException("Failed to read remote node recovery handshake (connection closed).");
            }
            rcvCnt = buf.getLong(2);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received handshake message [rmtNode=" + rmtNodeId + ", rcvCnt=" + rcvCnt + ']');
        }
        if (rcvCnt == -1L && this.log.isDebugEnabled()) {
            this.log.debug("Connection rejected, will retry client creation [rmtNode=" + rmtNodeId + ']');
        }
        return rcvCnt;
    }

    private ByteBuffer appendAndResizeIfNeeded(ByteBuffer target, ByteBuffer src) {
        if (target.remaining() < src.remaining()) {
            int newSize = Math.max(target.capacity() * 2, target.capacity() + src.remaining());
            ByteBuffer tmp = ByteBuffer.allocate(newSize);
            tmp.order(target.order());
            target.flip();
            tmp.put(target);
            target = tmp;
        }
        target.put(src);
        return target;
    }
}

