/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class QueryTypeDescriptorImpl
implements GridQueryTypeDescriptor {
    private final String cacheName;
    private String name;
    private String schemaName;
    private String tblName;
    @GridToStringInclude
    private final LinkedHashMap<String, Class<?>> fields = new LinkedHashMap();
    @GridToStringExclude
    private final Map<String, GridQueryProperty> props = new HashMap<String, GridQueryProperty>();
    private final Map<String, GridQueryProperty> uppercaseProps = new HashMap<String, GridQueryProperty>();
    private final Object idxMux = new Object();
    @GridToStringInclude
    private final Map<String, QueryIndexDescriptorImpl> idxs = new HashMap<String, QueryIndexDescriptorImpl>();
    private Map<String, String> aliases;
    private QueryIndexDescriptorImpl fullTextIdx;
    private Class<?> keyCls;
    private Class<?> valCls;
    private String keyTypeName;
    private String valTypeName;
    private boolean valTextIdx;
    private int typeId;
    private String affKey;
    private boolean customAffKeyMapper;
    private String keyFieldName;
    private String valFieldName;
    private volatile boolean obsolete;
    private List<GridQueryProperty> validateProps;
    private List<GridQueryProperty> propsWithDefaultValue;
    private final CacheObjectContext coCtx;
    private Set<String> pkFields;

    public QueryTypeDescriptorImpl(String cacheName, CacheObjectContext coCtx) {
        this.cacheName = cacheName;
        this.coCtx = coCtx;
    }

    public String cacheName() {
        return this.cacheName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    public void name(String name) {
        this.name = name;
    }

    @Override
    public String tableName() {
        return this.tblName != null ? this.tblName : this.name;
    }

    public void tableName(String tblName) {
        this.tblName = tblName;
    }

    public LinkedHashMap<String, Class<?>> fields() {
        return this.fields;
    }

    @Override
    public GridQueryProperty property(String name) {
        GridQueryProperty res = this.props.get(name);
        if (res == null) {
            res = this.uppercaseProps.get(name.toUpperCase());
        }
        return res;
    }

    public Map<String, GridQueryProperty> properties() {
        return this.props;
    }

    @Override
    public <T> T value(String field, Object key, Object val) throws IgniteCheckedException {
        assert (field != null);
        GridQueryProperty prop = this.property(field);
        if (prop == null) {
            throw new IgniteCheckedException("Failed to find field '" + field + "' in type '" + this.name + "'.");
        }
        return (T)prop.value(key, val);
    }

    @Override
    public void setValue(String field, Object key, Object val, Object propVal) throws IgniteCheckedException {
        assert (field != null);
        GridQueryProperty prop = this.property(field);
        if (prop == null) {
            throw new IgniteCheckedException("Failed to find field '" + field + "' in type '" + this.name + "'.");
        }
        prop.setValue(key, val, propVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, GridQueryIndexDescriptor> indexes() {
        Object object = this.idxMux;
        synchronized (object) {
            return Collections.unmodifiableMap(this.idxs);
        }
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public boolean matchType(CacheObject val) {
        if (val instanceof BinaryObject) {
            return ((BinaryObject)((Object)val)).type().typeId() == this.typeId;
        }
        return val.value(this.coCtx, false).getClass() == this.valCls;
    }

    public void typeId(int typeId) {
        this.typeId = typeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public QueryIndexDescriptorImpl index(String name) {
        Object object = this.idxMux;
        synchronized (object) {
            return this.idxs.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QueryIndexDescriptorImpl> indexes0() {
        Object object = this.idxMux;
        synchronized (object) {
            return new ArrayList<QueryIndexDescriptorImpl>(this.idxs.values());
        }
    }

    @Override
    public GridQueryIndexDescriptor textIndex() {
        return this.fullTextIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(QueryIndexDescriptorImpl idx) throws IgniteCheckedException {
        Object object = this.idxMux;
        synchronized (object) {
            if (this.idxs.put(idx.name(), idx) != null) {
                throw new IgniteCheckedException("Index with name '" + idx.name() + "' already exists.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropIndex(String idxName) {
        Object object = this.idxMux;
        synchronized (object) {
            this.idxs.remove(idxName);
        }
    }

    public boolean hasField(String field) {
        return this.props.containsKey(field) || "_VAL".equalsIgnoreCase(field);
    }

    public void addFieldToTextIndex(String field) throws IgniteCheckedException {
        if (this.fullTextIdx == null) {
            this.fullTextIdx = new QueryIndexDescriptorImpl(this, null, QueryIndexType.FULLTEXT, 0);
        }
        this.fullTextIdx.addField(field, 0, false);
    }

    @Override
    public Class<?> valueClass() {
        return this.valCls;
    }

    public void valueClass(Class<?> valCls) {
        A.notNull(valCls, "Value class must not be null");
        this.valCls = valCls;
    }

    @Override
    public Class<?> keyClass() {
        return this.keyCls;
    }

    public void keyClass(Class<?> keyCls) {
        this.keyCls = keyCls;
    }

    @Override
    public String keyTypeName() {
        return this.keyTypeName;
    }

    public void keyTypeName(String keyTypeName) {
        this.keyTypeName = keyTypeName;
    }

    @Override
    public String valueTypeName() {
        return this.valTypeName;
    }

    public void valueTypeName(String valTypeName) {
        this.valTypeName = valTypeName;
    }

    public void addProperty(GridQueryProperty prop, boolean failOnDuplicate) throws IgniteCheckedException {
        this.addProperty(prop, failOnDuplicate, true);
    }

    public void addProperty(GridQueryProperty prop, boolean failOnDuplicate, boolean isField) throws IgniteCheckedException {
        String name = prop.name();
        if (this.props.put(name, prop) != null && failOnDuplicate) {
            throw new IgniteCheckedException("Property with name '" + name + "' already exists.");
        }
        if (this.uppercaseProps.put(name.toUpperCase(), prop) != null && failOnDuplicate) {
            throw new IgniteCheckedException("Property with upper cased name '" + name + "' already exists.");
        }
        if (prop.notNull() && !prop.name().equals("_KEY") && !prop.name().equals("_VAL") || prop.precision() != -1 || this.coCtx.kernalContext().config().getSqlConfiguration().isValidationEnabled()) {
            if (this.validateProps == null) {
                this.validateProps = new ArrayList<GridQueryProperty>();
            }
            this.validateProps.add(prop);
        }
        if (prop.defaultValue() != null) {
            if (this.propsWithDefaultValue == null) {
                this.propsWithDefaultValue = new ArrayList<GridQueryProperty>();
            }
            this.propsWithDefaultValue.add(prop);
        }
        if (isField) {
            this.fields.put(name, prop.type());
        }
    }

    public void removeProperty(String name) throws IgniteCheckedException {
        GridQueryProperty prop = this.props.remove(name);
        if (prop == null) {
            throw new IgniteCheckedException("Property with name '" + name + "' does not exist.");
        }
        if (this.validateProps != null) {
            this.validateProps.remove(prop);
        }
        this.uppercaseProps.remove(name.toUpperCase());
        this.fields.remove(name);
    }

    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean valueTextIndex() {
        return this.valTextIdx;
    }

    public void valueTextIndex(boolean valTextIdx) {
        this.valTextIdx = valTextIdx;
    }

    @Override
    public String affinityKey() {
        return this.affKey;
    }

    public void affinityKey(String affKey) {
        this.affKey = affKey;
    }

    @Override
    public boolean customAffinityKeyMapper() {
        return this.customAffKeyMapper;
    }

    public void customAffinityKeyMapper(boolean customAffKeyMapper) {
        this.customAffKeyMapper = customAffKeyMapper;
    }

    public Map<String, String> aliases() {
        return this.aliases != null ? this.aliases : Collections.emptyMap();
    }

    public void aliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public boolean obsolete() {
        return this.obsolete;
    }

    public void markObsolete() {
        this.obsolete = true;
    }

    public String toString() {
        return S.toString(QueryTypeDescriptorImpl.class, this);
    }

    void keyFieldName(String keyFieldName) {
        this.keyFieldName = keyFieldName;
    }

    @Override
    public String keyFieldName() {
        return this.keyFieldName;
    }

    void valueFieldName(String valFieldName) {
        this.valFieldName = valFieldName;
    }

    @Override
    public String valueFieldName() {
        return this.valFieldName;
    }

    @Override
    @Nullable
    public String keyFieldAlias() {
        return this.keyFieldName != null ? this.aliases.get(this.keyFieldName) : null;
    }

    @Override
    @Nullable
    public String valueFieldAlias() {
        return this.valFieldName != null ? this.aliases.get(this.valFieldName) : null;
    }

    @Override
    public void validateKeyAndValue(Object key, Object val) throws IgniteCheckedException {
        if (F.isEmpty(this.validateProps) && F.isEmpty(this.idxs)) {
            return;
        }
        this.validateProps(key, val);
        this.validateIndexes(key, val);
    }

    private void validateProps(Object key, Object val) throws IgniteCheckedException {
        if (F.isEmpty(this.validateProps)) {
            return;
        }
        boolean validateTypes = this.coCtx.kernalContext().config().getSqlConfiguration().isValidationEnabled();
        for (int i = 0; i < this.validateProps.size(); ++i) {
            Object propVal;
            GridQueryProperty prop = this.validateProps.get(i);
            boolean isKey = false;
            if (F.eq(prop.name(), this.keyFieldAlias()) || this.keyFieldName == null && F.eq(prop.name(), "_KEY")) {
                propVal = key instanceof KeyCacheObject ? ((CacheObject)key).value(this.coCtx, true) : key;
                isKey = true;
            } else {
                propVal = F.eq(prop.name(), this.valueFieldAlias()) || this.valFieldName == null && F.eq(prop.name(), "_VAL") ? (val instanceof CacheObject ? ((CacheObject)val).value(this.coCtx, true) : val) : prop.value(key, val);
            }
            if (propVal == null && prop.notNull()) {
                throw new IgniteSQLException("Null value is not allowed for column '" + prop.name() + "'", isKey ? 4003 : 4004);
            }
            if (validateTypes && propVal != null) {
                if (!(propVal instanceof BinaryObject)) {
                    if (!(U.box(prop.type()).isAssignableFrom(U.box(propVal.getClass())) || prop.type().isArray() && Object[].class == propVal.getClass() && Arrays.stream((Object[])propVal).noneMatch(x -> x != null && !U.box(prop.type().getComponentType()).isAssignableFrom(U.box(x.getClass()))))) {
                        throw new IgniteSQLException("Type for a column '" + prop.name() + "' is not compatible with table definition. Expected '" + prop.type().getSimpleName() + "', actual type '" + propVal.getClass().getSimpleName() + "'");
                    }
                } else if (this.coCtx.kernalContext().cacheObjects().typeId(prop.type().getName()) != ((BinaryObject)propVal).type().typeId()) {
                    throw new IgniteSQLException("Type for a column '" + prop.name() + "' is not compatible with table definition. Expected '" + prop.type().getSimpleName() + "', actual type '" + ((BinaryObject)propVal).type().typeName() + "'");
                }
            }
            if (propVal == null || prop.precision() == -1) continue;
            if (String.class == propVal.getClass() && ((String)propVal).length() > prop.precision()) {
                throw new IgniteSQLException("Value for a column '" + prop.name() + "' is too long. Maximum length: " + prop.precision() + ", actual length: " + ((CharSequence)propVal).length(), isKey ? 4007 : 4008);
            }
            if (BigDecimal.class != propVal.getClass()) continue;
            BigDecimal dec = (BigDecimal)propVal;
            if (dec.precision() > prop.precision()) {
                throw new IgniteSQLException("Value for a column '" + prop.name() + "' is out of range. Maximum precision: " + prop.precision() + ", actual precision: " + dec.precision(), isKey ? 4007 : 4008);
            }
            if (prop.scale() == -1 || dec.scale() <= prop.scale()) continue;
            throw new IgniteSQLException("Value for a column '" + prop.name() + "' is out of range. Maximum scale : " + prop.scale() + ", actual scale: " + dec.scale(), isKey ? 4010 : 4009);
        }
    }

    private void validateIndexes(Object key, Object val) throws IgniteCheckedException {
        if (F.isEmpty(this.idxs)) {
            return;
        }
        for (QueryIndexDescriptorImpl idx : this.idxs.values()) {
            for (String idxField : idx.fields()) {
                Class<?> propType;
                Object propVal;
                GridQueryProperty prop = this.props.get(idxField);
                if (F.eq(idxField, this.keyFieldAlias()) || F.eq(idxField, "_KEY")) {
                    propVal = key instanceof KeyCacheObject ? ((CacheObject)key).value(this.coCtx, true) : key;
                    propType = propVal == null ? null : propVal.getClass();
                } else if (F.eq(idxField, this.valueFieldAlias()) || F.eq(idxField, "_VAL")) {
                    propVal = val instanceof CacheObject ? ((CacheObject)val).value(this.coCtx, true) : val;
                    propType = propVal == null ? null : propVal.getClass();
                } else {
                    propVal = prop.value(key, val);
                    propType = prop.type();
                }
                if (propVal == null) continue;
                if (!(propVal instanceof BinaryObject)) {
                    if (U.box(propType).isAssignableFrom(U.box(propVal.getClass())) || propType.isArray() && Object[].class == propVal.getClass() && Arrays.stream((Object[])propVal).noneMatch(x -> x != null && !U.box(propType.getComponentType()).isAssignableFrom(U.box(x.getClass())))) continue;
                    throw new IgniteSQLException("Type for a column '" + idxField + "' is not compatible with index definition. Expected '" + propType.getSimpleName() + "', actual type '" + propVal.getClass().getSimpleName() + "'");
                }
                if (this.coCtx.kernalContext().cacheObjects().typeId(propType.getName()) == ((BinaryObject)propVal).type().typeId()) continue;
                throw new IgniteSQLException("Type for a column '" + idxField + "' is not compatible with index definition. Expected '" + propType.getSimpleName() + "', actual type '" + ((BinaryObject)propVal).type().typeName() + "'");
            }
        }
    }

    @Override
    public void setDefaults(Object key, Object val) throws IgniteCheckedException {
        if (F.isEmpty(this.propsWithDefaultValue)) {
            return;
        }
        for (int i = 0; i < this.propsWithDefaultValue.size(); ++i) {
            GridQueryProperty prop = this.propsWithDefaultValue.get(i);
            prop.setValue(key, val, prop.defaultValue());
        }
    }

    @Override
    public Set<String> primaryKeyFields() {
        return this.pkFields == null ? Collections.emptySet() : this.pkFields;
    }

    @Override
    public void primaryKeyFields(Set<String> keys) {
        this.pkFields = keys;
    }
}

