/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.LightweightCheckpointManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.DefragmentationFileUtils;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.DefragmentationPageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.LinkMap;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.TreeIterator;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FileVersionCheckingFactory;
import org.apache.ignite.internal.processors.cache.persistence.freelist.AbstractFreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.SimpleDataRow;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIOV3;
import org.apache.ignite.internal.processors.cache.tree.AbstractDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.collection.IntRWHashMap;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.Nullable;

public class CachePartitionDefragmentationManager {
    public static final String DEFRAGMENTATION_MNTC_TASK_NAME = "defragmentationMaintenanceTask";
    private final Set<String> cachesForDefragmentation;
    private final Set<CacheGroupContext> cacheGrpCtxsForDefragmentation = new TreeSet<CacheGroupContext>(Comparator.comparing(CacheGroupContext::cacheOrGroupName));
    private final GridCacheSharedContext<?, ?> sharedCtx;
    private final MaintenanceRegistry mntcReg;
    private final IgniteLogger log;
    private final GridCacheDatabaseSharedManager dbMgr;
    private final FilePageStoreManager filePageStoreMgr;
    private final LightweightCheckpointManager defragmentationCheckpoint;
    private final CheckpointManager nodeCheckpoint;
    private final int pageSize;
    private final DataRegion partDataRegion;
    private final DataRegion mappingDataRegion;
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final Status status = new Status();
    private final GridFutureAdapter<?> completionFut = new GridFutureAdapter();
    @Nullable
    private volatile IgniteThreadPoolExecutor defragmentationThreadPool;

    public CachePartitionDefragmentationManager(List<String> cacheNames, GridCacheSharedContext<?, ?> sharedCtx, GridCacheDatabaseSharedManager dbMgr, FilePageStoreManager filePageStoreMgr, CheckpointManager nodeCheckpoint, LightweightCheckpointManager defragmentationCheckpoint, int pageSize, int defragmentationThreadPoolSize) throws IgniteCheckedException {
        this.cachesForDefragmentation = new HashSet<String>(cacheNames);
        this.dbMgr = dbMgr;
        this.filePageStoreMgr = filePageStoreMgr;
        this.pageSize = pageSize;
        this.sharedCtx = sharedCtx;
        this.mntcReg = sharedCtx.kernalContext().maintenanceRegistry();
        this.log = sharedCtx.logger(this.getClass());
        this.defragmentationCheckpoint = defragmentationCheckpoint;
        this.nodeCheckpoint = nodeCheckpoint;
        this.partDataRegion = dbMgr.dataRegion("defragPartitionsDataRegion");
        this.mappingDataRegion = dbMgr.dataRegion("defragMappingDataRegion");
        this.defragmentationThreadPool = new IgniteThreadPoolExecutor("defragmentation-worker", sharedCtx.igniteInstanceName(), defragmentationThreadPoolSize, defragmentationThreadPoolSize, 30000L, new LinkedBlockingQueue<Runnable>());
    }

    public void beforeDefragmentation() throws IgniteCheckedException {
        this.dbMgr.resumeWalLogging();
        this.dbMgr.onStateRestored(null);
        this.nodeCheckpoint.forceCheckpoint("beforeDefragmentation", null).futureFor(CheckpointState.FINISHED).get();
        this.dbMgr.preserveWalTailPointer();
        this.sharedCtx.wal().onDeActivate(this.sharedCtx.kernalContext());
        for (CacheGroupContext oldGrpCtx : this.sharedCtx.cache().cacheGroups()) {
            if (!oldGrpCtx.userCache() || this.cacheGrpCtxsForDefragmentation.contains(oldGrpCtx) || !this.cachesForDefragmentation.isEmpty() && oldGrpCtx.caches().stream().noneMatch(cctx -> this.cachesForDefragmentation.contains(cctx.name()))) continue;
            this.cacheGrpCtxsForDefragmentation.add(oldGrpCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDefragmentation() throws IgniteCheckedException {
        HashMap oldStores = new HashMap();
        for (CacheGroupContext oldGrpCtx : this.cacheGrpCtxsForDefragmentation) {
            int grpId = oldGrpCtx.groupId();
            IgniteCacheOffheapManager offheap = oldGrpCtx.offheap();
            List oldCacheDataStores = StreamSupport.stream(offheap.cacheDataStores().spliterator(), false).filter(store -> {
                try {
                    return this.filePageStoreMgr.exists(grpId, store.partId());
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }).collect(Collectors.toList());
            oldStores.put(grpId, oldCacheDataStores);
        }
        int partitionCount = oldStores.values().stream().mapToInt(List::size).sum();
        this.status.onStart(this.cacheGrpCtxsForDefragmentation, partitionCount);
        try {
            IgniteInternalFuture<Object> idxDfrgFut = null;
            DataPageEvictionMode prevPageEvictionMode = null;
            for (CacheGroupContext oldGrpCtx : this.cacheGrpCtxsForDefragmentation) {
                int grpId = oldGrpCtx.groupId();
                File workDir = this.filePageStoreMgr.cacheWorkDir(oldGrpCtx.sharedGroup(), oldGrpCtx.cacheOrGroupName());
                List oldCacheDataStores = (List)oldStores.get(grpId);
                if (DefragmentationFileUtils.skipAlreadyDefragmentedCacheGroup(workDir, grpId, this.log)) {
                    this.status.onCacheGroupSkipped(oldGrpCtx, oldCacheDataStores.size());
                    continue;
                }
                try {
                    GridCacheOffheapManager offheap = (GridCacheOffheapManager)oldGrpCtx.offheap();
                    this.status.onCacheGroupStart(oldGrpCtx, oldCacheDataStores.size());
                    if (workDir == null || oldCacheDataStores.isEmpty()) {
                        this.status.onCacheGroupFinish(oldGrpCtx);
                        continue;
                    }
                    DataPageEvictionMode curPageEvictionMode = oldGrpCtx.dataRegion().config().getPageEvictionMode();
                    if (prevPageEvictionMode == null || prevPageEvictionMode != curPageEvictionMode) {
                        prevPageEvictionMode = curPageEvictionMode;
                        this.partDataRegion.config().setPageEvictionMode(curPageEvictionMode);
                        if (idxDfrgFut != null) {
                            idxDfrgFut.get();
                        }
                    }
                    IntHashMap<IgniteCacheOffheapManager.CacheDataStore> cacheDataStores = new IntHashMap<IgniteCacheOffheapManager.CacheDataStore>();
                    for (IgniteCacheOffheapManager.CacheDataStore store2 : offheap.cacheDataStores()) {
                        assert (store2.tree() == null || store2.tree().groupId() == grpId);
                        if (store2.tree() == null) continue;
                        cacheDataStores.put(store2.partId(), store2);
                    }
                    this.dbMgr.checkpointedDataRegions().remove(oldGrpCtx.dataRegion());
                    oldGrpCtx.caches().stream().filter(cacheCtx -> cacheCtx.groupId() == grpId).forEach(cacheCtx -> cacheCtx.ttl().unregister());
                    oldGrpCtx.localWalEnabled(false, false);
                    boolean encrypted = oldGrpCtx.config().isEncryptionEnabled();
                    FileVersionCheckingFactory pageStoreFactory = this.filePageStoreMgr.getPageStoreFactory(grpId, encrypted);
                    GridAtomicLong idxAllocationTracker = new GridAtomicLong();
                    this.createIndexPageStore(grpId, workDir, pageStoreFactory, this.partDataRegion, idxAllocationTracker::addAndGet);
                    this.checkCancellation();
                    GridCompoundFuture cmpFut = new GridCompoundFuture();
                    PageMemoryEx oldPageMem = (PageMemoryEx)oldGrpCtx.dataRegion().pageMemory();
                    CacheGroupContext newGrpCtx = new CacheGroupContext(this.sharedCtx, grpId, oldGrpCtx.receivedFrom(), CacheType.USER, oldGrpCtx.config(), oldGrpCtx.affinityNode(), this.partDataRegion, oldGrpCtx.cacheObjectContext(), null, null, oldGrpCtx.localStartVersion(), true, false, true);
                    this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
                    try {
                        newGrpCtx.start();
                    }
                    finally {
                        this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
                    }
                    IntRWHashMap<LinkMap> linkMapByPart = new IntRWHashMap<LinkMap>();
                    IgniteUtils.doInParallel(this.defragmentationThreadPool, oldCacheDataStores, oldCacheDataStore -> this.defragmentOnePartition(oldGrpCtx, grpId, workDir, offheap, pageStoreFactory, cmpFut, oldPageMem, newGrpCtx, (IntMap<LinkMap>)linkMapByPart, (IgniteCacheOffheapManager.CacheDataStore)oldCacheDataStore));
                    cmpFut.markInitialized().get();
                    idxDfrgFut = new GridFinishedFuture<Object>();
                    if (this.filePageStoreMgr.hasIndexStore(grpId)) {
                        this.defragmentIndexPartition(oldGrpCtx, newGrpCtx, linkMapByPart);
                        idxDfrgFut = this.defragmentationCheckpoint.forceCheckpoint("index defragmented", null).futureFor(CheckpointState.FINISHED);
                    }
                    PageStore oldIdxPageStore = this.filePageStoreMgr.getStore(grpId, 65535);
                    idxDfrgFut = idxDfrgFut.chain(fut -> {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(S.toString("Index partition defragmented", "grpId", (Object)grpId, false, "oldPages", (Object)oldIdxPageStore.pages(), false, "newPages", (Object)(idxAllocationTracker.get() + 1L), false, "pageSize", (Object)this.pageSize, false, "partFile", (Object)DefragmentationFileUtils.defragmentedIndexFile(workDir).getName(), false, "workDir", (Object)workDir, false));
                        }
                        oldPageMem.invalidate(grpId, 65535);
                        PageMemoryEx partPageMem = (PageMemoryEx)this.partDataRegion.pageMemory();
                        partPageMem.invalidate(grpId, 65535);
                        DefragmentationPageReadWriteManager pageMgr = (DefragmentationPageReadWriteManager)partPageMem.pageManager();
                        pageMgr.pageStoreMap().removePageStore(grpId, 65535);
                        PageMemoryEx mappingPageMem = (PageMemoryEx)this.mappingDataRegion.pageMemory();
                        pageMgr = (DefragmentationPageReadWriteManager)mappingPageMem.pageManager();
                        pageMgr.pageStoreMap().clear(grpId);
                        DefragmentationFileUtils.renameTempIndexFile(workDir);
                        DefragmentationFileUtils.writeDefragmentationCompletionMarker(this.filePageStoreMgr.getPageStoreFileIoFactory(), workDir, this.log);
                        DefragmentationFileUtils.batchRenameDefragmentedCacheGroupPartitions(workDir, this.log);
                        return null;
                    });
                    this.status.onIndexDefragmented(oldGrpCtx, oldIdxPageStore.size(), (long)this.pageSize + idxAllocationTracker.get() * (long)this.pageSize);
                }
                catch (DefragmentationCancelledException e) {
                    DefragmentationFileUtils.deleteLeftovers(workDir);
                    throw e;
                }
                this.status.onCacheGroupFinish(oldGrpCtx);
            }
            if (idxDfrgFut != null) {
                idxDfrgFut.get();
            }
            this.mntcReg.unregisterMaintenanceTask(DEFRAGMENTATION_MNTC_TASK_NAME);
            this.status.onFinish();
            this.completionFut.onDone();
        }
        catch (DefragmentationCancelledException e) {
            this.mntcReg.unregisterMaintenanceTask(DEFRAGMENTATION_MNTC_TASK_NAME);
            this.log.info("Defragmentation process has been cancelled.");
            this.status.onFinish();
            this.completionFut.onDone();
        }
        catch (Throwable t) {
            this.log.error("Defragmentation process failed.", t);
            this.status.onFinish();
            this.completionFut.onDone(t);
            throw t;
        }
        finally {
            this.defragmentationCheckpoint.stop(true);
        }
    }

    private boolean defragmentOnePartition(CacheGroupContext oldGrpCtx, int grpId, File workDir, GridCacheOffheapManager offheap, FileVersionCheckingFactory pageStoreFactory, GridCompoundFuture<Object, Object> cmpFut, PageMemoryEx oldPageMem, CacheGroupContext newGrpCtx, IntMap<LinkMap> linkMapByPart, IgniteCacheOffheapManager.CacheDataStore oldCacheDataStore) throws IgniteCheckedException {
        TreeIterator treeIter = new TreeIterator(this.pageSize);
        this.checkCancellation();
        int partId = oldCacheDataStore.partId();
        PartitionContext partCtx = new PartitionContext(workDir, grpId, partId, this.partDataRegion, this.mappingDataRegion, oldGrpCtx, newGrpCtx, oldCacheDataStore, pageStoreFactory);
        if (DefragmentationFileUtils.skipAlreadyDefragmentedPartition(workDir, grpId, partId, this.log)) {
            partCtx.createPageStore(() -> DefragmentationFileUtils.defragmentedPartMappingFile(workDir, partId).toPath(), partCtx.mappingPagesAllocated, partCtx.mappingPageMemory);
            linkMapByPart.put(partId, partCtx.createLinkMapTree(false));
            return false;
        }
        partCtx.createPageStore(() -> DefragmentationFileUtils.defragmentedPartMappingFile(workDir, partId).toPath(), partCtx.mappingPagesAllocated, partCtx.mappingPageMemory);
        linkMapByPart.put(partId, partCtx.createLinkMapTree(true));
        this.checkCancellation();
        partCtx.createPageStore(() -> DefragmentationFileUtils.defragmentedPartTmpFile(workDir, partId).toPath(), partCtx.partPagesAllocated, partCtx.partPageMemory);
        partCtx.createNewCacheDataStore(offheap);
        this.copyPartitionData(partCtx, treeIter);
        DefragmentationPageReadWriteManager pageMgr = (DefragmentationPageReadWriteManager)partCtx.partPageMemory.pageManager();
        PageStore oldPageStore = this.filePageStoreMgr.getStore(grpId, partId);
        this.status.onPartitionDefragmented(oldGrpCtx, oldPageStore.size(), (long)this.pageSize + partCtx.partPagesAllocated.get() * (long)this.pageSize);
        IgniteInClosure<IgniteInternalFuture> cpLsnr = fut -> {
            if (fut.error() == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(S.toString("Partition defragmented", "grpId", grpId, false, "partId", partId, false, "oldPages", oldPageStore.pages(), false, "newPages", partCtx.partPagesAllocated.get() + 1L, false, "mappingPages", partCtx.mappingPagesAllocated.get() + 1L, false, "pageSize", this.pageSize, false, "partFile", DefragmentationFileUtils.defragmentedPartFile(workDir, partId).getName(), false, "workDir", workDir, false));
                }
                oldPageMem.invalidate(grpId, partId);
                partCtx.partPageMemory.invalidate(grpId, partId);
                pageMgr.pageStoreMap().removePageStore(grpId, partId);
                DefragmentationFileUtils.renameTempPartitionFile(workDir, partId);
            }
        };
        GridFutureAdapter cpFut = this.defragmentationCheckpoint.forceCheckpoint("partition defragmented", null).futureFor(CheckpointState.FINISHED);
        cpFut.listen(cpLsnr);
        cmpFut.add(cpFut);
        return true;
    }

    public IgniteInternalFuture<?> completionFuture() {
        return this.completionFut.chain(future -> null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndexPageStore(int grpId, File workDir, FileVersionCheckingFactory pageStoreFactory, DataRegion partRegion, LongConsumer allocatedTracker) throws IgniteCheckedException {
        PageStore idxPageStore;
        U.delete(DefragmentationFileUtils.defragmentedIndexTmpFile(workDir));
        this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
        try {
            idxPageStore = pageStoreFactory.createPageStore((byte)2, () -> DefragmentationFileUtils.defragmentedIndexTmpFile(workDir).toPath(), allocatedTracker);
        }
        finally {
            this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
        }
        idxPageStore.sync();
        PageMemoryEx partPageMem = (PageMemoryEx)partRegion.pageMemory();
        DefragmentationPageReadWriteManager partMgr = (DefragmentationPageReadWriteManager)partPageMem.pageManager();
        partMgr.pageStoreMap().addPageStore(grpId, 65535, idxPageStore);
    }

    public boolean cancel() {
        if (this.completionFut.isDone()) {
            return false;
        }
        if (this.cancel.compareAndSet(false, true)) {
            try {
                this.completionFut.get();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void checkCancellation() throws DefragmentationCancelledException {
        if (this.cancel.get()) {
            throw new DefragmentationCancelledException();
        }
    }

    public Status status() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartitionData(PartitionContext partCtx, TreeIterator treeIter) throws IgniteCheckedException {
        CacheDataTree tree = partCtx.oldCacheDataStore.tree();
        CacheDataTree newTree = partCtx.newCacheDataStore.tree();
        newTree.enableSequentialWriteMode();
        PendingEntriesTree newPendingTree = partCtx.newCacheDataStore.pendingTree();
        AbstractFreeList<CacheDataRow> freeList = partCtx.newCacheDataStore.getCacheStoreFreeList();
        long cpLockThreshold = 150L;
        this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
        try {
            AtomicLong lastCpLockTs = new AtomicLong(System.currentTimeMillis());
            AtomicInteger entriesProcessed = new AtomicInteger();
            treeIter.iterate(tree, partCtx.cachePageMemory, (tree0, io, pageAddr, idx) -> {
                this.checkCancellation();
                if (System.currentTimeMillis() - lastCpLockTs.get() >= cpLockThreshold) {
                    this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
                    this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
                    lastCpLockTs.set(System.currentTimeMillis());
                }
                AbstractDataLeafIO leafIo = (AbstractDataLeafIO)io;
                CacheDataRow row = (CacheDataRow)tree.getRow(io, pageAddr, idx);
                int cacheId = row.cacheId();
                row.link(0L);
                if (row instanceof DataRow && !partCtx.oldGrpCtx.storeCacheIdInDataPage()) {
                    ((DataRow)row).cacheId(0);
                }
                freeList.insertDataRow(row, IoStatisticsHolderNoOp.INSTANCE);
                if (row instanceof DataRow) {
                    ((DataRow)row).cacheId(cacheId);
                }
                newTree.putx(row);
                long newLink = row.link();
                partCtx.linkMap.put(leafIo.getLink(pageAddr, idx), newLink);
                if (row.expireTime() != 0L) {
                    newPendingTree.putx(new PendingRow(cacheId, row.expireTime(), newLink));
                }
                entriesProcessed.incrementAndGet();
                return true;
            });
            this.checkCancellation();
            this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
            this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
            freeList.saveMetadata(IoStatisticsHolderNoOp.INSTANCE);
            this.copyCacheMetadata(partCtx);
        }
        finally {
            this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCacheMetadata(PartitionContext partCtx) throws IgniteCheckedException {
        long partMetaPageId = partCtx.cachePageMemory.partitionMetaPageId(partCtx.grpId, partCtx.partId);
        long oldPartMetaPage = partCtx.cachePageMemory.acquirePage(partCtx.grpId, partMetaPageId);
        try {
            long oldPartMetaPageAddr = partCtx.cachePageMemory.readLock(partCtx.grpId, partMetaPageId, oldPartMetaPage);
            try {
                PagePartitionMetaIO oldPartMetaIo = (PagePartitionMetaIO)PageIO.getPageIO(oldPartMetaPageAddr);
                assert (Arrays.asList(1, 2, 3).contains(oldPartMetaIo.getVersion())) : "IO version " + oldPartMetaIo.getVersion() + " is not supported by current defragmentation algorithm. Please implement copying of all data added in new version.";
                long newPartMetaPage = partCtx.partPageMemory.acquirePage(partCtx.grpId, partMetaPageId);
                try {
                    long newPartMetaPageAddr = partCtx.partPageMemory.writeLock(partCtx.grpId, partMetaPageId, newPartMetaPage);
                    try {
                        long oldGapsLink;
                        PagePartitionMetaIOV3 newPartMetaIo = (PagePartitionMetaIOV3)PageIO.getPageIO(newPartMetaPageAddr);
                        byte partState = oldPartMetaIo.getPartitionState(oldPartMetaPageAddr);
                        newPartMetaIo.setPartitionState(newPartMetaPageAddr, partState);
                        long size = oldPartMetaIo.getSize(oldPartMetaPageAddr);
                        newPartMetaIo.setSize(newPartMetaPageAddr, size);
                        long updateCntr = oldPartMetaIo.getUpdateCounter(oldPartMetaPageAddr);
                        newPartMetaIo.setUpdateCounter(newPartMetaPageAddr, updateCntr);
                        long rmvId = oldPartMetaIo.getGlobalRemoveId(oldPartMetaPageAddr);
                        newPartMetaIo.setGlobalRemoveId(newPartMetaPageAddr, rmvId);
                        long oldCountersPageId = oldPartMetaIo.getCountersPageId(oldPartMetaPageAddr);
                        if (oldCountersPageId != 0L) {
                            Map<Integer, Long> sizes = GridCacheOffheapManager.readSharedGroupCacheSizes(partCtx.cachePageMemory, partCtx.grpId, oldCountersPageId);
                            long newCountersPageId = GridCacheOffheapManager.writeSharedGroupCacheSizes(partCtx.partPageMemory, partCtx.grpId, 0L, partCtx.partId, sizes);
                            newPartMetaIo.setCountersPageId(newPartMetaPageAddr, newCountersPageId);
                        }
                        if ((oldGapsLink = oldPartMetaIo.getGapsLink(oldPartMetaPageAddr)) != 0L) {
                            byte[] gapsBytes = partCtx.oldCacheDataStore.partStorage().readRow(oldGapsLink);
                            SimpleDataRow gapsDataRow = new SimpleDataRow(partCtx.partId, gapsBytes);
                            partCtx.newCacheDataStore.partStorage().insertDataRow(gapsDataRow, IoStatisticsHolderNoOp.INSTANCE);
                            newPartMetaIo.setGapsLink(newPartMetaPageAddr, gapsDataRow.link());
                        }
                        newPartMetaIo.setEncryptedPageCount(newPartMetaPageAddr, 0);
                        newPartMetaIo.setEncryptedPageIndex(newPartMetaPageAddr, 0);
                    }
                    finally {
                        partCtx.partPageMemory.writeUnlock(partCtx.grpId, partMetaPageId, newPartMetaPage, null, true);
                    }
                }
                finally {
                    partCtx.partPageMemory.releasePage(partCtx.grpId, partMetaPageId, newPartMetaPage);
                }
            }
            finally {
                partCtx.cachePageMemory.readUnlock(partCtx.grpId, partMetaPageId, oldPartMetaPage);
            }
        }
        finally {
            partCtx.cachePageMemory.releasePage(partCtx.grpId, partMetaPageId, oldPartMetaPage);
        }
    }

    private void defragmentIndexPartition(CacheGroupContext grpCtx, CacheGroupContext newCtx, IntMap<LinkMap> mappingByPartition) throws IgniteCheckedException {
        GridQueryProcessor query = grpCtx.caches().get(0).kernalContext().query();
        if (!query.moduleEnabled()) {
            return;
        }
        IndexProcessor idx = grpCtx.caches().get(0).kernalContext().indexProcessor();
        CheckpointTimeoutLock cpLock = this.defragmentationCheckpoint.checkpointTimeoutLock();
        Runnable cancellationChecker = this::checkCancellation;
        idx.defragment(grpCtx, newCtx, (PageMemoryEx)this.partDataRegion.pageMemory(), mappingByPartition, cpLock, cancellationChecker, this.defragmentationThreadPool);
    }

    static class DefragmentationCacheGroupProgress {
        private final int partsTotal;
        private int partsCompleted;
        private long oldSize;
        private long newSize;
        private final long startTs;
        private long finishTs;

        public DefragmentationCacheGroupProgress(int parts) {
            this.partsTotal = parts;
            this.startTs = System.currentTimeMillis();
        }

        public void onPartitionDefragmented(long oldSize, long newSize) {
            ++this.partsCompleted;
            this.oldSize += oldSize;
            this.newSize += newSize;
        }

        public void onIndexDefragmented(long oldSize, long newSize) {
            this.oldSize += oldSize;
            this.newSize += newSize;
        }

        public long getOldSize() {
            return this.oldSize;
        }

        public long getNewSize() {
            return this.newSize;
        }

        public long getStartTs() {
            return this.startTs;
        }

        public long getFinishTs() {
            return this.finishTs;
        }

        public int getPartsTotal() {
            return this.partsTotal;
        }

        public int getPartsCompleted() {
            return this.partsCompleted;
        }

        public void onFinish() {
            this.finishTs = System.currentTimeMillis();
        }
    }

    class Status {
        private long startTs;
        private long finishTs;
        private int totalPartitionCount;
        private int defragmentedPartitionCount;
        private final Set<String> scheduledGroups;
        private final Map<CacheGroupContext, DefragmentationCacheGroupProgress> progressGroups;
        private final Map<CacheGroupContext, DefragmentationCacheGroupProgress> finishedGroups;
        private final Set<String> skippedGroups;

        public Status() {
            this.scheduledGroups = new TreeSet<String>();
            this.progressGroups = new TreeMap<CacheGroupContext, DefragmentationCacheGroupProgress>(Comparator.comparing(CacheGroupContext::cacheOrGroupName));
            this.finishedGroups = new TreeMap<CacheGroupContext, DefragmentationCacheGroupProgress>(Comparator.comparing(CacheGroupContext::cacheOrGroupName));
            this.skippedGroups = new TreeSet<String>();
        }

        public Status(long startTs, long finishTs, Set<String> scheduledGroups, Map<CacheGroupContext, DefragmentationCacheGroupProgress> progressGroups, Map<CacheGroupContext, DefragmentationCacheGroupProgress> finishedGroups, Set<String> skippedGroups) {
            this.startTs = startTs;
            this.finishTs = finishTs;
            this.scheduledGroups = scheduledGroups;
            this.progressGroups = progressGroups;
            this.finishedGroups = finishedGroups;
            this.skippedGroups = skippedGroups;
        }

        public synchronized void onStart(Set<CacheGroupContext> scheduledGroups, int partitions) {
            this.startTs = System.currentTimeMillis();
            this.totalPartitionCount = partitions;
            for (CacheGroupContext grp : scheduledGroups) {
                this.scheduledGroups.add(grp.cacheOrGroupName());
            }
            CachePartitionDefragmentationManager.this.log.info("Defragmentation started.");
        }

        private synchronized void onCacheGroupStart(CacheGroupContext grpCtx, int parts) {
            this.scheduledGroups.remove(grpCtx.cacheOrGroupName());
            this.progressGroups.put(grpCtx, new DefragmentationCacheGroupProgress(parts));
        }

        private synchronized void onPartitionDefragmented(CacheGroupContext grpCtx, long oldSize, long newSize) {
            this.progressGroups.get(grpCtx).onPartitionDefragmented(oldSize, newSize);
            ++this.defragmentedPartitionCount;
        }

        private synchronized void onIndexDefragmented(CacheGroupContext grpCtx, long oldSize, long newSize) {
            this.progressGroups.get(grpCtx).onIndexDefragmented(oldSize, newSize);
        }

        private synchronized void onCacheGroupFinish(CacheGroupContext grpCtx) {
            DefragmentationCacheGroupProgress progress = this.progressGroups.remove(grpCtx);
            progress.onFinish();
            this.finishedGroups.put(grpCtx, progress);
        }

        private synchronized void onCacheGroupSkipped(CacheGroupContext grpCtx, int partitions) {
            this.scheduledGroups.remove(grpCtx.cacheOrGroupName());
            this.skippedGroups.add(grpCtx.cacheOrGroupName());
            this.defragmentedPartitionCount += partitions;
        }

        private synchronized void onFinish() {
            this.finishTs = System.currentTimeMillis();
            this.progressGroups.clear();
            this.scheduledGroups.clear();
            CachePartitionDefragmentationManager.this.log.info("Defragmentation process completed. Time: " + (double)(this.finishTs - this.startTs) * 0.001 + "s.");
        }

        private synchronized Status copy() {
            return new Status(this.startTs, this.finishTs, new HashSet<String>(this.scheduledGroups), new HashMap<CacheGroupContext, DefragmentationCacheGroupProgress>(this.progressGroups), new HashMap<CacheGroupContext, DefragmentationCacheGroupProgress>(this.finishedGroups), new HashSet<String>(this.skippedGroups));
        }

        public long getStartTs() {
            return this.startTs;
        }

        public long getFinishTs() {
            return this.finishTs;
        }

        public Set<String> getScheduledGroups() {
            return this.scheduledGroups;
        }

        public Map<CacheGroupContext, DefragmentationCacheGroupProgress> getProgressGroups() {
            return this.progressGroups;
        }

        public Map<CacheGroupContext, DefragmentationCacheGroupProgress> getFinishedGroups() {
            return this.finishedGroups;
        }

        public Set<String> getSkippedGroups() {
            return this.skippedGroups;
        }

        public int getTotalPartitionCount() {
            return this.totalPartitionCount;
        }

        public int getDefragmentedPartitionCount() {
            return this.defragmentedPartitionCount;
        }
    }

    private static class DefragmentationCancelledException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private DefragmentationCancelledException() {
        }
    }

    private class PartitionContext {
        public final File workDir;
        public final int grpId;
        public final int partId;
        public final DataRegion cacheDataRegion;
        public final PageMemoryEx cachePageMemory;
        public final PageMemoryEx partPageMemory;
        public final PageMemoryEx mappingPageMemory;
        public final CacheGroupContext oldGrpCtx;
        public final CacheGroupContext newGrpCtx;
        public final IgniteCacheOffheapManager.CacheDataStore oldCacheDataStore;
        private GridCacheOffheapManager.GridCacheDataStore newCacheDataStore;
        public final FileVersionCheckingFactory pageStoreFactory;
        public final AtomicLong partPagesAllocated = new AtomicLong();
        public final AtomicLong mappingPagesAllocated = new AtomicLong();
        private LinkMap linkMap;

        public PartitionContext(File workDir, int grpId, int partId, DataRegion partDataRegion, DataRegion mappingDataRegion, CacheGroupContext oldGrpCtx, CacheGroupContext newGrpCtx, IgniteCacheOffheapManager.CacheDataStore oldCacheDataStore, FileVersionCheckingFactory pageStoreFactory) {
            this.workDir = workDir;
            this.grpId = grpId;
            this.partId = partId;
            this.cacheDataRegion = oldGrpCtx.dataRegion();
            this.cachePageMemory = (PageMemoryEx)this.cacheDataRegion.pageMemory();
            this.partPageMemory = (PageMemoryEx)partDataRegion.pageMemory();
            this.mappingPageMemory = (PageMemoryEx)mappingDataRegion.pageMemory();
            this.oldGrpCtx = oldGrpCtx;
            this.newGrpCtx = newGrpCtx;
            this.oldCacheDataStore = oldCacheDataStore;
            this.pageStoreFactory = pageStoreFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PageStore createPageStore(IgniteOutClosure<Path> pathProvider, AtomicLong pagesAllocated, PageMemoryEx pageMemory) throws IgniteCheckedException {
            PageStore partPageStore;
            CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
            try {
                partPageStore = this.pageStoreFactory.createPageStore((byte)1, pathProvider, pagesAllocated::addAndGet);
            }
            finally {
                CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
            }
            partPageStore.sync();
            DefragmentationPageReadWriteManager pageMgr = (DefragmentationPageReadWriteManager)pageMemory.pageManager();
            pageMgr.pageStoreMap().addPageStore(this.grpId, this.partId, partPageStore);
            return partPageStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkMap createLinkMapTree(boolean initNew) throws IgniteCheckedException {
            CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
            try {
                long mappingMetaPageId;
                long l = mappingMetaPageId = initNew ? this.mappingPageMemory.allocatePage(this.grpId, this.partId, (byte)1) : PageIdUtils.pageId(this.partId, (byte)1, 2);
                assert (PageIdUtils.pageIndex(mappingMetaPageId) == 2) : PageIdUtils.toDetailString(mappingMetaPageId);
                this.linkMap = new LinkMap(this.newGrpCtx, this.mappingPageMemory, mappingMetaPageId, initNew);
            }
            finally {
                CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
            }
            return this.linkMap;
        }

        public void createNewCacheDataStore(GridCacheOffheapManager offheap) {
            GridCacheOffheapManager.GridCacheDataStore newCacheDataStore = offheap.createGridCacheDataStore(this.newGrpCtx, this.partId, true, CachePartitionDefragmentationManager.this.log);
            CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadLock();
            try {
                newCacheDataStore.init();
            }
            finally {
                CachePartitionDefragmentationManager.this.defragmentationCheckpoint.checkpointTimeoutLock().checkpointReadUnlock();
            }
            this.newCacheDataStore = newCacheDataStore;
        }
    }
}

