/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.lang.IgniteProductVersion;

public class MetaPageInfo {
    private final int inlineSize;
    private final boolean useUnwrappedPk;
    private final boolean flagsSupported;
    private boolean inlineObjSupported;
    private boolean inlineObjHash;
    private final IgniteProductVersion createdVer;

    public MetaPageInfo(BPlusMetaIO io, long pageAddr) {
        this.inlineSize = io.getInlineSize(pageAddr);
        this.useUnwrappedPk = io.unwrappedPk(pageAddr);
        this.flagsSupported = io.supportFlags();
        if (this.flagsSupported) {
            this.inlineObjSupported = io.inlineObjectSupported(pageAddr);
            this.inlineObjHash = io.inlineObjectHash(pageAddr);
        }
        this.createdVer = io.createdVersion(pageAddr);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public boolean useUnwrappedPk() {
        return this.useUnwrappedPk;
    }

    public boolean flagsSupported() {
        return this.flagsSupported;
    }

    public boolean inlineObjectSupported() {
        return this.inlineObjSupported;
    }

    public boolean inlineObjectHash() {
        return this.inlineObjHash;
    }
}

