/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.h2.database.IndexInformation;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;

public class SqlIndexView {
    private final GridH2Table tbl;
    private final IndexInformation idx;

    public SqlIndexView(GridH2Table tbl, IndexInformation idx) {
        this.tbl = tbl;
        this.idx = idx;
    }

    @Order
    public int cacheGroupId() {
        return this.tbl.cacheInfo().groupId();
    }

    @Order(value=1)
    public String cacheGroupName() {
        return this.tbl.cacheInfo().groupName();
    }

    @Order(value=2)
    public int cacheId() {
        return this.tbl.cacheId();
    }

    @Order(value=3)
    public String cacheName() {
        return this.tbl.cacheName();
    }

    @Order(value=4)
    public String schemaName() {
        return this.tbl.getSchema().getName();
    }

    @Order(value=5)
    public String tableName() {
        return this.tbl.identifier().table();
    }

    @Order(value=6)
    public String indexName() {
        return this.idx.name();
    }

    @Order(value=7)
    public String indexType() {
        return this.idx.type();
    }

    @Order(value=8)
    public String columns() {
        return this.idx.keySql();
    }

    @Order(value=9)
    public boolean isPk() {
        return this.idx.pk();
    }

    @Order(value=10)
    public boolean isUnique() {
        return this.idx.unique();
    }

    @Order(value=11)
    public Integer inlineSize() {
        return this.idx.inlineSize();
    }
}

