/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskAction;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotRestoreTaskArg;

public class SnapshotCommand
extends AbstractCommand<Object> {
    private Object cmdArg;
    private SnapshotSubcommand cmd;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Object res = TaskExecutor.executeTaskByNameOnNode(client, this.cmd.taskName(), this.arg(), null, clientCfg);
            if (this.cmd == SnapshotSubcommand.CHECK) {
                ((IdleVerifyResultV2)res).print(log::info, true);
            }
            if (this.cmd == SnapshotSubcommand.RESTORE) {
                log.info(String.valueOf(res));
            }
            Object r = res;
            return r;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.cmdArg;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        this.cmd = SnapshotSubcommand.of(argIter.nextArg("Expected snapshot action."));
        String snpName = argIter.nextArg("Expected snapshot name.");
        if (this.cmd != SnapshotSubcommand.RESTORE) {
            this.cmdArg = snpName;
            return;
        }
        VisorSnapshotRestoreTaskAction cmdAction = VisorSnapshotRestoreTaskAction.fromCmdArg((String)argIter.nextArg("Restore action expected."));
        Set<String> grpNames = null;
        if (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg("");
            if (cmdAction != VisorSnapshotRestoreTaskAction.START) {
                throw new IllegalArgumentException("Invalid argument \"" + arg + "\", no more arguments expected.");
            }
            grpNames = argIter.parseStringSet(arg);
        }
        this.cmdArg = new VisorSnapshotRestoreTaskArg(cmdAction, snpName, grpNames);
    }

    @Override
    public void printUsage(Logger log) {
        Map<String, String> commonParams = Collections.singletonMap("snapshot_name", "Snapshot name.");
        Command.usage(log, "Create cluster snapshot:", CommandList.SNAPSHOT, commonParams, SnapshotSubcommand.CREATE.toString(), "snapshot_name");
        Command.usage(log, "Cancel running snapshot:", CommandList.SNAPSHOT, commonParams, SnapshotSubcommand.CANCEL.toString(), "snapshot_name");
        Command.usage(log, "Check snapshot:", CommandList.SNAPSHOT, commonParams, SnapshotSubcommand.CHECK.toString(), "snapshot_name");
        LinkedHashMap<String, String> startParams = new LinkedHashMap<String, String>(commonParams);
        startParams.put("group1,...groupN", "Cache group names.");
        Command.usage(log, "Restore snapshot:", CommandList.SNAPSHOT, startParams, SnapshotSubcommand.RESTORE.toString(), "snapshot_name", VisorSnapshotRestoreTaskAction.START.cmdName(), CommandLogger.optional("group1,...groupN"));
        Command.usage(log, "Snapshot restore operation status:", CommandList.SNAPSHOT, commonParams, SnapshotSubcommand.RESTORE.toString(), "snapshot_name", VisorSnapshotRestoreTaskAction.STATUS.cmdName());
        Command.usage(log, "Cancel snapshot restore operation:", CommandList.SNAPSHOT, commonParams, SnapshotSubcommand.RESTORE.toString(), "snapshot_name", VisorSnapshotRestoreTaskAction.CANCEL.cmdName());
    }

    @Override
    public String confirmationPrompt() {
        if (this.cmd != SnapshotSubcommand.RESTORE) {
            return null;
        }
        VisorSnapshotRestoreTaskArg arg = (VisorSnapshotRestoreTaskArg)this.cmdArg;
        return arg.jobAction() == VisorSnapshotRestoreTaskAction.START && arg.groupNames() != null ? null : "Warning: command will restore ALL PUBLIC CACHE GROUPS from the snapshot " + arg.snapshotName() + '.';
    }

    @Override
    public String name() {
        return CommandList.SNAPSHOT.toCommandName();
    }
}

