/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.property.subcommands;

import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.property.PropertyArgs;
import org.apache.ignite.internal.commandline.property.PropertySubCommandsList;
import org.apache.ignite.internal.commandline.property.subcommands.PropertyAbstractSubCommand;
import org.apache.ignite.internal.commandline.property.tasks.PropertyOperationResult;
import org.apache.ignite.internal.commandline.property.tasks.PropertyTask;

public class PropertySetCommand
extends PropertyAbstractSubCommand<PropertyArgs, PropertyOperationResult> {
    @Override
    protected String taskName() {
        return PropertyTask.class.getName();
    }

    @Override
    public PropertyArgs parseArguments0(CommandArgIterator argIter) {
        String name = null;
        String val = null;
        while (argIter.hasNextSubArg() && (name == null || val == null)) {
            String optName = argIter.nextArg("Expecting " + (name == null ? "--name" : "--val"));
            if ("--name".equals(optName)) {
                name = argIter.nextArg("property name");
            }
            if (!"--val".equals(optName)) continue;
            val = argIter.nextArg("property value");
        }
        if (name == null) {
            throw new IllegalArgumentException("Property name is not specified. Please the option: --name <property_name>");
        }
        if (val == null) {
            throw new IllegalArgumentException("Property name is not specified. Please the option: --name <property_name>");
        }
        return new PropertyArgs(name, val, PropertyArgs.Action.SET);
    }

    @Override
    protected void printResult(PropertyOperationResult res, Logger log) {
    }

    @Override
    public String name() {
        return PropertySubCommandsList.SET.text();
    }
}

