/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.defragmentation.DefragmentationArguments;
import org.apache.ignite.internal.commandline.defragmentation.DefragmentationSubcommands;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationOperation;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTask;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTaskArg;
import org.apache.ignite.internal.visor.defragmentation.VisorDefragmentationTaskResult;

public class DefragmentationCommand
implements Command<DefragmentationArguments> {
    private static final String NODES_ARG = "--nodes";
    private static final String CACHES_ARG = "--caches";
    private DefragmentationArguments args;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Optional<GridClientNode> firstNodeOpt = client.compute().nodes().stream().filter(GridClientNode::connectable).findFirst();
            if (firstNodeOpt.isPresent()) {
                VisorDefragmentationTaskResult res;
                if (this.args.nodeIds() == null) {
                    res = (VisorDefragmentationTaskResult)TaskExecutor.executeTaskByNameOnNode(client, VisorDefragmentationTask.class.getName(), this.convertArguments(), null, clientCfg);
                } else {
                    VisorTaskArgument visorArg = new VisorTaskArgument((Collection)client.compute().nodes().stream().filter(node -> this.args.nodeIds().contains(node.consistentId().toString())).map(GridClientNode::nodeId).collect(Collectors.toList()), (Object)this.convertArguments(), false);
                    res = (VisorDefragmentationTaskResult)client.compute().projection(firstNodeOpt.get()).execute(VisorDefragmentationTask.class.getName(), (Object)visorArg);
                }
                this.printResult(res, log);
            } else {
                log.warning("No nodes found in topology, command won't be executed.");
            }
        }
        catch (Throwable t) {
            log.severe("Failed to execute defragmentation command='" + this.args.subcommand().text() + "'");
            log.severe(CommandLogger.errorMessage(t));
            throw t;
        }
        return null;
    }

    private void printResult(VisorDefragmentationTaskResult res, Logger log) {
        assert (res != null);
        log.info(res.getMessage());
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        DefragmentationSubcommands cmd = DefragmentationSubcommands.of(argIter.nextArg("Expected defragmentation subcommand."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct defragmentation subcommand.");
        }
        this.args = new DefragmentationArguments(cmd);
        switch (cmd) {
            case SCHEDULE: {
                String subarg;
                ArrayList<String> consistentIds = null;
                ArrayList<String> cacheNames = null;
                while ((subarg = argIter.peekNextArg()) != null) {
                    switch (subarg = subarg.toLowerCase(Locale.ENGLISH)) {
                        case "--nodes": {
                            argIter.nextArg("");
                            Set<String> ids = argIter.nextStringSet(NODES_ARG);
                            if (ids.isEmpty()) {
                                throw new IllegalArgumentException("Consistent ids list is empty.");
                            }
                            consistentIds = new ArrayList<String>(ids);
                            break;
                        }
                        case "--caches": {
                            argIter.nextArg("");
                            Set<String> ids = argIter.nextStringSet(CACHES_ARG);
                            if (ids.isEmpty()) {
                                throw new IllegalArgumentException("Caches list is empty.");
                            }
                            cacheNames = new ArrayList<String>(ids);
                            break;
                        }
                        default: {
                            subarg = null;
                        }
                    }
                    if (subarg != null) continue;
                }
                if (consistentIds == null) {
                    throw new IllegalArgumentException("--nodes argument is missing.");
                }
                this.args.setNodeIds(consistentIds);
                this.args.setCacheNames(cacheNames);
                break;
            }
        }
    }

    @Override
    public DefragmentationArguments arg() {
        return this.args;
    }

    @Override
    public void printUsage(Logger log) {
        String consistentIds = "consistentId0,consistentId1";
        String cacheNames = "cache1,cache2,cache3";
        Command.usage(log, "Schedule PDS defragmentation on given nodes for all caches:", CommandList.DEFRAGMENTATION, DefragmentationSubcommands.SCHEDULE.text(), NODES_ARG, consistentIds);
        Command.usage(log, "Schedule PDS defragmentation on given nodes but only for given caches:", CommandList.DEFRAGMENTATION, DefragmentationSubcommands.SCHEDULE.text(), NODES_ARG, consistentIds, CACHES_ARG, cacheNames);
        Command.usage(log, "Cancel scheduled or active PDS defragmentation on underlying node:", CommandList.DEFRAGMENTATION, DefragmentationSubcommands.CANCEL.text());
    }

    @Override
    public String name() {
        return CommandList.DEFRAGMENTATION.toCommandName();
    }

    private VisorDefragmentationTaskArg convertArguments() {
        return new VisorDefragmentationTaskArg(DefragmentationCommand.convertSubcommand(this.args.subcommand()), this.args.cacheNames());
    }

    private static VisorDefragmentationOperation convertSubcommand(DefragmentationSubcommands subcmd) {
        switch (subcmd) {
            case SCHEDULE: {
                return VisorDefragmentationOperation.SCHEDULE;
            }
            case STATUS: {
                return VisorDefragmentationOperation.STATUS;
            }
            case CANCEL: {
                return VisorDefragmentationOperation.CANCEL;
            }
        }
        throw new IllegalArgumentException(subcmd.name());
    }
}

