/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataRegionMetricsProvider;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.systemview.walker.MetastorageViewWalker;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.DataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MasterKeyChangeRecordV2;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.MetastoreDataRecord;
import org.apache.ignite.internal.pagemem.wal.record.MvccDataEntry;
import org.apache.ignite.internal.pagemem.wal.record.MvccTxRecord;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.ReencryptionStartRecord;
import org.apache.ignite.internal.pagemem.wal.record.RollbackRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionDestroyRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PartitionMetaStateRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLog;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.CorruptedPdsMaintenanceCallback;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.DatabaseLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointEntry;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistoryResult;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointStatus;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.LightweightCheckpointManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.ReservationReason;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.CachePartitionDefragmentationManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.DefragmentationPageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.DefragmentationParameters;
import org.apache.ignite.internal.processors.cache.persistence.defragmentation.maintenance.DefragmentationWorkflowCallback;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageReadWriteManager;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.configuration.distributed.SimpleDistributedProperty;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.GridCountDownCallback;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.TimeBag;
import org.apache.ignite.internal.util.lang.GridInClosure3X;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.maintenance.MaintenanceRegistry;
import org.apache.ignite.maintenance.MaintenanceTask;
import org.apache.ignite.mxbean.DataStorageMetricsMXBean;
import org.apache.ignite.spi.systemview.view.MetastorageView;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCacheDatabaseSharedManager
extends IgniteCacheDatabaseSharedManager {
    @SystemProperty(value="Sets the flag controlling if the I/O sync needs to be skipped on a checkpoint")
    public static final String IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC = "IGNITE_PDS_CHECKPOINT_TEST_SKIP_SYNC";
    @SystemProperty(value="Sets the flag controlling of a checkpoint needs to be skipped during a node termination")
    public static final String IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP = "IGNITE_PDS_SKIP_CHECKPOINT_ON_NODE_STOP";
    @SystemProperty(value="Enables log checkpoint read lock holders")
    public static final String IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS = "IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS";
    public static final String METASTORE_DATA_REGION_NAME = "metastoreMemPlc";
    public static final String METASTORE_VIEW = "metastorage";
    public static final String METASTORE_VIEW_DESC = "Local metastorage data";
    public static final String DEFRAGMENTATION_PART_REGION_NAME = "defragPartitionsDataRegion";
    public static final String DEFRAGMENTATION_MAPPING_REGION_NAME = "defragMappingDataRegion";
    private static final double PAGE_LIST_CACHE_LIMIT_THRESHOLD = 0.1;
    public static final int DFLT_PDS_WAL_REBALANCE_THRESHOLD = 500;
    public static final int DFLT_DEFRAGMENTATION_REGION_SIZE_PERCENTAGE = 60;
    private final int walRebalanceThreshold = IgniteSystemProperties.getInteger("IGNITE_PDS_WAL_REBALANCE_THRESHOLD", 500);
    private final boolean preferWalRebalance = IgniteSystemProperties.getBoolean("IGNITE_PREFER_WAL_REBALANCE");
    private final String throttlingPolicyOverride = IgniteSystemProperties.getString("IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED");
    private final int defragmentationRegionSizePercentageOfConfiguredSize = IgniteSystemProperties.getInteger("IGNITE_DEFRAGMENTATION_REGION_SIZE_PERCENTAGE", 60);
    private static final String MBEAN_NAME = "DataStorageMetrics";
    private static final String MBEAN_GROUP = "Persistent Store";
    private static final String WAL_KEY_PREFIX = "grp-wal-";
    private static final String WAL_GLOBAL_KEY_PREFIX = "grp-wal-disabled-";
    private static final String WAL_LOCAL_KEY_PREFIX = "grp-wal-local-disabled-";
    private static final String CHECKPOINT_INAPPLICABLE_FOR_REBALANCE = "cp-wal-rebalance-inapplicable-";
    private static final int DEFAULT_CHECKPOINT_DEVIATION = 40;
    private FilePageStoreManager storeMgr;
    CheckpointManager checkpointManager;
    private final DataStorageConfiguration persistenceCfg;
    private volatile WALPointer walTail;
    @Nullable
    private FileLockHolder fileLockHolder;
    private final long lockWaitTime;
    private WALPointer reservedForExchange;
    private volatile WALPointer reservedForPreloading;
    private IgniteCacheSnapshotManager snapshotMgr;
    private final DataStorageMetricsImpl persStoreMetrics;
    private MetaStorage metaStorage;
    private MetaStorage.TmpStorage tmpMetaStorage;
    private List<MetastorageLifecycleListener> metastorageLifecycleLsnrs;
    private final Collection<Integer> initiallyGlobalWalDisabledGrps = new HashSet<Integer>();
    private final Collection<Integer> initiallyLocWalDisabledGrps = new HashSet<Integer>();
    private final boolean recoveryVerboseLogging = IgniteSystemProperties.getBoolean("IGNITE_RECOVERY_VERBOSE_LOGGING", false);
    private final Map<String, AtomicLong> pageListCacheLimits = new ConcurrentHashMap<String, AtomicLong>();
    private final ReentrantLock releaseHistForPreloadingLock = new ReentrantLock();
    private CachePartitionDefragmentationManager defrgMgr;
    protected final Set<DataRegion> checkpointedDataRegions = new GridConcurrentHashSet<DataRegion>();
    private SimpleDistributedProperty<Integer> cpFreqDeviation;

    public GridCacheDatabaseSharedManager(GridKernalContext ctx) {
        IgniteConfiguration cfg = ctx.config();
        this.persistenceCfg = cfg.getDataStorageConfiguration();
        assert (this.persistenceCfg != null);
        this.lockWaitTime = this.persistenceCfg.getLockWaitTime();
        this.persStoreMetrics = new DataStorageMetricsImpl(ctx.metric(), this.persistenceCfg.isMetricsEnabled(), this.persistenceCfg.getMetricsRateTimeInterval(), this.persistenceCfg.getMetricsSubIntervalCount());
    }

    public FilePageStoreManager getFileStoreManager() {
        return this.storeMgr;
    }

    private void registerSystemView() {
        this.cctx.kernalContext().systemView().registerView(METASTORE_VIEW, METASTORE_VIEW_DESC, new MetastorageViewWalker(), () -> {
            try {
                ArrayList data = new ArrayList();
                this.metaStorage.iterate("", (key, valBytes) -> {
                    try {
                        Serializable val = (Serializable)this.metaStorage.marshaller().unmarshal((byte[])valBytes, U.gridClassLoader());
                        data.add(new MetastorageView((String)key, IgniteUtils.toStringSafe(val)));
                    }
                    catch (IgniteCheckedException ignored) {
                        data.add(new MetastorageView((String)key, "[Raw data. " + ((byte[])valBytes).length + " bytes]"));
                    }
                }, false);
                return data;
            }
            catch (IgniteCheckedException e) {
                this.log.warning("Metastore iteration error", e);
                return Collections.emptyList();
            }
        }, Function.identity());
    }

    private void notifyMetastorageReadyForRead() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForRead(this.metaStorage);
        }
    }

    private void notifyMetastorageReadyForReadWrite() throws IgniteCheckedException {
        for (MetastorageLifecycleListener lsnr : this.metastorageLifecycleLsnrs) {
            lsnr.onReadyForReadWrite(this.metaStorage);
        }
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointManager.getCheckpointer();
    }

    public boolean preferWalRebalance() {
        return this.preferWalRebalance;
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        IgniteInternalFuture<Void> fut = this.checkpointManager.enableCheckpoints(enable);
        this.wakeupForCheckpoint("enableCheckpoints()");
        return fut;
    }

    @Override
    protected void initDataRegions0(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        super.initDataRegions0(memCfg);
        this.addDataRegion(memCfg, this.createMetastoreDataRegionConfig(memCfg), false);
        List<DataRegionMetrics> regionMetrics = this.dataRegionMap.values().stream().map(DataRegion::metrics).collect(Collectors.toList());
        this.persStoreMetrics.regionMetrics(regionMetrics);
    }

    private DataRegionConfiguration createMetastoreDataRegionConfig(DataStorageConfiguration storageCfg) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(METASTORE_DATA_REGION_NAME);
        cfg.setInitialSize(storageCfg.getSystemRegionInitialSize());
        cfg.setMaxSize(storageCfg.getSystemRegionMaxSize());
        cfg.setPersistenceEnabled(true);
        cfg.setLazyMemoryAllocation(false);
        return cfg;
    }

    private DataRegionConfiguration createDefragmentationDataRegionConfig(long regionSize) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(DEFRAGMENTATION_PART_REGION_NAME);
        cfg.setInitialSize(regionSize);
        cfg.setMaxSize(regionSize);
        cfg.setPersistenceEnabled(true);
        cfg.setLazyMemoryAllocation(false);
        return cfg;
    }

    private DataRegionConfiguration createDefragmentationMappingRegionConfig(long regionSize) {
        DataRegionConfiguration cfg = new DataRegionConfiguration();
        cfg.setName(DEFRAGMENTATION_MAPPING_REGION_NAME);
        cfg.setInitialSize(regionSize);
        cfg.setMaxSize(regionSize);
        cfg.setPersistenceEnabled(true);
        cfg.setLazyMemoryAllocation(false);
        return cfg;
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        this.snapshotMgr = this.cctx.snapshot();
        IgnitePageStoreManager store = this.cctx.pageStore();
        assert (store instanceof FilePageStoreManager) : "Invalid page store manager was created: " + store;
        this.storeMgr = (FilePageStoreManager)store;
        GridKernalContext kernalCtx = this.cctx.kernalContext();
        assert (!kernalCtx.clientNode());
        if (!kernalCtx.clientNode()) {
            kernalCtx.internalSubscriptionProcessor().registerDatabaseListener(new MetastorageRecoveryLifecycle());
            this.cpFreqDeviation = new SimpleDistributedProperty<Integer>("checkpoint.deviation", Integer::parseInt);
            kernalCtx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
                this.cpFreqDeviation.addListener((name, oldVal, newVal) -> U.log(this.log, "Checkpoint frequency deviation changed [oldVal=" + oldVal + ", newVal=" + newVal + "]"));
                dispatcher.registerProperty(this.cpFreqDeviation);
            });
            this.checkpointManager = new CheckpointManager(kernalCtx::log, this.cctx.igniteInstanceName(), "db-checkpoint-thread", this.cctx.wal(), kernalCtx.workersRegistry(), this.persistenceCfg, this.storeMgr, this::isCheckpointInapplicableForWalRebalance, this::checkpointedDataRegions, this::cacheGroupContexts, this::getPageMemoryForCacheGroup, this.resolveThrottlingPolicy(), this.snapshotMgr, this.persistentStoreMetricsImpl(), kernalCtx.longJvmPauseDetector(), kernalCtx.failure(), kernalCtx.cache(), () -> this.cpFreqDeviation.getOrDefault(40));
            FileLockHolder preLocked = kernalCtx.pdsFolderResolver().resolveFolders().getLockedFileLockHolder();
            this.acquireFileLock(preLocked);
            this.cleanupTempCheckpointDirectory();
            this.persStoreMetrics.wal(this.cctx.wal());
        }
    }

    @Override
    protected void initDataRegions(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        if (this.isDefragmentationScheduled() && !this.dataRegionsInitialized) {
            memCfg = this.configureDataRegionForDefragmentation(memCfg);
        }
        super.initDataRegions(memCfg);
    }

    private DataStorageConfiguration configureDataRegionForDefragmentation(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        ArrayList<DataRegionConfiguration> regionConfs = new ArrayList<DataRegionConfiguration>();
        DataStorageConfiguration dataConf = memCfg;
        regionConfs.add(dataConf.getDefaultDataRegionConfiguration());
        if (dataConf.getDataRegionConfigurations() != null) {
            regionConfs.addAll(Arrays.asList(dataConf.getDataRegionConfigurations()));
        }
        long totalDefrRegionSize = 0L;
        long totalRegionsSize = 0L;
        for (DataRegionConfiguration regionCfg : regionConfs) {
            totalDefrRegionSize = Math.max(totalDefrRegionSize, (long)((double)regionCfg.getMaxSize() * 0.01 * (double)this.defragmentationRegionSizePercentageOfConfiguredSize));
            totalRegionsSize += regionCfg.getMaxSize();
        }
        double shrinkPercentage = 1.0 * (double)(totalRegionsSize - totalDefrRegionSize) / (double)totalRegionsSize;
        for (DataRegionConfiguration region : regionConfs) {
            long newSize = (long)((double)region.getMaxSize() * shrinkPercentage);
            long newInitSize = Math.min(region.getInitialSize(), newSize);
            this.log.info("Region size was reassigned by defragmentation reason: region = '" + region.getName() + "', oldInitialSize = '" + region.getInitialSize() + "', newInitialSize = '" + newInitSize + "', oldMaxSize = '" + region.getMaxSize() + "', newMaxSize = '" + newSize);
            region.setMaxSize(newSize);
            region.setInitialSize(newInitSize);
            region.setCheckpointPageBufferSize(0L);
        }
        long mappingRegionSize = Math.min(0x40000000L, (long)((double)totalDefrRegionSize * 0.1));
        this.checkpointedDataRegions.remove(this.addDataRegion(memCfg, this.createDefragmentationDataRegionConfig(totalDefrRegionSize - mappingRegionSize), true, new DefragmentationPageReadWriteManager(this.cctx.kernalContext(), "defrgPartitionsStore")));
        this.checkpointedDataRegions.remove(this.addDataRegion(memCfg, this.createDefragmentationMappingRegionConfig(mappingRegionSize), true, new DefragmentationPageReadWriteManager(this.cctx.kernalContext(), "defrgLinkMappingStore")));
        return dataConf;
    }

    private boolean isDefragmentationScheduled() {
        return this.cctx.kernalContext().maintenanceRegistry().activeMaintenanceTask("defragmentationMaintenanceTask") != null;
    }

    public Collection<DataRegion> checkpointedDataRegions() {
        return this.checkpointedDataRegions;
    }

    private Collection<CacheGroupContext> cacheGroupContexts() {
        return this.cctx.cache().cacheGroups();
    }

    @Override
    public void cleanupTempCheckpointDirectory() throws IgniteCheckedException {
        this.checkpointManager.cleanupTempCheckpointDirectory();
    }

    @Override
    public void cleanupRestoredCaches() {
        PageMemory memory;
        if (this.dataRegionMap.isEmpty()) {
            return;
        }
        boolean hasMvccCache = false;
        for (CacheGroupDescriptor grpDesc : this.cctx.cache().cacheGroupDescriptors().values()) {
            hasMvccCache |= grpDesc.config().getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT;
            String regionName = grpDesc.config().getDataRegionName();
            DataRegion region = regionName != null ? (DataRegion)this.dataRegionMap.get(regionName) : this.dfltDataRegion;
            if (region == null) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Page memory " + region.config().getName() + " for " + grpDesc + " has invalidated.");
            }
            int partitions = grpDesc.config().getAffinity().partitions();
            if (region.pageMemory() instanceof PageMemoryEx) {
                PageMemoryEx memEx = (PageMemoryEx)region.pageMemory();
                for (int partId = 0; partId < partitions; ++partId) {
                    memEx.invalidate(grpDesc.groupId(), partId);
                }
                memEx.invalidate(grpDesc.groupId(), 65535);
            }
            if (!grpDesc.config().isEncryptionEnabled()) continue;
            this.cctx.kernalContext().encryption().onCacheGroupStop(grpDesc.groupId());
        }
        if (!hasMvccCache && this.dataRegionMap.containsKey("TxLog") && (memory = ((DataRegion)this.dataRegionMap.get("TxLog")).pageMemory()) instanceof PageMemoryEx) {
            ((PageMemoryEx)memory).invalidate(TxLog.TX_LOG_CACHE_ID, 65535);
        }
        final boolean hasMvccCache0 = hasMvccCache;
        this.storeMgr.cleanupPageStoreIfMatch(new Predicate<Integer>(){

            @Override
            public boolean test(Integer grpId) {
                return MetaStorage.METASTORAGE_CACHE_ID != grpId && (TxLog.TX_LOG_CACHE_ID != grpId || !hasMvccCache0);
            }
        }, true);
    }

    @Override
    public void cleanupCheckpointDirectory() throws IgniteCheckedException {
        this.checkpointManager.cleanupCheckpointDirectory();
    }

    private void acquireFileLock(FileLockHolder preLocked) throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        FileLockHolder fileLockHolder = this.fileLockHolder = preLocked == null ? new FileLockHolder(this.storeMgr.workDir().getPath(), this.cctx.kernalContext(), this.log) : preLocked;
        if (!this.fileLockHolder.isLocked()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Try to capture file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
            }
            this.fileLockHolder.tryLock(this.lockWaitTime);
        }
    }

    private void releaseFileLock() {
        if (this.cctx.kernalContext().clientNode() || this.fileLockHolder == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Release file lock [nodeId=" + this.cctx.localNodeId() + " path=" + this.fileLockHolder.lockPath() + "]");
        }
        this.fileLockHolder.close();
    }

    private void prepareCacheDefragmentation(List<String> cacheNames) throws IgniteCheckedException {
        GridKernalContext kernalCtx = this.cctx.kernalContext();
        DataStorageConfiguration dsCfg = kernalCtx.config().getDataStorageConfiguration();
        assert (CU.isPersistenceEnabled(dsCfg));
        List<DataRegion> regions = Arrays.asList(this.dataRegion(DEFRAGMENTATION_MAPPING_REGION_NAME), this.dataRegion(DEFRAGMENTATION_PART_REGION_NAME));
        LightweightCheckpointManager lightCheckpointMgr = new LightweightCheckpointManager(kernalCtx::log, this.cctx.igniteInstanceName(), "db-checkpoint-thread-defrag", kernalCtx.workersRegistry(), this.persistenceCfg, () -> regions, this::getPageMemoryForCacheGroup, this.resolveThrottlingPolicy(), this.snapshotMgr, this.persistentStoreMetricsImpl(), kernalCtx.longJvmPauseDetector(), kernalCtx.failure(), kernalCtx.cache());
        lightCheckpointMgr.start();
        this.defrgMgr = new CachePartitionDefragmentationManager(cacheNames, this.cctx, this, (FilePageStoreManager)this.cctx.pageStore(), this.checkpointManager, lightCheckpointMgr, this.persistenceCfg.getPageSize(), this.persistenceCfg.getDefragmentationThreadPoolSize());
    }

    public CachePartitionDefragmentationManager defragmentationManager() {
        return this.defrgMgr;
    }

    @Override
    public DataRegion addDataRegion(DataStorageConfiguration dataStorageCfg, DataRegionConfiguration dataRegionCfg, boolean trackable, PageReadWriteManager pmPageMgr) throws IgniteCheckedException {
        DataRegion region = super.addDataRegion(dataStorageCfg, dataRegionCfg, trackable, pmPageMgr);
        this.checkpointedDataRegions.add(region);
        return region;
    }

    private void readMetastore() throws IgniteCheckedException {
        try {
            CheckpointStatus status = this.readCheckpointStatus();
            this.checkpointReadLock();
            try {
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().start();
                this.performBinaryMemoryRestore(status, this.onlyMetastorageGroup(), this.physicalRecords(), false);
                this.metaStorage = this.createMetastorage(true);
                this.applyLogicalUpdates(status, this.onlyMetastorageGroup(), this.onlyMetastorageAndEncryptionRecords(), true);
                this.fillWalDisabledGroups();
                this.checkpointManager.initializeStorage();
                this.registerSystemView();
                this.notifyMetastorageReadyForRead();
                this.cctx.kernalContext().maintenanceRegistry().registerWorkflowCallbackIfTaskExists("defragmentationMaintenanceTask", task -> {
                    this.prepareCacheDefragmentation(DefragmentationParameters.fromStore(task).cacheNames());
                    return new DefragmentationWorkflowCallback(this.cctx.kernalContext()::log, this.defrgMgr, this.cctx.kernalContext().failure());
                });
                this.metaStorage = null;
            }
            catch (Throwable throwable) {
                this.metaStorage = null;
                this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
                this.cctx.pageStore().cleanupPageStoreIfMatch(new Predicate<Integer>(){

                    @Override
                    public boolean test(Integer grpId) {
                        return MetaStorage.METASTORAGE_CACHE_ID == grpId;
                    }
                }, false);
                this.checkpointReadUnlock();
                throw throwable;
            }
            this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory().stop(false);
            this.cctx.pageStore().cleanupPageStoreIfMatch(new /* invalid duplicate definition of identical inner class */, false);
            this.checkpointReadUnlock();
        }
        catch (StorageException e) {
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            throw new IgniteCheckedException(e);
        }
    }

    @Override
    public void onActivate(GridKernalContext ctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.snapshotMgr = this.cctx.snapshot();
        this.checkpointManager.init();
        super.onActivate(ctx);
        if (!this.cctx.kernalContext().clientNode()) {
            this.finishRecovery();
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate database manager [id=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.onKernalStop0(false);
        super.onDeActivate(kctx);
        this.checkpointManager.unblockCheckpointLock();
    }

    @Override
    protected void registerMetricsMBeans(IgniteConfiguration cfg) {
        super.registerMetricsMBeans(cfg);
        this.registerMetricsMBean(this.cctx.kernalContext().config(), MBEAN_GROUP, MBEAN_NAME, this.persStoreMetrics, DataStorageMetricsMXBean.class);
    }

    @Override
    @Deprecated
    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.freeSpaceProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){

            @Override
            public Long apply() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }
        };
    }

    @Override
    protected DataRegionMetricsProvider dataRegionMetricsProvider(DataRegionConfiguration dataRegCfg) {
        if (!dataRegCfg.isPersistenceEnabled()) {
            return super.dataRegionMetricsProvider(dataRegCfg);
        }
        final String dataRegName = dataRegCfg.getName();
        return new DataRegionMetricsProvider(){

            @Override
            public long partiallyFilledPagesFreeSpace() {
                long freeSpace = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    freeSpace += ((GridCacheOffheapManager)grpCtx.offheap()).freeSpace();
                }
                return freeSpace;
            }

            @Override
            public long emptyDataPages() {
                long emptyDataPages = 0L;
                for (CacheGroupContext grpCtx : GridCacheDatabaseSharedManager.this.cctx.cache().cacheGroups()) {
                    if (!grpCtx.dataRegion().config().getName().equals(dataRegName)) continue;
                    assert (grpCtx.offheap() instanceof GridCacheOffheapManager);
                    emptyDataPages += ((GridCacheOffheapManager)grpCtx.offheap()).emptyDataPages();
                }
                return emptyDataPages;
            }
        };
    }

    private void finishRecovery() throws IgniteCheckedException {
        assert (!this.cctx.kernalContext().clientNode());
        long time = System.currentTimeMillis();
        CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        try {
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeResumeWalLogging(this);
            }
            if (this.walTail == null) {
                CheckpointStatus status = this.readCheckpointStatus();
                this.walTail = CheckpointStatus.NULL_PTR.equals(status.endPtr) ? null : status.endPtr;
            }
            this.resumeWalLogging();
            this.walTail = null;
            if (this.metaStorage == null) {
                this.metaStorage = this.createMetastorage(false);
            }
            this.notifyMetastorageReadyForReadWrite();
            U.log(this.log, "Finish recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
        finally {
            CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    private MetaStorage createMetastorage(boolean readOnly) throws IgniteCheckedException {
        this.cctx.pageStore().initializeForMetastorage();
        MetaStorage storage = new MetaStorage(this.cctx, this.dataRegion(METASTORE_DATA_REGION_NAME), readOnly);
        storage.init(this);
        return storage;
    }

    private RestoreBinaryState restoreBinaryMemory(IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate) throws IgniteCheckedException {
        long time = System.currentTimeMillis();
        try {
            this.log.info("Starting binary memory restore for: " + this.cctx.cache().cacheGroupDescriptors().keySet());
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.beforeBinaryMemoryRestore(this);
            }
            CheckpointStatus status = this.readCheckpointStatus();
            RestoreBinaryState binaryState = this.performBinaryMemoryRestore(status, cacheGroupsPredicate, recordTypePredicate, true);
            WALPointer restored = binaryState.lastReadRecordPointer();
            restored = restored.equals(CheckpointStatus.NULL_PTR) ? null : restored.next();
            if (restored == null && !status.endPtr.equals(CheckpointStatus.NULL_PTR)) {
                throw new StorageException("The memory cannot be restored. The critical part of WAL archive is missing [tailWalPtr=" + restored + ", endPtr=" + status.endPtr + ']');
            }
            if (restored != null) {
                U.log(this.log, "Binary memory state restored at node startup [restoredPtr=" + restored + ']');
            }
            this.cctx.wal().resumeLogging(restored);
            this.checkpointManager.memoryRecoveryRecordPtr(this.cctx.wal().log(new MemoryRecoveryRecord(U.currentTimeMillis())));
            for (DatabaseLifecycleListener lsnr : this.getDatabaseListeners(this.cctx.kernalContext())) {
                lsnr.afterBinaryMemoryRestore(this, binaryState);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Binary recovery performed in " + (System.currentTimeMillis() - time) + " ms.");
            }
            return binaryState;
        }
        catch (IgniteCheckedException e) {
            if (X.hasCause((Throwable)e, StorageException.class, IOException.class)) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
            throw e;
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        if (this.defrgMgr != null) {
            this.defrgMgr.cancel();
        }
        this.checkpointManager.stop(cancel);
        super.onKernalStop0(cancel);
        this.unregisterMetricsMBean(this.cctx.gridConfig(), MBEAN_GROUP, MBEAN_NAME);
        this.metaStorage = null;
    }

    @Override
    protected void stop0(boolean cancel) {
        super.stop0(cancel);
        this.releaseFileLock();
    }

    private long[] calculateFragmentSizes(int concLvl, long cacheSize, long chpBufSize) {
        long fragmentSize;
        if (concLvl < 2) {
            concLvl = Runtime.getRuntime().availableProcessors();
        }
        if ((fragmentSize = cacheSize / (long)concLvl) < 0x100000L) {
            fragmentSize = 0x100000L;
        }
        long[] sizes = new long[concLvl + 1];
        for (int i = 0; i < concLvl; ++i) {
            sizes[i] = fragmentSize;
        }
        sizes[concLvl] = chpBufSize;
        return sizes;
    }

    @Override
    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, final boolean trackable, PageReadWriteManager pmPageMgr) {
        if (!plcCfg.isPersistenceEnabled()) {
            return super.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, trackable, pmPageMgr);
        }
        memMetrics.persistenceEnabled(true);
        long cacheSize = plcCfg.getMaxSize();
        long chpBufSize = IgniteUtils.checkpointBufferSize(plcCfg);
        if (chpBufSize > cacheSize) {
            U.quietAndInfo(this.log, "Configured checkpoint page buffer size is too big, setting to the max region size [size=" + U.readableSize(cacheSize, false) + ",  memPlc=" + plcCfg.getName() + ']');
            chpBufSize = cacheSize;
        }
        GridInClosure3X<Long, FullPageId, PageMemoryEx> changeTracker = trackable ? new GridInClosure3X<Long, FullPageId, PageMemoryEx>(){

            @Override
            public void applyx(Long page, FullPageId fullId, PageMemoryEx pageMem) throws IgniteCheckedException {
                if (trackable) {
                    GridCacheDatabaseSharedManager.this.snapshotMgr.onChangeTrackerPage(page, fullId, pageMem);
                }
            }
        } : null;
        PageMemoryImpl pageMem = new PageMemoryImpl(this.wrapMetricsPersistentMemoryProvider(memProvider, memMetrics), this.calculateFragmentSizes(memCfg.getConcurrencyLevel(), cacheSize, chpBufSize), this.cctx, pmPageMgr, memCfg.getPageSize(), (fullId, pageBuf, tag) -> {
            memMetrics.onPageWritten();
            this.snapshotMgr.beforePageWrite(fullId);
            pmPageMgr.write(fullId.groupId(), fullId.pageId(), pageBuf, tag, true);
            this.getCheckpointer().currentProgress().updateEvictedPages(1);
        }, changeTracker, this, memMetrics, this.resolveThrottlingPolicy(), () -> this.getCheckpointer().currentProgress());
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    private DirectMemoryProvider wrapMetricsPersistentMemoryProvider(final DirectMemoryProvider memoryProvider0, final DataRegionMetricsImpl memMetrics) {
        return new DirectMemoryProvider(){
            private final AtomicInteger checkPointBufferIdxCnt = new AtomicInteger();
            private final DirectMemoryProvider memProvider = memoryProvider0;

            @Override
            public void initialize(long[] chunkSizes) {
                this.memProvider.initialize(chunkSizes);
                this.checkPointBufferIdxCnt.set(chunkSizes.length);
            }

            @Override
            public void shutdown(boolean deallocate) {
                this.memProvider.shutdown(deallocate);
            }

            @Override
            public DirectMemoryRegion nextRegion() {
                DirectMemoryRegion nextMemoryRegion = this.memProvider.nextRegion();
                if (nextMemoryRegion == null) {
                    return null;
                }
                int idx = this.checkPointBufferIdxCnt.decrementAndGet();
                long chunkSize = nextMemoryRegion.size();
                if (idx != 0) {
                    memMetrics.updateOffHeapSize(chunkSize);
                } else {
                    memMetrics.updateCheckpointBufferSize(chunkSize);
                }
                return nextMemoryRegion;
            }
        };
    }

    @NotNull
    private PageMemoryImpl.ThrottlingPolicy resolveThrottlingPolicy() {
        PageMemoryImpl.ThrottlingPolicy plc;
        PageMemoryImpl.ThrottlingPolicy throttlingPolicy = plc = this.persistenceCfg.isWriteThrottlingEnabled() ? PageMemoryImpl.ThrottlingPolicy.SPEED_BASED : PageMemoryImpl.ThrottlingPolicy.CHECKPOINT_BUFFER_ONLY;
        if (this.throttlingPolicyOverride != null) {
            try {
                plc = PageMemoryImpl.ThrottlingPolicy.valueOf(this.throttlingPolicyOverride.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log.error("Incorrect value of IGNITE_OVERRIDE_WRITE_THROTTLING_ENABLED property. The default throttling policy will be used [plc=" + this.throttlingPolicyOverride + ", defaultPlc=" + (Object)((Object)plc) + ']');
            }
        }
        return plc;
    }

    @Override
    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (!regCfg.isPersistenceEnabled()) {
            super.checkRegionEvictionProperties(regCfg, dbCfg);
        } else if (regCfg.getPageEvictionMode() != DataPageEvictionMode.DISABLED) {
            U.warn(this.log, "Page eviction mode will have no effect because the oldest pages are evicted automatically if Ignite persistence is enabled: " + regCfg.getName());
        }
    }

    @Override
    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            try {
                assert (this.cctx.pageStore() instanceof FilePageStoreManager) : "Invalid page store manager was created: " + this.cctx.pageStore();
                Path anyIdxPartFile = IgniteUtils.searchFileRecursively(((FilePageStoreManager)this.cctx.pageStore()).workDir().toPath(), "index.bin");
                if (anyIdxPartFile != null) {
                    memCfg.setPageSize(this.resolvePageSizeFromPartitionFile(anyIdxPartFile));
                    return;
                }
            }
            catch (IOException | IllegalArgumentException | IgniteCheckedException e) {
                U.quietAndWarn(this.log, "Attempt to resolve pageSize from store files failed: " + e.getMessage());
                U.quietAndWarn(this.log, "Default page size will be used: 4096 bytes");
            }
            memCfg.setPageSize(4096);
        }
    }

    private int resolvePageSizeFromPartitionFile(Path partFile) throws IOException, IgniteCheckedException {
        FileIOFactory ioFactory = this.persistenceCfg.getFileIOFactory();
        try (FileIO fileIO = ioFactory.create(partFile.toFile());){
            int minimalHdr = 17;
            if (fileIO.size() < (long)minimalHdr) {
                throw new IgniteCheckedException("Partition file is too small: " + partFile);
            }
            ByteBuffer hdr = ByteBuffer.allocate(minimalHdr).order(ByteOrder.nativeOrder());
            fileIO.readFully(hdr);
            hdr.rewind();
            hdr.getLong();
            hdr.getInt();
            hdr.get();
            int pageSize = hdr.getInt();
            if (pageSize == 2048) {
                U.quietAndWarn(this.log, "You are currently using persistent store with 2K pages (DataStorageConfiguration#pageSize). If you use SSD disk, consider migrating to 4K pages for better IO performance.");
            }
            int n = pageSize;
            return n;
        }
    }

    @Override
    public void beforeExchange(GridDhtPartitionsExchangeFuture fut) throws IgniteCheckedException {
        if (fut.localJoinExchange() || fut.activateCluster() || fut.exchangeActions() != null && !F.isEmpty(fut.exchangeActions().cacheGroupsToStart())) {
            U.doInParallel(this.cctx.kernalContext().getSystemExecutorService(), this.cctx.cache().cacheGroups(), cacheGroup -> {
                if (cacheGroup.isLocal()) {
                    return null;
                }
                this.cctx.database().checkpointReadLock();
                try {
                    cacheGroup.offheap().restorePartitionStates(Collections.emptyMap());
                    if (cacheGroup.localStartVersion().equals(fut.initialVersion())) {
                        cacheGroup.topology().afterStateRestored(fut.initialVersion());
                    }
                    fut.timeBag().finishLocalStage("Restore partition states [grp=" + cacheGroup.cacheOrGroupName() + "]");
                }
                finally {
                    this.cctx.database().checkpointReadUnlock();
                }
                return null;
            });
            fut.timeBag().finishGlobalStage("Restore partition states");
        }
        if (this.cctx.kernalContext().query().moduleEnabled()) {
            this.cctx.kernalContext().query().beforeExchange(fut);
        }
    }

    @Override
    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture exchangeFut) {
        if (this.defrgMgr != null) {
            return;
        }
        Collection<GridCacheContext> rejected = this.rebuildIndexes(this.cctx.cacheContexts(), cacheCtx -> cacheCtx.startTopologyVersion().equals(exchangeFut.initialVersion()) && this.cctx.kernalContext().query().rebuildIndexOnExchange(cacheCtx.cacheId(), exchangeFut), false);
        if (!rejected.isEmpty()) {
            this.cctx.kernalContext().query().removeIndexRebuildFuturesOnExchange(exchangeFut, rejected.stream().map(GridCacheContext::cacheId).collect(Collectors.toSet()));
        }
    }

    @Override
    public Collection<GridCacheContext> forceRebuildIndexes(Collection<GridCacheContext> contexts) {
        Set<Integer> cacheIds = contexts.stream().map(GridCacheContext::cacheId).collect(Collectors.toSet());
        Set<Integer> rejected = this.cctx.kernalContext().query().prepareRebuildIndexes(cacheIds);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Preparing features of rebuilding indexes for caches on force rebuild [requested=" + cacheIds + ", rejected=" + rejected + ']');
        }
        this.rebuildIndexes(contexts, cacheCtx -> !rejected.contains(cacheCtx.cacheId()), true);
        return rejected.isEmpty() ? Collections.emptyList() : (Collection)contexts.stream().filter(ctx -> rejected.contains(ctx.cacheId())).collect(Collectors.toList());
    }

    private Collection<GridCacheContext> rebuildIndexes(Collection<GridCacheContext> contexts, Predicate<GridCacheContext> rebuildCond, boolean force) {
        GridQueryProcessor qryProc = this.cctx.kernalContext().query();
        if (!qryProc.moduleEnabled()) {
            return Collections.emptyList();
        }
        GridCountDownCallback rebuildIndexesCompleteCntr = new GridCountDownCallback(contexts.size(), () -> {
            if (this.log.isInfoEnabled()) {
                this.log.info("Indexes rebuilding completed for all caches.");
            }
        }, 1);
        ArrayList<GridCacheContext> rejected = null;
        for (GridCacheContext cacheCtx : contexts) {
            if (rebuildCond.test(cacheCtx)) {
                IgniteInternalFuture<?> rebuildFut = qryProc.rebuildIndexesFromHash(cacheCtx, force || !qryProc.rebuildIndexesCompleted(cacheCtx));
                if (rebuildFut != null) {
                    rebuildFut.listen(fut -> rebuildIndexesCompleteCntr.countDown(true));
                    continue;
                }
                rebuildIndexesCompleteCntr.countDown(false);
                continue;
            }
            if (rejected == null) {
                rejected = new ArrayList<GridCacheContext>();
            }
            rejected.add(cacheCtx);
        }
        return rejected == null ? Collections.emptyList() : rejected;
    }

    private String cacheInfo(GridCacheContext cacheCtx) {
        assert (Objects.nonNull(cacheCtx));
        return "name=" + cacheCtx.name() + ", grpName=" + cacheCtx.group().name();
    }

    @Override
    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
        HashMap<PageMemoryEx, Collection> destroyed = new HashMap<PageMemoryEx, Collection>();
        List<Integer> stoppedGrpIds = stoppedGrps.stream().filter(IgniteBiTuple::get2).map(t -> ((CacheGroupContext)t.get1()).groupId()).collect(Collectors.toList());
        this.cctx.snapshotMgr().onCacheGroupsStopped(stoppedGrpIds);
        this.initiallyLocWalDisabledGrps.removeAll(stoppedGrpIds);
        this.initiallyGlobalWalDisabledGrps.removeAll(stoppedGrpIds);
        for (IgniteBiTuple<CacheGroupContext, Boolean> tup : stoppedGrps) {
            CacheGroupContext cacheGroupContext = tup.get1();
            boolean destroy = tup.get2();
            int grpId2 = cacheGroupContext.groupId();
            DataRegion dataRegion = cacheGroupContext.dataRegion();
            if (dataRegion != null) {
                dataRegion.metrics().removeCacheGrpPageMetrics(grpId2);
            }
            if (!cacheGroupContext.persistenceEnabled()) continue;
            this.snapshotMgr.onCacheGroupStop(cacheGroupContext, destroy);
            PageMemoryEx pageMem = (PageMemoryEx)dataRegion.pageMemory();
            Collection grpIds = destroyed.computeIfAbsent(pageMem, k -> new HashSet());
            grpIds.add(grpId2);
            if (cacheGroupContext.config().isEncryptionEnabled()) {
                this.cctx.kernalContext().encryption().onCacheGroupStop(grpId2);
            }
            pageMem.onCacheGroupDestroyed(grpId2);
            if (!destroy) continue;
            this.cctx.kernalContext().encryption().onCacheGroupDestroyed(grpId2);
        }
        ArrayList<IgniteInternalFuture<Void>> clearFuts = new ArrayList<IgniteInternalFuture<Void>>(destroyed.size());
        for (Map.Entry entry : destroyed.entrySet()) {
            Collection grpIds = (Collection)entry.getValue();
            clearFuts.add(((PageMemoryEx)entry.getKey()).clearAsync((grpId, pageIdg) -> grpIds.contains(grpId), false));
        }
        for (IgniteInternalFuture igniteInternalFuture : clearFuts) {
            try {
                igniteInternalFuture.get();
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to clear page memory", e);
            }
        }
        if (this.cctx.pageStore() != null) {
            for (IgniteBiTuple igniteBiTuple : stoppedGrps) {
                CacheGroupContext grp = (CacheGroupContext)igniteBiTuple.get1();
                try {
                    this.cctx.pageStore().shutdownForCacheGroup(grp, (Boolean)igniteBiTuple.get2());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to gracefully clean page store resources for destroyed cache [cache=" + grp.cacheOrGroupName() + "]", e);
                }
            }
        }
    }

    @Override
    public void checkpointReadLock() {
        this.checkpointManager.checkpointTimeoutLock().checkpointReadLock();
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return this.checkpointManager.checkpointTimeoutLock().checkpointLockIsHeldByThread();
    }

    @Override
    public void checkpointReadUnlock() {
        this.checkpointManager.checkpointTimeoutLock().checkpointReadUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        Map<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> earliestValidCheckpoints;
        assert (this.reservedForExchange == null) : this.reservedForExchange;
        Map<Integer, Set<Integer>> applicableGroupsAndPartitions = this.partitionsApplicableForWalRebalance();
        this.checkpointReadLock();
        try {
            CheckpointHistoryResult checkpointHistoryResult = this.checkpointHistory().searchAndReserveCheckpoints(applicableGroupsAndPartitions);
            earliestValidCheckpoints = checkpointHistoryResult.earliestValidCheckpoints();
            if (checkpointHistoryResult.reservedCheckoint() != null) {
                this.reservedForExchange = checkpointHistoryResult.reservedCheckoint().checkpointMark();
            }
        }
        finally {
            this.checkpointReadUnlock();
        }
        HashMap<Integer, Map<Integer, Long>> grpPartsWithCnts = new HashMap<Integer, Map<Integer, Long>>();
        for (Map.Entry<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> e : earliestValidCheckpoints.entrySet()) {
            int grpId = e.getKey();
            if (e.getValue().get2() == null) continue;
            for (Map.Entry e0 : ((Map)e.getValue().get2()).entrySet()) {
                CheckpointEntry cpEntry = (CheckpointEntry)e0.getValue();
                int partId = (Integer)e0.getKey();
                assert (this.cctx.wal().reserved(cpEntry.checkpointMark())) : "WAL segment for checkpoint " + cpEntry + " has not reserved";
                try {
                    Long updCntr = cpEntry.partitionCounter(this.cctx.wal(), grpId, partId);
                    if (updCntr == null) continue;
                    grpPartsWithCnts.computeIfAbsent(grpId, k -> new HashMap()).put(partId, updCntr);
                }
                catch (IgniteCheckedException ex) {
                    this.log.warning("Reservation failed because counters are not available [grpId=" + grpId + ", part=" + partId + ", cp=(" + cpEntry.checkpointId() + ", " + U.format(cpEntry.timestamp()) + ")]", ex);
                }
            }
        }
        if (this.log.isInfoEnabled() && !F.isEmpty(earliestValidCheckpoints)) {
            this.printReservationToLog(earliestValidCheckpoints);
        }
        return grpPartsWithCnts;
    }

    private void printReservationToLog(Map<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> earliestValidCheckpoints) {
        try {
            HashMap<ReservationReason, List> notReservedCachesToPrint = new HashMap<ReservationReason, List>();
            HashMap<ReservationReason, List> reservedCachesToPrint = new HashMap<ReservationReason, List>();
            for (Map.Entry<Integer, T2<ReservationReason, Map<Integer, CheckpointEntry>>> entry2 : earliestValidCheckpoints.entrySet()) {
                if (entry2.getValue().get2() == null) {
                    notReservedCachesToPrint.computeIfAbsent((ReservationReason)((Object)entry2.getValue().get1()), reason -> new ArrayList()).add(entry2.getKey());
                    continue;
                }
                reservedCachesToPrint.computeIfAbsent((ReservationReason)((Object)entry2.getValue().get1()), reason -> new ArrayList()).add(new T2<Integer, CheckpointEntry>(entry2.getKey(), ((Map)entry2.getValue().get2()).values().stream().min(Comparator.comparingLong(CheckpointEntry::timestamp)).get()));
            }
            if (!F.isEmpty(notReservedCachesToPrint)) {
                this.log.info("Cache groups were not reserved [" + notReservedCachesToPrint.entrySet().stream().map(entry -> '[' + ((List)entry.getValue()).stream().map(grpId -> "[grpId=" + grpId + ", grpName=" + this.cctx.cache().cacheGroup((int)grpId).cacheOrGroupName() + ']').collect(Collectors.joining(", ")) + ", reason=" + entry.getKey() + ']').collect(Collectors.joining(", ")) + ']');
            }
            if (!F.isEmpty(reservedCachesToPrint)) {
                this.log.info("Cache groups with earliest reserved checkpoint and a reason why a previous checkpoint was inapplicable: [" + reservedCachesToPrint.entrySet().stream().map(entry -> '[' + ((List)entry.getValue()).stream().map(grpCp -> "[grpId=" + grpCp.get1() + ", grpName=" + this.cctx.cache().cacheGroup((Integer)grpCp.get1()).cacheOrGroupName() + ", cp=(" + ((CheckpointEntry)grpCp.get2()).checkpointId() + ", " + U.format(((CheckpointEntry)grpCp.get2()).timestamp()) + ")]").collect(Collectors.joining(", ")) + ", reason=" + entry.getKey() + ']').collect(Collectors.joining(", ")) + ']');
            }
        }
        catch (Exception e) {
            this.log.error("An error happened during printing partitions that were reserved for potential historical rebalance.", e);
        }
    }

    private Map<Integer, Set<Integer>> partitionsApplicableForWalRebalance() {
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>();
        for (CacheGroupContext grp : this.cctx.cache().cacheGroups()) {
            if (grp.isLocal()) continue;
            for (GridDhtLocalPartition locPart : grp.topology().currentLocalPartitions()) {
                if (locPart.state() != GridDhtPartitionState.OWNING || !this.preferWalRebalance() && locPart.fullSize() <= (long)this.walRebalanceThreshold) continue;
                res.computeIfAbsent(grp.groupId(), k -> new HashSet()).add(locPart.id());
            }
        }
        return res;
    }

    @Override
    public synchronized void releaseHistoryForExchange() {
        if (this.reservedForExchange == null) {
            return;
        }
        assert (this.cctx.wal().reserved(this.reservedForExchange)) : "Earliest checkpoint WAL pointer is not reserved for exchange: " + this.reservedForExchange;
        try {
            this.cctx.wal().release(this.reservedForExchange);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to release earliest checkpoint WAL pointer: " + this.reservedForExchange, e);
        }
        this.reservedForExchange = null;
    }

    @Override
    public boolean reserveHistoryForPreloading(Map<T2<Integer, Integer>, Long> reservationMap) {
        Map<GroupPartitionId, CheckpointEntry> entries = this.checkpointHistory().searchCheckpointEntry(reservationMap);
        if (F.isEmpty(entries)) {
            return false;
        }
        WALPointer oldestWALPointerToReserve = null;
        for (GroupPartitionId key : entries.keySet()) {
            WALPointer ptr = entries.get(key).checkpointMark();
            if (ptr == null) {
                return false;
            }
            if (oldestWALPointerToReserve != null && ptr.compareTo(oldestWALPointerToReserve) >= 0) continue;
            oldestWALPointerToReserve = ptr;
        }
        if (this.cctx.wal().reserve(oldestWALPointerToReserve)) {
            this.reservedForPreloading = oldestWALPointerToReserve;
            return true;
        }
        return false;
    }

    @Override
    public void releaseHistoryForPreloading() {
        this.releaseHistForPreloadingLock.lock();
        try {
            if (this.reservedForPreloading != null) {
                this.cctx.wal().release(this.reservedForPreloading);
                this.reservedForPreloading = null;
            }
        }
        catch (IgniteCheckedException ex) {
            U.error(this.log, "Could not release WAL reservation", ex);
            throw new IgniteException(ex);
        }
        finally {
            this.releaseHistForPreloadingLock.unlock();
        }
    }

    @Override
    public WALPointer latestWalPointerReservedForPreloading() {
        return this.reservedForPreloading;
    }

    @Override
    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        CheckpointProgress progress = this.checkpointManager.forceCheckpoint(reason, null);
        if (progress != null) {
            return progress.futureFor(CheckpointState.LOCK_RELEASED);
        }
        return null;
    }

    @Override
    public <R> void waitForCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) throws IgniteCheckedException {
        CheckpointProgress progress = this.checkpointManager.forceCheckpoint(reason, lsnr);
        if (progress == null) {
            return;
        }
        progress.futureFor(CheckpointState.FINISHED).get();
    }

    @Override
    public CheckpointProgress forceCheckpoint(String reason) {
        return this.checkpointManager.forceCheckpoint(reason, null);
    }

    @Override
    public <R> CheckpointProgress forceNewCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        A.notNull(lsnr, "lsnr");
        return this.checkpointManager.forceCheckpoint(reason, lsnr);
    }

    @Override
    public WALPointer lastCheckpointMarkWalPointer() {
        CheckpointEntry lastCheckpointEntry = this.checkpointHistory() == null ? null : this.checkpointHistory().lastCheckpoint();
        return lastCheckpointEntry == null ? null : lastCheckpointEntry.checkpointMark();
    }

    public File checkpointDirectory() {
        return this.checkpointManager.checkpointDirectory();
    }

    public void addCheckpointListener(CheckpointListener lsnr, DataRegion dataRegion) {
        this.checkpointManager.addCheckpointListener(lsnr, dataRegion);
    }

    public void addCheckpointListener(CheckpointListener lsnr) {
        this.checkpointManager.addCheckpointListener(lsnr, null);
    }

    public void removeCheckpointListener(CheckpointListener lsnr) {
        this.checkpointManager.removeCheckpointListener(lsnr);
    }

    private CheckpointStatus readCheckpointStatus() throws IgniteCheckedException {
        return this.checkpointManager.readCheckpointStatus();
    }

    @Override
    public void startMemoryRestore(GridKernalContext kctx, TimeBag startTimer) throws IgniteCheckedException {
        RestoreLogicalState logicalState;
        if (kctx.clientNode()) {
            return;
        }
        MaintenanceRegistry mntcRegistry = kctx.maintenanceRegistry();
        MaintenanceTask mntcTask = mntcRegistry.activeMaintenanceTask("corrupted-cache-data-files-task");
        if (mntcTask != null) {
            this.log.warning("Maintenance task found, stop restoring memory");
            File workDir = ((FilePageStoreManager)this.cctx.pageStore()).workDir();
            mntcRegistry.registerWorkflowCallback("corrupted-cache-data-files-task", new CorruptedPdsMaintenanceCallback(workDir, Arrays.asList(mntcTask.parameters().split(Pattern.quote(File.separator)))));
            return;
        }
        this.checkpointReadLock();
        try {
            this.initAndStartRegions(kctx.config().getDataStorageConfiguration());
            startTimer.finishGlobalStage("Init and start regions");
            this.restoreBinaryMemory(this.groupsWithEnabledWal(), this.physicalRecords());
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after BINARY RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore binary memory");
            CheckpointStatus status = this.readCheckpointStatus();
            logicalState = this.applyLogicalUpdates(status, this.groupsWithEnabledWal(), this.logicalRecords(), false);
            this.cctx.tm().clearUncommitedStates();
            if (this.recoveryVerboseLogging && this.log.isInfoEnabled()) {
                this.log.info("Partition states information after LOGICAL RECOVERY phase:");
                GridCacheDatabaseSharedManager.dumpPartitionsInfo(this.cctx, this.log);
            }
            startTimer.finishGlobalStage("Restore logical state");
        }
        catch (IgniteCheckedException e) {
            this.releaseFileLock();
            throw e;
        }
        finally {
            this.checkpointReadUnlock();
        }
        this.walTail = this.tailPointer(logicalState);
        this.cctx.wal().onDeActivate(kctx);
    }

    public void resumeWalLogging() throws IgniteCheckedException {
        this.cctx.wal().resumeLogging(this.walTail);
    }

    public void preserveWalTailPointer() throws IgniteCheckedException {
        this.walTail = this.cctx.wal().flush(null, true);
    }

    public PageStore getPageStore(int grpId, int partId) throws IgniteCheckedException {
        return this.storeMgr.getStore(grpId, partId);
    }

    public long forGroupPageStores(CacheGroupContext gctx, ToLongFunction<PageStore> f) {
        int groupId = gctx.groupId();
        long res = 0L;
        try {
            Collection<PageStore> stores = this.storeMgr.getStores(groupId);
            if (stores != null) {
                for (PageStore store : stores) {
                    res += f.applyAsLong(store);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        return res;
    }

    private WALPointer tailPointer(RestoreLogicalState logicalState) throws IgniteCheckedException {
        WALPointer lastFlushPtr = this.cctx.wal().flush(null, true);
        WALPointer lastReadPtr = logicalState.lastReadRecordPointer();
        if (lastFlushPtr != null && lastReadPtr == null) {
            return lastFlushPtr;
        }
        if (lastFlushPtr == null && lastReadPtr != null) {
            return lastReadPtr;
        }
        if (lastFlushPtr != null && lastReadPtr != null) {
            return lastReadPtr.compareTo(lastFlushPtr) >= 0 ? lastReadPtr : lastFlushPtr;
        }
        return null;
    }

    @Override
    public void onStateRestored(AffinityTopologyVersion topVer) throws IgniteCheckedException {
        this.checkpointManager.start();
        CheckpointProgress chp = this.checkpointManager.forceCheckpoint("node started", null);
        if (chp != null) {
            chp.futureFor(CheckpointState.LOCK_RELEASED).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreBinaryState performBinaryMemoryRestore(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean finalizeState) throws IgniteCheckedException {
        WALPointer recPtr;
        block21: {
            if (this.log.isInfoEnabled()) {
                this.log.info("Checking memory state [lastValidPos=" + status.endPtr + ", lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
            }
            recPtr = status.endPtr;
            boolean apply = status.needRestoreMemory();
            try {
                WALRecord startRec;
                WALRecord wALRecord = startRec = !CheckpointStatus.NULL_PTR.equals(status.startPtr) || apply ? this.cctx.wal().read(status.startPtr) : null;
                if (apply) {
                    if (finalizeState) {
                        U.quietAndWarn(this.log, "Ignite node stopped in the middle of checkpoint. Will restore memory state and finish checkpoint on node start.");
                    }
                    this.cctx.cache().cacheGroupDescriptors().forEach((grpId, desc) -> {
                        if (!cacheGroupsPredicate.apply((Integer)grpId)) {
                            return;
                        }
                        try {
                            DataRegion region = this.cctx.database().dataRegion(desc.config().getDataRegionName());
                            if (region == null || !this.cctx.isLazyMemoryAllocation(region)) {
                                return;
                            }
                            region.pageMemory().start();
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                    });
                    this.cctx.pageStore().beginRecover();
                    if (!(startRec instanceof CheckpointRecord)) {
                        throw new StorageException("Checkpoint marker doesn't point to checkpoint record [ptr=" + status.startPtr + ", rec=" + startRec + "]");
                    }
                    WALPointer cpMark = ((CheckpointRecord)startRec).checkpointMark();
                    if (cpMark != null) {
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Restoring checkpoint after logical recovery, will start physical recovery from back pointer: " + cpMark);
                        }
                        recPtr = cpMark;
                    }
                    break block21;
                }
                this.cctx.wal().notchLastCheckpointPtr(status.startPtr);
            }
            catch (NoSuchElementException e) {
                throw new StorageException("Failed to read checkpoint record from WAL, persistence consistency cannot be guaranteed. Make sure configuration points to correct WAL folders and WAL folder is properly mounted [ptr=" + status.startPtr + ", walPath=" + this.persistenceCfg.getWalPath() + ", walArchive=" + this.persistenceCfg.getWalArchivePath() + "]");
            }
        }
        AtomicReference<Throwable> applyError = new AtomicReference<Throwable>();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        long start = U.currentTimeMillis();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        WALIterator it = this.cctx.wal().replay(recPtr, recordTypePredicate);
        RestoreBinaryState restoreBinaryState = new RestoreBinaryState(status, it, lastArchivedSegment, cacheGroupsPredicate);
        AtomicLong applied = new AtomicLong();
        try {
            WALRecord rec;
            block10: while (it.hasNextX() && applyError.get() == null && (rec = restoreBinaryState.next()) != null) {
                switch (rec.type()) {
                    case PAGE_RECORD: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate()) continue block10;
                        PageSnapshot pageSnapshot = (PageSnapshot)rec;
                        int groupId = pageSnapshot.fullPageId().groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageSnapshot.fullPageId().pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageSnapshot((PageMemoryEx)pageMem, pageSnapshot);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page snapshot. rec=[" + pageSnapshot + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page snapshot", t));
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        int groupId = metaStateRecord.groupId();
                        int partId = metaStateRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            GridDhtPartitionState state = GridDhtPartitionState.fromOrdinal(metaStateRecord.state());
                            if (state == null || state == GridDhtPartitionState.EVICTED) {
                                this.schedulePartitionDestroy(groupId, partId);
                            } else {
                                try {
                                    this.cancelOrWaitPartitionDestroy(groupId, partId);
                                }
                                catch (Throwable t) {
                                    U.error(this.log, "Failed to cancel or wait partition destroy. rec=[" + metaStateRecord + ']');
                                    applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to cancel or wait partition destroy", t));
                                }
                            }
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    case PARTITION_DESTROY: {
                        PartitionDestroyRecord destroyRecord = (PartitionDestroyRecord)rec;
                        int groupId = destroyRecord.groupId();
                        int partId = destroyRecord.partitionId();
                        this.stripedApplyPage(pageMem -> {
                            pageMem.invalidate(groupId, partId);
                            this.schedulePartitionDestroy(groupId, partId);
                        }, groupId, partId, exec, semaphore);
                        break;
                    }
                    default: {
                        int partId;
                        if (!restoreBinaryState.needApplyBinaryUpdate() || !(rec instanceof PageDeltaRecord)) continue block10;
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        int groupId = pageDelta.groupId();
                        if (this.skipRemovedIndexUpdates(groupId, partId = PageIdUtils.partId(pageDelta.pageId()))) break;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, true);
                                applied.incrementAndGet();
                            }
                            catch (Throwable t) {
                                U.error(this.log, "Failed to apply page delta. rec=[" + pageDelta + ']');
                                applyError.compareAndSet(null, t instanceof IgniteCheckedException ? (IgniteCheckedException)t : new IgniteCheckedException("Failed to apply page delta", t));
                            }
                        }, groupId, partId, exec, semaphore);
                    }
                }
            }
        }
        finally {
            it.close();
            this.awaitApplyComplete(exec, applyError);
        }
        if (!finalizeState) {
            return null;
        }
        WALPointer lastReadPtr = restoreBinaryState.lastReadRecordPointer();
        if (status.needRestoreMemory()) {
            if (restoreBinaryState.needApplyBinaryUpdate()) {
                throw new StorageException("Failed to restore memory state (checkpoint marker is present on disk, but checkpoint record is missed in WAL) [cpStatus=" + status + ", lastRead=" + lastReadPtr + "]");
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Finished applying memory changes [changesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
            }
            this.finalizeCheckpointOnRecovery(status.cpStartTs, status.cpStartId, status.startPtr, exec);
        }
        return restoreBinaryState;
    }

    private int semaphorePertmits(StripedExecutor exec) {
        int permits = exec.stripesCount() * 4;
        long maxMemory = Runtime.getRuntime().maxMemory();
        int permits0 = (int)((double)maxMemory * 0.2 / 8192.0);
        if (permits0 < permits) {
            permits = permits0;
        }
        return IgniteSystemProperties.getInteger("IGNITE_RECOVERY_SEMAPHORE_PERMITS", permits);
    }

    private void awaitApplyComplete(StripedExecutor exec, AtomicReference<Throwable> applyError) throws IgniteCheckedException {
        try {
            exec.awaitComplete(new int[0]);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        Throwable error = applyError.get();
        if (error != null) {
            throw error instanceof IgniteCheckedException ? (IgniteCheckedException)error : new IgniteCheckedException(error);
        }
    }

    public void stripedApplyPage(Consumer<PageMemoryEx> consumer, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) throws IgniteCheckedException {
        assert (consumer != null);
        assert (exec != null);
        assert (semaphore != null);
        PageMemoryEx pageMem = this.getPageMemoryForCacheGroup(grpId);
        if (pageMem == null) {
            return;
        }
        this.stripedApply(() -> consumer.accept(pageMem), grpId, partId, exec, semaphore);
    }

    public void stripedApply(Runnable run, int grpId, int partId, StripedExecutor exec, Semaphore semaphore) {
        assert (run != null);
        assert (exec != null);
        assert (semaphore != null);
        int stripes = exec.stripesCount();
        int stripe = U.stripeIdx(stripes, grpId, partId);
        assert (stripe >= 0 && stripe <= stripes) : "idx=" + stripe + ", stripes=" + stripes;
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        exec.execute(stripe, () -> {
            CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(1);
            try {
                run.run();
            }
            finally {
                CheckpointReadWriteLock.CHECKPOINT_LOCK_HOLD_COUNT.set(0);
                semaphore.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyPageSnapshot(PageMemoryEx pageMem, PageSnapshot pageSnapshotRecord) throws IgniteCheckedException {
        int grpId = pageSnapshotRecord.fullPageId().groupId();
        long pageId = pageSnapshotRecord.fullPageId().pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, true);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, true);
            try {
                PageUtils.putBytes(pageAddr, 0, pageSnapshotRecord.pageData());
                if (PageIO.getCompressionType(pageAddr) != 0) {
                    int realPageSize = pageMem.realPageSize(pageSnapshotRecord.groupId());
                    assert (pageSnapshotRecord.pageDataSize() <= realPageSize) : pageSnapshotRecord.pageDataSize();
                    this.cctx.kernalContext().compress().decompressPage(pageMem.pageBuffer(pageAddr), realPageSize);
                }
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, true);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPageDelta(PageMemoryEx pageMem, PageDeltaRecord pageDeltaRecord, boolean restore) throws IgniteCheckedException {
        int grpId = pageDeltaRecord.groupId();
        long pageId = pageDeltaRecord.pageId();
        long page = pageMem.acquirePage(grpId, pageId, IoStatisticsHolderNoOp.INSTANCE, restore);
        try {
            long pageAddr = pageMem.writeLock(grpId, pageId, page, restore);
            try {
                pageDeltaRecord.applyDelta(pageMem, pageAddr);
            }
            finally {
                pageMem.writeUnlock(grpId, pageId, page, null, true, restore);
            }
        }
        finally {
            pageMem.releasePage(grpId, pageId, page);
        }
    }

    private boolean skipRemovedIndexUpdates(int grpId, int partId) {
        return partId == 65535 && !this.storeMgr.hasIndexStore(grpId);
    }

    private PageMemoryEx getPageMemoryForCacheGroup(int grpId) throws IgniteCheckedException {
        if (grpId == MetaStorage.METASTORAGE_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion(METASTORE_DATA_REGION_NAME).pageMemory();
        }
        if (grpId == TxLog.TX_LOG_CACHE_ID) {
            return (PageMemoryEx)this.dataRegion("TxLog").pageMemory();
        }
        GridCacheSharedContext sharedCtx = this.context();
        CacheGroupDescriptor desc = sharedCtx.cache().cacheGroupDescriptors().get(grpId);
        if (desc == null) {
            return null;
        }
        String memPlcName = desc.config().getDataRegionName();
        return (PageMemoryEx)sharedCtx.database().dataRegion(memPlcName).pageMemory();
    }

    public void applyUpdatesOnRecovery(@Nullable WALIterator it, IgniteBiPredicate<WALPointer, WALRecord> recPredicate, IgnitePredicate<DataEntry> entryPredicate) throws IgniteCheckedException {
        if (it == null) {
            return;
        }
        this.cctx.walState().runWithOutWAL(() -> {
            block15: while (it.hasNext()) {
                IgniteBiTuple next = (IgniteBiTuple)it.next();
                WALRecord rec = (WALRecord)next.get2();
                if (!recPredicate.apply((WALPointer)next.get1(), rec)) break;
                switch (rec.type()) {
                    case MVCC_DATA_RECORD: 
                    case DATA_RECORD: {
                        this.checkpointReadLock();
                        try {
                            DataRecord dataRec = (DataRecord)rec;
                            for (DataEntry dataEntry : dataRec.writeEntries()) {
                                if (!entryPredicate.apply(dataEntry)) continue;
                                this.checkpointReadLock();
                                try {
                                    int cacheId = dataEntry.cacheId();
                                    GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                    if (cacheCtx != null) {
                                        this.applyUpdate(cacheCtx, dataEntry);
                                        continue;
                                    }
                                    if (this.log == null) continue;
                                    this.log.warning("Cache is not started. Updates cannot be applied [cacheId=" + cacheId + ']');
                                }
                                finally {
                                    this.checkpointReadUnlock();
                                }
                            }
                            continue block15;
                        }
                        catch (IgniteCheckedException e) {
                            throw new IgniteException(e);
                        }
                        finally {
                            this.checkpointReadUnlock();
                            continue block15;
                        }
                    }
                    case MVCC_TX_RECORD: {
                        this.checkpointReadLock();
                        try {
                            MvccTxRecord txRecord = (MvccTxRecord)rec;
                            byte txState = this.convertToTxState(txRecord.state());
                            this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                            continue block15;
                        }
                        finally {
                            this.checkpointReadUnlock();
                            continue block15;
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestoreLogicalState applyLogicalUpdates(CheckpointStatus status, IgnitePredicate<Integer> cacheGroupsPredicate, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordTypePredicate, boolean restoreMeta) throws IgniteCheckedException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Applying lost " + (restoreMeta ? "metastore" : "cache") + " updates since last checkpoint record [lastMarked=" + status.startPtr + ", lastCheckpointId=" + status.cpStartId + ']');
        }
        if (!restoreMeta) {
            this.cctx.kernalContext().query().skipFieldLookup(true);
        }
        long start = U.currentTimeMillis();
        AtomicReference<Throwable> applyError = new AtomicReference<Throwable>();
        AtomicLong applied = new AtomicLong();
        long lastArchivedSegment = this.cctx.wal().lastArchivedSegment();
        StripedExecutor exec = this.cctx.kernalContext().getStripedExecutorService();
        Semaphore semaphore = new Semaphore(this.semaphorePertmits(exec));
        HashMap<GroupPartitionId, Integer> partitionRecoveryStates = new HashMap<GroupPartitionId, Integer>();
        WALIterator it = this.cctx.wal().replay(status.startPtr, recordTypePredicate);
        RestoreLogicalState restoreLogicalState = new RestoreLogicalState(status, it, lastArchivedSegment, cacheGroupsPredicate, partitionRecoveryStates);
        IgniteTxManager txManager = this.cctx.tm();
        try {
            WALRecord rec;
            block15: while (it.hasNextX() && (rec = restoreLogicalState.next()) != null) {
                switch (rec.type()) {
                    case TX_RECORD: {
                        if (!restoreMeta) break;
                        TxRecord txRec = (TxRecord)rec;
                        txManager.collectTxStates(txRec);
                        break;
                    }
                    case CHECKPOINT_RECORD: {
                        CheckpointRecord cpRec = (CheckpointRecord)rec;
                        for (Map.Entry<Integer, CacheState> entry : cpRec.cacheGroupStates().entrySet()) {
                            CacheState cacheState = entry.getValue();
                            for (int i = 0; i < cacheState.size(); ++i) {
                                int partId = cacheState.partitionByIndex(i);
                                byte state = cacheState.stateByIndex(i);
                                if (state == -1) continue;
                                partitionRecoveryStates.put(new GroupPartitionId(entry.getKey(), partId), Integer.valueOf(state));
                            }
                        }
                        continue block15;
                    }
                    case ROLLBACK_TX_RECORD: {
                        RollbackRecord rbRec = (RollbackRecord)rec;
                        CacheGroupContext ctx = this.cctx.cache().cacheGroup(rbRec.groupId());
                        if (ctx == null || ctx.isLocal()) break;
                        ctx.topology().forceCreatePartition(rbRec.partitionId());
                        ctx.offheap().onPartitionInitialCounterUpdated(rbRec.partitionId(), rbRec.start(), rbRec.range());
                        break;
                    }
                    case MVCC_DATA_RECORD: 
                    case DATA_RECORD: 
                    case ENCRYPTED_DATA_RECORD: 
                    case ENCRYPTED_DATA_RECORD_V2: {
                        DataRecord dataRec = (DataRecord)rec;
                        for (DataEntry dataEntry : dataRec.writeEntries()) {
                            if (!restoreMeta && txManager.uncommitedTx(dataEntry)) continue;
                            int cacheId = dataEntry.cacheId();
                            DynamicCacheDescriptor cacheDesc = this.cctx.cache().cacheDescriptor(cacheId);
                            if (cacheDesc == null) continue;
                            this.stripedApply(() -> {
                                GridCacheContext cacheCtx = this.cctx.cacheContext(cacheId);
                                if (this.skipRemovedIndexUpdates(cacheCtx.groupId(), 65535)) {
                                    this.cctx.kernalContext().query().markAsRebuildNeeded(cacheCtx, true);
                                }
                                try {
                                    this.applyUpdate(cacheCtx, dataEntry);
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(this.log, "Failed to apply data entry, dataEntry=" + dataEntry + ", ptr=" + dataRec.position());
                                    applyError.compareAndSet(null, e);
                                }
                                applied.incrementAndGet();
                            }, cacheDesc.groupId(), dataEntry.partitionId(), exec, semaphore);
                        }
                        continue block15;
                    }
                    case MVCC_TX_RECORD: {
                        MvccTxRecord txRecord = (MvccTxRecord)rec;
                        byte txState = this.convertToTxState(txRecord.state());
                        this.cctx.coordinators().updateState(txRecord.mvccVersion(), txState, true);
                        break;
                    }
                    case PART_META_UPDATE_STATE: {
                        PartitionMetaStateRecord metaStateRecord = (PartitionMetaStateRecord)rec;
                        GroupPartitionId groupPartitionId = new GroupPartitionId(metaStateRecord.groupId(), metaStateRecord.partitionId());
                        restoreLogicalState.partitionRecoveryStates.put(groupPartitionId, Integer.valueOf(metaStateRecord.state()));
                        break;
                    }
                    case METASTORE_DATA_RECORD: {
                        MetastoreDataRecord metastoreDataRecord = (MetastoreDataRecord)rec;
                        this.metaStorage.applyUpdate(metastoreDataRecord.key(), metastoreDataRecord.value());
                        break;
                    }
                    case META_PAGE_UPDATE_NEXT_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_SUCCESSFUL_FULL_SNAPSHOT_ID: 
                    case META_PAGE_UPDATE_LAST_ALLOCATED_INDEX: {
                        PageDeltaRecord pageDelta = (PageDeltaRecord)rec;
                        this.stripedApplyPage(pageMem -> {
                            try {
                                this.applyPageDelta((PageMemoryEx)pageMem, pageDelta, false);
                            }
                            catch (IgniteCheckedException e) {
                                U.error(this.log, "Failed to apply page delta, " + pageDelta);
                                applyError.compareAndSet(null, e);
                            }
                        }, pageDelta.groupId(), PageIdUtils.partId(pageDelta.pageId()), exec, semaphore);
                        break;
                    }
                    case MASTER_KEY_CHANGE_RECORD_V2: {
                        this.cctx.kernalContext().encryption().applyKeys((MasterKeyChangeRecordV2)rec);
                        break;
                    }
                    case REENCRYPTION_START_RECORD: {
                        this.cctx.kernalContext().encryption().applyReencryptionStartRecord((ReencryptionStartRecord)rec);
                        break;
                    }
                }
            }
        }
        finally {
            it.close();
            if (!restoreMeta) {
                this.cctx.kernalContext().query().skipFieldLookup(false);
            }
        }
        this.awaitApplyComplete(exec, applyError);
        if (this.log.isInfoEnabled()) {
            this.log.info("Finished applying WAL changes [updatesApplied=" + applied + ", time=" + (U.currentTimeMillis() - start) + " ms]");
        }
        Iterator<DatabaseLifecycleListener> iterator = this.getDatabaseListeners(this.cctx.kernalContext()).iterator();
        while (iterator.hasNext()) {
            DatabaseLifecycleListener lsnr = iterator.next();
            lsnr.afterLogicalUpdatesApplied(this, restoreLogicalState);
        }
        return restoreLogicalState;
    }

    private byte convertToTxState(TransactionState state) {
        switch (state) {
            case PREPARED: {
                return 1;
            }
            case COMMITTED: {
                return 3;
            }
            case ROLLED_BACK: {
                return 2;
            }
        }
        throw new IllegalStateException("Unsupported TxState.");
    }

    public void onWalTruncated(@Nullable WALPointer highBound) throws IgniteCheckedException {
        this.checkpointManager.removeCheckpointsUntil(highBound);
    }

    private void applyUpdate(GridCacheContext cacheCtx, DataEntry dataEntry) throws IgniteCheckedException {
        int partId = dataEntry.partitionId();
        if (partId == -1) {
            partId = cacheCtx.affinity().partition(dataEntry.key());
        }
        GridDhtLocalPartition locPart = cacheCtx.isLocal() ? null : cacheCtx.topology().forceCreatePartition(partId);
        switch (dataEntry.op()) {
            case CREATE: 
            case UPDATE: {
                if (dataEntry instanceof MvccDataEntry) {
                    cacheCtx.offheap().mvccApplyUpdate(cacheCtx, dataEntry.key(), dataEntry.value(), dataEntry.writeVersion(), dataEntry.expireTime(), locPart, ((MvccDataEntry)dataEntry).mvccVer());
                } else {
                    cacheCtx.offheap().update(cacheCtx, dataEntry.key(), dataEntry.value(), dataEntry.writeVersion(), dataEntry.expireTime(), locPart, null);
                }
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter() - 1L, 1L);
                break;
            }
            case DELETE: {
                if (dataEntry instanceof MvccDataEntry) {
                    cacheCtx.offheap().mvccApplyUpdate(cacheCtx, dataEntry.key(), null, dataEntry.writeVersion(), 0L, locPart, ((MvccDataEntry)dataEntry).mvccVer());
                } else {
                    cacheCtx.offheap().remove(cacheCtx, dataEntry.key(), partId, locPart);
                }
                if (dataEntry.partitionCounter() == 0L) break;
                cacheCtx.offheap().onPartitionInitialCounterUpdated(partId, dataEntry.partitionCounter() - 1L, 1L);
                break;
            }
            case READ: {
                break;
            }
            default: {
                throw new IgniteCheckedException("Invalid operation for WAL entry update: " + (Object)((Object)dataEntry.op()));
            }
        }
    }

    private void finalizeCheckpointOnRecovery(long cpTs, UUID cpId, WALPointer walPtr, StripedExecutor exec) throws IgniteCheckedException {
        assert (this.checkpointManager != null) : "Checkpoint is null";
        this.checkpointManager.finalizeCheckpointOnRecovery(cpTs, cpId, walPtr, exec);
        this.cctx.pageStore().finishRecover();
    }

    public void setThreadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        assert (this.checkpointManager != null) : "Checkpointer is null";
        this.checkpointManager.threadBuf(threadBuf);
    }

    @Nullable
    public CheckpointHistory checkpointHistory() {
        if (this.checkpointManager == null) {
            return null;
        }
        return this.checkpointManager.checkpointHistory();
    }

    public void schedulePartitionDestroy(int grpId, int partId) {
        this.checkpointManager.schedulePartitionDestroy(this.cctx.cache().cacheGroup(grpId), grpId, partId);
    }

    public boolean cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        return this.checkpointManager.cancelOrWaitPartitionDestroy(grpId, partId);
    }

    @Override
    public long checkpointReadLockTimeout() {
        return this.checkpointManager.checkpointTimeoutLock().checkpointReadLockTimeout();
    }

    @Override
    public void checkpointReadLockTimeout(long val) {
        this.checkpointManager.checkpointTimeoutLock().checkpointReadLockTimeout(val);
    }

    public AtomicLong pageListCacheLimitHolder(DataRegion dataRegion) {
        if (dataRegion.config().isPersistenceEnabled()) {
            return this.pageListCacheLimits.computeIfAbsent(dataRegion.config().getName(), name -> new AtomicLong((long)((double)((PageMemoryEx)dataRegion.pageMemory()).totalPages() * 0.1)));
        }
        return null;
    }

    @Override
    public DataStorageMetrics persistentStoreMetrics() {
        return new DataStorageMetricsSnapshot(this.persStoreMetrics);
    }

    public DataStorageMetricsImpl persistentStoreMetricsImpl() {
        return this.persStoreMetrics;
    }

    @Override
    public MetaStorage metaStorage() {
        return this.metaStorage;
    }

    public MetaStorage.TmpStorage temporaryMetaStorage() {
        return this.tmpMetaStorage;
    }

    public void temporaryMetaStorage(MetaStorage.TmpStorage tmpMetaStorage) {
        this.tmpMetaStorage = tmpMetaStorage;
    }

    @Override
    public void notifyMetaStorageSubscribersOnReadyForRead() throws IgniteCheckedException {
        this.metastorageLifecycleLsnrs = this.cctx.kernalContext().internalSubscriptionProcessor().getMetastorageSubscribers();
        this.readMetastore();
    }

    @Override
    public boolean walEnabled(int grpId, boolean local) {
        if (local) {
            return !this.initiallyLocWalDisabledGrps.contains(grpId);
        }
        return !this.initiallyGlobalWalDisabledGrps.contains(grpId);
    }

    @Override
    public void walEnabled(int grpId, boolean enabled, boolean local) {
        String key = GridCacheDatabaseSharedManager.walGroupIdToKey(grpId, local);
        this.checkpointReadLock();
        try {
            if (enabled) {
                this.metaStorage.remove(key);
            } else {
                this.metaStorage.write(key, Boolean.valueOf(true));
                this.lastCheckpointInapplicableForWalRebalance(grpId);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group WAL state [grpId=" + grpId + ", enabled=" + enabled + ']', e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    public boolean isCheckpointInapplicableForWalRebalance(Long cpTs, int grpId) throws IgniteCheckedException {
        return this.metaStorage.read(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(cpTs, grpId)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lastCheckpointInapplicableForWalRebalance(int grpId) {
        this.checkpointReadLock();
        try {
            long lastCpTs;
            CheckpointEntry lastCp = this.checkpointHistory().lastCheckpointMarkingAsInapplicable(grpId);
            long l = lastCpTs = lastCp != null ? lastCp.timestamp() : 0L;
            if (lastCpTs != 0L) {
                this.metaStorage.write(GridCacheDatabaseSharedManager.checkpointInapplicableCpAndGroupIdToKey(lastCpTs, grpId), Boolean.valueOf(true));
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to mark last checkpoint as inapplicable for WAL rebalance for group: " + grpId, e);
        }
        finally {
            this.checkpointReadUnlock();
        }
    }

    private void fillWalDisabledGroups() {
        assert (this.metaStorage != null);
        try {
            this.metaStorage.iterate(WAL_KEY_PREFIX, (key, val) -> {
                T2<Integer, Boolean> t2 = GridCacheDatabaseSharedManager.walKeyToGroupIdAndLocalFlag(key);
                if (t2 != null) {
                    if (((Boolean)t2.get2()).booleanValue()) {
                        this.initiallyLocWalDisabledGrps.add((Integer)t2.get1());
                    } else {
                        this.initiallyGlobalWalDisabledGrps.add((Integer)t2.get1());
                    }
                }
            }, false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read cache groups WAL state.", e);
        }
    }

    private static String walGroupIdToKey(int grpId, boolean local) {
        if (local) {
            return WAL_LOCAL_KEY_PREFIX + grpId;
        }
        return WAL_GLOBAL_KEY_PREFIX + grpId;
    }

    private static String checkpointInapplicableCpAndGroupIdToKey(long cpTs, int grpId) {
        return CHECKPOINT_INAPPLICABLE_FOR_REBALANCE + cpTs + "-" + grpId;
    }

    private static T2<Integer, Boolean> walKeyToGroupIdAndLocalFlag(String key) {
        if (key.startsWith(WAL_LOCAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_LOCAL_KEY_PREFIX.length())), true);
        }
        if (key.startsWith(WAL_GLOBAL_KEY_PREFIX)) {
            return new T2<Integer, Boolean>(Integer.parseInt(key.substring(WAL_GLOBAL_KEY_PREFIX.length())), false);
        }
        return null;
    }

    private static void dumpPartitionsInfo(GridCacheSharedContext cctx, IgniteLogger log) throws IgniteCheckedException {
        for (CacheGroupContext grp : cctx.cache().cacheGroups()) {
            if (grp.isLocal() || !grp.persistenceEnabled()) continue;
            GridCacheDatabaseSharedManager.dumpPartitionsInfo(grp, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpPartitionsInfo(CacheGroupContext grp, IgniteLogger log) throws IgniteCheckedException {
        PageMemoryEx pageMem = (PageMemoryEx)grp.dataRegion().pageMemory();
        IgnitePageStoreManager pageStore = grp.shared().pageStore();
        assert (pageStore != null) : "Persistent cache should have initialize page store manager.";
        for (int p = 0; p < grp.affinity().partitions(); ++p) {
            GridDhtLocalPartition part = grp.topology().localPartition(p);
            if (part != null) {
                if (!log.isInfoEnabled()) continue;
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + (Object)((Object)part.state()) + ", counter=" + part.dataStore().partUpdateCounter() + ", size=" + part.fullSize() + "]");
                continue;
            }
            if (!pageStore.exists(grp.groupId(), p)) continue;
            pageStore.ensure(grp.groupId(), p);
            if (pageStore.pages(grp.groupId(), p) <= 1) {
                if (!log.isInfoEnabled()) continue;
                log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=N/A (only file header) ]");
                continue;
            }
            long partMetaId = pageMem.partitionMetaPageId(grp.groupId(), p);
            long partMetaPage = pageMem.acquirePage(grp.groupId(), partMetaId);
            try {
                long pageAddr = pageMem.readLock(grp.groupId(), partMetaId, partMetaPage);
                try {
                    PagePartitionMetaIO io = PagePartitionMetaIO.VERSIONS.forPage(pageAddr);
                    GridDhtPartitionState partState = GridDhtPartitionState.fromOrdinal(io.getPartitionState(pageAddr));
                    String state = partState != null ? partState.toString() : "N/A";
                    long updateCntr = io.getUpdateCounter(pageAddr);
                    long size = io.getSize(pageAddr);
                    if (!log.isInfoEnabled()) continue;
                    log.info("Partition [grp=" + grp.cacheOrGroupName() + ", id=" + p + ", state=" + state + ", counter=" + updateCntr + ", size=" + size + "]");
                    continue;
                }
                finally {
                    pageMem.readUnlock(grp.groupId(), partMetaId, partMetaPage);
                }
            }
            finally {
                pageMem.releasePage(grp.groupId(), partMetaId, partMetaPage);
            }
        }
    }

    private IgnitePredicate<Integer> onlyMetastorageGroup() {
        return groupId -> MetaStorage.METASTORAGE_CACHE_ID == groupId;
    }

    private IgnitePredicate<Integer> groupsWithEnabledWal() {
        return groupId -> !this.initiallyGlobalWalDisabledGrps.contains(groupId) && !this.initiallyLocWalDisabledGrps.contains(groupId);
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> onlyMetastorageAndEncryptionRecords() {
        return (type, ptr) -> type == WALRecord.RecordType.METASTORE_DATA_RECORD || type == WALRecord.RecordType.TX_RECORD || type == WALRecord.RecordType.MASTER_KEY_CHANGE_RECORD || type == WALRecord.RecordType.MASTER_KEY_CHANGE_RECORD_V2;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> physicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.PHYSICAL || type.purpose() == WALRecord.RecordPurpose.MIXED;
    }

    private IgniteBiPredicate<WALRecord.RecordType, WALPointer> logicalRecords() {
        return (type, ptr) -> type.purpose() == WALRecord.RecordPurpose.LOGICAL || type.purpose() == WALRecord.RecordPurpose.MIXED || type == WALRecord.RecordType.CHECKPOINT_RECORD;
    }

    public class RestoreLogicalState
    extends RestoreStateContext {
        private final Map<GroupPartitionId, Integer> partitionRecoveryStates;

        public RestoreLogicalState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate, Map<GroupPartitionId, Integer> partitionRecoveryStates) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.partitionRecoveryStates = partitionRecoveryStates;
        }

        public Map<GroupPartitionId, Integer> partitionRecoveryStates() {
            return Collections.unmodifiableMap(this.partitionRecoveryStates);
        }
    }

    public class RestoreBinaryState
    extends RestoreStateContext {
        private boolean needApplyBinaryUpdates;

        public RestoreBinaryState(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupsPredicate) {
            super(status, iterator, lastArchivedSegment, cacheGroupsPredicate);
            this.needApplyBinaryUpdates = status.needRestoreMemory();
        }

        @Override
        public WALRecord next() throws IgniteCheckedException {
            WALRecord rec = super.next();
            if (rec == null) {
                return null;
            }
            if (rec.type() == WALRecord.RecordType.CHECKPOINT_RECORD) {
                CheckpointRecord cpRec = (CheckpointRecord)rec;
                if (F.eq(cpRec.checkpointId(), this.status.cpStartId)) {
                    GridCacheDatabaseSharedManager.this.log.info("Found last checkpoint marker [cpId=" + cpRec.checkpointId() + ", pos=" + rec.position() + ']');
                    this.needApplyBinaryUpdates = false;
                } else if (!F.eq(cpRec.checkpointId(), this.status.cpEndId)) {
                    U.warn(GridCacheDatabaseSharedManager.this.log, "Found unexpected checkpoint marker, skipping [cpId=" + cpRec.checkpointId() + ", expCpId=" + this.status.cpStartId + ", pos=" + rec.position() + ']');
                }
            }
            return rec;
        }

        public boolean needApplyBinaryUpdate() {
            return this.needApplyBinaryUpdates;
        }

        @Override
        public boolean throwsCRCError() {
            GridCacheDatabaseSharedManager.this.log.info("Throws CRC error check [needApplyBinaryUpdates=" + this.needApplyBinaryUpdates + ", lastArchivedSegment=" + this.lastArchivedSegment + ", lastRead=" + this.lastReadRecordPointer() + ']');
            if (this.needApplyBinaryUpdates) {
                return true;
            }
            return super.throwsCRCError();
        }
    }

    private abstract class RestoreStateContext {
        protected final long lastArchivedSegment;
        protected final CheckpointStatus status;
        private final WALIterator iterator;
        private final IgnitePredicate<Integer> cacheGroupPredicate;

        protected RestoreStateContext(CheckpointStatus status, WALIterator iterator, long lastArchivedSegment, IgnitePredicate<Integer> cacheGroupPredicate) {
            this.status = status;
            this.iterator = iterator;
            this.lastArchivedSegment = lastArchivedSegment;
            this.cacheGroupPredicate = cacheGroupPredicate;
        }

        public WALRecord next() throws IgniteCheckedException {
            try {
                WalRecordCacheGroupAware grpAwareRecord;
                WALRecord rec;
                do {
                    if (!this.iterator.hasNextX()) {
                        return null;
                    }
                    IgniteBiTuple tup = (IgniteBiTuple)this.iterator.nextX();
                    if (tup == null) {
                        return null;
                    }
                    rec = (WALRecord)tup.get2();
                    WALPointer ptr = (WALPointer)tup.get1();
                    rec.position(ptr);
                } while (rec instanceof WalRecordCacheGroupAware && !this.cacheGroupPredicate.apply((grpAwareRecord = (WalRecordCacheGroupAware)((Object)rec)).groupId()));
                if (rec instanceof DataRecord) {
                    rec = this.filterEntriesByGroupId((DataRecord)rec);
                }
                return rec;
            }
            catch (IgniteCheckedException e) {
                boolean throwsCRCError = this.throwsCRCError();
                if (X.hasCause((Throwable)e, IgniteDataIntegrityViolationException.class)) {
                    if (throwsCRCError) {
                        throw e;
                    }
                    return null;
                }
                GridCacheDatabaseSharedManager.this.log.error("There is an error during restore state [throwsCRCError=" + throwsCRCError + ']', e);
                throw e;
            }
        }

        private DataRecord filterEntriesByGroupId(DataRecord record) {
            List<DataEntry> filteredEntries = record.writeEntries().stream().filter(entry -> {
                int cacheId = entry.cacheId();
                return GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId) != null && this.cacheGroupPredicate.apply(GridCacheDatabaseSharedManager.this.cctx.cacheContext(cacheId).groupId());
            }).collect(Collectors.toList());
            return record.setWriteEntries(filteredEntries);
        }

        public WALPointer lastReadRecordPointer() {
            assert (this.status.startPtr != null);
            return this.iterator.lastRead().orElseGet(() -> this.status.startPtr);
        }

        public boolean throwsCRCError() {
            return this.lastReadRecordPointer().index() <= this.lastArchivedSegment;
        }
    }

    private class MetastorageRecoveryLifecycle
    implements DatabaseLifecycleListener {
        private MetastorageRecoveryLifecycle() {
        }

        @Override
        public void beforeBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr) throws IgniteCheckedException {
            GridCacheDatabaseSharedManager.this.cctx.pageStore().initializeForMetastorage();
        }

        @Override
        public void afterBinaryMemoryRestore(IgniteCacheDatabaseSharedManager mgr, RestoreBinaryState restoreState) throws IgniteCheckedException {
            assert (GridCacheDatabaseSharedManager.this.metaStorage == null);
            GridCacheDatabaseSharedManager.this.metaStorage = GridCacheDatabaseSharedManager.this.createMetastorage(false);
        }
    }

    public static class FileLockHolder
    implements AutoCloseable {
        private static final String lockFileName = "lock";
        private final File file;
        private final RandomAccessFile lockFile;
        private volatile FileLock lock;
        @NotNull
        private final GridKernalContext ctx;
        private final IgniteLogger log;

        public FileLockHolder(String path, @NotNull GridKernalContext ctx, IgniteLogger log) {
            try {
                this.file = Paths.get(path, lockFileName).toFile();
                this.lockFile = new RandomAccessFile(this.file, "rw");
                this.ctx = ctx;
                this.log = log;
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
        }

        public void tryLock(long lockWaitTimeMillis) throws IgniteCheckedException {
            String failMsg;
            ClusterNode node;
            assert (this.lockFile != null);
            FileChannel ch = this.lockFile.getChannel();
            SB sb = new SB();
            sb.a("[").a(this.ctx.localNodeId().toString()).a("]");
            GridDiscoveryManager discovery = this.ctx.discovery();
            if (discovery != null && (node = discovery.localNode()) != null) {
                sb.a(node.addresses());
            }
            sb.a("[");
            Iterator<GridPortRecord> it = this.ctx.ports().records().iterator();
            while (it.hasNext()) {
                GridPortRecord rec = it.next();
                sb.a((Object)rec.protocol()).a(":").a(rec.port());
                if (!it.hasNext()) continue;
                sb.a(", ");
            }
            sb.a("]");
            try {
                String content = null;
                int i = 0;
                while ((long)i < lockWaitTimeMillis) {
                    try {
                        this.lock = ch.tryLock(0L, 1L, false);
                        if (this.lock != null && this.lock.isValid()) {
                            this.writeContent(sb.toString());
                            return;
                        }
                    }
                    catch (OverlappingFileLockException ignore) {
                        if (content == null) {
                            content = this.readContent();
                        }
                        this.log.warning("Failed to acquire file lock. Will try again in 1s [nodeId=" + this.ctx.localNodeId() + ", holder=" + content + ", path=" + this.file.getAbsolutePath() + ']');
                    }
                    U.sleep(1000L);
                    i += 1000;
                }
                if (content == null) {
                    content = this.readContent();
                }
                failMsg = "Failed to acquire file lock [holder=" + content + ", time=" + lockWaitTimeMillis / 1000L + " sec, path=" + this.file.getAbsolutePath() + ']';
            }
            catch (Exception e) {
                throw new IgniteCheckedException(e);
            }
            if (failMsg != null) {
                throw new IgniteCheckedException(failMsg);
            }
        }

        private void writeContent(String content) throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            ch.write(buf, 1L);
            ch.force(false);
        }

        private String readContent() throws IOException {
            FileChannel ch = this.lockFile.getChannel();
            ByteBuffer buf = ByteBuffer.allocate((int)(ch.size() - 1L));
            ch.read(buf, 1L);
            String content = new String(buf.array());
            buf.clear();
            return content;
        }

        public boolean isLocked() {
            return this.lock != null && this.lock.isValid();
        }

        public void release() {
            U.releaseQuiet(this.lock);
        }

        @Override
        public void close() {
            this.release();
            U.closeQuiet(this.lockFile);
        }

        private String lockPath() {
            return this.file.getAbsolutePath();
        }
    }
}

