/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDhtAtomicUpdateRequest
extends GridDhtAtomicAbstractUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> keys;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> vals;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> prevVals;
    @GridDirectCollection(value=GridCacheVersion.class)
    private List<GridCacheVersion> conflictVers;
    private GridLongList ttls;
    private GridLongList conflictExpireTimes;
    private GridLongList nearTtls;
    private GridLongList nearExpireTimes;
    @GridToStringInclude
    @GridDirectCollection(value=KeyCacheObject.class)
    private List<KeyCacheObject> nearKeys;
    @GridToStringInclude
    @GridDirectCollection(value=CacheObject.class)
    private List<CacheObject> nearVals;
    @GridToStringInclude
    private GridIntList obsoleteIndexes;
    private boolean forceTransformBackups;
    @GridDirectTransient
    private List<EntryProcessor<Object, Object, Object>> entryProcessors;
    @GridDirectCollection(value=byte[].class)
    private List<byte[]> entryProcessorsBytes;
    @GridDirectTransient
    private List<EntryProcessor<Object, Object, Object>> nearEntryProcessors;
    @GridDirectCollection(value=byte[].class)
    private List<byte[]> nearEntryProcessorsBytes;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[][] invokeArgsBytes;
    private GridLongList updateCntrs;

    public GridDhtAtomicUpdateRequest() {
    }

    public GridDhtAtomicUpdateRequest(int cacheId, UUID nodeId, long futId, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, UUID subjId, int taskNameHash, Object[] invokeArgs, boolean addDepInfo, boolean keepBinary, boolean skipStore, boolean forceTransformBackups) {
        super(cacheId, nodeId, futId, writeVer, syncMode, topVer, subjId, taskNameHash, addDepInfo, keepBinary, skipStore);
        assert (invokeArgs == null || forceTransformBackups);
        this.forceTransformBackups = forceTransformBackups;
        this.invokeArgs = invokeArgs;
        this.keys = new ArrayList<KeyCacheObject>();
        if (forceTransformBackups) {
            this.entryProcessors = new ArrayList<EntryProcessor<Object, Object, Object>>();
            this.entryProcessorsBytes = new ArrayList<byte[]>();
        } else {
            this.vals = new ArrayList<CacheObject>();
        }
    }

    @Override
    public void addWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer, boolean addPrevVal, @Nullable CacheObject prevVal, long updateCntr, GridCacheOperation cacheOp) {
        int i;
        assert (key.partition() >= 0) : key;
        this.keys.add(key);
        if (this.forceTransformBackups) {
            assert (entryProcessor != null);
            this.entryProcessors.add(entryProcessor);
        } else {
            this.vals.add(val);
        }
        if (addPrevVal) {
            if (this.prevVals == null) {
                this.prevVals = new ArrayList<CacheObject>();
            }
            this.prevVals.add(prevVal);
        }
        if (this.updateCntrs == null) {
            this.updateCntrs = new GridLongList();
        }
        this.updateCntrs.add(updateCntr);
        if (conflictVer != null) {
            if (this.conflictVers == null) {
                this.conflictVers = new ArrayList<GridCacheVersion>();
                for (i = 0; i < this.keys.size() - 1; ++i) {
                    this.conflictVers.add(null);
                }
            }
            this.conflictVers.add(conflictVer);
        } else if (this.conflictVers != null) {
            this.conflictVers.add(null);
        }
        if (ttl >= 0L && this.ttls == null) {
            this.ttls = new GridLongList(this.keys.size());
            for (i = 0; i < this.keys.size() - 1; ++i) {
                this.ttls.add(-1L);
            }
        }
        if (this.ttls != null) {
            this.ttls.add(ttl);
        }
        if (conflictExpireTime >= 0L && this.conflictExpireTimes == null) {
            this.conflictExpireTimes = new GridLongList(this.keys.size());
            for (i = 0; i < this.keys.size() - 1; ++i) {
                this.conflictExpireTimes.add(-1L);
            }
        }
        if (this.conflictExpireTimes != null) {
            this.conflictExpireTimes.add(conflictExpireTime);
        }
    }

    @Override
    public void addNearWriteValue(KeyCacheObject key, @Nullable CacheObject val, EntryProcessor<Object, Object, Object> entryProcessor, long ttl, long expireTime) {
        int i;
        assert (key.partition() >= 0) : key;
        if (this.hasKey(key)) {
            if (this.obsoleteIndexes == null) {
                this.obsoleteIndexes = new GridIntList();
            }
            this.obsoleteIndexes.add(this.keys.indexOf(key));
            return;
        }
        if (this.nearKeys == null) {
            this.nearKeys = new ArrayList<KeyCacheObject>();
            if (this.forceTransformBackups) {
                this.nearEntryProcessors = new ArrayList<EntryProcessor<Object, Object, Object>>();
                this.nearEntryProcessorsBytes = new ArrayList<byte[]>();
            } else {
                this.nearVals = new ArrayList<CacheObject>();
            }
        }
        this.nearKeys.add(key);
        if (this.forceTransformBackups) {
            assert (entryProcessor != null);
            this.nearEntryProcessors.add(entryProcessor);
        } else {
            this.nearVals.add(val);
        }
        if (ttl >= 0L && this.nearTtls == null) {
            this.nearTtls = new GridLongList(this.nearKeys.size());
            for (i = 0; i < this.nearKeys.size() - 1; ++i) {
                this.nearTtls.add(-1L);
            }
        }
        if (this.nearTtls != null) {
            this.nearTtls.add(ttl);
        }
        if (expireTime >= 0L && this.nearExpireTimes == null) {
            this.nearExpireTimes = new GridLongList(this.nearKeys.size());
            for (i = 0; i < this.nearKeys.size() - 1; ++i) {
                this.nearExpireTimes.add(-1L);
            }
        }
        if (this.nearExpireTimes != null) {
            this.nearExpireTimes.add(expireTime);
        }
    }

    @Override
    public boolean forceTransformBackups() {
        return this.forceTransformBackups;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public int nearSize() {
        return this.nearKeys != null ? this.nearKeys.size() : 0;
    }

    @Override
    public int obsoleteNearKeysSize() {
        return this.obsoleteIndexes != null ? this.obsoleteIndexes.size() : 0;
    }

    @Override
    public KeyCacheObject obsoleteNearKey(int idx) {
        return this.keys.get(this.obsoleteIndexes.get(idx));
    }

    @Override
    public boolean hasKey(KeyCacheObject key) {
        return F.contains(this.keys, key);
    }

    @Override
    public KeyCacheObject key(int idx) {
        return this.keys.get(idx);
    }

    @Override
    public Long updateCounter(int updCntr) {
        if (this.updateCntrs != null && updCntr < this.updateCntrs.size()) {
            return this.updateCntrs.get(updCntr);
        }
        return null;
    }

    @Override
    public KeyCacheObject nearKey(int idx) {
        return this.nearKeys.get(idx);
    }

    @Override
    @Nullable
    public CacheObject value(int idx) {
        if (this.vals != null) {
            return this.vals.get(idx);
        }
        return null;
    }

    @Override
    @Nullable
    public CacheObject previousValue(int idx) {
        if (this.prevVals != null) {
            return this.prevVals.get(idx);
        }
        return null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        return this.entryProcessors == null ? null : this.entryProcessors.get(idx);
    }

    @Override
    @Nullable
    public CacheObject nearValue(int idx) {
        if (this.nearVals != null) {
            return this.nearVals.get(idx);
        }
        return null;
    }

    @Override
    @Nullable
    public EntryProcessor<Object, Object, Object> nearEntryProcessor(int idx) {
        return this.nearEntryProcessors == null ? null : this.nearEntryProcessors.get(idx);
    }

    @Override
    @Nullable
    public GridCacheVersion conflictVersion(int idx) {
        if (this.conflictVers != null) {
            assert (idx >= 0 && idx < this.conflictVers.size());
            return this.conflictVers.get(idx);
        }
        return null;
    }

    @Override
    public long ttl(int idx) {
        if (this.ttls != null) {
            assert (idx >= 0 && idx < this.ttls.size());
            return this.ttls.get(idx);
        }
        return -1L;
    }

    @Override
    public long nearTtl(int idx) {
        if (this.nearTtls != null) {
            assert (idx >= 0 && idx < this.nearTtls.size());
            return this.nearTtls.get(idx);
        }
        return -1L;
    }

    @Override
    public int partition() {
        int p;
        assert (!F.isEmpty(this.keys) || !F.isEmpty(this.nearKeys));
        int n = p = !this.keys.isEmpty() ? this.keys.get(0).partition() : this.nearKeys.get(0).partition();
        assert (p >= 0);
        return p;
    }

    @Override
    public long conflictExpireTime(int idx) {
        if (this.conflictExpireTimes != null) {
            assert (idx >= 0 && idx < this.conflictExpireTimes.size());
            return this.conflictExpireTimes.get(idx);
        }
        return -1L;
    }

    @Override
    public long nearExpireTime(int idx) {
        if (this.nearExpireTimes != null) {
            assert (idx >= 0 && idx < this.nearExpireTimes.size());
            return this.nearExpireTimes.get(idx);
        }
        return -1L;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return this.invokeArgs;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObjects(this.keys, cctx);
        this.prepareMarshalCacheObjects(this.vals, cctx);
        this.prepareMarshalCacheObjects(this.nearKeys, cctx);
        this.prepareMarshalCacheObjects(this.nearVals, cctx);
        this.prepareMarshalCacheObjects(this.prevVals, cctx);
        if (this.forceTransformBackups) {
            if (!this.addDepInfo && ctx.deploymentEnabled()) {
                this.addDepInfo = true;
            }
            if (this.invokeArgsBytes == null) {
                this.invokeArgsBytes = this.marshalInvokeArguments(this.invokeArgs, cctx);
            }
            if (this.entryProcessorsBytes == null) {
                this.entryProcessorsBytes = this.marshalCollection(this.entryProcessors, cctx);
            }
            if (this.nearEntryProcessorsBytes == null) {
                this.nearEntryProcessorsBytes = this.marshalCollection(this.nearEntryProcessors, cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.finishUnmarshalCacheObjects(this.keys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.vals, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearKeys, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.nearVals, cctx, ldr);
        this.finishUnmarshalCacheObjects(this.prevVals, cctx, ldr);
        if (this.forceTransformBackups) {
            if (this.entryProcessors == null) {
                this.entryProcessors = this.unmarshalCollection(this.entryProcessorsBytes, ctx, ldr);
            }
            if (this.invokeArgs == null) {
                this.invokeArgs = this.unmarshalInvokeArguments(this.invokeArgsBytes, ctx, ldr);
            }
            if (this.nearEntryProcessors == null) {
                this.nearEntryProcessors = this.unmarshalCollection(this.nearEntryProcessorsBytes, ctx, ldr);
            }
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 13: {
                if (!writer.writeMessage("conflictExpireTimes", this.conflictExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeCollection("conflictVers", this.conflictVers, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeCollection("entryProcessorsBytes", this.entryProcessorsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeBoolean("forceTransformBackups", this.forceTransformBackups)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeObjectArray("invokeArgsBytes", (T[])this.invokeArgsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeCollection("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeCollection("nearEntryProcessorsBytes", this.nearEntryProcessorsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeMessage("nearExpireTimes", this.nearExpireTimes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 21: {
                if (!writer.writeCollection("nearKeys", this.nearKeys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 22: {
                if (!writer.writeMessage("nearTtls", this.nearTtls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 23: {
                if (!writer.writeCollection("nearVals", this.nearVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 24: {
                if (!writer.writeMessage("obsoleteIndexes", this.obsoleteIndexes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 25: {
                if (!writer.writeCollection("prevVals", this.prevVals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 26: {
                if (!writer.writeMessage("ttls", this.ttls)) {
                    return false;
                }
                writer.incrementState();
            }
            case 27: {
                if (!writer.writeMessage("updateCntrs", this.updateCntrs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 28: {
                if (!writer.writeCollection("vals", this.vals, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 13: {
                this.conflictExpireTimes = (GridLongList)reader.readMessage("conflictExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.conflictVers = (List)reader.readCollection("conflictVers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.entryProcessorsBytes = (List)reader.readCollection("entryProcessorsBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.forceTransformBackups = reader.readBoolean("forceTransformBackups");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.invokeArgsBytes = reader.readObjectArray("invokeArgsBytes", MessageCollectionItemType.BYTE_ARR, byte[].class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.keys = (List)reader.readCollection("keys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.nearEntryProcessorsBytes = (List)reader.readCollection("nearEntryProcessorsBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.nearExpireTimes = (GridLongList)reader.readMessage("nearExpireTimes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 21: {
                this.nearKeys = (List)reader.readCollection("nearKeys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 22: {
                this.nearTtls = (GridLongList)reader.readMessage("nearTtls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 23: {
                this.nearVals = (List)reader.readCollection("nearVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 24: {
                this.obsoleteIndexes = (GridIntList)reader.readMessage("obsoleteIndexes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 25: {
                this.prevVals = (List)reader.readCollection("prevVals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 26: {
                this.ttls = (GridLongList)reader.readMessage("ttls");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 27: {
                this.updateCntrs = (GridLongList)reader.readMessage("updateCntrs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 28: {
                this.vals = (List)reader.readCollection("vals", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicUpdateRequest.class);
    }

    @Override
    protected void cleanup() {
        this.nearVals = null;
        this.prevVals = null;
    }

    @Override
    public short directType() {
        return 38;
    }

    @Override
    public byte fieldsCount() {
        return 29;
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicUpdateRequest.class, this, "super", (Object)super.toString());
    }
}

