/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class PartitionUpdateCounterErrorWrapper
implements PartitionUpdateCounter {
    private final IgniteLogger log;
    private final int partId;
    private final CacheGroupContext grp;
    private final PartitionUpdateCounter delegate;

    public PartitionUpdateCounterErrorWrapper(int partId, PartitionUpdateCounter delegate) {
        this.partId = partId;
        this.grp = delegate.context();
        this.log = this.grp.shared().logger(this.getClass());
        this.delegate = delegate;
    }

    @Override
    public long reserve(long delta) {
        try {
            return this.delegate.reserve(delta);
        }
        catch (AssertionError e) {
            SB sb = new SB();
            sb.a("Failed to increment HWM ").a("[op=reserve").a(", grpId=").a(this.grp.groupId()).a(", grpName=").a(this.grp.cacheOrGroupName()).a(", caches=").a(this.grp.caches()).a(", atomicity=").a((Object)this.grp.config().getAtomicityMode()).a(", syncMode=").a((Object)this.grp.config().getWriteSynchronizationMode()).a(", mode=").a((Object)this.grp.config().getCacheMode()).a(", partId=").a(this.partId).a(", delta=").a(delta).a("]");
            U.error(this.log, sb.toString());
            throw e;
        }
    }

    @Override
    public void init(long initUpdCntr, @Nullable byte[] cntrUpdData) {
        this.delegate.init(initUpdCntr, cntrUpdData);
    }

    @Override
    public long next() {
        return this.delegate.next();
    }

    @Override
    public long next(long delta) {
        return this.delegate.next(delta);
    }

    @Override
    public void update(long val) throws IgniteCheckedException {
        this.delegate.update(val);
    }

    @Override
    public boolean update(long start, long delta) {
        return this.delegate.update(start, delta);
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public void updateInitial(long start, long delta) {
        this.delegate.updateInitial(start, delta);
    }

    @Override
    public GridLongList finalizeUpdateCounters() {
        return this.delegate.finalizeUpdateCounters();
    }

    @Override
    public void resetInitialCounter() {
        this.delegate.resetInitialCounter();
    }

    @Override
    public long initial() {
        return this.delegate.initial();
    }

    @Override
    public long get() {
        return this.delegate.get();
    }

    public boolean equals(Object o) {
        if (o instanceof PartitionUpdateCounterErrorWrapper) {
            return this.delegate.equals(((PartitionUpdateCounterErrorWrapper)o).delegate);
        }
        return false;
    }

    @Override
    public long reserved() {
        return this.delegate.reserved();
    }

    @Override
    @Nullable
    public byte[] getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public boolean sequential() {
        return this.delegate.sequential();
    }

    @Override
    public boolean empty() {
        return this.delegate.empty();
    }

    @Override
    public Iterator<long[]> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public CacheGroupContext context() {
        return this.delegate.context();
    }

    @Override
    public PartitionUpdateCounter copy() {
        return new PartitionUpdateCounterErrorWrapper(this.partId, this.delegate.copy());
    }

    public String toString() {
        return this.delegate.toString();
    }
}

