/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.io;

import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.inline.io.InlineIO;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;

class IORowHandler {
    IORowHandler() {
    }

    static void store(long pageAddr, int off, IndexRow row, boolean storeMvccInfo) {
        PageUtils.putLong(pageAddr, off, row.link());
        if (storeMvccInfo) {
            long mvccCrdVer = row.mvccCoordinatorVersion();
            long mvccCntr = row.mvccCounter();
            int mvccOpCntr = row.mvccOperationCounter();
            assert (MvccUtils.mvccVersionIsValid(mvccCrdVer, mvccCntr, mvccOpCntr));
            PageUtils.putLong(pageAddr, off + 8, mvccCrdVer);
            PageUtils.putLong(pageAddr, off + 16, mvccCntr);
            PageUtils.putInt(pageAddr, off + 24, mvccOpCntr);
        }
    }

    static void store(long dstPageAddr, int dstOff, InlineIO srcIo, long srcPageAddr, int srcIdx, boolean storeMvcc) {
        long link = srcIo.link(srcPageAddr, srcIdx);
        PageUtils.putLong(dstPageAddr, dstOff, link);
        if (storeMvcc) {
            long mvccCrdVer = srcIo.mvccCoordinatorVersion(srcPageAddr, srcIdx);
            long mvccCntr = srcIo.mvccCounter(srcPageAddr, srcIdx);
            int mvccOpCntr = srcIo.mvccOperationCounter(srcPageAddr, srcIdx);
            assert (MvccUtils.mvccVersionIsValid(mvccCrdVer, mvccCntr, mvccOpCntr));
            PageUtils.putLong(dstPageAddr, dstOff + 8, mvccCrdVer);
            PageUtils.putLong(dstPageAddr, dstOff + 16, mvccCntr);
            PageUtils.putInt(dstPageAddr, dstOff + 24, mvccOpCntr);
        }
    }
}

