/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.TreeSet;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.jetbrains.annotations.Nullable;

public class SplitterUtils {
    public static boolean hasAggregates(GridSqlAst el) {
        if (el instanceof GridSqlAggregateFunction) {
            return true;
        }
        if (el instanceof GridSqlSubquery) {
            return false;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!SplitterUtils.hasAggregates(el.child(i))) continue;
            return true;
        }
        return false;
    }

    public static void findParamsQuery(GridSqlQuery qry, int paramsCnt, TreeSet<Integer> paramIdxs) {
        if (qry instanceof GridSqlSelect) {
            SplitterUtils.findParamsSelect((GridSqlSelect)qry, paramsCnt, paramIdxs);
        } else {
            GridSqlUnion union = (GridSqlUnion)qry;
            SplitterUtils.findParamsQuery(union.left(), paramsCnt, paramIdxs);
            SplitterUtils.findParamsQuery(union.right(), paramsCnt, paramIdxs);
            SplitterUtils.findParams(qry.limit(), paramsCnt, paramIdxs);
            SplitterUtils.findParams(qry.offset(), paramsCnt, paramIdxs);
        }
    }

    private static void findParamsSelect(GridSqlSelect select, int paramsCnt, TreeSet<Integer> paramIdxs) {
        if (paramsCnt == 0) {
            return;
        }
        for (GridSqlAst el : select.columns(false)) {
            SplitterUtils.findParams(el, paramsCnt, paramIdxs);
        }
        SplitterUtils.findParams(select.from(), paramsCnt, paramIdxs);
        SplitterUtils.findParams(select.where(), paramsCnt, paramIdxs);
        SplitterUtils.findParams(select.limit(), paramsCnt, paramIdxs);
        SplitterUtils.findParams(select.offset(), paramsCnt, paramIdxs);
    }

    private static void findParams(@Nullable GridSqlAst el, int paramsCnt, TreeSet<Integer> paramIdxs) {
        if (el == null) {
            return;
        }
        if (el instanceof GridSqlParameter) {
            int idx = ((GridSqlParameter)el).index();
            if (paramsCnt <= idx) {
                throw new IgniteException("Invalid number of query parameters. Cannot find " + idx + " parameter.");
            }
            paramIdxs.add(idx);
        } else if (el instanceof GridSqlSubquery) {
            SplitterUtils.findParamsQuery(((GridSqlSubquery)el).subquery(), paramsCnt, paramIdxs);
        } else {
            for (int i = 0; i < el.size(); ++i) {
                SplitterUtils.findParams(el.child(i), paramsCnt, paramIdxs);
            }
        }
    }

    public static boolean hasDistinctAggregates(GridSqlAst el) {
        if (el instanceof GridSqlAggregateFunction) {
            GridSqlFunctionType type = ((GridSqlAggregateFunction)el).type();
            return ((GridSqlAggregateFunction)el).distinct() && type != GridSqlFunctionType.MIN && type != GridSqlFunctionType.MAX;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!SplitterUtils.hasDistinctAggregates(el.child(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLeftJoin(GridSqlAst from) {
        while (from instanceof GridSqlJoin) {
            GridSqlJoin join = (GridSqlJoin)from;
            assert (!(join.rightTable() instanceof GridSqlJoin));
            if (join.isLeftOuter()) {
                return true;
            }
            from = join.leftTable();
        }
        return false;
    }

    public static boolean hasOuterJoinReplicatedPartitioned(GridSqlAst from) {
        boolean isRightPartitioned = false;
        while (from instanceof GridSqlJoin) {
            GridSqlJoin join = (GridSqlJoin)from;
            assert (!(join.rightTable() instanceof GridSqlJoin));
            boolean bl = isRightPartitioned = isRightPartitioned || SplitterUtils.hasPartitionedTables(join.rightTable());
            if (join.isLeftOuter()) {
                boolean isLeftPartitioned = SplitterUtils.hasPartitionedTables(join.leftTable());
                return !isLeftPartitioned && isRightPartitioned;
            }
            from = join.leftTable();
        }
        return false;
    }

    public static void checkNoDataTablesInReduceQuery(GridSqlAst ast, String rdcQry) {
        if (ast instanceof GridSqlTable) {
            if (((GridSqlTable)ast).dataTable() != null) {
                throw new IgniteException("Failed to generate REDUCE query. Data table found: " + ast.getSQL() + " \n" + rdcQry);
            }
        } else {
            for (int i = 0; i < ast.size(); ++i) {
                SplitterUtils.checkNoDataTablesInReduceQuery(ast.child(i), rdcQry);
            }
        }
    }

    public static boolean isTrue(GridSqlAst expr) {
        return expr instanceof GridSqlConst && ((GridSqlConst)expr).value() == GridSqlConst.TRUE.value();
    }

    public static boolean isFractionalType(int type) {
        return type == 6 || type == 8 || type == 7;
    }

    public static GridSqlAggregateFunction aggregate(boolean distinct, GridSqlFunctionType type) {
        return new GridSqlAggregateFunction(distinct, type);
    }

    public static GridSqlColumn column(String name) {
        return new GridSqlColumn(null, null, null, null, name);
    }

    public static GridSqlAlias alias(String alias, GridSqlAst child) {
        GridSqlAlias res = new GridSqlAlias(alias, child);
        res.resultType(child.resultType());
        return res;
    }

    public static GridSqlOperation op(GridSqlOperationType type, GridSqlAst left, GridSqlAst right) {
        return new GridSqlOperation(type, left, right);
    }

    public static boolean hasPartitionedTables(GridSqlAst ast) {
        if (ast instanceof GridSqlTable) {
            if (((GridSqlTable)ast).dataTable() != null) {
                return ((GridSqlTable)ast).dataTable().isPartitioned();
            }
            return false;
        }
        for (int i = 0; i < ast.size(); ++i) {
            if (!SplitterUtils.hasPartitionedTables(ast.child(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSubQueries(GridSqlSelect qry) {
        boolean res;
        boolean bl = res = SplitterUtils.hasSubQueries0(qry.where()) || SplitterUtils.hasSubQueries0(qry.from());
        if (!res) {
            for (int i = 0; i < qry.columns(false).size(); ++i) {
                if (!SplitterUtils.hasSubQueries0(qry.column(i))) continue;
                res = true;
                break;
            }
        }
        return res;
    }

    private static boolean hasSubQueries0(GridSqlAst ast) {
        if (ast == null) {
            return false;
        }
        if (ast instanceof GridSqlSubquery) {
            return true;
        }
        for (int childIdx = 0; childIdx < ast.size(); ++childIdx) {
            if (!SplitterUtils.hasSubQueries0(ast.child(childIdx))) continue;
            return true;
        }
        return false;
    }

    private SplitterUtils() {
    }
}

