/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.cache.query.index.NullsOrder;
import org.apache.ignite.internal.cache.query.index.Order;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class QueryIndexKeyDefinitionProvider {
    private final GridH2Table table;
    private final List<IndexColumn> h2IdxColumns;
    private List<IndexKeyDefinition> keyDefs;

    public QueryIndexKeyDefinitionProvider(GridH2Table table, List<IndexColumn> h2IdxColumns) {
        this.table = table;
        this.h2IdxColumns = h2IdxColumns;
    }

    public List<IndexKeyDefinition> keyDefinitions() {
        if (this.keyDefs != null) {
            return this.keyDefs;
        }
        ArrayList<IndexKeyDefinition> idxKeyDefinitions = new ArrayList<IndexKeyDefinition>();
        for (IndexColumn c : this.h2IdxColumns) {
            idxKeyDefinitions.add(this.keyDefinition(c));
        }
        IndexColumn.mapColumns((IndexColumn[])this.h2IdxColumns.toArray(new IndexColumn[0]), (Table)this.table);
        this.keyDefs = Collections.unmodifiableList(idxKeyDefinitions);
        return this.keyDefs;
    }

    private IndexKeyDefinition keyDefinition(IndexColumn c) {
        return new IndexKeyDefinition(c.columnName, c.column.getType(), this.sortOrder(c.sortType));
    }

    private Order sortOrder(int sortType) {
        SortOrder sortOrder = (sortType & 1) != 0 ? SortOrder.DESC : SortOrder.ASC;
        NullsOrder nullsOrder = (sortType & 2) != 0 ? NullsOrder.NULLS_FIRST : NullsOrder.NULLS_LAST;
        return new Order(sortOrder, nullsOrder);
    }
}

