---
title: "Community"
---
<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->

# Welcome!

Apache Iceberg tracks issues in GitHub and prefers to receive contributions as pull requests.

Community discussions happen primarily on the dev mailing list, on apache-iceberg Slack workspace, and on specific GitHub issues.

## Contribute

See [Contributing](contribute.md) for more details on how to contribute to Iceberg.

## Issues

Issues are tracked in GitHub:

* [View open issues][open-issues]
* [Open a new issue][new-issue]

[open-issues]: https://github.com/apache/iceberg/issues
[new-issue]: https://github.com/apache/iceberg/issues/new

## Slack

We use the [Apache Iceberg workspace](https://apache-iceberg.slack.com/) on Slack. To be invited, follow [this invite link](https://join.slack.com/t/apache-iceberg/shared_invite/zt-287g3akar-K9Oe_En5j1UL7Y_Ikpai3A).

Please note that this link may occasionally break when Slack does an upgrade. If you encounter problems using it, please let us know by sending an email to <dev@iceberg.apache.org>.

## Iceberg Community Events

This calendar contains two calendar feeds:

* [Iceberg Community Events](https://calendar.google.com/calendar/u/0?cid=NTkzYmIwMGJmZTQ1N2QzMTkxNDEzNTBkZDI0Yzk2NGYzOWJkYmQ5ZmQyNDMyODFhODYzMmEwMDk2M2EyMWQ4NkBncm91cC5jYWxlbmRhci5nb29nbGUuY29t){:target="_blank"} : Events such as conferences and meetups, aimed to educate and inspire Iceberg users.
* [Iceberg Dev Events](https://calendar.google.com/calendar/u/0?cid=MzkwNWQ0OTJmMWI0NTBiYTA3MTJmMmFlNmFmYTc2ZWI3NTdmMTNkODUyMjBjYzAzYWE0NTI3ODg1YWRjNTYyOUBncm91cC5jYWxlbmRhci5nb29nbGUuY29t){:target="_blank"} : Events such as the triweekly Iceberg sync, aimed to discuss the project roadmap and how to implement features.

## Mailing Lists

Iceberg has four mailing lists:

* **Developers**: <dev@iceberg.apache.org> -- used for community discussions
    - [Subscribe](mailto:dev-subscribe@iceberg.apache.org)
    - [Unsubscribe](mailto:dev-unsubscribe@iceberg.apache.org)
    - [Archive](https://lists.apache.org/list.html?dev@iceberg.apache.org)
* **Commits**: <commits@iceberg.apache.org> -- distributes commit notifications
    - [Subscribe](mailto:commits-subscribe@iceberg.apache.org)
    - [Unsubscribe](mailto:commits-unsubscribe@iceberg.apache.org)
    - [Archive](https://lists.apache.org/list.html?commits@iceberg.apache.org)
* **Issues**: <issues@iceberg.apache.org> -- Github issue tracking
    - [Subscribe](mailto:issues-subscribe@iceberg.apache.org)
    - [Unsubscribe](mailto:issues-unsubscribe@iceberg.apache.org)
    - [Archive](https://lists.apache.org/list.html?issues@iceberg.apache.org)
* **Private**: <private@iceberg.apache.org> -- private list for the PMC to discuss sensitive issues related to the health of the project
    - [Archive](https://lists.apache.org/list.html?private@iceberg.apache.org)

## Community Guidelines

### Apache Iceberg Community Guidelines

The Apache Iceberg community is built on the principles described in the [Apache Way](https://www.apache.org/theapacheway/index.html) 
and all who engage with the community are expected to be respectful, open, come with the best interests of the community in mind, 
and abide by the Apache Foundation [Code of Conduct](https://www.apache.org/foundation/policies/conduct.html). 

### Participants with Corporate Interests

A wide range of corporate entities have interests that overlap in both features and frameworks related to Iceberg and while we 
encourage engagement and contributions, the community is not a venue for marketing, solicitation, or recruitment.

Any vendor who wants to participate in the Apache Iceberg community Slack workspace should create a dedicated vendor channel 
for their organization prefixed by `vendor-`.  

This space can be used to discuss features and integration with Iceberg related to the vendor offering.  This space should not 
be used to promote competing vendor products/services or disparage other vendor offerings.  Discussion should be focused on 
questions asked by the community and not to expand/introduce/redirect users to alternate offerings.

### Marketing / Solicitation / Recruiting

The Apache Iceberg community is a space for everyone to operate free of influence.  The development lists, slack workspace, 
and github should not be used to market products or services.  Solicitation or overt promotion should not be performed in common 
channels or through direct messages.

Recruitment of community members should not be conducted through direct messages or community channels, but opportunities 
related to contributing to or using Iceberg can be posted to the `#jobs` channel. 

For questions regarding any of the guidelines above, please contact a PMC member
