---
title: "Blogs"
---
<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->

## Iceberg Blogs

Here is a list of company blogs that talk about Iceberg. The blogs are ordered from most recent to oldest.

### [How not to use Apache Iceberg](https://medium.com/@ajanthabhat/how-not-to-use-apache-iceberg-046ae7e7c884)
**Date**: January 23rd, 2024, **Company**: Dremio

**Authors**: [Ajantha Bhat](https://www.linkedin.com/in/ajanthabhat/)

### [Apache Hive-4.x with Iceberg Branches & Tags](https://medium.com/@ayushtkn/apache-hive-4-x-with-iceberg-branches-tags-3d52293ac0bf/)
**Date**: October 12th, 2023, **Company**: Cloudera

**Authors**: [Ayush Saxena](https://www.linkedin.com/in/ayush151/)

### [Apache Hive 4.x With Apache Iceberg](https://medium.com/@ayushtkn/apache-hive-4-x-with-apache-iceberg-part-i-355e7a380725/)
**Date**: October 12th, 2023, **Company**: Cloudera

**Authors**: [Ayush Saxena](https://www.linkedin.com/in/ayush151/)

### [From Hive Tables to Iceberg Tables: Hassle-Free](https://blog.cloudera.com/from-hive-tables-to-iceberg-tables-hassle-free/)
**Date**: July 14th, 2023, **Company**: Cloudera

**Authors**: [Srinivas Rishindra Pothireddi](https://www.linkedin.com/in/srinivas-rishindra/)

### [From Hive Tables to Iceberg Tables: Hassle-Free](https://blog.cloudera.com/from-hive-tables-to-iceberg-tables-hassle-free/)
**Date**: July 14th, 2023, **Company**: Cloudera

**Authors**: [Srinivas Rishindra Pothireddi](https://www.linkedin.com/in/srinivas-rishindra/)

### [12 Times Faster Query Planning With Iceberg Manifest Caching in Impala](https://blog.cloudera.com/12-times-faster-query-planning-with-iceberg-manifest-caching-in-impala/)
**Date**: July 13th, 2023, **Company**: Cloudera

**Authors**: [Riza Suminto](https://www.linkedin.com/in/rizasuminto/)

### [How Bilibili Builds OLAP Data Lakehouse with Apache Iceberg](https://medium.com/@lirui.fudan/how-bilibili-builds-olap-data-lakehouse-with-apache-iceberg-9f3408e53f9)
**Date**: June 14th, 2023, **Company**: Bilibili

**Authors**: [Rui Li](https://www.linkedin.com/in/rui-li-19282979/)

### [Introducing the Apache Iceberg Catalog Migration Tool](https://www.dremio.com/blog/introducing-the-apache-iceberg-catalog-migration-tool/)
**Date**: May 12th, 2022, **Company**: Dremio

**Authors**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/) & [Ajantha Bhat](https://www.linkedin.com/in/ajanthabhat/)

### [3 Ways to Use Python with Apache Iceberg](https://www.dremio.com/blog/3-ways-to-use-python-with-apache-iceberg/)
**Date**: April 12th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [3 Ways to Convert a Delta Lake Table Into an Apache Iceberg Table](https://www.dremio.com/blog/3-ways-to-convert-a-delta-lake-table-into-an-apache-iceberg-table/)
**Date**: April 3rd, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [How to Convert CSV Files into an Apache Iceberg table with Dremio](https://www.dremio.com/blog/how-to-convert-csv-files-into-an-apache-iceberg-table-with-dremio/)
**Date**: April 3rd, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Open Data Lakehouse powered by Iceberg for all your Data Warehouse needs](https://blog.cloudera.com/open-data-lakehouse-powered-by-iceberg-for-all-your-data-warehouse-needs/)
**Date**: April 3rd, 2023, **Company**: Cloudera

**Authors**: [Zoltan Borok-Nagy](https://www.linkedin.com/in/zoltán-borók-nagy-7370a65b/), [Ayush Saxena](https://www.linkedin.com/in/ayush-saxena151/), [Tamas Mate](https://www.linkedin.com/in/tmater/), [Simhadri Govindappa](https://www.linkedin.com/in/simhadri-govindappa-1a7788148/)

### [Exploring Branch & Tags in Apache Iceberg using Spark](https://www.dremio.com/blog/exploring-branch-tags-in-apache-iceberg-using-spark/)
**Date**: March 29th, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Iceberg Tables: Catalog Support Now Available](https://www.snowflake.com/blog/iceberg-tables-catalog-support-available-now/)
**Date**: March 29th, 2023, **Company**: Snowflake

**Authors**: [Ron Ortloff](https://www.linkedin.com/in/ron-ortloff/), [Dennis Huo](https://www.linkedin.com/in/dennis-huo-2aaba92a/)

### [Dealing with Data Incidents Using the Rollback Feature in Apache Iceberg](https://www.dremio.com/blog/dealing-with-data-incidents-using-the-rollback-feature-in-apache-iceberg/)
**Date**: February 24th, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Partition and File Pruning for Dremio’s Apache Iceberg-backed Reflections](https://www.dremio.com/blog/partition-and-file-pruning-for-dremios-apache-iceberg-backed-reflections/)
**Date**: February 8th, 2022, **Company**: Dremio

**Author**: [Benny Chow](https://www.linkedin.com/in/bechow/)

### [Understanding Iceberg Table Metadata](https://medium.com/snowflake/understanding-iceberg-table-metadata-b1209fbcc7c3)
**Date**: January 30st, 2023, **Company**: Snowflake

**Author**: [Phani Raj](https://www.linkedin.com/in/phani-raj-9830a31b/)

### [Creating and managing Apache Iceberg tables using serverless features and without coding](https://medium.com/snowflake/creating-and-managing-apache-iceberg-tables-using-serverless-features-and-without-coding-14d2198cf5b5)
**Date**: January 27th, 2023, **Company**: Snowflake

**Author**: [Parag Jain](https://www.linkedin.com/in/paragjainsa/)

### [Getting started with Apache Iceberg](https://medium.com/snowflake/getting-started-with-apache-iceberg-80f338921a31)
**Date**: January 27th, 2023, **Company**: Snowflake

**Author**: [Jedidiah Rajbhushan](https://www.linkedin.com/in/jrajbhushan/)

### [How Apache Iceberg enables ACID compliance for data lakes](https://medium.com/snowflake/how-apache-iceberg-enables-acid-compliance-for-data-lakes-9069ae783b60/)
**Date**: January 13th, 2023, **Company**: Snowflake

**Authors**: [Sumeet Tandure](https://www.linkedin.com/in/sumeettandure/)

### [Multi-Cloud Open Lakehouse with Apache Iceberg in Cloudera Data Platform](https://blog.cloudera.com/implement-a-multi-cloud-open-lakehouse-with-apache-iceberg-in-cloudera-data-platform/)
**Date**: December 15th, 2022, **Company**: Cloudera

**Authors**: [Bill Zhang](https://www.linkedin.com/in/billzhang01/), [Shaun Ahmadian](https://www.linkedin.com/in/ssahmadian/), [Zoltan Borok-Nagy](https://www.linkedin.com/in/zoltán-borók-nagy-7370a65b/), [Vincent Kulandaisamy](https://www.linkedin.com/in/vincentkulandaisamy/)

### [Connecting Tableau to Apache Iceberg Tables with Dremio](https://www.dremio.com/blog/connecting-tableau-to-apache-iceberg-tables-with-dremio/)
**Date**: December 15th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Getting Started with Project Nessie, Apache Iceberg, and Apache Spark Using Docker](https://www.dremio.com/blog/getting-started-with-project-nessie-apache-iceberg-and-apache-spark-using-docker/)
**Date**: December 15th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Apache Iceberg FAQ](https://www.dremio.com/blog/apache-iceberg-faq/)
**Date**: December 14th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [A Notebook for getting started with Project Nessie, Apache Iceberg, and Apache Spark](https://www.dremio.com/blog/a-notebook-for-getting-started-with-project-nessie-apache-iceberg-and-apache-spark/)
**Date**: December 5th, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Time Travel with Dremio and Apache Iceberg](https://www.dremio.com/blog/time-travel-with-dremio-and-apache-iceberg/)
**Date**: November 29th, 2022, **Company**: Dremio

**Author**: [Michael Flower](https://www.linkedin.com/in/michael-flower-b0a3474/)

### [Compaction in Apache Iceberg: Fine-Tuning Your Iceberg Table's Data Files](https://www.dremio.com/subsurface/compaction-in-apache-iceberg-fine-tuning-your-iceberg-tables-data-files/)
**Date**: November 9th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [The Life of a Read Query for Apache Iceberg Tables](https://www.dremio.com/subsurface/the-life-of-a-read-query-for-apache-iceberg-tables/)
**Date**: October 31st, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Puffins and Icebergs: Additional Stats for Apache Iceberg Tables](https://www.dremio.com/subsurface/puffins-and-icebergs-additional-stats-for-apache-iceberg-tables/)
**Date**: October 17th, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Apache Iceberg and the Right to be Forgotten](https://www.dremio.com/subsurface/apache-iceberg-and-the-right-to-be-forgotten/)
**Date**: September 30th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Streaming Data into Apache Iceberg tables using AWS Kinesis and AWS Glue](https://www.dremio.com/subsurface/streaming-data-into-apache-iceberg-tables-using-aws-kinesis-and-aws-glue/)
**Date**: September 26th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Iceberg Flink Sink: Stream Directly into your Data Warehouse Tables](https://tabular.io/blog/flink-sink/)
**Date**: October 12, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Partitioning for Correctness (and Performance)](https://tabular.io/blog/partitioning/)
**Date**: September 28, 2022, **Company**: Tabular

**Author**: [Jason Reid](https://www.linkedin.com/in/jasonreid/)

### [Ensuring High Performance at Any Scale with Apache Iceberg’s Object Store File Layout](https://www.dremio.com/subsurface/ensuring-high-performance-at-any-scale-with-apache-icebergs-object-store-file-layout/)
**Date**: September 20, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Introduction to Apache Iceberg Using Spark](https://www.dremio.com/subsurface/introduction-to-apache-iceberg-using-spark/)
**Date**: September 15, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [How Z-Ordering in Apache Iceberg Helps Improve Performance](https://www.dremio.com/subsurface/how-z-ordering-in-apache-iceberg-helps-improve-performance/)
**Date**: September 13th, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Apache Iceberg 101 – Your Guide to Learning Apache Iceberg Concepts and Practices](https://www.dremio.com/subsurface/apache-iceberg-101-your-guide-to-learning-apache-iceberg-concepts-and-practices/)
**Date**: September 12th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [A Hands-On Look at the Structure of an Apache Iceberg Table](https://www.dremio.com/subsurface/a-hands-on-look-at-the-structure-of-an-apache-iceberg-table/)
**Date**: August 24, 2022, **Company**: Dremio

**Author**: [Dipankar Mazumdar](https://www.linkedin.com/in/dipankar-mazumdar/)

### [Future-Proof Partitioning and Fewer Table Rewrites with Apache Iceberg](https://www.dremio.com/subsurface/future-proof-partitioning-and-fewer-table-rewrites-with-apache-iceberg/)
**Date**: August 18, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [How to use Apache Iceberg in CDP's Open Lakehouse](https://blog.cloudera.com/how-to-use-apache-iceberg-in-cdps-open-lakehouse/)
**Date**: August 8th, 2022, **Company**: Cloudera

**Authors**: [Bill Zhang](https://www.linkedin.com/in/billzhang01/), [Peter Ableda](https://www.linkedin.com/in/peterableda), [Shaun Ahmadian](https://www.linkedin.com/in/ssahmadian/), [Manish Maheshwari](https://www.linkedin.com/in/mmaheshwari/)

### [Near Real-Time Ingestion For Trino](https://www.starburst.io/blog/near-real-time-ingestion-for-trino/)
**Date**: August 4th, 2022, **Company**: Starburst

**Authors**: [Eric Hwang](https://www.linkedin.com/in/ericwhwang), [Monica Miller](https://www.linkedin.com/in/monica-d-miller), [Brian Zhan](https://www.linkedin.com/in/bzhan)

### [How to implement Apache Iceberg in AWS Athena](https://big-data-demystified.ninja/2022/07/28/how-to-implement-apache-iceberg-in-aws-athena/)
**Date**: July 28th, 2022

**Author**: [Shneior Dicastro]

### [Supercharge your Data Lakehouse with Apache Iceberg in Cloudera Data Platform](https://blog.cloudera.com/supercharge-your-data-lakehouse-with-apache-iceberg-in-cloudera-data-platform/)
**Date**: June 30th, 2022, **Company**: Cloudera

**Authors**: [Bill Zhang](https://www.linkedin.com/in/billzhang01/), [Shaun Ahmadian](https://www.linkedin.com/in/ssahmadian/)

### [Migrating a Hive Table to an Iceberg Table Hands-on Tutorial](https://www.dremio.com/subsurface/migrating-a-hive-table-to-an-iceberg-table-hands-on-tutorial/)
**Date**: June 6th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Fewer Accidental Full Table Scans Brought to You by Apache Iceberg’s Hidden Partitioning](https://www.dremio.com/subsurface/fewer-accidental-full-table-scans-brought-to-you-by-apache-icebergs-hidden-partitioning/)
**Date**: May 21st, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [An Introduction To The Iceberg Java API Part 2 - Table Scans](https://tabular.io/blog/java-api-part-2/)
**Date**: May 11th, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Iceberg's Guiding Light: The Iceberg Open Table Format Specification](https://tabular.io/blog/iceberg-format-version/)
**Date**: April 26th, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [How to Migrate a Hive Table to an Iceberg Table](https://www.dremio.com/subsurface/how-to-migrate-a-hive-table-to-an-iceberg-table/)
**Date**: April 15th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [Using Iceberg's S3FileIO Implementation To Store Your Data In MinIO](https://tabular.io/blog/minio/)
**Date**: April 14th, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Maintaining Iceberg Tables – Compaction, Expiring Snapshots, and More](https://www.dremio.com/subsurface/maintaining-iceberg-tables-compaction-expiring-snapshots-and-more/)
**Date**: April 7th, 2022, **Company**: Dremio

**Author**: [Alex Merced](https://www.linkedin.com/in/alexmerced/)

### [An Introduction To The Iceberg Java API - Part 1](https://tabular.io/blog/java-api-part-1/)
**Date**: April 1st, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Integrated Audits: Streamlined Data Observability With Apache Iceberg](https://tabular.io/blog/integrated-audits/)
**Date**: March 2nd, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Introducing Apache Iceberg in Cloudera Data Platform](https://blog.cloudera.com/introducing-apache-iceberg-in-cloudera-data-platform/)
**Date**: February 23rd, 2022, **Company**: Cloudera

**Authors**: [Bill Zhang](https://www.linkedin.com/in/billzhang01/), [Peter Vary](https://www.linkedin.com/in/peter-vary/), [Marton Bod](https://www.linkedin.com/in/martonbod/), [Wing Yew Poon](https://github.com/wypoon)

### [What's new in Iceberg 0.13](https://tabular.io/blog/whats-new-in-iceberg-0.13/)
**Date**: February 22nd, 2022, **Company**: Tabular

**Author**: [Ryan Blue](https://www.linkedin.com/in/rdblue/)

### [Apache Iceberg Becomes Industry Open Standard with Ecosystem Adoption](https://www.dremio.com/apache-iceberg-becomes-industry-open-standard-with-ecosystem-adoption/)
**Date**: February 3rd, 2022, **Company**: Dremio

**Author**: [Mark Lyons](https://www.linkedin.com/in/markclyons/)

### [Docker, Spark, and Iceberg: The Fastest Way to Try Iceberg!](https://tabular.io/blog/docker-spark-and-iceberg/)
**Date**: February 2nd, 2022, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/), [Kyle Bendickson](https://www.linkedin.com/in/kylebendickson/)

### [Expanding the Data Cloud with Apache Iceberg](https://www.snowflake.com/blog/expanding-the-data-cloud-with-apache-iceberg/)
**Date**: January 21st, 2022, **Company**: Snowflake

**Author**: [James Malone](https://www.linkedin.com/in/jamesamalone/)

### [Iceberg FileIO: Cloud Native Tables](https://tabular.io/blog/iceberg-fileio/)
**Date**: December 16th, 2021, **Company**: Tabular

**Author**: [Daniel Weeks](https://www.linkedin.com/in/daniel-weeks-a1946860/)

### [Using Spark in EMR with Apache Iceberg](https://tabular.io/blog/emr-spark-and-iceberg/)
**Date**: December 10th, 2021, **Company**: Tabular

**Author**: [Sam Redai](https://www.linkedin.com/in/sredai/)

### [Using Flink CDC to synchronize data from MySQL sharding tables and build real-time data lake](https://ververica.github.io/flink-cdc-connectors/master/content/quickstart/build-real-time-data-lake-tutorial.html)
**Date**: November 11th, 2021, **Company**: Ververica, Alibaba Cloud

**Author**: [Yuxia Luo](https://github.com/luoyuxia), [Jark Wu](https://github.com/wuchong), [Zheng Hu](https://www.linkedin.com/in/zheng-hu-37017683/)

### [Metadata Indexing in Iceberg](https://tabular.io/blog/iceberg-metadata-indexing/)
**Date**: October 10th, 2021, **Company**: Tabular

**Author**: [Ryan Blue](https://www.linkedin.com/in/rdblue/)

### [Using Debezium to Create a Data Lake with Apache Iceberg](https://debezium.io/blog/2021/10/20/using-debezium-create-data-lake-with-apache-iceberg/)
**Date**: October 20th, 2021, **Company**: Memiiso Community

**Author**: [Ismail Simsek](https://www.linkedin.com/in/ismailsimsek/)

### [How to Analyze CDC Data in Iceberg Data Lake Using Flink](https://www.alibabacloud.com/blog/how-to-analyze-cdc-data-in-iceberg-data-lake-using-flink_597838)
**Date**: June 15th, 2021, **Company**: Alibaba Cloud Community

**Author**: [Li Jinsong](https://www.linkedin.com/in/%E5%8A%B2%E6%9D%BE-%E6%9D%8E-48b54b101/), [Hu Zheng](https://www.linkedin.com/in/zheng-hu-37017683/), [Yang Weihai](https://www.linkedin.com/in/weihai-yang-697a16224/), [Peidan Li](https://www.linkedin.com/in/peidian-li-18938820a/)

### [Apache Iceberg: An Architectural Look Under the Covers](https://www.dremio.com/apache-iceberg-an-architectural-look-under-the-covers/)
**Date**: July 6th, 2021, **Company**: Dremio

**Author**: [Jason Hughes](https://www.linkedin.com/in/jasonhhughes/)

### [Migrating to Apache Iceberg at Adobe Experience Platform](https://medium.com/adobetech/migrating-to-apache-iceberg-at-adobe-experience-platform-40fa80f8b8de)
**Date**: Jun 17th, 2021, **Company**: Adobe

**Author**: [Romin Parekh](https://www.linkedin.com/in/rominparekh/), [Miao Wang](https://www.linkedin.com/in/miao-wang-0406a74/), [Shone Sadler](https://www.linkedin.com/in/shonesadler/)

### [Flink + Iceberg: How to Construct a Whole-scenario Real-time Data Warehouse](https://www.alibabacloud.com/blog/flink-%2B-iceberg-how-to-construct-a-whole-scenario-real-time-data-warehouse_597824)
**Date**: Jun 8th, 2021, **Company**: Tencent

**Author** [Shu (Simon Su) Su](https://www.linkedin.com/in/shu-su-62944994/)

### [Trino on Ice III: Iceberg Concurrency Model, Snapshots, and the Iceberg Spec](https://blog.starburst.io/trino-on-ice-iii-iceberg-concurrency-model-snapshots-and-the-iceberg-spec)
**Date**: May 25th, 2021, **Company**: Starburst

**Author**: [Brian Olsen](https://www.linkedin.com/in/bitsondatadev)

### [Trino on Ice II: In-Place Table Evolution and Cloud Compatibility with Iceberg](https://blog.starburst.io/trino-on-ice-ii-in-place-table-evolution-and-cloud-compatibility-with-iceberg)
**Date**: May 11th, 2021, **Company**: Starburst

**Author**: [Brian Olsen](https://www.linkedin.com/in/bitsondatadev)

### [Trino On Ice I: A Gentle Introduction To Iceberg](https://blog.starburst.io/trino-on-ice-i-a-gentle-introduction-to-iceberg)
**Date**: Apr 27th, 2021, **Company**: Starburst

**Author**: [Brian Olsen](https://www.linkedin.com/in/bitsondatadev)

### [Apache Iceberg: A Different Table Design for Big Data](https://thenewstack.io/apache-iceberg-a-different-table-design-for-big-data/)
**Date**: Feb 1st, 2021, **Company**: thenewstack.io

**Author**: [Susan Hall](https://thenewstack.io/author/susanhall/)

### [A Short Introduction to Apache Iceberg](https://medium.com/expedia-group-tech/a-short-introduction-to-apache-iceberg-d34f628b6799)
**Date**: Jan 26th, 2021, **Company**: Expedia

**Author**: [Christine Mathiesen](https://www.linkedin.com/in/christine-mathiesen-676a98159/)

### [Taking Query Optimizations to the Next Level with Iceberg](https://medium.com/adobetech/taking-query-optimizations-to-the-next-level-with-iceberg-6c968b83cd6f)
**Date**: Jan 14th, 2021, **Company**: Adobe

**Author**: [Gautam Kowshik](https://www.linkedin.com/in/gautamk/), [Xabriel J. Collazo Mojica](https://www.linkedin.com/in/xabriel/)

### [FastIngest: Low-latency Gobblin with Apache Iceberg and ORC format](https://engineering.linkedin.com/blog/2021/fastingest-low-latency-gobblin)
**Date**: Jan 6th, 2021, **Company**: Linkedin

**Author**: [Zihan Li](https://www.linkedin.com/in/zihan-li-0a8a15149/), [Sudarshan Vasudevan](https://www.linkedin.com/in/suddu/), [Lei Sun](https://www.linkedin.com/in/lei-s-a93138a0/), [Shirshanka Das](https://www.linkedin.com/in/shirshankadas/)

### [High Throughput Ingestion with Iceberg](https://medium.com/adobetech/high-throughput-ingestion-with-iceberg-ccf7877a413f)
**Date**: Dec 22nd, 2020, **Company**: Adobe

**Author**: [Andrei Ionescu](http://linkedin.com/in/andreiionescu), [Shone Sadler](https://www.linkedin.com/in/shonesadler/), [Anil Malkani](https://www.linkedin.com/in/anil-malkani-52861a/)

### [Optimizing data warehouse storage](https://netflixtechblog.com/optimizing-data-warehouse-storage-7b94a48fdcbe)
**Date**: Dec 21st, 2020, **Company**: Netflix

**Author**: [Anupom Syam](https://www.linkedin.com/in/anupom/)

### [Iceberg at Adobe](https://medium.com/adobetech/iceberg-at-adobe-88cf1950e866)
**Date**: Dec 3rd, 2020, **Company**: Adobe

**Author**: [Shone Sadler](https://www.linkedin.com/in/shonesadler/), [Romin Parekh](https://www.linkedin.com/in/rominparekh/), [Anil Malkani](https://www.linkedin.com/in/anil-malkani-52861a/)

### [Bulldozer: Batch Data Moving from Data Warehouse to Online Key-Value Stores](https://netflixtechblog.com/bulldozer-batch-data-moving-from-data-warehouse-to-online-key-value-stores-41bac13863f8)
**Date**: Oct 27th, 2020, **Company**: Netflix

**Author**: [Tianlong Chen](https://www.linkedin.com/in/tianlong-chen-39189b7a/), [Ioannis Papapanagiotou](https://www.linkedin.com/in/ipapapa/)
