---
title: "Roadmap"
---
<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->

# Roadmap Overview

This roadmap outlines projects that the Iceberg community is working on.
Each high-level item links to a Github project board that tracks the current status.
Related design docs will be linked on the planning boards.

# General

* [Multi-table transaction support](https://github.com/apache/iceberg/projects/30)
* [Views Support](https://github.com/apache/iceberg/projects/29)
* [Change Data Capture (CDC) Support](https://github.com/apache/iceberg/projects/26)
* [Snapshot tagging and branching](https://github.com/apache/iceberg/projects/4)
* [Inline file compaction](https://github.com/apache/iceberg/projects/14)
* [Delete File compaction](https://github.com/apache/iceberg/projects/10)
* [Z-ordering / Space-filling curves](https://github.com/apache/iceberg/projects/16)
* [Support UPSERT](https://github.com/apache/iceberg/projects/15)

# Clients
_Python, Rust, and Go projects are pointing to their respective repositories which include 
their own issues as the implementations are not final._

* [Add the Iceberg Python Client](https://github.com/apache/iceberg-python)
* [Add the Iceberg Rust Client](https://github.com/apache/iceberg-rust)
* [Add the Iceberg Go Client](https://github.com/apache/iceberg-go)

# Spec V2

* [Views Spec](https://github.com/apache/iceberg/projects/6)
* [DSv2 streaming improvements](https://github.com/apache/iceberg/projects/2)
* [Secondary indexes](https://github.com/apache/iceberg/projects/17)

# Spec V3

* [Encryption](https://github.com/apache/iceberg/projects/5)
* [Relative paths](https://github.com/apache/iceberg/projects/18)
* [Default field values](https://github.com/apache/iceberg/projects/19)
