/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.DataInputViewWrapper;
import org.apache.beam.runners.flink.translation.wrappers.DataOutputViewWrapper;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class CoderTypeSerializer<@UnknownKeyFor T>
extends TypeSerializer<T> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized boolean fasterCopy;

    public CoderTypeSerializer(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
        Preconditions.checkNotNull(coder);
        Preconditions.checkNotNull((Object)pipelineOptions);
        this.coder = coder;
        this.pipelineOptions = pipelineOptions;
        FlinkPipelineOptions options = (FlinkPipelineOptions)pipelineOptions.get().as(FlinkPipelineOptions.class);
        this.fasterCopy = options.getFasterCopy();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isImmutableType() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized CoderTypeSerializer<T> duplicate() {
        return new CoderTypeSerializer<T>(this.coder, this.pipelineOptions);
    }

    public T createInstance() {
        return null;
    }

    public T copy(T t) {
        if (this.fasterCopy) {
            return t;
        }
        try {
            return (T)CoderUtils.clone(this.coder, t);
        }
        catch (CoderException e) {
            throw new RuntimeException("Could not clone.", e);
        }
    }

    public T copy(T t, T reuse) {
        return this.copy(t);
    }

    public @UnknownKeyFor @NonNull @Initialized int getLength() {
        return -1;
    }

    public void serialize(T t, @UnknownKeyFor @NonNull @Initialized DataOutputView dataOutputView) throws @UnknownKeyFor @NonNull @Initialized IOException {
        DataOutputViewWrapper outputWrapper = new DataOutputViewWrapper(dataOutputView);
        this.coder.encode(t, (OutputStream)outputWrapper);
    }

    public T deserialize(@UnknownKeyFor @NonNull @Initialized DataInputView dataInputView) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            DataInputViewWrapper inputWrapper = new DataInputViewWrapper(dataInputView);
            return (T)this.coder.decode((InputStream)inputWrapper);
        }
        catch (CoderException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw e;
        }
    }

    public T deserialize(T t, @UnknownKeyFor @NonNull @Initialized DataInputView dataInputView) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.deserialize(dataInputView);
    }

    public void copy(@UnknownKeyFor @NonNull @Initialized DataInputView dataInputView, @UnknownKeyFor @NonNull @Initialized DataOutputView dataOutputView) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.serialize(this.deserialize(dataInputView), dataOutputView);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoderTypeSerializer that = (CoderTypeSerializer)((Object)o);
        return this.coder.equals(that.coder);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.coder.hashCode();
    }

    public @UnknownKeyFor @NonNull @Initialized TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new LegacySnapshot(this);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "CoderTypeSerializer{coder=" + this.coder + '}';
    }

    public static class LegacySnapshot<@UnknownKeyFor T>
    extends TypeSerializerConfigSnapshot<T> {
        public LegacySnapshot() {
        }

        public LegacySnapshot(@UnknownKeyFor @NonNull @Initialized CoderTypeSerializer<T> serializer) {
            this.setPriorSerializer(serializer);
        }

        public @UnknownKeyFor @NonNull @Initialized int getVersion() {
            return 1;
        }

        public @UnknownKeyFor @NonNull @Initialized TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(@UnknownKeyFor @NonNull @Initialized TypeSerializer<T> newSerializer) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

