/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.io;

import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.beam.sdk.extensions.avro.io.AvroSink;
import org.apache.beam.sdk.extensions.avro.io.AvroSource;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public abstract class AvroDatumFactory<@UnknownKeyFor T>
implements AvroSource.DatumReaderFactory<T>,
AvroSink.DatumWriterFactory<T> {
    protected final @UnknownKeyFor @NonNull @Initialized Class<T> type;

    public static @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<@UnknownKeyFor @NonNull @Initialized GenericRecord> generic() {
        return GenericDatumFactory.INSTANCE;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> specific(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return new SpecificDatumFactory<T>(type);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> reflect(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return new ReflectDatumFactory<T>(type);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        return AvroDatumFactory.of(type, true);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AvroDatumFactory<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type, @UnknownKeyFor @NonNull @Initialized boolean useReflectApi) {
        if (GenericRecord.class.equals(type)) {
            return GenericDatumFactory.INSTANCE;
        }
        if (SpecificRecord.class.isAssignableFrom(type) && !useReflectApi) {
            return new SpecificDatumFactory<T>(type);
        }
        return new ReflectDatumFactory<T>(type);
    }

    public AvroDatumFactory(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
        this.type = type;
    }

    public @UnknownKeyFor @NonNull @Initialized Class<T> getType() {
        return this.type;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AvroDatumFactory that = (AvroDatumFactory)other;
        return Objects.equals(this.type, that.type);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getClass(), this.type);
    }

    public static class ReflectDatumFactory<@UnknownKeyFor T>
    extends AvroDatumFactory<T> {
        public ReflectDatumFactory(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
            super(type);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumReader<T> apply(@UnknownKeyFor @NonNull @Initialized Schema writer, @UnknownKeyFor @NonNull @Initialized Schema reader) {
            ReflectDatumReader datumReader = new ReflectDatumReader(this.type);
            datumReader.setExpected(reader);
            datumReader.setSchema(writer);
            AvroUtils.addLogicalTypeConversions(datumReader.getData());
            return datumReader;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumWriter<T> apply(@UnknownKeyFor @NonNull @Initialized Schema writer) {
            ReflectDatumWriter datumWriter = new ReflectDatumWriter(this.type);
            datumWriter.setSchema(writer);
            AvroUtils.addLogicalTypeConversions(datumWriter.getData());
            return datumWriter;
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized ReflectDatumFactory<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
            return new ReflectDatumFactory<T>(type);
        }
    }

    public static class SpecificDatumFactory<@UnknownKeyFor T>
    extends AvroDatumFactory<T> {
        public SpecificDatumFactory(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
            super(type);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumReader<T> apply(@UnknownKeyFor @NonNull @Initialized Schema writer, @UnknownKeyFor @NonNull @Initialized Schema reader) {
            SpecificDatumReader datumReader = new SpecificDatumReader(this.type);
            datumReader.setExpected(reader);
            datumReader.setSchema(writer);
            return datumReader;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumWriter<T> apply(@UnknownKeyFor @NonNull @Initialized Schema writer) {
            SpecificDatumWriter datumWriter = new SpecificDatumWriter(this.type);
            datumWriter.setSchema(writer);
            return datumWriter;
        }

        public static <T> @UnknownKeyFor @NonNull @Initialized SpecificDatumFactory<T> of(@UnknownKeyFor @NonNull @Initialized Class<T> type) {
            return new SpecificDatumFactory<T>(type);
        }
    }

    public static class GenericDatumFactory
    extends AvroDatumFactory<GenericRecord> {
        public static final @UnknownKeyFor @NonNull @Initialized GenericDatumFactory INSTANCE = new GenericDatumFactory();

        public GenericDatumFactory() {
            super(GenericRecord.class);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumReader<@UnknownKeyFor @NonNull @Initialized GenericRecord> apply(@UnknownKeyFor @NonNull @Initialized Schema writer, @UnknownKeyFor @NonNull @Initialized Schema reader) {
            return new GenericDatumReader(writer, reader);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DatumWriter<@UnknownKeyFor @NonNull @Initialized GenericRecord> apply(@UnknownKeyFor @NonNull @Initialized Schema writer) {
            return new GenericDatumWriter(writer);
        }
    }
}

