/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLList;
import java.io.IOException;
import java.io.ObjectInputStream;

public class UnorderedList
extends HTMLList {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final long serialVersionUID = -8234261579413831795L;
    private String type_;

    public UnorderedList() {
    }

    public UnorderedList(String type) {
        this.setType(type);
    }

    private String getTypeAttributeTag() {
        StringBuffer s = new StringBuffer("");
        if (this.type_ != null) {
            if (this.type_.equals("disc")) {
                s.append(" type=\"disc\"");
            } else if (this.type_.equals("square")) {
                s.append(" type=\"square\"");
            } else if (this.type_.equals("circle")) {
                s.append(" type=\"circle\"");
            }
            return s.toString();
        }
        return "";
    }

    public String getType() {
        return this.type_;
    }

    @Override
    public String getTag() {
        if (this.isUseFO()) {
            return this.getFOTag();
        }
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        StringBuffer s = new StringBuffer("<ul");
        s.append(this.getTypeAttributeTag());
        if (this.isCompact()) {
            s.append(" compact=\"compact\"");
        }
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        s.append(">\n");
        s.append(this.getItemAttributeTag());
        s.append("</ul>\n");
        return s.toString();
    }

    @Override
    public String getFOTag() {
        boolean useFO = this.isUseFO();
        this.setUseFO(true);
        if (this.getItems().isEmpty()) {
            Trace.log(2, "Attempting to get XSL-FO tag before setting items in list.");
            throw new ExtendedIllegalStateException("items", 4);
        }
        if (this.type_ == null) {
            this.type_ = "disc";
        }
        StringBuffer s = new StringBuffer("<fo:block-container");
        s.append(this.getDirectionAttributeTag());
        s.append(">\n");
        s.append("<fo:list-block");
        s.append(">\n");
        s.append(this.getItemAttributeFOTag(this.type_));
        s.append("</fo:list-block>\n");
        s.append("</fo:block-container>\n");
        this.setUseFO(useFO);
        return s.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setType(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (!(type.equals("disc") || type.equals("circle") || type.equals("square"))) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        String old = this.type_;
        this.type_ = type;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("type", old, type);
        }
    }
}

