/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.DirFilter;
import com.ibm.as400.util.html.HTMLFileFilter;
import com.ibm.as400.util.html.HTMLTree;
import com.ibm.as400.util.html.ResourceBundleLoader_h;
import com.ibm.as400.util.html.URLEncoder;
import com.ibm.as400.util.servlet.ListMetaData;
import com.ibm.as400.util.servlet.ListRowData;
import com.ibm.as400.util.servlet.RowDataException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class FileListRenderer
implements Serializable {
    private String uri_;
    private String reqPath_;
    private StringBuffer sharePath_;
    private StringBuffer shareName_;
    private SimpleDateFormat formatter_ = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
    private static ResourceBundleLoader_h loader_;
    private static String name;
    private static String size;
    private static String type;
    private static String modified;

    public FileListRenderer(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        this.uri_ = request.getRequestURI();
        String servletPath = request.getServletPath();
        int i = this.uri_.indexOf(servletPath);
        this.uri_ = this.uri_.substring(0, i + servletPath.length());
        this.reqPath_ = request.getPathInfo();
    }

    public FileListRenderer(HttpServletRequest request, String shareName, String sharePath) {
        this(request);
        if (sharePath == null) {
            throw new NullPointerException("sharePath");
        }
        if (shareName == null) {
            throw new NullPointerException("shareName");
        }
        this.sharePath_ = new StringBuffer(sharePath);
        this.shareName_ = new StringBuffer(shareName);
        if (Trace.isTraceOn()) {
            Trace.log(3, "Renderer sharePath: " + this.shareName_);
            Trace.log(3, "Renderer shareName: " + this.sharePath_);
        }
    }

    public String getDirectoryName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        String name = file.getName();
        StringBuffer buffer = new StringBuffer("<a href=\"");
        buffer.append(this.uri_);
        buffer.append(URLEncoder.encode(this.reqPath_.replace('\\', '/'), false));
        buffer.append(this.reqPath_.endsWith("/") ? "" : "/");
        buffer.append(URLEncoder.encode(name, false));
        buffer.append("\">");
        buffer.append(name);
        buffer.append("</a>");
        return buffer.toString();
    }

    public String getFileName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        return file.getName();
    }

    public String getParentName(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        String parent = file.getParent();
        if (parent != null) {
            block6: {
                if (this.sharePath_ != null) {
                    try {
                        parent = this.shareName_.append(parent.substring(this.sharePath_.length(), parent.length())).toString();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        if (parent.length() >= this.sharePath_.length()) break block6;
                        return null;
                    }
                }
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "Renderer parent: " + parent);
            }
            StringBuffer buffer = new StringBuffer("<a href=\"");
            buffer.append(this.uri_);
            buffer.append(parent.startsWith("\\") || parent.startsWith("/") ? "" : "/");
            buffer.append(parent != null ? URLEncoder.encode(parent.replace('\\', '/'), false) : "");
            buffer.append("\">../ (Parent Directory)</a>");
            return buffer.toString();
        }
        return null;
    }

    public ListRowData getRowData(File file, boolean sort, Collator collator) throws RowDataException {
        Date d;
        Vector<Object> v;
        ListMetaData metaData = new ListMetaData(4);
        metaData.setColumnName(0, "Name");
        metaData.setColumnLabel(0, name);
        metaData.setColumnType(0, 8);
        metaData.setColumnName(1, "Size");
        metaData.setColumnLabel(1, size);
        metaData.setColumnType(1, 5);
        metaData.setColumnName(2, "Type");
        metaData.setColumnLabel(2, type);
        metaData.setColumnType(2, 8);
        metaData.setColumnName(3, "Modified");
        metaData.setColumnLabel(3, modified);
        metaData.setColumnType(3, 8);
        ListRowData rowData = new ListRowData();
        try {
            rowData.setMetaData(metaData);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        String parentName = this.getParentName(file);
        if (parentName != null) {
            Object[] row = new Object[]{parentName.replace('\\', '/'), "", "", ""};
            rowData.addRow(row);
        }
        Object[] dirList = null;
        Object[] fileList = null;
        if (file instanceof IFSJavaFile) {
            File[] filesAndDirs = ((IFSJavaFile)file).listFiles();
            Vector<File> dv = new Vector<File>();
            Vector<File> fv = new Vector<File>();
            for (int i = 0; i < filesAndDirs.length; ++i) {
                if (filesAndDirs[i].isDirectory()) {
                    dv.addElement(filesAndDirs[i]);
                    continue;
                }
                fv.addElement(filesAndDirs[i]);
            }
            dirList = new File[dv.size()];
            fileList = new File[fv.size()];
            dv.copyInto(dirList);
            fv.copyInto(fileList);
        } else {
            String[] dlist = file.list(new DirFilter());
            dirList = new File[dlist.length];
            for (int i = 0; i < dlist.length; ++i) {
                dirList[i] = new File(file, dlist[i]);
            }
            String[] flist = file.list(new HTMLFileFilter());
            fileList = new File[flist.length];
            for (int i = 0; i < flist.length; ++i) {
                fileList[i] = new File(file, flist[i]);
            }
        }
        if (dirList != null) {
            if (sort) {
                v = new Vector<Object>();
                for (int i = 0; i < dirList.length; ++i) {
                    v.addElement(dirList[i]);
                }
                HTMLTree.sort(collator, v);
                v.copyInto(dirList);
            }
            for (int i = 0; i < dirList.length; ++i) {
                String dirName = this.getDirectoryName((File)dirList[i]);
                if (dirName == null) continue;
                Object[] row = new Object[4];
                d = new Date(((File)dirList[i]).lastModified());
                row[0] = dirName.replace('\\', '/');
                row[1] = "";
                row[2] = "Directory";
                row[3] = this.formatter_.format(d);
                rowData.addRow(row);
            }
        }
        if (fileList != null) {
            if (sort) {
                v = new Vector();
                for (int i = 0; i < fileList.length; ++i) {
                    v.addElement(fileList[i]);
                }
                HTMLTree.sort(collator, v);
                v.copyInto(fileList);
            }
            for (int i = 0; i < fileList.length; ++i) {
                String fileName = this.getFileName((File)fileList[i]);
                if (fileName == null) continue;
                Object[] row = new Object[4];
                d = new Date(((File)fileList[i]).lastModified());
                row[0] = fileName.replace('\\', '/');
                row[1] = ((File)fileList[i]).length();
                row[2] = "File";
                row[3] = this.formatter_.format(d);
                rowData.addRow(row);
            }
        }
        return rowData;
    }

    static {
        name = ResourceBundleLoader_h.getText("PROP_FLE_NAME_NAME");
        size = ResourceBundleLoader_h.getText("PROP_FLE_NAME_SIZE");
        type = ResourceBundleLoader_h.getText("PROP_FLE_NAME_TYPE");
        modified = ResourceBundleLoader_h.getText("PROP_FLE_NAME_MODIFIED");
    }
}

