/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.Map;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class BatchStatefulParDoOverrides {
    public static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT>> singleOutputOverrideFactory() {
        return new SingleOutputOverrideFactory();
    }

    public static <K, InputT, OutputT> @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT>> multiOutputOverrideFactory(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        return new MultiOutputOverrideFactory();
    }

    private static <InputT, OutputT> void verifyFnIsStateful(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        Preconditions.checkState((signature.usesState() || signature.usesTimers() ? 1 : 0) != 0, (String)"%s used for %s that does not use state or timers.", (Object)BatchStatefulParDoOverrides.class.getSimpleName(), (Object)ParDo.class.getSimpleName());
    }

    public static class BatchStatefulDoFn<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor OutputT>
    extends DoFn<KV<K, Iterable<KV<Instant, WindowedValue<KV<K, V>>>>>, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, OutputT> underlyingDoFn;

        BatchStatefulDoFn(@UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, OutputT> underlyingDoFn) {
            this.underlyingDoFn = underlyingDoFn;
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @NonNull @Initialized KV<K, V>, OutputT> getUnderlyingDoFn() {
            return this.underlyingDoFn;
        }

        @DoFn.Setup
        public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            DoFnInvokers.tryInvokeSetupFor(this.underlyingDoFn, (PipelineOptions)options);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            throw new UnsupportedOperationException("BatchStatefulDoFn.ProcessElement should never be invoked");
        }

        @DoFn.Teardown
        public void teardown() {
            DoFnInvokers.invokerFor(this.underlyingDoFn).invokeTeardown();
        }

        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.underlyingDoFn.getOutputTypeDescriptor();
        }
    }

    static class ReifyWindowedValueFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KV<K, V>, KV<K, KV<Instant, WindowedValue<KV<K, V>>>>> {
        ReifyWindowedValueFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)KV.of((Object)c.timestamp(), (Object)WindowedValue.of((Object)((KV)c.element()), (Instant)c.timestamp(), (BoundedWindow)window, (PaneInfo)c.pane()))));
        }
    }

    static class GbkBeforeStatefulParDo<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<KV<Instant, WindowedValue<KV<K, V>>>>>>> {
        GbkBeforeStatefulParDo() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Instant, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>>>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            WindowingStrategy inputWindowingStrategy = input.getWindowingStrategy();
            Preconditions.checkState((boolean)(input.getCoder() instanceof KvCoder), (String)"Input to a %s using state requires a %s, but the coder was %s", (Object)ParDo.class.getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)input.getCoder());
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder windowCoder = inputWindowingStrategy.getWindowFn().windowCoder();
            return ((PCollection)((PCollection)input.apply("ReifyWindows", (PTransform)ParDo.of(new ReifyWindowedValueFn()))).setCoder((Coder)KvCoder.of((Coder)keyCoder, (Coder)KvCoder.of((Coder)InstantCoder.of(), (Coder)WindowedValue.getFullCoder((Coder)kvCoder, (Coder)windowCoder)))).apply("PartitionKeys", new BatchViewOverrides.GroupByKeyAndSortValuesOnly())).setWindowingStrategyInternal(inputWindowingStrategy);
        }
    }

    static class StatefulMultiOutputParDo<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollectionTuple> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> originalParDo;

        StatefulMultiOutputParDo(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> originalParDo) {
            this.originalParDo = originalParDo;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            DoFn fn = this.originalParDo.getFn();
            BatchStatefulParDoOverrides.verifyFnIsStateful(fn);
            DataflowPipelineOptions options = (DataflowPipelineOptions)input.getPipeline().getOptions().as(DataflowPipelineOptions.class);
            DataflowRunner.verifyDoFnSupported(fn, false, options);
            DataflowRunner.verifyStateSupportForWindowingStrategy(input.getWindowingStrategy());
            ParDo.MultiOutput statefulParDo = ParDo.of(new BatchStatefulDoFn(fn)).withSideInputs(this.originalParDo.getSideInputs()).withOutputTags(this.originalParDo.getMainOutputTag(), this.originalParDo.getAdditionalOutputTags());
            return (PCollectionTuple)((PCollection)input.apply(new GbkBeforeStatefulParDo())).apply((PTransform)statefulParDo);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> getOriginalParDo() {
            return this.originalParDo;
        }
    }

    static class StatefulSingleOutputParDo<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<OutputT>> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> originalParDo;

        StatefulSingleOutputParDo(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> originalParDo) {
            this.originalParDo = originalParDo;
        }

        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT> getOriginalParDo() {
            return this.originalParDo;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>> input) {
            DoFn fn = this.originalParDo.getFn();
            BatchStatefulParDoOverrides.verifyFnIsStateful(fn);
            DataflowPipelineOptions options = (DataflowPipelineOptions)input.getPipeline().getOptions().as(DataflowPipelineOptions.class);
            DataflowRunner.verifyDoFnSupported(fn, false, options);
            DataflowRunner.verifyStateSupportForWindowingStrategy(input.getWindowingStrategy());
            ParDo.SingleOutput statefulParDo = ParDo.of(new BatchStatefulDoFn(fn)).withSideInputs(this.originalParDo.getSideInputs());
            return (PCollection)((PCollection)input.apply(new GbkBeforeStatefulParDo())).apply((PTransform)statefulParDo);
        }
    }

    private static class MultiOutputOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollectionTuple, ParDo.MultiOutput<KV<K, InputT>, OutputT>> {
        private MultiOutputOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StatefulMultiOutputParDo((ParDo.MultiOutput)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, (POutput)newOutput);
        }
    }

    private static class SingleOutputOverrideFactory<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollection<OutputT>, ParDo.SingleOutput<KV<K, InputT>, OutputT>> {
        private SingleOutputOverrideFactory() {
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>>, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StatefulSingleOutputParDo((ParDo.SingleOutput)transform.getTransform()));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

