/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.commons.math3.stat.StatUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BundleSplitter
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions options;

    public BundleSplitter(@UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions options) {
        this.options = options;
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OffsetRange> getBundleSizes(@UnknownKeyFor @NonNull @Initialized int desiredNumBundles, @UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        ArrayList<OffsetRange> result = new ArrayList<OffsetRange>();
        double[] relativeSizes = this.getRelativeBundleSizes(desiredNumBundles);
        double s = StatUtils.sum((double[])relativeSizes);
        long startOffset = start;
        double sizeSoFar = 0.0;
        for (int i = 0; i < relativeSizes.length; ++i) {
            long endOffset;
            long l = endOffset = i == relativeSizes.length - 1 ? end : (long)((double)start + (sizeSoFar += relativeSizes[i]) * (double)(end - start) / s);
            if (startOffset != endOffset) {
                result.add(new OffsetRange(startOffset, endOffset));
            }
            startOffset = endOffset;
        }
        return result;
    }

    private @UnknownKeyFor @NonNull @Initialized double @UnknownKeyFor @NonNull @Initialized [] getRelativeBundleSizes(@UnknownKeyFor @NonNull @Initialized int desiredNumBundles) {
        double[] relativeSizes = new double[desiredNumBundles];
        for (int i = 0; i < relativeSizes.length; ++i) {
            relativeSizes[i] = this.options.bundleSizeDistribution.sample(this.options.hashFunction().hashInt(i).asLong());
        }
        return relativeSizes;
    }
}

