/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OdfSchemaDocument
extends OdfPackageDocument {
    protected OdfContentDom mContentDom;
    protected OdfStylesDom mStylesDom;
    protected OdfMetaDom mMetaDom;
    protected OdfSettingsDom mSettingsDom;
    protected OdfOfficeStyles mDocumentStyles;

    protected OdfSchemaDocument(OdfPackage pkg, String internalPath, String mediaTypeString) {
        super(pkg, internalPath, mediaTypeString);
        ErrorHandler errorHandler = pkg.getErrorHandler();
        if (errorHandler != null) {
            if (pkg.getFileEntry(internalPath + "content.xml") == null && pkg.getFileEntry(internalPath + "styles.xml") == null) {
                try {
                    String baseURI = pkg.getBaseURI();
                    if (baseURI == null) {
                        baseURI = internalPath;
                    } else if (!internalPath.equals("")) {
                        baseURI = "/" + internalPath;
                    }
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITHOUT_CONTENT_NOR_STYLES_XML, baseURI, new Object[0]));
                }
                catch (SAXException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            InputStream mimetypeStream = pkg.getInputStream(OdfPackage.OdfFile.MEDIA_TYPE.getPath(), true);
            if (internalPath.equals("") && mimetypeStream == null) {
                try {
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.PACKAGE_SHALL_CONTAIN_MIMETYPE, pkg.getBaseURI(), new Object[0]));
                }
                catch (SAXException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public InputStream getContentStream() throws Exception {
        String path = this.getXMLFilePath(OdfXMLFile.CONTENT);
        return this.mPackage.getInputStream(path);
    }

    public InputStream getStylesStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.STYLES));
    }

    public InputStream getSettingsStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.SETTINGS));
    }

    public InputStream getMetaStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.META));
    }

    protected String getXMLFilePath(OdfXMLFile file) {
        return file.mFileName;
    }

    public String getBaseURI() {
        return this.mPackage.getBaseURI();
    }

    public OdfContentDom getContentDom() throws Exception {
        if (this.mContentDom == null) {
            this.mContentDom = (OdfContentDom)this.getFileDom(OdfXMLFile.CONTENT);
        }
        return this.mContentDom;
    }

    public OdfStylesDom getStylesDom() throws Exception {
        if (this.mStylesDom == null) {
            this.mStylesDom = (OdfStylesDom)this.getFileDom(OdfXMLFile.STYLES);
        }
        return this.mStylesDom;
    }

    public OdfMetaDom getMetaDom() throws Exception {
        if (this.mMetaDom == null) {
            this.mMetaDom = (OdfMetaDom)this.getFileDom(OdfXMLFile.META);
        }
        return this.mMetaDom;
    }

    public OdfSettingsDom getSettingsDom() throws Exception {
        if (this.mSettingsDom == null) {
            this.mSettingsDom = (OdfSettingsDom)this.getFileDom(OdfXMLFile.SETTINGS);
        }
        return this.mSettingsDom;
    }

    public OdfOfficeStyles getDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                OdfStylesDom stylesDom = this.getStylesDom();
                if (stylesDom == null) {
                    return null;
                }
                this.mDocumentStyles = OdfElement.findFirstChildNode(OdfOfficeStyles.class, stylesDom.getFirstChild());
            }
            catch (Exception ex) {
                Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public OdfOfficeMasterStyles getOfficeMasterStyles() {
        try {
            OdfStylesDom fileDom = this.getStylesDom();
            if (fileDom != null) {
                return OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, fileDom.getFirstChild());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public OdfOfficeStyles getOrCreateDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                Node parent;
                OdfStylesDom stylesDom = this.getStylesDom();
                Node node = parent = stylesDom != null ? stylesDom.getFirstChild() : null;
                if (parent != null) {
                    this.mDocumentStyles = OdfElement.findFirstChildNode(OdfOfficeStyles.class, parent);
                    if (this.mDocumentStyles == null) {
                        this.mDocumentStyles = stylesDom.newOdfElement(OdfOfficeStyles.class);
                        parent.insertBefore((Node)((Object)this.mDocumentStyles), parent.getFirstChild());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public void close() {
        this.mContentDom = null;
        this.mStylesDom = null;
        this.mMetaDom = null;
        this.mSettingsDom = null;
        this.mDocumentStyles = null;
        super.close();
    }

    public OdfFileDom getFileDom(OdfXMLFile file) throws Exception {
        return this.getFileDom(this.getXMLFilePath(file));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfXMLFile {
        CONTENT("content.xml"),
        META("meta.xml"),
        SETTINGS("settings.xml"),
        STYLES("styles.xml");

        private final String mFileName;

        public String getFileName() {
            return this.mFileName;
        }

        private OdfXMLFile(String fileName) {
            this.mFileName = fileName;
        }
    }
}

