/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.exceptions.UnknownColumnException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class ColumnSubselection
implements Comparable<ColumnSubselection> {
    public static final Serializer serializer = new Serializer();
    protected final ColumnMetadata column;

    protected ColumnSubselection(ColumnMetadata column) {
        this.column = column;
    }

    public static ColumnSubselection slice(ColumnMetadata column, CellPath from, CellPath to) {
        assert (column.isComplex() && column.type instanceof CollectionType);
        assert (from.size() <= 1 && to.size() <= 1);
        return new Slice(column, from, to);
    }

    public static ColumnSubselection element(ColumnMetadata column, CellPath elt) {
        assert (column.isComplex() && column.type instanceof CollectionType);
        assert (elt.size() == 1);
        return new Element(column, elt);
    }

    public ColumnMetadata column() {
        return this.column;
    }

    protected abstract Kind kind();

    protected abstract CellPath comparisonPath();

    @Override
    public int compareTo(ColumnSubselection other) {
        assert (other.column().name.equals(this.column().name));
        return this.column().cellPathComparator().compare(this.comparisonPath(), other.comparisonPath());
    }

    public abstract int compareInclusionOf(CellPath var1);

    public String toString() {
        return this.toString(false);
    }

    protected abstract String toString(boolean var1);

    public static class Serializer {
        public void serialize(ColumnSubselection subSel, DataOutputPlus out, int version) throws IOException {
            ColumnMetadata column = subSel.column();
            ByteBufferUtil.writeWithShortLength(column.name.bytes, out);
            out.writeByte(subSel.kind().ordinal());
            switch (subSel.kind()) {
                case SLICE: {
                    Slice slice = (Slice)subSel;
                    column.cellPathSerializer().serialize(slice.from, out);
                    column.cellPathSerializer().serialize(slice.to, out);
                    break;
                }
                case ELEMENT: {
                    Element eltSelection = (Element)subSel;
                    column.cellPathSerializer().serialize(eltSelection.element, out);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public ColumnSubselection deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            ByteBuffer name = ByteBufferUtil.readWithShortLength(in);
            ColumnMetadata column = metadata.getColumn(name);
            if (column == null && (column = metadata.getDroppedColumn(name)) == null) {
                throw new UnknownColumnException("Unknown column " + UTF8Type.instance.getString(name) + " during deserialization");
            }
            Kind kind = Kind.values()[in.readUnsignedByte()];
            switch (kind) {
                case SLICE: {
                    CellPath from = column.cellPathSerializer().deserialize(in);
                    CellPath to = column.cellPathSerializer().deserialize(in);
                    return new Slice(column, from, to);
                }
                case ELEMENT: {
                    CellPath elt = column.cellPathSerializer().deserialize(in);
                    return new Element(column, elt);
                }
            }
            throw new AssertionError();
        }

        public long serializedSize(ColumnSubselection subSel, int version) {
            long size = 0L;
            ColumnMetadata column = subSel.column();
            size += (long)TypeSizes.sizeofWithShortLength(column.name.bytes);
            ++size;
            switch (subSel.kind()) {
                case SLICE: {
                    Slice slice = (Slice)subSel;
                    size += column.cellPathSerializer().serializedSize(slice.from);
                    size += column.cellPathSerializer().serializedSize(slice.to);
                    break;
                }
                case ELEMENT: {
                    Element element = (Element)subSel;
                    size += column.cellPathSerializer().serializedSize(element.element);
                }
            }
            return size;
        }
    }

    private static class Element
    extends ColumnSubselection {
        private final CellPath element;

        private Element(ColumnMetadata column, CellPath elt) {
            super(column);
            this.element = elt;
        }

        @Override
        protected Kind kind() {
            return Kind.ELEMENT;
        }

        @Override
        public CellPath comparisonPath() {
            return this.element;
        }

        @Override
        public int compareInclusionOf(CellPath path) {
            return this.column.cellPathComparator().compare(path, this.element);
        }

        @Override
        protected String toString(boolean cql) {
            AbstractType<?> type = ((CollectionType)this.column().type).nameComparator();
            return String.format("[%s]", cql ? type.toCQLString(this.element.get(0)) : type.getString(this.element.get(0)));
        }
    }

    private static class Slice
    extends ColumnSubselection {
        private final CellPath from;
        private final CellPath to;

        private Slice(ColumnMetadata column, CellPath from, CellPath to) {
            super(column);
            this.from = from;
            this.to = to;
        }

        @Override
        protected Kind kind() {
            return Kind.SLICE;
        }

        @Override
        public CellPath comparisonPath() {
            return this.from;
        }

        @Override
        public int compareInclusionOf(CellPath path) {
            Comparator<CellPath> cmp = this.column.cellPathComparator();
            if (cmp.compare(path, this.from) < 0) {
                return -1;
            }
            if (cmp.compare(this.to, path) < 0) {
                return 1;
            }
            return 0;
        }

        @Override
        protected String toString(boolean cql) {
            AbstractType<?> type = ((CollectionType)this.column().type).nameComparator();
            Object[] objectArray = new Object[2];
            Object object = this.from == CellPath.BOTTOM ? "" : (objectArray[0] = cql ? type.toCQLString(this.from.get(0)) : type.getString(this.from.get(0)));
            objectArray[1] = this.to == CellPath.TOP ? "" : (cql ? type.toCQLString(this.to.get(0)) : type.getString(this.to.get(0)));
            return String.format("[%s:%s]", objectArray);
        }
    }

    private static enum Kind {
        SLICE,
        ELEMENT;

    }
}

