/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pgpverify;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.pgpverify.ActionPGPVerify;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionPGPVerifyDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionPGPVerify.class;
    private static final String[] EXTENSIONS = new String[]{"*"};
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionPGPVerify.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wGPGLocation;
    private TextVar wFilename;
    private Button wUseDetachedSignature;
    private Label wlDetachedFilename;
    private Button wbDetachedFilename;
    private TextVar wDetachedFilename;
    private ActionPGPVerify action;
    private boolean changed;

    public ActionPGPVerifyDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionPGPVerify)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Settings.Group.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)settingsgroupLayout);
        Label wlGPGLocation = new Label((Composite)wSettings, 131072);
        wlGPGLocation.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.GPGLocation.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGPGLocation);
        FormData fdlGPGLocation = new FormData();
        fdlGPGLocation.left = new FormAttachment(0, 0);
        fdlGPGLocation.top = new FormAttachment((Control)this.wName, margin);
        fdlGPGLocation.right = new FormAttachment(middle, -margin);
        wlGPGLocation.setLayoutData((Object)fdlGPGLocation);
        Button wbGPGLocation = new Button((Composite)wSettings, 0x1000008);
        PropsUi.setLook((Widget)wbGPGLocation);
        wbGPGLocation.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbGPGLocation = new FormData();
        fdbGPGLocation.right = new FormAttachment(100, 0);
        fdbGPGLocation.top = new FormAttachment((Control)this.wName, 0);
        wbGPGLocation.setLayoutData((Object)fdbGPGLocation);
        this.wGPGLocation = new TextVar(this.variables, (Composite)wSettings, 18436);
        PropsUi.setLook((Widget)this.wGPGLocation);
        this.wGPGLocation.addModifyListener(lsMod);
        FormData fdGPGLocation = new FormData();
        fdGPGLocation.left = new FormAttachment(middle, 0);
        fdGPGLocation.top = new FormAttachment((Control)this.wName, margin);
        fdGPGLocation.right = new FormAttachment((Control)wbGPGLocation, -margin);
        this.wGPGLocation.setLayoutData((Object)fdGPGLocation);
        Label wlFilename = new Label((Composite)wSettings, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wGPGLocation, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)wSettings, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wGPGLocation, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)wSettings, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wGPGLocation, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlUseDetachedSignature = new Label((Composite)wSettings, 131072);
        wlUseDetachedSignature.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.useDetachedSignature.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseDetachedSignature);
        FormData fdlUseDetachedSignature = new FormData();
        fdlUseDetachedSignature.left = new FormAttachment(0, 0);
        fdlUseDetachedSignature.top = new FormAttachment((Control)this.wFilename, margin);
        fdlUseDetachedSignature.right = new FormAttachment(middle, -margin);
        wlUseDetachedSignature.setLayoutData((Object)fdlUseDetachedSignature);
        this.wUseDetachedSignature = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wUseDetachedSignature);
        this.wUseDetachedSignature.setToolTipText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.useDetachedSignature.Tooltip", (String[])new String[0]));
        FormData fdUseDetachedSignature = new FormData();
        fdUseDetachedSignature.left = new FormAttachment(middle, 0);
        fdUseDetachedSignature.top = new FormAttachment((Control)wlUseDetachedSignature, 0, 0x1000000);
        fdUseDetachedSignature.right = new FormAttachment(100, -margin);
        this.wUseDetachedSignature.setLayoutData((Object)fdUseDetachedSignature);
        this.wUseDetachedSignature.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionPGPVerifyDialog.this.enableDetachedSignature();
            }
        });
        this.wlDetachedFilename = new Label((Composite)wSettings, 131072);
        this.wlDetachedFilename.setText(BaseMessages.getString(PKG, (String)"ActionPGPVerify.DetachedFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDetachedFilename);
        FormData fdlDetachedFilename = new FormData();
        fdlDetachedFilename.left = new FormAttachment(0, 0);
        fdlDetachedFilename.top = new FormAttachment((Control)wlUseDetachedSignature, 2 * margin);
        fdlDetachedFilename.right = new FormAttachment(middle, -margin);
        this.wlDetachedFilename.setLayoutData((Object)fdlDetachedFilename);
        this.wbDetachedFilename = new Button((Composite)wSettings, 0x1000008);
        PropsUi.setLook((Widget)this.wbDetachedFilename);
        this.wbDetachedFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbDetachedFilename = new FormData();
        fdbDetachedFilename.right = new FormAttachment(100, 0);
        fdbDetachedFilename.top = new FormAttachment((Control)this.wlDetachedFilename, 0, 0x1000000);
        this.wbDetachedFilename.setLayoutData((Object)fdbDetachedFilename);
        this.wDetachedFilename = new TextVar(this.variables, (Composite)wSettings, 18436);
        PropsUi.setLook((Widget)this.wDetachedFilename);
        this.wDetachedFilename.addModifyListener(lsMod);
        FormData fdDetachedFilename = new FormData();
        fdDetachedFilename.left = new FormAttachment(middle, 0);
        fdDetachedFilename.top = new FormAttachment((Control)this.wlDetachedFilename, 0, 0x1000000);
        fdDetachedFilename.right = new FormAttachment((Control)this.wbDetachedFilename, -margin);
        this.wDetachedFilename.setLayoutData((Object)fdDetachedFilename);
        this.wDetachedFilename.addModifyListener(e -> this.wDetachedFilename.setToolTipText(this.variables.resolve(this.wDetachedFilename.getText())));
        this.wbDetachedFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wDetachedFilename, (IVariables)this.variables, (String[])EXTENSIONS, (String[])FILETYPES, (boolean)false));
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])EXTENSIONS, (String[])FILETYPES, (boolean)false));
        this.wGPGLocation.addModifyListener(e -> this.wGPGLocation.setToolTipText(this.variables.resolve(this.wGPGLocation.getText())));
        wbGPGLocation.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wGPGLocation, (IVariables)this.variables, (String[])EXTENSIONS, (String[])FILETYPES, (boolean)false));
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        fdSettings.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wSettings.setLayoutData((Object)fdSettings);
        this.getData();
        this.enableDetachedSignature();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        if (this.action.getGPGLocation() != null) {
            this.wGPGLocation.setText(this.action.getGPGLocation());
        }
        if (this.action.getFilename() != null) {
            this.wFilename.setText(this.action.getFilename());
        }
        if (this.action.getDetachedfilename() != null) {
            this.wDetachedFilename.setText(this.action.getDetachedfilename());
        }
        this.wUseDetachedSignature.setSelection(this.action.useDetachedfilename());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setGPGLocation(this.wGPGLocation.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setDetachedfilename(this.wDetachedFilename.getText());
        this.action.setUseDetachedfilename(this.wUseDetachedSignature.getSelection());
        this.dispose();
    }

    private void enableDetachedSignature() {
        this.wlDetachedFilename.setEnabled(this.wUseDetachedSignature.getSelection());
        this.wDetachedFilename.setEnabled(this.wUseDetachedSignature.getSelection());
        this.wbDetachedFilename.setEnabled(this.wUseDetachedSignature.getSelection());
    }
}

