/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dbproc;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dbproc.DBProcMeta;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DBProcDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DBProcMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wProcName;
    private Button wAutoCommit;
    private Text wResult;
    private CCombo wResultType;
    private TableView wFields;
    private final DBProcMeta input;
    private ColumnInfo[] fieldColumns;
    private final List<String> inputFields = new ArrayList<String>();

    public DBProcDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (DBProcMeta)((Object)in);
    }

    public String open() {
        String[] types;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wGet = new Button((Composite)this.shell, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.GetFields.Button", (String[])new String[0]));
        wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getConnection(), null);
        Button wbProcName = new Button((Composite)this.shell, 8);
        wbProcName.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Finding.Button", (String[])new String[0]));
        FormData fdbProcName = new FormData();
        fdbProcName.right = new FormAttachment(100, 0);
        fdbProcName.top = new FormAttachment(this.wConnection, margin * 2);
        wbProcName.setLayoutData((Object)fdbProcName);
        wbProcName.addListener(13, this::selectProcedure);
        Label wlProcName = new Label((Composite)this.shell, 131072);
        wlProcName.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.ProcedureName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlProcName);
        FormData fdlProcName = new FormData();
        fdlProcName.left = new FormAttachment(0, 0);
        fdlProcName.right = new FormAttachment(middle, -margin);
        fdlProcName.top = new FormAttachment(this.wConnection, margin * 2);
        wlProcName.setLayoutData((Object)fdlProcName);
        this.wProcName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wProcName);
        FormData fdProcName = new FormData();
        fdProcName.left = new FormAttachment(middle, 0);
        fdProcName.top = new FormAttachment(this.wConnection, margin * 2);
        fdProcName.right = new FormAttachment((Control)wbProcName, -margin);
        this.wProcName.setLayoutData((Object)fdProcName);
        Label wlAutoCommit = new Label((Composite)this.shell, 131072);
        wlAutoCommit.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Label", (String[])new String[0]));
        wlAutoCommit.setToolTipText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAutoCommit);
        FormData fdlAutoCommit = new FormData();
        fdlAutoCommit.left = new FormAttachment(0, 0);
        fdlAutoCommit.top = new FormAttachment((Control)this.wProcName, margin);
        fdlAutoCommit.right = new FormAttachment(middle, -margin);
        wlAutoCommit.setLayoutData((Object)fdlAutoCommit);
        this.wAutoCommit = new Button((Composite)this.shell, 32);
        this.wAutoCommit.setToolTipText(BaseMessages.getString(PKG, (String)"DBProcDialog.AutoCommit.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAutoCommit);
        FormData fdAutoCommit = new FormData();
        fdAutoCommit.left = new FormAttachment(middle, 0);
        fdAutoCommit.top = new FormAttachment((Control)wlAutoCommit, 0, 0x1000000);
        fdAutoCommit.right = new FormAttachment(100, 0);
        this.wAutoCommit.setLayoutData((Object)fdAutoCommit);
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Result.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wAutoCommit, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wResult);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wAutoCommit, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        Label wlResultType = new Label((Composite)this.shell, 131072);
        wlResultType.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.ResultType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResultType);
        FormData fdlResultType = new FormData();
        fdlResultType.left = new FormAttachment(0, 0);
        fdlResultType.right = new FormAttachment(middle, -margin);
        fdlResultType.top = new FormAttachment((Control)this.wResult, margin);
        wlResultType.setLayoutData((Object)fdlResultType);
        this.wResultType = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wResultType);
        for (String type : types = ValueMetaFactory.getValueMetaNames()) {
            this.wResultType.add(type);
        }
        this.wResultType.select(0);
        FormData fdResultType = new FormData();
        fdResultType.left = new FormAttachment(middle, 0);
        fdResultType.top = new FormAttachment((Control)this.wResult, margin);
        fdResultType.right = new FormAttachment(100, 0);
        this.wResultType.setLayoutData((Object)fdResultType);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wResultType, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.input.getArguments().size();
        this.fieldColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Direction", (String[])new String[0]), 2, new String[]{"IN", "OUT", "INOUT"}), new ColumnInfo(BaseMessages.getString(PKG, (String)"DBProcDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames())};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.fieldColumns, nrRows, null, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void selectProcedure(Event event) {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                db.connect();
                String[] procs = db.getProcedures();
                if (procs != null && procs.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, procs, BaseMessages.getString(PKG, (String)"DBProcDialog.EnterSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DBProcDialog.EnterSelection.DialogMessage", (String[])new String[0]));
                    String proc = esd.open();
                    if (proc != null) {
                        this.wProcName.setText(proc);
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DBProcDialog.NoProceduresFound.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.NoProceduresFound.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (HopDatabaseException dbe) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DBProcDialog.ErrorGettingProceduresList.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DBProcDialog.ErrorGettingProceduresList.DialogMessage", (String[])new String[0]), (Exception)((Object)dbe));
            }
        }
    }

    protected void setComboBoxes() {
        String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
        this.fieldColumns[0].setComboValues(fieldNames);
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"DBProcDialog.Log.GettingKeyInfo", (String[])new String[0]));
        for (int i = 0; i < this.input.getArguments().size(); ++i) {
            DBProcMeta.ProcArgument argument = this.input.getArguments().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)argument.getName(), (String)""));
            item.setText(2, Const.NVL((String)argument.getDirection(), (String)""));
            item.setText(3, Const.NVL((String)argument.getType(), (String)""));
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wProcName.setText(Const.NVL((String)this.input.getProcedure(), (String)""));
        this.wResult.setText(Const.NVL((String)this.input.getResult().getName(), (String)""));
        this.wResultType.setText(Const.NVL((String)this.input.getResult().getType(), (String)""));
        this.wAutoCommit.setSelection(this.input.isAutoCommit());
        this.wFields.optimizeTableView();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.getArguments().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            DBProcMeta.ProcArgument argument = new DBProcMeta.ProcArgument();
            argument.setName(item.getText(1));
            argument.setDirection(item.getText(2));
            argument.setType(item.getText(3));
            this.input.getArguments().add(argument);
        }
        this.input.setConnection(this.wConnection.getText());
        this.input.setProcedure(this.wProcName.getText());
        this.input.getResult().setName(this.wResult.getText());
        this.input.getResult().setType(this.wResultType.getText());
        this.input.setAutoCommit(this.wAutoCommit.getSelection());
        this.transformName = this.wTransformName.getText();
        if (this.input.getConnection() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DBProcDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DBProcDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.input.setChanged();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "IN");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{3}, (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DBProcDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DBProcDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

