/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.naming.SizeLimitExceededException;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class PreparePubsubWriteDoFn<@UnknownKeyFor InputT>
extends DoFn<InputT, PubsubMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_DATA_MAX_BYTES = 0xA00000;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_MAX_ATTRIBUTES = 100;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_MAX_KEY_BYTES = 256;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_MAX_VALUE_BYTES = 1024;
    private static final @UnknownKeyFor @NonNull @Initialized int PUBSUB_MESSAGE_ATTRIBUTE_ENCODE_ADDITIONAL_BYTES = 6;
    private @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFunction;
    @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>,  @UnknownKeyFor @NonNull @Initialized PubsubIO.PubsubTopic> topicFunction;

    static @UnknownKeyFor @NonNull @Initialized int validatePubsubMessageSize(@UnknownKeyFor @NonNull @Initialized PubsubMessage message, @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize) throws @UnknownKeyFor @NonNull @Initialized SizeLimitExceededException {
        int payloadSize = message.getPayload().length;
        if (payloadSize > 0xA00000) {
            throw new SizeLimitExceededException("Pubsub message data field of length " + payloadSize + " exceeds maximum of " + 0xA00000 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
        }
        int totalSize = payloadSize;
        @Nullable Map<String, String> attributes = message.getAttributeMap();
        if (attributes != null) {
            if (attributes.size() > 100) {
                throw new SizeLimitExceededException("Pubsub message contains " + attributes.size() + " attributes which exceeds the maximum of " + 100 + ". See https://cloud.google.com/pubsub/quotas#resource_limits");
            }
            totalSize += attributes.size() * 6;
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                String key = attribute.getKey();
                int keySize = key.getBytes(StandardCharsets.UTF_8).length;
                if (keySize > 256) {
                    throw new SizeLimitExceededException("Pubsub message attribute key '" + key + "' exceeds the maximum of " + 256 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
                }
                totalSize += keySize;
                String value = attribute.getValue();
                int valueSize = value.getBytes(StandardCharsets.UTF_8).length;
                if (valueSize > 1024) {
                    throw new SizeLimitExceededException("Pubsub message attribute value for key '" + key + "' starting with '" + value.substring(0, Math.min(256, value.length())) + "' exceeds the maximum of " + 1024 + " bytes. See https://cloud.google.com/pubsub/quotas#resource_limits");
                }
                totalSize += valueSize;
            }
        }
        if (totalSize > maxPublishBatchSize) {
            throw new SizeLimitExceededException("Pubsub message of length " + totalSize + " exceeds maximum of " + maxPublishBatchSize + " bytes, when considering the payload and attributes. See https://cloud.google.com/pubsub/quotas#resource_limits");
        }
        return totalSize;
    }

    PreparePubsubWriteDoFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized PubsubMessage> formatFunction, @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<InputT>,  @UnknownKeyFor @NonNull @Initialized PubsubIO.PubsubTopic> topicFunction, @UnknownKeyFor @NonNull @Initialized int maxPublishBatchSize) {
        this.formatFunction = formatFunction;
        this.topicFunction = topicFunction;
        this.maxPublishBatchSize = maxPublishBatchSize;
    }

    @DoFn.ProcessElement
    public void process(@DoFn.Element InputT element, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant ts, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized PubsubMessage> o) {
        PubsubMessage message = (PubsubMessage)this.formatFunction.apply(element);
        if (this.topicFunction != null) {
            message = message.withTopic(((PubsubIO.PubsubTopic)this.topicFunction.apply((Object)ValueInSingleWindow.of(element, (Instant)ts, (BoundedWindow)window, (PaneInfo)paneInfo))).asPath());
        }
        try {
            PreparePubsubWriteDoFn.validatePubsubMessageSize(message, this.maxPublishBatchSize);
        }
        catch (SizeLimitExceededException e) {
            throw new IllegalArgumentException(e);
        }
        o.output((Object)message);
    }
}

