/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1;

import com.google.datastore.v1.AggregationQueryOrBuilder;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryOrBuilder;
import com.google.datastore.v1.QueryProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Int64ValueOrBuilder;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AggregationQuery
extends GeneratedMessageV3
implements AggregationQueryOrBuilder {
    private static final long serialVersionUID = 0L;
    private int queryTypeCase_ = 0;
    private Object queryType_;
    public static final int NESTED_QUERY_FIELD_NUMBER = 1;
    public static final int AGGREGATIONS_FIELD_NUMBER = 3;
    private List<Aggregation> aggregations_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final AggregationQuery DEFAULT_INSTANCE = new AggregationQuery();
    private static final Parser<AggregationQuery> PARSER = new AbstractParser<AggregationQuery>(){

        public AggregationQuery parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = AggregationQuery.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private AggregationQuery(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private AggregationQuery() {
        this.aggregations_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new AggregationQuery();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return QueryProto.internal_static_google_datastore_v1_AggregationQuery_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return QueryProto.internal_static_google_datastore_v1_AggregationQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(AggregationQuery.class, Builder.class);
    }

    @Override
    public QueryTypeCase getQueryTypeCase() {
        return QueryTypeCase.forNumber(this.queryTypeCase_);
    }

    @Override
    public boolean hasNestedQuery() {
        return this.queryTypeCase_ == 1;
    }

    @Override
    public Query getNestedQuery() {
        if (this.queryTypeCase_ == 1) {
            return (Query)this.queryType_;
        }
        return Query.getDefaultInstance();
    }

    @Override
    public QueryOrBuilder getNestedQueryOrBuilder() {
        if (this.queryTypeCase_ == 1) {
            return (Query)this.queryType_;
        }
        return Query.getDefaultInstance();
    }

    @Override
    public List<Aggregation> getAggregationsList() {
        return this.aggregations_;
    }

    @Override
    public List<? extends AggregationOrBuilder> getAggregationsOrBuilderList() {
        return this.aggregations_;
    }

    @Override
    public int getAggregationsCount() {
        return this.aggregations_.size();
    }

    @Override
    public Aggregation getAggregations(int index) {
        return this.aggregations_.get(index);
    }

    @Override
    public AggregationOrBuilder getAggregationsOrBuilder(int index) {
        return this.aggregations_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.queryTypeCase_ == 1) {
            output.writeMessage(1, (MessageLite)((Query)this.queryType_));
        }
        for (int i = 0; i < this.aggregations_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.aggregations_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.queryTypeCase_ == 1) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((Query)this.queryType_));
        }
        for (int i = 0; i < this.aggregations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.aggregations_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AggregationQuery)) {
            return super.equals(obj);
        }
        AggregationQuery other = (AggregationQuery)obj;
        if (!this.getAggregationsList().equals(other.getAggregationsList())) {
            return false;
        }
        if (!this.getQueryTypeCase().equals((Object)other.getQueryTypeCase())) {
            return false;
        }
        switch (this.queryTypeCase_) {
            case 1: {
                if (this.getNestedQuery().equals(other.getNestedQuery())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + AggregationQuery.getDescriptor().hashCode();
        if (this.getAggregationsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getAggregationsList().hashCode();
        }
        switch (this.queryTypeCase_) {
            case 1: {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getNestedQuery().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static AggregationQuery parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data);
    }

    public static AggregationQuery parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AggregationQuery parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data);
    }

    public static AggregationQuery parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AggregationQuery parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data);
    }

    public static AggregationQuery parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (AggregationQuery)PARSER.parseFrom(data, extensionRegistry);
    }

    public static AggregationQuery parseFrom(InputStream input) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static AggregationQuery parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AggregationQuery parseDelimitedFrom(InputStream input) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static AggregationQuery parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static AggregationQuery parseFrom(CodedInputStream input) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static AggregationQuery parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (AggregationQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return AggregationQuery.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(AggregationQuery prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static AggregationQuery getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<AggregationQuery> parser() {
        return PARSER;
    }

    public Parser<AggregationQuery> getParserForType() {
        return PARSER;
    }

    public AggregationQuery getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements AggregationQueryOrBuilder {
        private int queryTypeCase_ = 0;
        private Object queryType_;
        private int bitField0_;
        private SingleFieldBuilderV3<Query, Query.Builder, QueryOrBuilder> nestedQueryBuilder_;
        private List<Aggregation> aggregations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Aggregation, Aggregation.Builder, AggregationOrBuilder> aggregationsBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return QueryProto.internal_static_google_datastore_v1_AggregationQuery_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return QueryProto.internal_static_google_datastore_v1_AggregationQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(AggregationQuery.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.nestedQueryBuilder_ != null) {
                this.nestedQueryBuilder_.clear();
            }
            if (this.aggregationsBuilder_ == null) {
                this.aggregations_ = Collections.emptyList();
            } else {
                this.aggregations_ = null;
                this.aggregationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            this.queryTypeCase_ = 0;
            this.queryType_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return QueryProto.internal_static_google_datastore_v1_AggregationQuery_descriptor;
        }

        public AggregationQuery getDefaultInstanceForType() {
            return AggregationQuery.getDefaultInstance();
        }

        public AggregationQuery build() {
            AggregationQuery result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public AggregationQuery buildPartial() {
            AggregationQuery result = new AggregationQuery(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.buildPartialOneofs(result);
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(AggregationQuery result) {
            if (this.aggregationsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.aggregations_ = Collections.unmodifiableList(this.aggregations_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.aggregations_ = this.aggregations_;
            } else {
                result.aggregations_ = this.aggregationsBuilder_.build();
            }
        }

        private void buildPartial0(AggregationQuery result) {
            int from_bitField0_ = this.bitField0_;
        }

        private void buildPartialOneofs(AggregationQuery result) {
            result.queryTypeCase_ = this.queryTypeCase_;
            result.queryType_ = this.queryType_;
            if (this.queryTypeCase_ == 1 && this.nestedQueryBuilder_ != null) {
                result.queryType_ = this.nestedQueryBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof AggregationQuery) {
                return this.mergeFrom((AggregationQuery)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(AggregationQuery other) {
            if (other == AggregationQuery.getDefaultInstance()) {
                return this;
            }
            if (this.aggregationsBuilder_ == null) {
                if (!other.aggregations_.isEmpty()) {
                    if (this.aggregations_.isEmpty()) {
                        this.aggregations_ = other.aggregations_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureAggregationsIsMutable();
                        this.aggregations_.addAll(other.aggregations_);
                    }
                    this.onChanged();
                }
            } else if (!other.aggregations_.isEmpty()) {
                if (this.aggregationsBuilder_.isEmpty()) {
                    this.aggregationsBuilder_.dispose();
                    this.aggregationsBuilder_ = null;
                    this.aggregations_ = other.aggregations_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.aggregationsBuilder_ = alwaysUseFieldBuilders ? this.getAggregationsFieldBuilder() : null;
                } else {
                    this.aggregationsBuilder_.addAllMessages((Iterable)other.aggregations_);
                }
            }
            switch (other.getQueryTypeCase()) {
                case NESTED_QUERY: {
                    this.mergeNestedQuery(other.getNestedQuery());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block10: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block10;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getNestedQueryFieldBuilder().getBuilder(), extensionRegistry);
                            this.queryTypeCase_ = 1;
                            continue block10;
                        }
                        case 26: {
                            Aggregation m = (Aggregation)input.readMessage(Aggregation.parser(), extensionRegistry);
                            if (this.aggregationsBuilder_ == null) {
                                this.ensureAggregationsIsMutable();
                                this.aggregations_.add(m);
                                continue block10;
                            }
                            this.aggregationsBuilder_.addMessage((AbstractMessage)m);
                            continue block10;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public QueryTypeCase getQueryTypeCase() {
            return QueryTypeCase.forNumber(this.queryTypeCase_);
        }

        public Builder clearQueryType() {
            this.queryTypeCase_ = 0;
            this.queryType_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasNestedQuery() {
            return this.queryTypeCase_ == 1;
        }

        @Override
        public Query getNestedQuery() {
            if (this.nestedQueryBuilder_ == null) {
                if (this.queryTypeCase_ == 1) {
                    return (Query)this.queryType_;
                }
                return Query.getDefaultInstance();
            }
            if (this.queryTypeCase_ == 1) {
                return (Query)this.nestedQueryBuilder_.getMessage();
            }
            return Query.getDefaultInstance();
        }

        public Builder setNestedQuery(Query value) {
            if (this.nestedQueryBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.queryType_ = value;
                this.onChanged();
            } else {
                this.nestedQueryBuilder_.setMessage((AbstractMessage)value);
            }
            this.queryTypeCase_ = 1;
            return this;
        }

        public Builder setNestedQuery(Query.Builder builderForValue) {
            if (this.nestedQueryBuilder_ == null) {
                this.queryType_ = builderForValue.build();
                this.onChanged();
            } else {
                this.nestedQueryBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.queryTypeCase_ = 1;
            return this;
        }

        public Builder mergeNestedQuery(Query value) {
            if (this.nestedQueryBuilder_ == null) {
                this.queryType_ = this.queryTypeCase_ == 1 && this.queryType_ != Query.getDefaultInstance() ? Query.newBuilder((Query)this.queryType_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.queryTypeCase_ == 1) {
                this.nestedQueryBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.nestedQueryBuilder_.setMessage((AbstractMessage)value);
            }
            this.queryTypeCase_ = 1;
            return this;
        }

        public Builder clearNestedQuery() {
            if (this.nestedQueryBuilder_ == null) {
                if (this.queryTypeCase_ == 1) {
                    this.queryTypeCase_ = 0;
                    this.queryType_ = null;
                    this.onChanged();
                }
            } else {
                if (this.queryTypeCase_ == 1) {
                    this.queryTypeCase_ = 0;
                    this.queryType_ = null;
                }
                this.nestedQueryBuilder_.clear();
            }
            return this;
        }

        public Query.Builder getNestedQueryBuilder() {
            return (Query.Builder)this.getNestedQueryFieldBuilder().getBuilder();
        }

        @Override
        public QueryOrBuilder getNestedQueryOrBuilder() {
            if (this.queryTypeCase_ == 1 && this.nestedQueryBuilder_ != null) {
                return (QueryOrBuilder)this.nestedQueryBuilder_.getMessageOrBuilder();
            }
            if (this.queryTypeCase_ == 1) {
                return (Query)this.queryType_;
            }
            return Query.getDefaultInstance();
        }

        private SingleFieldBuilderV3<Query, Query.Builder, QueryOrBuilder> getNestedQueryFieldBuilder() {
            if (this.nestedQueryBuilder_ == null) {
                if (this.queryTypeCase_ != 1) {
                    this.queryType_ = Query.getDefaultInstance();
                }
                this.nestedQueryBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Query)this.queryType_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.queryType_ = null;
            }
            this.queryTypeCase_ = 1;
            this.onChanged();
            return this.nestedQueryBuilder_;
        }

        private void ensureAggregationsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.aggregations_ = new ArrayList<Aggregation>(this.aggregations_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Aggregation> getAggregationsList() {
            if (this.aggregationsBuilder_ == null) {
                return Collections.unmodifiableList(this.aggregations_);
            }
            return this.aggregationsBuilder_.getMessageList();
        }

        @Override
        public int getAggregationsCount() {
            if (this.aggregationsBuilder_ == null) {
                return this.aggregations_.size();
            }
            return this.aggregationsBuilder_.getCount();
        }

        @Override
        public Aggregation getAggregations(int index) {
            if (this.aggregationsBuilder_ == null) {
                return this.aggregations_.get(index);
            }
            return (Aggregation)this.aggregationsBuilder_.getMessage(index);
        }

        public Builder setAggregations(int index, Aggregation value) {
            if (this.aggregationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAggregationsIsMutable();
                this.aggregations_.set(index, value);
                this.onChanged();
            } else {
                this.aggregationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAggregations(int index, Aggregation.Builder builderForValue) {
            if (this.aggregationsBuilder_ == null) {
                this.ensureAggregationsIsMutable();
                this.aggregations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.aggregationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAggregations(Aggregation value) {
            if (this.aggregationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAggregationsIsMutable();
                this.aggregations_.add(value);
                this.onChanged();
            } else {
                this.aggregationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAggregations(int index, Aggregation value) {
            if (this.aggregationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAggregationsIsMutable();
                this.aggregations_.add(index, value);
                this.onChanged();
            } else {
                this.aggregationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAggregations(Aggregation.Builder builderForValue) {
            if (this.aggregationsBuilder_ == null) {
                this.ensureAggregationsIsMutable();
                this.aggregations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.aggregationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAggregations(int index, Aggregation.Builder builderForValue) {
            if (this.aggregationsBuilder_ == null) {
                this.ensureAggregationsIsMutable();
                this.aggregations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.aggregationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAggregations(Iterable<? extends Aggregation> values) {
            if (this.aggregationsBuilder_ == null) {
                this.ensureAggregationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.aggregations_);
                this.onChanged();
            } else {
                this.aggregationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAggregations() {
            if (this.aggregationsBuilder_ == null) {
                this.aggregations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.aggregationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAggregations(int index) {
            if (this.aggregationsBuilder_ == null) {
                this.ensureAggregationsIsMutable();
                this.aggregations_.remove(index);
                this.onChanged();
            } else {
                this.aggregationsBuilder_.remove(index);
            }
            return this;
        }

        public Aggregation.Builder getAggregationsBuilder(int index) {
            return (Aggregation.Builder)this.getAggregationsFieldBuilder().getBuilder(index);
        }

        @Override
        public AggregationOrBuilder getAggregationsOrBuilder(int index) {
            if (this.aggregationsBuilder_ == null) {
                return this.aggregations_.get(index);
            }
            return (AggregationOrBuilder)this.aggregationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AggregationOrBuilder> getAggregationsOrBuilderList() {
            if (this.aggregationsBuilder_ != null) {
                return this.aggregationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.aggregations_);
        }

        public Aggregation.Builder addAggregationsBuilder() {
            return (Aggregation.Builder)this.getAggregationsFieldBuilder().addBuilder((AbstractMessage)Aggregation.getDefaultInstance());
        }

        public Aggregation.Builder addAggregationsBuilder(int index) {
            return (Aggregation.Builder)this.getAggregationsFieldBuilder().addBuilder(index, (AbstractMessage)Aggregation.getDefaultInstance());
        }

        public List<Aggregation.Builder> getAggregationsBuilderList() {
            return this.getAggregationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Aggregation, Aggregation.Builder, AggregationOrBuilder> getAggregationsFieldBuilder() {
            if (this.aggregationsBuilder_ == null) {
                this.aggregationsBuilder_ = new RepeatedFieldBuilderV3(this.aggregations_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.aggregations_ = null;
            }
            return this.aggregationsBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum QueryTypeCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        NESTED_QUERY(1),
        QUERYTYPE_NOT_SET(0);

        private final int value;

        private QueryTypeCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static QueryTypeCase valueOf(int value) {
            return QueryTypeCase.forNumber(value);
        }

        public static QueryTypeCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return NESTED_QUERY;
                }
                case 0: {
                    return QUERYTYPE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class Aggregation
    extends GeneratedMessageV3
    implements AggregationOrBuilder {
        private static final long serialVersionUID = 0L;
        private int operatorCase_ = 0;
        private Object operator_;
        public static final int COUNT_FIELD_NUMBER = 1;
        public static final int ALIAS_FIELD_NUMBER = 7;
        private volatile Object alias_ = "";
        private byte memoizedIsInitialized = (byte)-1;
        private static final Aggregation DEFAULT_INSTANCE = new Aggregation();
        private static final Parser<Aggregation> PARSER = new AbstractParser<Aggregation>(){

            public Aggregation parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Aggregation.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private Aggregation(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private Aggregation() {
            this.alias_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new Aggregation();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_fieldAccessorTable.ensureFieldAccessorsInitialized(Aggregation.class, Builder.class);
        }

        @Override
        public OperatorCase getOperatorCase() {
            return OperatorCase.forNumber(this.operatorCase_);
        }

        @Override
        public boolean hasCount() {
            return this.operatorCase_ == 1;
        }

        @Override
        public Count getCount() {
            if (this.operatorCase_ == 1) {
                return (Count)this.operator_;
            }
            return Count.getDefaultInstance();
        }

        @Override
        public CountOrBuilder getCountOrBuilder() {
            if (this.operatorCase_ == 1) {
                return (Count)this.operator_;
            }
            return Count.getDefaultInstance();
        }

        @Override
        public String getAlias() {
            Object ref = this.alias_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.alias_ = s;
            return s;
        }

        @Override
        public ByteString getAliasBytes() {
            Object ref = this.alias_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.alias_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.operatorCase_ == 1) {
                output.writeMessage(1, (MessageLite)((Count)this.operator_));
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.alias_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.alias_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.operatorCase_ == 1) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((Count)this.operator_));
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.alias_)) {
                size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.alias_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Aggregation)) {
                return super.equals(obj);
            }
            Aggregation other = (Aggregation)obj;
            if (!this.getAlias().equals(other.getAlias())) {
                return false;
            }
            if (!this.getOperatorCase().equals((Object)other.getOperatorCase())) {
                return false;
            }
            switch (this.operatorCase_) {
                case 1: {
                    if (this.getCount().equals(other.getCount())) break;
                    return false;
                }
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Aggregation.getDescriptor().hashCode();
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getAlias().hashCode();
            switch (this.operatorCase_) {
                case 1: {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getCount().hashCode();
                    break;
                }
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Aggregation parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data);
        }

        public static Aggregation parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Aggregation parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data);
        }

        public static Aggregation parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Aggregation parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data);
        }

        public static Aggregation parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Aggregation)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Aggregation parseFrom(InputStream input) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Aggregation parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Aggregation parseDelimitedFrom(InputStream input) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Aggregation parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Aggregation parseFrom(CodedInputStream input) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Aggregation parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Aggregation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Aggregation.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Aggregation prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Aggregation getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Aggregation> parser() {
            return PARSER;
        }

        public Parser<Aggregation> getParserForType() {
            return PARSER;
        }

        public Aggregation getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AggregationOrBuilder {
            private int operatorCase_ = 0;
            private Object operator_;
            private int bitField0_;
            private SingleFieldBuilderV3<Count, Count.Builder, CountOrBuilder> countBuilder_;
            private Object alias_ = "";

            public static final Descriptors.Descriptor getDescriptor() {
                return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_fieldAccessorTable.ensureFieldAccessorsInitialized(Aggregation.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                if (this.countBuilder_ != null) {
                    this.countBuilder_.clear();
                }
                this.alias_ = "";
                this.operatorCase_ = 0;
                this.operator_ = null;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
            }

            public Aggregation getDefaultInstanceForType() {
                return Aggregation.getDefaultInstance();
            }

            public Aggregation build() {
                Aggregation result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Aggregation buildPartial() {
                Aggregation result = new Aggregation(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.buildPartialOneofs(result);
                this.onBuilt();
                return result;
            }

            private void buildPartial0(Aggregation result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 2) != 0) {
                    result.alias_ = this.alias_;
                }
            }

            private void buildPartialOneofs(Aggregation result) {
                result.operatorCase_ = this.operatorCase_;
                result.operator_ = this.operator_;
                if (this.operatorCase_ == 1 && this.countBuilder_ != null) {
                    result.operator_ = this.countBuilder_.build();
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Aggregation) {
                    return this.mergeFrom((Aggregation)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Aggregation other) {
                if (other == Aggregation.getDefaultInstance()) {
                    return this;
                }
                if (!other.getAlias().isEmpty()) {
                    this.alias_ = other.alias_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                switch (other.getOperatorCase()) {
                    case COUNT: {
                        this.mergeCount(other.getCount());
                        break;
                    }
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getCountFieldBuilder().getBuilder(), extensionRegistry);
                                this.operatorCase_ = 1;
                                continue block10;
                            }
                            case 58: {
                                this.alias_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public OperatorCase getOperatorCase() {
                return OperatorCase.forNumber(this.operatorCase_);
            }

            public Builder clearOperator() {
                this.operatorCase_ = 0;
                this.operator_ = null;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasCount() {
                return this.operatorCase_ == 1;
            }

            @Override
            public Count getCount() {
                if (this.countBuilder_ == null) {
                    if (this.operatorCase_ == 1) {
                        return (Count)this.operator_;
                    }
                    return Count.getDefaultInstance();
                }
                if (this.operatorCase_ == 1) {
                    return (Count)this.countBuilder_.getMessage();
                }
                return Count.getDefaultInstance();
            }

            public Builder setCount(Count value) {
                if (this.countBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.operator_ = value;
                    this.onChanged();
                } else {
                    this.countBuilder_.setMessage((AbstractMessage)value);
                }
                this.operatorCase_ = 1;
                return this;
            }

            public Builder setCount(Count.Builder builderForValue) {
                if (this.countBuilder_ == null) {
                    this.operator_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.countBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                this.operatorCase_ = 1;
                return this;
            }

            public Builder mergeCount(Count value) {
                if (this.countBuilder_ == null) {
                    this.operator_ = this.operatorCase_ == 1 && this.operator_ != Count.getDefaultInstance() ? Count.newBuilder((Count)this.operator_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else if (this.operatorCase_ == 1) {
                    this.countBuilder_.mergeFrom((AbstractMessage)value);
                } else {
                    this.countBuilder_.setMessage((AbstractMessage)value);
                }
                this.operatorCase_ = 1;
                return this;
            }

            public Builder clearCount() {
                if (this.countBuilder_ == null) {
                    if (this.operatorCase_ == 1) {
                        this.operatorCase_ = 0;
                        this.operator_ = null;
                        this.onChanged();
                    }
                } else {
                    if (this.operatorCase_ == 1) {
                        this.operatorCase_ = 0;
                        this.operator_ = null;
                    }
                    this.countBuilder_.clear();
                }
                return this;
            }

            public Count.Builder getCountBuilder() {
                return (Count.Builder)this.getCountFieldBuilder().getBuilder();
            }

            @Override
            public CountOrBuilder getCountOrBuilder() {
                if (this.operatorCase_ == 1 && this.countBuilder_ != null) {
                    return (CountOrBuilder)this.countBuilder_.getMessageOrBuilder();
                }
                if (this.operatorCase_ == 1) {
                    return (Count)this.operator_;
                }
                return Count.getDefaultInstance();
            }

            private SingleFieldBuilderV3<Count, Count.Builder, CountOrBuilder> getCountFieldBuilder() {
                if (this.countBuilder_ == null) {
                    if (this.operatorCase_ != 1) {
                        this.operator_ = Count.getDefaultInstance();
                    }
                    this.countBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Count)this.operator_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.operator_ = null;
                }
                this.operatorCase_ = 1;
                this.onChanged();
                return this.countBuilder_;
            }

            @Override
            public String getAlias() {
                Object ref = this.alias_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.alias_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getAliasBytes() {
                Object ref = this.alias_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.alias_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setAlias(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.alias_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearAlias() {
                this.alias_ = Aggregation.getDefaultInstance().getAlias();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setAliasBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Aggregation.checkByteStringIsUtf8((ByteString)value);
                this.alias_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static enum OperatorCase implements Internal.EnumLite,
        AbstractMessageLite.InternalOneOfEnum
        {
            COUNT(1),
            OPERATOR_NOT_SET(0);

            private final int value;

            private OperatorCase(int value) {
                this.value = value;
            }

            @Deprecated
            public static OperatorCase valueOf(int value) {
                return OperatorCase.forNumber(value);
            }

            public static OperatorCase forNumber(int value) {
                switch (value) {
                    case 1: {
                        return COUNT;
                    }
                    case 0: {
                        return OPERATOR_NOT_SET;
                    }
                }
                return null;
            }

            public int getNumber() {
                return this.value;
            }
        }

        public static final class Count
        extends GeneratedMessageV3
        implements CountOrBuilder {
            private static final long serialVersionUID = 0L;
            public static final int UP_TO_FIELD_NUMBER = 1;
            private Int64Value upTo_;
            private byte memoizedIsInitialized = (byte)-1;
            private static final Count DEFAULT_INSTANCE = new Count();
            private static final Parser<Count> PARSER = new AbstractParser<Count>(){

                public Count parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Count.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private Count(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private Count() {
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new Count();
            }

            public final UnknownFieldSet getUnknownFields() {
                return this.unknownFields;
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_fieldAccessorTable.ensureFieldAccessorsInitialized(Count.class, Builder.class);
            }

            @Override
            public boolean hasUpTo() {
                return this.upTo_ != null;
            }

            @Override
            public Int64Value getUpTo() {
                return this.upTo_ == null ? Int64Value.getDefaultInstance() : this.upTo_;
            }

            @Override
            public Int64ValueOrBuilder getUpToOrBuilder() {
                return this.upTo_ == null ? Int64Value.getDefaultInstance() : this.upTo_;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if (this.upTo_ != null) {
                    output.writeMessage(1, (MessageLite)this.getUpTo());
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if (this.upTo_ != null) {
                    size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getUpTo());
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Count)) {
                    return super.equals(obj);
                }
                Count other = (Count)obj;
                if (this.hasUpTo() != other.hasUpTo()) {
                    return false;
                }
                if (this.hasUpTo() && !this.getUpTo().equals((Object)other.getUpTo())) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + Count.getDescriptor().hashCode();
                if (this.hasUpTo()) {
                    hash = 37 * hash + 1;
                    hash = 53 * hash + this.getUpTo().hashCode();
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static Count parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data);
            }

            public static Count parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Count parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data);
            }

            public static Count parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Count parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data);
            }

            public static Count parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (Count)PARSER.parseFrom(data, extensionRegistry);
            }

            public static Count parseFrom(InputStream input) throws IOException {
                return (Count)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static Count parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Count)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Count parseDelimitedFrom(InputStream input) throws IOException {
                return (Count)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static Count parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Count)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static Count parseFrom(CodedInputStream input) throws IOException {
                return (Count)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static Count parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (Count)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return Count.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(Count prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static Count getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<Count> parser() {
                return PARSER;
            }

            public Parser<Count> getParserForType() {
                return PARSER;
            }

            public Count getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements CountOrBuilder {
                private int bitField0_;
                private Int64Value upTo_;
                private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> upToBuilder_;

                public static final Descriptors.Descriptor getDescriptor() {
                    return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_fieldAccessorTable.ensureFieldAccessorsInitialized(Count.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.bitField0_ = 0;
                    this.upTo_ = null;
                    if (this.upToBuilder_ != null) {
                        this.upToBuilder_.dispose();
                        this.upToBuilder_ = null;
                    }
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return QueryProto.internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
                }

                public Count getDefaultInstanceForType() {
                    return Count.getDefaultInstance();
                }

                public Count build() {
                    Count result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public Count buildPartial() {
                    Count result = new Count(this);
                    if (this.bitField0_ != 0) {
                        this.buildPartial0(result);
                    }
                    this.onBuilt();
                    return result;
                }

                private void buildPartial0(Count result) {
                    int from_bitField0_ = this.bitField0_;
                    if ((from_bitField0_ & 1) != 0) {
                        result.upTo_ = this.upToBuilder_ == null ? this.upTo_ : (Int64Value)this.upToBuilder_.build();
                    }
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof Count) {
                        return this.mergeFrom((Count)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(Count other) {
                    if (other == Count.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasUpTo()) {
                        this.mergeUpTo(other.getUpTo());
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block9: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block9;
                                }
                                case 10: {
                                    input.readMessage((MessageLite.Builder)this.getUpToFieldBuilder().getBuilder(), extensionRegistry);
                                    this.bitField0_ |= 1;
                                    continue block9;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasUpTo() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public Int64Value getUpTo() {
                    if (this.upToBuilder_ == null) {
                        return this.upTo_ == null ? Int64Value.getDefaultInstance() : this.upTo_;
                    }
                    return (Int64Value)this.upToBuilder_.getMessage();
                }

                public Builder setUpTo(Int64Value value) {
                    if (this.upToBuilder_ == null) {
                        if (value == null) {
                            throw new NullPointerException();
                        }
                        this.upTo_ = value;
                    } else {
                        this.upToBuilder_.setMessage((AbstractMessage)value);
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder setUpTo(Int64Value.Builder builderForValue) {
                    if (this.upToBuilder_ == null) {
                        this.upTo_ = builderForValue.build();
                    } else {
                        this.upToBuilder_.setMessage((AbstractMessage)builderForValue.build());
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder mergeUpTo(Int64Value value) {
                    if (this.upToBuilder_ == null) {
                        if ((this.bitField0_ & 1) != 0 && this.upTo_ != null && this.upTo_ != Int64Value.getDefaultInstance()) {
                            this.getUpToBuilder().mergeFrom(value);
                        } else {
                            this.upTo_ = value;
                        }
                    } else {
                        this.upToBuilder_.mergeFrom((AbstractMessage)value);
                    }
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return this;
                }

                public Builder clearUpTo() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.upTo_ = null;
                    if (this.upToBuilder_ != null) {
                        this.upToBuilder_.dispose();
                        this.upToBuilder_ = null;
                    }
                    this.onChanged();
                    return this;
                }

                public Int64Value.Builder getUpToBuilder() {
                    this.bitField0_ |= 1;
                    this.onChanged();
                    return (Int64Value.Builder)this.getUpToFieldBuilder().getBuilder();
                }

                @Override
                public Int64ValueOrBuilder getUpToOrBuilder() {
                    if (this.upToBuilder_ != null) {
                        return (Int64ValueOrBuilder)this.upToBuilder_.getMessageOrBuilder();
                    }
                    return this.upTo_ == null ? Int64Value.getDefaultInstance() : this.upTo_;
                }

                private SingleFieldBuilderV3<Int64Value, Int64Value.Builder, Int64ValueOrBuilder> getUpToFieldBuilder() {
                    if (this.upToBuilder_ == null) {
                        this.upToBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getUpTo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                        this.upTo_ = null;
                    }
                    return this.upToBuilder_;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface CountOrBuilder
        extends MessageOrBuilder {
            public boolean hasUpTo();

            public Int64Value getUpTo();

            public Int64ValueOrBuilder getUpToOrBuilder();
        }
    }

    public static interface AggregationOrBuilder
    extends MessageOrBuilder {
        public boolean hasCount();

        public Aggregation.Count getCount();

        public Aggregation.CountOrBuilder getCountOrBuilder();

        public String getAlias();

        public ByteString getAliasBytes();

        public Aggregation.OperatorCase getOperatorCase();
    }
}

