/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.security.auth.AuthenticationSystem;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Vector;

public abstract class AS400Principal
implements Principal,
Serializable {
    static final long serialVersionUID = 4L;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetos_ = new VetoableChangeSupport(this);
    private transient Vector credentialListeners_ = new Vector();
    private AS400 system_ = null;

    public AS400Principal() {
        this.initTransient();
    }

    public AS400Principal(AS400 aS400) {
        this();
        try {
            this.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.changes_.firePropertyChange(string, object, object2);
    }

    void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetos_.fireVetoableChange(string, object, object2);
    }

    public String getName() {
        return this.getUserProfileName();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public User getUser() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException {
        if (this.getSystem() == null) {
            Trace.log(2, "Required property 'system' not set.");
            throw new ExtendedIllegalStateException(4);
        }
        return new User(this.getSystem(), this.getUserProfileName());
    }

    public String getUserProfileName() {
        return "";
    }

    void initTransient() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        AS400 aS4002 = this.getSystem();
        this.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.firePropertyChange("system", aS4002, aS400);
    }
}

