/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import net.snowflake.client.core.SFArrowResultSet;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFResultSet;
import net.snowflake.client.core.SFStatement;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;

class SFResultSetFactory {
    SFResultSetFactory() {
    }

    static SFBaseResultSet getResultSet(JsonNode result, SFStatement statement, boolean sortResult) throws SQLException {
        SnowflakeResultSetSerializableV1 resultSetSerializable = SnowflakeResultSetSerializableV1.create(result, statement.getSFBaseSession(), statement);
        switch (resultSetSerializable.getQueryResultFormat()) {
            case ARROW: {
                return new SFArrowResultSet(resultSetSerializable, statement.getSFBaseSession(), statement, sortResult);
            }
            case JSON: {
                return new SFResultSet(resultSetSerializable, statement, sortResult);
            }
        }
        throw new SnowflakeSQLLoggedException(statement.getSFBaseSession(), ErrorCode.INTERNAL_ERROR, "Unsupported query result format: " + resultSetSerializable.getQueryResultFormat().name());
    }
}

