/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Encodable;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Null;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Primitive;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1Sequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1TaggedObject;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERNull;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERSequence;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DERTaggedObject;
import net.snowflake.client.jdbc.internal.org.bouncycastle.oer.its.EccCurvePoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.BigIntegers;

public class EccP256CurvePoint
extends EccCurvePoint {
    public static final int xOnly = 0;
    public static final int fill = 1;
    public static final int compressedY0 = 2;
    public static final int compressedY1 = 3;
    public static final int uncompressedP256 = 4;
    private final int choice;
    private final ASN1Encodable value;

    public EccP256CurvePoint(int n, ASN1Encodable aSN1Encodable) {
        this.choice = n;
        this.value = aSN1Encodable;
    }

    public static EccP256CurvePoint getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object instanceof EccP256CurvePoint) {
            return (EccP256CurvePoint)object;
        }
        ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object);
        switch (aSN1TaggedObject.getTagNo()) {
            case 1: {
                aSN1Primitive = ASN1Null.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                aSN1Primitive = ASN1OctetString.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 4: {
                aSN1Primitive = ASN1Sequence.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag " + aSN1TaggedObject.getTagNo());
            }
        }
        return new Builder().setChoice(aSN1TaggedObject.getTagNo()).setValue(aSN1Primitive).createEccP256CurvePoint();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public byte[] getEncodedPoint() {
        byte[] byArray;
        switch (this.choice) {
            case 2: {
                byte[] byArray2 = DEROctetString.getInstance(this.value).getOctets();
                byArray = new byte[byArray2.length + 1];
                byArray[0] = 2;
                System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
                break;
            }
            case 3: {
                byte[] byArray3 = DEROctetString.getInstance(this.value).getOctets();
                byArray = new byte[byArray3.length + 1];
                byArray[0] = 3;
                System.arraycopy(byArray3, 0, byArray, 1, byArray3.length);
                break;
            }
            case 4: {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(this.value);
                byte[] byArray4 = DEROctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets();
                byte[] byArray5 = DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
                byArray = Arrays.concatenate(new byte[]{4}, byArray4, byArray5);
                break;
            }
            case 0: {
                throw new IllegalStateException("x Only not implemented");
            }
            default: {
                throw new IllegalStateException("unknown point choice");
            }
        }
        return byArray;
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable value;

        Builder setChoice(int n) {
            this.choice = n;
            return this;
        }

        Builder setValue(ASN1Encodable aSN1Encodable) {
            this.value = aSN1Encodable;
            return this;
        }

        public EccP256CurvePoint createXOnly(BigInteger bigInteger) {
            this.choice = 0;
            this.value = new DEROctetString(BigIntegers.asUnsignedByteArray(bigInteger));
            return this.createEccP256CurvePoint();
        }

        public EccP256CurvePoint createFill() {
            this.choice = 1;
            this.value = DERNull.INSTANCE;
            return this.createEccP256CurvePoint();
        }

        public EccP256CurvePoint createCompressedY0(BigInteger bigInteger) {
            this.choice = 2;
            throw new IllegalStateException("not fully implemented.");
        }

        public EccP256CurvePoint createCompressedY1(BigInteger bigInteger) {
            this.choice = 3;
            throw new IllegalStateException("not fully implemented.");
        }

        public EccP256CurvePoint createUncompressedP256(BigInteger bigInteger, BigInteger bigInteger2) {
            this.choice = 4;
            this.value = new DERSequence(new ASN1Encodable[]{new DEROctetString(BigIntegers.asUnsignedByteArray(32, bigInteger)), new DEROctetString(BigIntegers.asUnsignedByteArray(32, bigInteger2))});
            return this.createEccP256CurvePoint();
        }

        private EccP256CurvePoint createEccP256CurvePoint() {
            return new EccP256CurvePoint(this.choice, this.value);
        }
    }
}

