/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class AppliedCombineFn<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn;
    private final @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumulatorCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputViews;
    private final @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;

    private AppliedCombineFn(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumulatorCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputViews, @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        this.fn = fn;
        this.accumulatorCoder = accumulatorCoder;
        this.sideInputViews = sideInputViews;
        this.kvCoder = kvCoder;
        this.windowingStrategy = windowingStrategy;
    }

    public static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder) {
        return AppliedCombineFn.withAccumulatorCoder(fn, accumCoder, null, null, null);
    }

    public static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> withAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputViews, @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        CombineFnBase.GlobalCombineFn<? super InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        return AppliedCombineFn.create(clonedFn, accumCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    @VisibleForTesting
    public static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder) {
        return AppliedCombineFn.withInputCoder(fn, registry, kvCoder, null, null);
    }

    public static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> withInputCoder(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputViews, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> clonedFn = SerializableUtils.clone(fn);
        try {
            Coder<AccumT> accumulatorCoder = clonedFn.getAccumulatorCoder(registry, kvCoder.getValueCoder());
            return AppliedCombineFn.create(clonedFn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
        }
        catch (CannotProvideCoderException e) {
            throw new IllegalStateException("Could not determine coder for accumulator", e);
        }
    }

    private static <K, InputT, AccumT, OutputT> @UnknownKeyFor @NonNull @Initialized AppliedCombineFn<K, InputT, AccumT, OutputT> create(@UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<AccumT> accumulatorCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputViews, @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> kvCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
        return new AppliedCombineFn<K, InputT, AccumT, OutputT>(fn, accumulatorCoder, sideInputViews, kvCoder, windowingStrategy);
    }

    public @UnknownKeyFor @NonNull @Initialized CombineFnBase.GlobalCombineFn<InputT, AccumT, OutputT> getFn() {
        return this.fn;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputViews() {
        return this.sideInputViews;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder() {
        return this.accumulatorCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized KvCoder<K, InputT> getKvCoder() {
        return this.kvCoder;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }
}

