/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ConvertHelpers;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.AutoValue_DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
@Internal
public abstract class DoFnSchemaInformation
implements Serializable {
    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getElementConverters();

    public abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

    public static @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation create() {
        return new AutoValue_DoFnSchemaInformation.Builder().setElementConverters(Collections.emptyList()).setFieldAccessDescriptor(FieldAccessDescriptor.create()).build();
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation withSelectFromSchemaParameter(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SchemaCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputCoder, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized Schema selectOutputSchema, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SchemaCoder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> parameterCoder, @UnknownKeyFor @NonNull @Initialized boolean unbox) {
        ImmutableList converters = ImmutableList.builder().addAll(this.getElementConverters()).add((Object)ConversionFunction.of(inputCoder.getSchema(), inputCoder.getToRowFunction(), parameterCoder.getFromRowFunction(), selectDescriptor, unbox)).build();
        return this.toBuilder().setElementConverters((List<SerializableFunction<?, ?>>)converters).build();
    }

    @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation withUnboxPrimitiveParameter(@UnknownKeyFor @NonNull @Initialized SchemaCoder inputCoder, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized Schema selectOutputSchema, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> elementT) {
        if (selectOutputSchema.getFieldCount() != 1) {
            throw new RuntimeException("Parameter has no schema and the input is not a simple type.");
        }
        Schema.FieldType fieldType = selectOutputSchema.getField(0).getType();
        if (fieldType.getTypeName().isCompositeType()) {
            throw new RuntimeException("Parameter has no schema and the input is not a primitive type.");
        }
        ImmutableList converters = ImmutableList.builder().addAll(this.getElementConverters()).add((Object)UnboxingConversionFunction.of(inputCoder.getSchema(), inputCoder.getToRowFunction(), selectDescriptor, selectOutputSchema, elementT)).build();
        return this.toBuilder().setElementConverters((List<SerializableFunction<?, ?>>)converters).build();
    }

    @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation withFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor) {
        FieldAccessDescriptor descriptor = FieldAccessDescriptor.union((Iterable<FieldAccessDescriptor>)ImmutableList.of((Object)this.getFieldAccessDescriptor(), (Object)selectDescriptor));
        return this.toBuilder().setFieldAccessDescriptor(descriptor).build();
    }

    private static class UnboxingConversionFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements SerializableFunction<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction;
        private final @UnknownKeyFor @NonNull @Initialized Schema.FieldType primitiveType;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> primitiveOutputType;
        private transient @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> conversionFunction;
        private final @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;

        private UnboxingConversionFunction(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized Schema selectOutputSchema, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> primitiveOutputType) {
            this.toRowFunction = toRowFunction;
            this.primitiveType = selectOutputSchema.getField(0).getType();
            this.primitiveOutputType = primitiveOutputType;
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, selectDescriptor, true);
        }

        public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized UnboxingConversionFunction of(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized Schema selectOutputSchema, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> primitiveOutputType) {
            return new UnboxingConversionFunction<InputT, OutputT>(inputSchema, toRowFunction, selectDescriptor, selectOutputSchema, primitiveOutputType);
        }

        @Override
        public OutputT apply(InputT input) {
            Row row = this.toRowFunction.apply(input);
            Row selected = this.rowSelector.select(row);
            return this.getConversionFunction().apply(selected.getValue(0));
        }

        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> getConversionFunction() {
            if (this.conversionFunction == null) {
                this.conversionFunction = ConvertHelpers.getConvertPrimitive(this.primitiveType, this.primitiveOutputType, new ByteBuddyUtils.DefaultTypeConversionsFactory());
            }
            return this.conversionFunction;
        }
    }

    private static class ConversionFunction<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements SerializableFunction<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, OutputT> fromRowFunction;
        private final @UnknownKeyFor @NonNull @Initialized boolean unbox;
        private final @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;

        private ConversionFunction(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, OutputT> fromRowFunction, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized boolean unbox) {
            this.toRowFunction = toRowFunction;
            this.fromRowFunction = fromRowFunction;
            this.unbox = unbox;
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, selectDescriptor, true);
        }

        public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized ConversionFunction of(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, OutputT> fromRowFunction, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor selectDescriptor, @UnknownKeyFor @NonNull @Initialized boolean unbox) {
            return new ConversionFunction<InputT, OutputT>(inputSchema, toRowFunction, fromRowFunction, selectDescriptor, unbox);
        }

        @Override
        public OutputT apply(InputT input) {
            Row row = this.toRowFunction.apply(input);
            Row selected = this.rowSelector.select(row);
            if (this.unbox) {
                selected = selected.getRow(0);
            }
            return this.fromRowFunction.apply(selected);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract @UnknownKeyFor @NonNull @Initialized Builder setElementConverters(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

        abstract @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation build();
    }
}

