/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.SavepointSupport;
import javax.annotation.Nonnull;

@InternalApi
interface UnitOfWork {
    public void cancel();

    public Type getType();

    public UnitOfWorkState getState();

    public boolean isActive();

    public ApiFuture<Void> commitAsync();

    public ApiFuture<Void> rollbackAsync();

    public void savepoint(@Nonnull String var1, @Nonnull Dialect var2);

    public void releaseSavepoint(@Nonnull String var1);

    public void rollbackToSavepoint(@Nonnull String var1, @Nonnull SavepointSupport var2);

    public ApiFuture<long[]> runBatchAsync();

    public void abortBatch();

    public boolean isReadOnly();

    public ApiFuture<ResultSet> executeQueryAsync(AbstractStatementParser.ParsedStatement var1, AnalyzeMode var2, Options.QueryOption ... var3);

    public Timestamp getReadTimestamp();

    public Timestamp getReadTimestampOrNull();

    public Timestamp getCommitTimestamp();

    public Timestamp getCommitTimestampOrNull();

    public CommitResponse getCommitResponse();

    public CommitResponse getCommitResponseOrNull();

    public ApiFuture<Void> executeDdlAsync(AbstractStatementParser.ParsedStatement var1);

    public ApiFuture<Long> executeUpdateAsync(AbstractStatementParser.ParsedStatement var1, Options.UpdateOption ... var2);

    public ApiFuture<ResultSet> analyzeUpdateAsync(AbstractStatementParser.ParsedStatement var1, AnalyzeMode var2, Options.UpdateOption ... var3);

    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<AbstractStatementParser.ParsedStatement> var1, Options.UpdateOption ... var2);

    public ApiFuture<Void> writeAsync(Iterable<Mutation> var1);

    public static enum UnitOfWorkState {
        STARTED,
        COMMITTING,
        COMMITTED,
        COMMIT_FAILED,
        ROLLED_BACK,
        RUNNING,
        RAN,
        RUN_FAILED,
        ABORTED;


        public boolean isActive() {
            return this == STARTED;
        }
    }

    public static enum Type {
        TRANSACTION,
        BATCH;

    }
}

