/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.runners.fnexecution.artifact.ArtifactRetrievalService;
import org.apache.beam.runners.fnexecution.control.ControlClientPool;
import org.apache.beam.runners.fnexecution.control.FnApiControlClientPoolService;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.EnvironmentFactory;
import org.apache.beam.runners.fnexecution.environment.ProcessEnvironment;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;
import org.apache.beam.runners.fnexecution.logging.GrpcLoggingService;
import org.apache.beam.runners.fnexecution.provisioning.StaticGrpcProvisionService;
import org.apache.beam.sdk.fn.IdGenerator;
import org.apache.beam.sdk.fn.server.GrpcFnServer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.RemoteEnvironmentOptions;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p54p0.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEnvironmentFactory
implements EnvironmentFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ProcessEnvironmentFactory.class);
    private final @UnknownKeyFor @NonNull @Initialized ProcessManager processManager;
    private final @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer;
    private final @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource;
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

    public static @UnknownKeyFor @NonNull @Initialized ProcessEnvironmentFactory create(@UnknownKeyFor @NonNull @Initialized ProcessManager processManager, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource, @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        return new ProcessEnvironmentFactory(processManager, provisioningServiceServer, clientSource, pipelineOptions);
    }

    private ProcessEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized ProcessManager processManager, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool.Source clientSource, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.processManager = processManager;
        this.provisioningServiceServer = provisioningServiceServer;
        this.clientSource = clientSource;
        this.pipelineOptions = pipelineOptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized RemoteEnvironment createEnvironment(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Environment environment, @UnknownKeyFor @NonNull @Initialized String workerId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Preconditions.checkState((boolean)environment.getUrn().equals(BeamUrns.getUrn((ProtocolMessageEnum)RunnerApi.StandardEnvironments.Environments.PROCESS)), (Object)"The passed environment does not contain a ProcessPayload.");
        RunnerApi.ProcessPayload processPayload = RunnerApi.ProcessPayload.parseFrom((ByteString)environment.getPayload());
        String executable = processPayload.getCommand();
        String provisionEndpoint = this.provisioningServiceServer.getApiServiceDescriptor().getUrl();
        String semiPersistDir = ((RemoteEnvironmentOptions)this.pipelineOptions.as(RemoteEnvironmentOptions.class)).getSemiPersistDir();
        ImmutableList.Builder argsBuilder = ImmutableList.builder().add((Object)String.format("--id=%s", workerId)).add((Object)String.format("--provision_endpoint=%s", provisionEndpoint));
        if (semiPersistDir != null) {
            argsBuilder.add((Object)String.format("--semi_persist_dir=%s", semiPersistDir));
        }
        LOG.debug("Creating Process for worker ID {}", (Object)workerId);
        InstructionRequestHandler instructionHandler = null;
        try {
            ProcessManager.RunningProcess process = this.processManager.startProcess(workerId, executable, (List<String>)argsBuilder.build(), processPayload.getEnvMap());
            while (instructionHandler == null) {
                try {
                    process.isAliveOrThrow();
                    instructionHandler = this.clientSource.take(workerId, Duration.ofSeconds(5L));
                }
                catch (TimeoutException timeoutEx) {
                    LOG.info("Still waiting for startup of environment '{}' for worker id {}", (Object)processPayload.getCommand(), (Object)workerId);
                }
                catch (InterruptedException interruptEx) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(interruptEx);
                    return ProcessEnvironment.create(this.processManager, environment, workerId, instructionHandler);
                }
            }
        }
        catch (Exception e) {
            try {
                this.processManager.stopProcess(workerId);
                throw e;
            }
            catch (Exception processKillException) {
                e.addSuppressed(processKillException);
            }
            throw e;
        }
    }

    public static class Provider
    implements EnvironmentFactory.Provider {
        private final @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

        public Provider(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.pipelineOptions = options;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized EnvironmentFactory createEnvironmentFactory(@UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized FnApiControlClientPoolService> controlServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized GrpcLoggingService> loggingServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized ArtifactRetrievalService> retrievalServiceServer, @UnknownKeyFor @NonNull @Initialized GrpcFnServer<@UnknownKeyFor @NonNull @Initialized StaticGrpcProvisionService> provisioningServiceServer, @UnknownKeyFor @NonNull @Initialized ControlClientPool clientPool, @UnknownKeyFor @NonNull @Initialized IdGenerator idGenerator) {
            return ProcessEnvironmentFactory.create(ProcessManager.create(), provisioningServiceServer, clientPool.getSource(), idGenerator, this.pipelineOptions);
        }
    }
}

