/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.core.compress;

import org.apache.hop.core.compress.NoneCompressionProvider.NoneCompressionInputStream;
import org.apache.hop.core.compress.NoneCompressionProvider.NoneCompressionOutputStream;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.junit.rules.RestoreHopEngineEnvironment;
import org.junit.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import static org.junit.Assert.*;

public class NoneCompressionProviderTest {
  @ClassRule public static RestoreHopEngineEnvironment env = new RestoreHopEngineEnvironment();

  public static final String PROVIDER_NAME = "None";

  public CompressionProviderFactory factory = null;

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    PluginRegistry.addPluginType(CompressionPluginType.getInstance());
    PluginRegistry.init(false);
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {}

  @Before
  public void setUp() throws Exception {
    factory = CompressionProviderFactory.getInstance();
  }

  @After
  public void tearDown() throws Exception {}

  @Test
  public void testCtor() {
    NoneCompressionProvider ncp = new NoneCompressionProvider();
    assertNotNull(ncp);
  }

  @Test
  public void testGetName() {
    NoneCompressionProvider provider =
        (NoneCompressionProvider) factory.getCompressionProviderByName(PROVIDER_NAME);
    assertNotNull(provider);
    assertEquals(PROVIDER_NAME, provider.getName());
  }

  @Test
  public void testGetProviderAttributes() {
    NoneCompressionProvider provider =
        (NoneCompressionProvider) factory.getCompressionProviderByName(PROVIDER_NAME);
    assertEquals("No compression", provider.getDescription());
    assertTrue(provider.supportsInput());
    assertTrue(provider.supportsOutput());
    assertNull(provider.getDefaultExtension());
  }

  @Test
  public void testCreateInputStream() throws IOException {
    NoneCompressionProvider provider =
        (NoneCompressionProvider) factory.getCompressionProviderByName(PROVIDER_NAME);
    ByteArrayInputStream in = new ByteArrayInputStream("Test".getBytes());
    NoneCompressionInputStream inStream = new NoneCompressionInputStream(in, provider);
    assertNotNull(inStream);
    NoneCompressionInputStream ncis = (NoneCompressionInputStream) provider.createInputStream(in);
    assertNotNull(ncis);
  }

  @Test
  public void testCreateOutputStream() throws IOException {
    NoneCompressionProvider provider =
        (NoneCompressionProvider) factory.getCompressionProviderByName(PROVIDER_NAME);
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    NoneCompressionOutputStream outStream = new NoneCompressionOutputStream(out, provider);
    assertNotNull(outStream);
    NoneCompressionOutputStream ncis =
        (NoneCompressionOutputStream) provider.createOutputStream(out);
    assertNotNull(ncis);
  }
}
